/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.Verify;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.engine.FixPSessionInfo;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.fixp.AbstractFixPStorage;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPFirstMessageResponse;
import uk.co.real_logic.artio.fixp.FixPKey;
import uk.co.real_logic.artio.fixp.FixPProtocolFactory;
import uk.co.real_logic.artio.fixp.InternalFixPContext;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.FixPContextWrapperDecoder;
import uk.co.real_logic.artio.storage.messages.FixPContextWrapperEncoder;

public class FixPContexts
implements SessionContexts {
    public static final int WRAPPER_LENGTH = 4;
    private final EnumMap<FixPProtocolType, AbstractFixPStorage> typeToStorage = new EnumMap(FixPProtocolType.class);
    private final Function<FixPProtocolType, AbstractFixPStorage> makeStorageFunc = this::makeStorage;
    private final MappedFile mappedFile;
    private final AtomicBuffer buffer;
    private final ErrorHandler errorHandler;
    private final EpochNanoClock epochNanoClock;
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final FixPContextWrapperEncoder contextWrapperEncoder = new FixPContextWrapperEncoder();
    private final FixPContextWrapperDecoder contextWrapperDecoder = new FixPContextWrapperDecoder();
    private final int actingBlockLength = this.contextWrapperEncoder.sbeBlockLength();
    private final int actingVersion = this.contextWrapperEncoder.sbeSchemaVersion();
    private final Long2LongHashMap authenticatedSessionIdToConnectionId = new Long2LongHashMap(Long.MIN_VALUE);
    private final Map<FixPKey, InternalFixPContext> keyToContext = new HashMap<FixPKey, InternalFixPContext>();
    private final List<FixPSessionInfo> sessionInfos = new ArrayList<FixPSessionInfo>();
    private int offset;

    FixPContexts(MappedFile mappedFile, ErrorHandler errorHandler, EpochNanoClock epochNanoClock) {
        this.mappedFile = mappedFile;
        this.buffer = mappedFile.buffer();
        this.errorHandler = errorHandler;
        this.epochNanoClock = epochNanoClock;
        this.loadBuffer();
    }

    private void loadBuffer() {
        if (LoggerUtil.initialiseBuffer(this.buffer, this.headerEncoder, this.headerDecoder, this.contextWrapperEncoder.sbeSchemaId(), this.contextWrapperEncoder.sbeTemplateId(), this.actingVersion, this.actingBlockLength, this.errorHandler)) {
            this.mappedFile.force();
        }
        this.offset = 8;
        int capacity = this.buffer.capacity();
        while (this.offset < capacity) {
            this.contextWrapperDecoder.wrap((DirectBuffer)this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
            int protocolTypeValue = this.contextWrapperDecoder.protocolType();
            int contextLength = this.contextWrapperDecoder.contextLength();
            if (protocolTypeValue == 0) break;
            this.offset += 4;
            FixPProtocolType type = FixPProtocolType.get((int)protocolTypeValue);
            AbstractFixPStorage storage = this.lookupStorage(type);
            InternalFixPContext context = storage.loadContext(this.buffer, this.offset, this.actingVersion);
            this.addContext(context);
            this.offset += contextLength;
        }
    }

    private void addContext(InternalFixPContext context) {
        InternalFixPContext oldContext = this.keyToContext.put(context.key(), context);
        this.sessionInfos.add(new InfoWrapper((FixPContext)context));
        if (oldContext != null) {
            CollectionUtil.removeIf(this.sessionInfos, info -> ((InfoWrapper)info).context == oldContext);
        }
    }

    private AbstractFixPStorage lookupStorage(FixPProtocolType type) {
        return this.typeToStorage.computeIfAbsent(type, this.makeStorageFunc);
    }

    private AbstractFixPStorage makeStorage(FixPProtocolType type) {
        return FixPProtocolFactory.make(type, this.errorHandler).makeStorage(this.epochNanoClock);
    }

    InternalFixPContext calculateInitiatorContext(FixPKey key, boolean reestablishConnection) {
        Verify.notNull((Object)key, (String)"key");
        InternalFixPContext context = this.keyToContext.get(key);
        if (context != null) {
            context.initiatorReconnect(reestablishConnection);
            return context;
        }
        return this.allocateInitiatorContext(key);
    }

    private InternalFixPContext allocateInitiatorContext(FixPKey key) {
        InternalFixPContext context = this.newInitiatorContext(key);
        this.addContext(context);
        return context;
    }

    private InternalFixPContext newInitiatorContext(FixPKey key) {
        return this.lookupStorage(key.protocolType()).newInitiatorContext(key, this.offset + 4);
    }

    public void updateContext(InternalFixPContext context) {
        this.lookupStorage(context.protocolType()).updateContext(context, this.buffer);
    }

    public void saveNewContext(InternalFixPContext context) {
        FixPProtocolType type = context.protocolType();
        AbstractFixPStorage storage = this.lookupStorage(type);
        this.contextWrapperEncoder.wrap((MutableDirectBuffer)this.buffer, this.offset).protocolType(type.value());
        this.offset += 4;
        int length = storage.saveContext(context, this.buffer, this.offset, this.actingVersion);
        this.contextWrapperEncoder.contextLength(length);
        this.offset += length;
    }

    int offset() {
        return this.offset;
    }

    public void close() {
        this.mappedFile.close();
    }

    public FixPFirstMessageResponse onAcceptorLogon(long sessionId, InternalFixPContext context, long connectionId, boolean ignoreFromNegotiate) {
        long duplicateConnection = this.authenticatedSessionIdToConnectionId.get(sessionId);
        FixPKey key = context.key();
        FixPContext oldContext = (FixPContext)this.keyToContext.get(key);
        if (duplicateConnection == Long.MIN_VALUE || duplicateConnection == -1L) {
            this.authenticatedSessionIdToConnectionId.put(sessionId, connectionId);
            FixPFirstMessageResponse rejectReason = context.checkAccept(oldContext, ignoreFromNegotiate);
            if (rejectReason == FixPFirstMessageResponse.OK) {
                if (oldContext == null) {
                    this.saveNewContext(context);
                } else {
                    this.updateContext(context);
                }
                this.addContext(context);
            }
            return rejectReason;
        }
        if (context.fromNegotiate()) {
            return context.compareVersion(oldContext) == 0 ? FixPFirstMessageResponse.NEGOTIATE_DUPLICATE_ID : FixPFirstMessageResponse.NEGOTIATE_DUPLICATE_ID_BAD_VER;
        }
        return FixPFirstMessageResponse.ESTABLISH_DUPLICATE_ID;
    }

    public void onDisconnect(long connectionId) {
        Long2LongHashMap.EntryIterator it = this.authenticatedSessionIdToConnectionId.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            if (it.getLongValue() != connectionId) continue;
            it.remove();
        }
    }

    public List<FixPSessionInfo> allSessions() {
        return this.sessionInfos;
    }

    @Override
    public void sequenceReset(long sessionId, long resetTimeInNs) {
        InternalFixPContext context = this.lookupContext(sessionId);
        if (context != null) {
            context.onEndSequence();
            this.updateContext(context);
        } else {
            this.errorHandler.onError((Throwable)new IllegalArgumentException("Unable to reset sequence number for " + sessionId + " unknown session"));
        }
    }

    @Override
    public boolean isKnownSessionId(long sessionId) {
        return this.lookupContext(sessionId) != null;
    }

    InternalFixPContext lookupContext(long sessionId) {
        for (Map.Entry<FixPKey, InternalFixPContext> entry : this.keyToContext.entrySet()) {
            if (entry.getKey().sessionIdIfExists() != sessionId) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean isAuthenticated(long sessionId) {
        return this.authenticatedSessionIdToConnectionId.containsKey(sessionId);
    }

    static class InfoWrapper
    implements FixPSessionInfo {
        private final FixPContext context;

        InfoWrapper(FixPContext context) {
            this.context = context;
        }

        @Override
        public FixPKey key() {
            return this.context.key();
        }

        public String toString() {
            return "InfoWrapper{context=" + String.valueOf(this.context) + "}";
        }
    }
}

