/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.engine.ReplayerCommandQueue;
import uk.co.real_logic.artio.engine.SenderSequenceNumber;

public class SenderSequenceNumbers {
    public static final int UNKNOWN_SESSION = -1;
    private final ReplayerCommandQueue queue;
    private final Long2ObjectHashMap<SenderSequenceNumber> connectionIdToSequencePosition = new Long2ObjectHashMap();
    private final LongHashSet oldConnectionIds = new LongHashSet();

    public SenderSequenceNumbers(ReplayerCommandQueue queue) {
        this.queue = queue;
    }

    public SenderSequenceNumber onNewSender(long connectionId, AtomicCounter bytesInBuffer) {
        SenderSequenceNumber position = new SenderSequenceNumber(connectionId, bytesInBuffer, this);
        this.enqueue(position);
        return position;
    }

    void onSenderClosed(SenderSequenceNumber senderSequenceNumber) {
        this.enqueue(senderSequenceNumber);
    }

    private void enqueue(SenderSequenceNumber senderSequenceNumber) {
        this.queue.enqueue(senderSequenceNumber);
    }

    public int lastSentSequenceNumber(long connectionId) {
        SenderSequenceNumber senderSequenceNumber = (SenderSequenceNumber)this.connectionIdToSequencePosition.get(connectionId);
        if (senderSequenceNumber == null) {
            return -1;
        }
        return senderSequenceNumber.lastSentSequenceNumber();
    }

    public AtomicCounter bytesInBufferCounter(long connectionId) {
        SenderSequenceNumber senderSequenceNumber = (SenderSequenceNumber)this.connectionIdToSequencePosition.get(connectionId);
        return senderSequenceNumber == null ? null : senderSequenceNumber.bytesInBuffer();
    }

    public boolean hasDisconnected(long connectionId) {
        return this.oldConnectionIds.contains(connectionId);
    }

    void onSenderSequenceNumber(SenderSequenceNumber senderSequenceNumber) {
        long connectionId = senderSequenceNumber.connectionId();
        if (this.connectionIdToSequencePosition.remove(connectionId) == null) {
            this.connectionIdToSequencePosition.put(connectionId, (Object)senderSequenceNumber);
        } else {
            this.oldConnectionIds.add(connectionId);
        }
    }
}

