/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.CompositeAgent;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.engine.RecordingCoordinator;

public class LowResourceEngineScheduler
implements EngineScheduler {
    private AgentRunner runner;
    private ErrorHandler errorHandler;
    private Agent framer;
    private RecordingCoordinator recordingCoordinator;

    @Override
    public void launch(EngineConfiguration configuration, ErrorHandler errorHandler, Agent framer, Agent indexingAgent, Agent monitoringAgent, Agent conductorAgent, RecordingCoordinator recordingCoordinator) {
        this.errorHandler = errorHandler;
        this.framer = framer;
        this.recordingCoordinator = recordingCoordinator;
        if (this.runner != null) {
            EngineScheduler.fail();
        }
        ArrayList<Agent> agents = new ArrayList<Agent>();
        Collections.addAll(agents, monitoringAgent, framer, indexingAgent, new RecordingCoordinatorAgent(), conductorAgent);
        agents.removeIf(Objects::isNull);
        this.runner = new AgentRunner(configuration.framerIdleStrategy(), errorHandler, null, (Agent)new CompositeAgent(agents));
        AgentRunner.startOnThread((AgentRunner)this.runner, (ThreadFactory)configuration.threadFactory());
    }

    @Override
    public void close() {
        EngineScheduler.awaitRunnerStart(this.runner);
        CloseHelper.close((AutoCloseable)this.runner);
    }

    @Override
    public int pollFramer() {
        if (this.framer != null) {
            try {
                return this.framer.doWork();
            }
            catch (Throwable e) {
                if (this.errorHandler != null) {
                    this.errorHandler.onError(e);
                }
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public void configure(Aeron.Context aeronContext) {
        aeronContext.useConductorAgentInvoker(true);
    }

    private final class RecordingCoordinatorAgent
    implements Agent {
        private RecordingCoordinatorAgent() {
        }

        public int doWork() {
            return 0;
        }

        public String roleName() {
            return "RecordingCoordinator";
        }

        public void onClose() {
            LowResourceEngineScheduler.this.recordingCoordinator.close();
        }
    }
}

