/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.TimeoutException;
import org.agrona.LangUtil;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.session.Session;

public final class LibraryUtil {
    private static final int DEFAULT_FRAGMENT_LIMIT = 10;

    public static Session initiate(FixLibrary library, SessionConfiguration configuration, int attempts, IdleStrategy idleStrategy) throws IllegalStateException, FixGatewayException, TimeoutException {
        return LibraryUtil.initiate(library, configuration, attempts, idleStrategy, 10);
    }

    private static Session initiate(FixLibrary library, SessionConfiguration configuration, int attempts, IdleStrategy idleStrategy, int fragmentLimit) {
        if (attempts < 1) {
            throw new IllegalArgumentException("Attempts should be >= 1, but is " + attempts);
        }
        Reply<Session> reply = null;
        for (int i = 0; i < attempts; ++i) {
            reply = library.initiate(configuration);
            while (reply.isExecuting()) {
                idleStrategy.idle(library.poll(fragmentLimit));
            }
            if (!reply.hasCompleted()) continue;
            return reply.resultIfPresent();
        }
        if (reply.hasTimedOut()) {
            throw new TimeoutException("reply timeout", AeronException.Category.ERROR);
        }
        LangUtil.rethrowUnchecked((Throwable)reply.error());
        return null;
    }
}

