/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.fixp;

import io.aeron.ExclusivePublication;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.agrona.LangUtil;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.sbe.CompositeDecoderFlyweight;
import org.agrona.sbe.MessageDecoderFlyweight;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.FixPSequenceNumberHandler;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.fixp.AbstractFixPOffsets;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.AbstractFixPSequenceExtractor;
import uk.co.real_logic.artio.fixp.AbstractFixPStorage;
import uk.co.real_logic.artio.fixp.FixPConnection;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPMessageDissector;
import uk.co.real_logic.artio.fixp.FixPRejectRefIdExtractor;
import uk.co.real_logic.artio.library.FixPSessionOwner;
import uk.co.real_logic.artio.library.InternalFixPConnection;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.Token;

public abstract class FixPProtocol {
    public static final boolean BUSINESS_MESSAGE_LOGGING_ENABLED = DebugLogger.isEnabled(LogTag.FIXP_BUSINESS);
    public static final int DOES_NOT_SUPPORT_SEQUENCE_FINISHING_TEMPLATE_ID = -1;
    private final String packageName;
    private final FixPProtocolType protocolType;
    private final short encodingType;
    private final int finishedSendingTemplateId;
    private final int finishedReceivingTemplateId;
    private final int negotiateResponseTemplateId;

    protected FixPProtocol(FixPProtocolType protocolType, short encodingType, int negotiateResponseTemplateId, String packageName) {
        this(protocolType, encodingType, -1, -1, negotiateResponseTemplateId, packageName);
    }

    protected FixPProtocol(FixPProtocolType protocolType, short encodingType, int finishedSendingTemplateId, int finishedReceivingTemplateId, int negotiateResponseTemplateId, String packageName) {
        this.packageName = packageName;
        this.protocolType = protocolType;
        this.encodingType = encodingType;
        this.finishedSendingTemplateId = finishedSendingTemplateId;
        this.finishedReceivingTemplateId = finishedReceivingTemplateId;
        this.negotiateResponseTemplateId = negotiateResponseTemplateId;
    }

    public FixPProtocolType protocolType() {
        return this.protocolType;
    }

    public short encodingType() {
        return this.encodingType;
    }

    public int finishedSendingTemplateId() {
        return this.finishedSendingTemplateId;
    }

    public int finishedReceivingTemplateId() {
        return this.finishedReceivingTemplateId;
    }

    public int negotiateResponseTemplateId() {
        return this.negotiateResponseTemplateId;
    }

    public abstract AbstractFixPParser makeParser(FixPConnection var1);

    public abstract AbstractFixPProxy makeProxy(FixPMessageDissector var1, ExclusivePublication var2, EpochNanoClock var3);

    public abstract AbstractFixPOffsets makeOffsets();

    public abstract InternalFixPConnection makeAcceptorConnection(long var1, GatewayPublication var3, GatewayPublication var4, int var5, FixPSessionOwner var6, long var7, long var9, long var11, FixPContext var13, CommonConfiguration var14, FixPMessageDissector var15);

    public abstract AbstractFixPStorage makeStorage(EpochNanoClock var1);

    public abstract AbstractFixPSequenceExtractor makeSequenceExtractor(FixPSequenceNumberHandler var1, SequenceNumberIndexReader var2);

    protected abstract Ir loadIr();

    public FixPRejectRefIdExtractor makeRefIdExtractor() {
        return new FixPRejectRefIdExtractor(this.loadIr());
    }

    public abstract boolean explicitSequenceNumbers();

    public List<? extends MessageDecoderFlyweight> messageDecoders() {
        return this.loadIr().messages().stream().map(tokens -> {
            Token beginMessage = (Token)tokens.get(0);
            String decoderName = this.packageName + "." + beginMessage.name() + "Decoder";
            return (MessageDecoderFlyweight)this.newInstance(decoderName);
        }).collect(Collectors.toList());
    }

    public CompositeDecoderFlyweight makeHeader() {
        return (CompositeDecoderFlyweight)this.newInstance(this.packageName + ".MessageHeaderDecoder");
    }

    private Object newInstance(String decoderName) {
        try {
            return Class.forName(decoderName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }
}

