/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.TimeIndexRecordEncoder;

class TimeIndexWriter
implements AutoCloseable {
    static final String FILE_NAME = "time-index-";
    private static final int BUFFER_SIZE = Math.max(8, 16);
    private final TimeIndexRecordEncoder recordEncoder = new TimeIndexRecordEncoder();
    private final UnsafeBuffer buffer = new UnsafeBuffer(new byte[BUFFER_SIZE]);
    private final Long2ObjectHashMap<RecordingWriter> recordingIdToWriter = new Long2ObjectHashMap();
    private final String logFileDir;
    private final int streamId;
    private final long indexFlushIntervalInNs;
    private final ErrorHandler errorHandler;

    static File fileLocation(String logFileDir, int streamid, long recordingId) {
        return new File(logFileDir + File.separator + FILE_NAME + streamid + "-" + recordingId);
    }

    TimeIndexWriter(String logFileDir, int streamId, long indexFlushIntervalInNs, ErrorHandler errorHandler) {
        this.logFileDir = logFileDir;
        this.streamId = streamId;
        this.indexFlushIntervalInNs = indexFlushIntervalInNs;
        this.errorHandler = errorHandler;
    }

    public void onRecord(long recordingId, long endPosition, long timestamp) {
        RecordingWriter writer = (RecordingWriter)this.recordingIdToWriter.get(recordingId);
        if (writer == null) {
            writer = new RecordingWriter(recordingId);
            this.recordingIdToWriter.put(recordingId, (Object)writer);
        }
        writer.onRecord(endPosition, timestamp);
    }

    public int doWork() {
        int work = 0;
        for (RecordingWriter recordingWriter : this.recordingIdToWriter.values()) {
            work += recordingWriter.doWork();
        }
        return work;
    }

    @Override
    public void close() {
        this.recordingIdToWriter.values().forEach(RecordingWriter::close);
        this.recordingIdToWriter.clear();
    }

    class RecordingWriter {
        private final RandomAccessFile file;
        private final TimeIndexRecordEncoder recordEncoder;
        private final UnsafeBuffer buffer;
        private long nextFlushInNs = 0L;
        private long endPosition;
        private long timestampInNs;

        RecordingWriter(long recordingId) {
            this.recordEncoder = TimeIndexWriter.this.recordEncoder;
            this.buffer = TimeIndexWriter.this.buffer;
            File file = TimeIndexWriter.fileLocation(TimeIndexWriter.this.logFileDir, TimeIndexWriter.this.streamId, recordingId);
            this.file = file.exists() ? this.loadFile(file) : this.createFile(file);
            this.recordEncoder.wrap((MutableDirectBuffer)this.buffer, 0);
        }

        private RandomAccessFile loadFile(File file) {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "rwd");
                raf.seek(raf.length());
                return raf;
            }
            catch (IOException e) {
                TimeIndexWriter.this.errorHandler.onError((Throwable)e);
                return null;
            }
        }

        private RandomAccessFile createFile(File file) {
            try {
                MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
                this.recordEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, headerEncoder);
                RandomAccessFile raf = new RandomAccessFile(file, "rwd");
                raf.write(this.buffer.byteArray(), 0, 8);
                return raf;
            }
            catch (IOException e) {
                TimeIndexWriter.this.errorHandler.onError((Throwable)e);
                return null;
            }
        }

        public void onRecord(long endPosition, long timestampInNs) {
            this.endPosition = endPosition;
            this.timestampInNs = timestampInNs;
        }

        int doWork() {
            long endPosition = this.endPosition;
            long timestampInNs = this.timestampInNs;
            if (endPosition != 0L && timestampInNs > this.nextFlushInNs) {
                this.update(endPosition, timestampInNs);
                this.nextFlushInNs = timestampInNs + TimeIndexWriter.this.indexFlushIntervalInNs;
                return 1;
            }
            return 0;
        }

        private void update(long endPosition, long timestampInNs) {
            try {
                RandomAccessFile file = this.file;
                if (file != null) {
                    this.recordEncoder.position(endPosition).timestamp(timestampInNs);
                    file.write(this.buffer.byteArray(), 0, 16);
                }
            }
            catch (IOException e) {
                TimeIndexWriter.this.errorHandler.onError((Throwable)e);
            }
        }

        void close() {
            this.update(this.endPosition, this.timestampInNs);
            try {
                this.file.getFD().sync();
            }
            catch (IOException e) {
                TimeIndexWriter.this.errorHandler.onError((Throwable)e);
            }
            Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.file});
        }
    }
}

