/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.util.CharFormatter;

public class Indexer
implements Agent,
ControlledFragmentHandler {
    private final CharFormatter indexingFormatter = new CharFormatter("Indexing @ %s from [%s, %s]");
    private final CharFormatter catchupFormatter = new CharFormatter("Catchup [%s]: recordingId = %s, recordingStopped @ %s, indexStopped @ %s");
    private final List<Index> indices;
    private final String agentNamePrefix;
    private final int archiveReplayStream;

    public Indexer(List<Index> indices, String agentNamePrefix, int archiveReplayStream) {
        this.indices = indices;
        this.agentNamePrefix = agentNamePrefix;
        this.archiveReplayStream = archiveReplayStream;
    }

    public int doWork() {
        return this.pollIndexes();
    }

    private int pollIndexes() {
        int total = 0;
        List<Index> indices = this.indices;
        int size = indices.size();
        for (int i = 0; i < size; ++i) {
            Index value = indices.get(i);
            total += value.doWork();
        }
        return total;
    }

    public void catchIndexUp(AeronArchive aeronArchive, ErrorHandler errorHandler) {
        IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
        AgentInvoker aeronInvoker = aeronArchive.context().aeron().conductorAgentInvoker();
        int size = this.indices.size();
        for (int i = 0; i < size; ++i) {
            Index index = this.indices.get(i);
            index.readLastPosition((aeronSessionId, recordingId, indexStoppedPosition) -> {
                block10: {
                    try {
                        long recordingStoppedPosition = aeronArchive.getStopPosition(recordingId);
                        if (recordingStoppedPosition <= indexStoppedPosition) break block10;
                        DebugLogger.log(LogTag.INDEX, this.catchupFormatter, index.getName(), recordingId, recordingStoppedPosition, indexStoppedPosition);
                        long length = recordingStoppedPosition - indexStoppedPosition;
                        try (Subscription subscription = aeronArchive.replay(recordingId, indexStoppedPosition, length, "aeron:ipc", this.archiveReplayStream);){
                            while (subscription.imageCount() != 1) {
                                this.idle(idleStrategy, aeronInvoker, 0);
                                aeronArchive.checkForErrorResponse();
                            }
                            idleStrategy.reset();
                            Image replayImage = subscription.imageAtIndex(0);
                            FragmentHandler handler = (buffer, offset, srcLength, header) -> index.onCatchup(buffer, offset, srcLength, header, recordingId);
                            while (replayImage.position() < recordingStoppedPosition) {
                                int workCount = replayImage.poll(handler, 20);
                                this.idle(idleStrategy, aeronInvoker, workCount);
                            }
                            idleStrategy.reset();
                        }
                    }
                    catch (ArchiveException ex) {
                        errorHandler.onError((Throwable)ex);
                    }
                }
            });
        }
    }

    private void idle(IdleStrategy idleStrategy, AgentInvoker aeronInvoker, int workCount) {
        int totalWork = workCount;
        if (aeronInvoker != null) {
            totalWork += aeronInvoker.invoke();
        }
        idleStrategy.idle(totalWork);
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int streamId = header.streamId();
        int aeronSessionId = header.sessionId();
        long endPosition = header.position();
        DebugLogger.log(LogTag.INDEX, this.indexingFormatter, endPosition, (long)streamId, (long)aeronSessionId);
        int size = this.indices.size();
        for (int i = 0; i < size; ++i) {
            Index index = this.indices.get(i);
            index.onFragment(buffer, offset, length, header);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public void onClose() {
        Exceptions.closeAll(this.indices);
    }

    public String roleName() {
        return this.agentNamePrefix + "Indexer";
    }
}

