/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.driver.DutyCycleTracker;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.Header;
import java.util.ArrayDeque;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.decoder.AbstractResendRequestDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.engine.ReplayerCommandQueue;
import uk.co.real_logic.artio.engine.SenderSequenceNumber;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.AbstractReplayer;
import uk.co.real_logic.artio.engine.logger.FixReplayerCodecs;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecsFactory;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.engine.logger.ReplayTimestamper;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class GapFiller
extends AbstractReplayer {
    private final Long2ObjectHashMap<GapFillerChannel> gapFillerChannels = new Long2ObjectHashMap();
    private final ReplayerCommandQueue replayerCommandQueue;
    private final GatewayPublication publication;
    private final String agentNamePrefix;
    private final ReplayTimestamper timestamper;
    private final AtomicCounter gapfillerCounter;

    public GapFiller(GatewayPublication publication, BufferClaim bufferClaim, String agentNamePrefix, SenderSequenceNumbers senderSequenceNumbers, ReplayerCommandQueue replayerCommandQueue, FixSessionCodecsFactory fixSessionCodecsFactory, AtomicCounter gapfillerCounter, EpochNanoClock clock, DutyCycleTracker dutyCycleTracker) {
        super(publication.dataPublication(), fixSessionCodecsFactory, bufferClaim, senderSequenceNumbers, clock, dutyCycleTracker);
        this.publication = publication;
        this.agentNamePrefix = agentNamePrefix;
        this.replayerCommandQueue = replayerCommandQueue;
        this.gapfillerCounter = gapfillerCounter;
        this.timestamper = new ReplayTimestamper(publication.dataPublication(), clock);
    }

    public void onFragment(DirectBuffer buffer, int start, int length, Header header) {
        if ((header.flags() & 0x80) != 128) {
            return;
        }
        this.messageHeader.wrap(buffer, start);
        int templateId = this.messageHeader.templateId();
        int offset = start + 8;
        int blockLength = this.messageHeader.blockLength();
        int version = this.messageHeader.version();
        if (templateId == 59) {
            this.validResendRequest.wrap(buffer, offset, blockLength, version);
            long sessionId = this.validResendRequest.session();
            long connectionId = this.validResendRequest.connection();
            int beginSeqNo = (int)this.validResendRequest.beginSequenceNumber();
            int endSeqNo = (int)this.validResendRequest.endSequenceNumber();
            int sequenceIndex = this.validResendRequest.sequenceIndex();
            long correlationId = this.validResendRequest.correlationId();
            MutableAsciiBuffer copiedBuffer = new MutableAsciiBuffer(new byte[this.validResendRequest.bodyLength()]);
            this.validResendRequest.getBody((MutableDirectBuffer)copiedBuffer, 0, this.validResendRequest.bodyLength());
            this.onResendRequest(sessionId, connectionId, beginSeqNo, endSeqNo, sequenceIndex, correlationId, copiedBuffer);
        } else {
            this.fixSessionCodecsFactory.onFragment(buffer, start, length, header);
        }
    }

    void onResendRequest(long sessionId, long connectionId, int beginSeqNo, int endSeqNo, int sequenceIndex, long correlationId, MutableAsciiBuffer copiedBuffer) {
        GapFillerSession gapFillerSession = new GapFillerSession(sessionId, connectionId, beginSeqNo, endSeqNo, sequenceIndex, correlationId, copiedBuffer);
        if (this.gapFillerChannels.containsKey(connectionId)) {
            GapFillerChannel gapFillerChannel = (GapFillerChannel)this.gapFillerChannels.get(connectionId);
            gapFillerChannel.enqueue(gapFillerSession);
        } else {
            GapFillerChannel gapFillerChannel = new GapFillerChannel();
            gapFillerChannel.currentSession(gapFillerSession);
            this.gapFillerChannels.put(connectionId, (Object)gapFillerChannel);
            this.gapfillerCounter.increment();
        }
    }

    public int doWork() {
        int workCount = 0;
        long timeInNs = this.clock.nanoTime();
        this.trackDutyCycleTime(timeInNs);
        this.timestamper.sendTimestampMessage(timeInNs);
        workCount += this.replayerCommandQueue.poll();
        return workCount += this.sendGapfills();
    }

    private int sendGapfills() {
        int workCount = 0;
        Long2ObjectHashMap.EntryIterator gapFillerChannelIterator = this.gapFillerChannels.entrySet().iterator();
        while (gapFillerChannelIterator.hasNext()) {
            gapFillerChannelIterator.next();
            long connectionId = gapFillerChannelIterator.getLongKey();
            GapFillerChannel gapFillerChannel = (GapFillerChannel)gapFillerChannelIterator.getValue();
            if (this.checkDisconnected(connectionId)) {
                gapFillerChannelIterator.remove();
                this.gapfillerCounter.decrement();
                continue;
            }
            GapFillerSession currentSession = gapFillerChannel.currentSession();
            workCount += currentSession.doWork();
            if (!currentSession.isDone()) continue;
            GapFillerSession queuedSession = gapFillerChannel.pollEnqueued();
            if (null == queuedSession) {
                gapFillerChannelIterator.remove();
                this.gapfillerCounter.decrement();
                continue;
            }
            gapFillerChannel.currentSession(queuedSession);
        }
        return workCount;
    }

    public String roleName() {
        return this.agentNamePrefix + "GapFiller";
    }

    class GapFillerSession {
        final long sessionId;
        final long connectionId;
        final int beginSeqNo;
        final int endSeqNo;
        final int sequenceIndex;
        final long correlationId;
        final MutableAsciiBuffer copiedBuffer;
        private State state;
        private FixReplayerCodecs fixReplayerCodecs;

        GapFillerSession(long sessionId, long connectionId, int beginSeqNo, int endSeqNo, int sequenceIndex, long correlationId, MutableAsciiBuffer copiedBuffer) {
            this.sessionId = sessionId;
            this.connectionId = connectionId;
            this.beginSeqNo = beginSeqNo;
            this.endSeqNo = endSeqNo;
            this.sequenceIndex = sequenceIndex;
            this.correlationId = correlationId;
            this.copiedBuffer = copiedBuffer;
            this.state = State.INIT;
        }

        boolean isDone() {
            return State.DONE == this.state;
        }

        int doWork() {
            return switch (this.state) {
                default -> throw new IncompatibleClassChangeError();
                case State.INIT -> {
                    SenderSequenceNumber senderSequenceNumber = GapFiller.this.senderSequenceNumbers.senderSequenceNumber(this.connectionId);
                    if (null == senderSequenceNumber) {
                        yield 0;
                    }
                    if (senderSequenceNumber.fixP()) {
                        this.state = State.DONE;
                        yield 0;
                    }
                    this.fixReplayerCodecs = GapFiller.this.fixSessionCodecsFactory.get(this.sessionId);
                    if (null != this.fixReplayerCodecs) {
                        this.state = State.ON_START_REPLAY;
                        yield 1;
                    }
                    yield 0;
                }
                case State.ON_START_REPLAY -> {
                    if (GapFiller.this.trySendStartReplay(this.sessionId, this.connectionId, this.correlationId)) {
                        this.state = State.ON_GAP_FILL;
                        yield 1;
                    }
                    yield 0;
                }
                case State.ON_GAP_FILL -> {
                    AbstractResendRequestDecoder resendRequest = this.fixReplayerCodecs.resendRequest();
                    GapFillEncoder encoder = this.fixReplayerCodecs.gapFillEncoder();
                    resendRequest.decode((AsciiBuffer)this.copiedBuffer, 0, this.copiedBuffer.capacity());
                    SessionHeaderDecoder reqHeader = resendRequest.header();
                    int gapFillMsgSeqNum = this.beginSeqNo;
                    encoder.setupMessage(reqHeader);
                    long result = encoder.encode(gapFillMsgSeqNum, this.endSeqNo + 1);
                    int encodedLength = Encoder.length((long)result);
                    int encodedOffset = Encoder.offset((long)result);
                    long sentPosition = GapFiller.this.publication.saveMessage((DirectBuffer)encoder.buffer(), encodedOffset, encodedLength, 0, 52L, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.OK, gapFillMsgSeqNum);
                    if (0L < sentPosition) {
                        this.state = State.ON_SEND_COMPLETE;
                        yield 1;
                    }
                    yield 0;
                }
                case State.ON_SEND_COMPLETE -> {
                    if (GapFiller.this.sendCompleteMessage(this.connectionId, this.correlationId)) {
                        this.state = State.DONE;
                        yield 1;
                    }
                    yield 0;
                }
                case State.DONE -> 0;
            };
        }

        private static enum State {
            INIT,
            ON_START_REPLAY,
            ON_GAP_FILL,
            ON_SEND_COMPLETE,
            DONE;

        }
    }

    class GapFillerChannel {
        private GapFillerSession currentSession;
        private ArrayDeque<GapFillerSession> enqueued;

        GapFillerChannel() {
        }

        void currentSession(GapFillerSession currentSession) {
            this.currentSession = currentSession;
        }

        GapFillerSession currentSession() {
            return this.currentSession;
        }

        void enqueue(GapFillerSession enqueuedSession) {
            if (null == this.enqueued) {
                this.enqueued = new ArrayDeque();
            }
            this.enqueued.add(enqueuedSession);
        }

        GapFillerSession pollEnqueued() {
            if (null == this.enqueued) {
                return null;
            }
            return this.enqueued.poll();
        }
    }
}

