/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.engine.PossDupEnabler;
import uk.co.real_logic.artio.engine.ReplayHandler;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.framer.FixThrottleRejectBuilder;
import uk.co.real_logic.artio.engine.framer.MessageTypeExtractor;
import uk.co.real_logic.artio.engine.logger.FixMessageTracker;
import uk.co.real_logic.artio.engine.logger.GapFillEncoder;
import uk.co.real_logic.artio.engine.logger.RecordingRange;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.ThrottleNotificationDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class FixReplayerSession
extends ReplayerSession {
    private static final int NONE = -1;
    private static final byte[] NO_BYTES = new byte[0];
    private final GapFillEncoder gapFillEncoder;
    private final PossDupEnabler possDupEnabler;
    private final EpochNanoClock clock;
    private final String message;
    private final ReplayHandler replayHandler;
    private final LongHashSet gapFillMessageTypes;
    private final ErrorHandler errorHandler;
    private final SequenceNumberExtractor sequenceNumberExtractor;
    private final FixThrottleRejectBuilder throttleRejectBuilder;
    private final int overriddenBeginSeqNo;
    private int lastSeqNo;
    private int headerSeqNum;
    private int beginGapFillSeqNum = -1;
    private State state;

    FixReplayerSession(BufferClaim bufferClaim, IdleStrategy idleStrategy, ReplayHandler replayHandler, int maxClaimAttempts, LongHashSet gapFillMessageTypes, ExclusivePublication publication, EpochNanoClock clock, int beginSeqNo, int endSeqNo, long connectionId, long correlationId, long sessionId, int sequenceIndex, int overriddenBeginSeqNo, ReplayQuery replayQuery, String message, ErrorHandler errorHandler, GapFillEncoder gapFillEncoder, AtomicCounter bytesInBuffer, int maxBytesInBuffer, UtcTimestampEncoder utcTimestampEncoder, Replayer replayer, FixThrottleRejectBuilder throttleRejectBuilder, List<RecordingRange> recordingRanges) {
        super(connectionId, correlationId, bufferClaim, idleStrategy, maxClaimAttempts, publication, replayQuery, beginSeqNo, endSeqNo, sessionId, sequenceIndex, replayer, bytesInBuffer, maxBytesInBuffer);
        this.replayHandler = replayHandler;
        this.gapFillMessageTypes = gapFillMessageTypes;
        this.clock = clock;
        this.message = message;
        this.errorHandler = errorHandler;
        this.gapFillEncoder = gapFillEncoder;
        this.overriddenBeginSeqNo = overriddenBeginSeqNo;
        this.sequenceNumberExtractor = new SequenceNumberExtractor();
        if (beginSeqNo < overriddenBeginSeqNo) {
            this.beginGapFillSeqNum = beginSeqNo;
            this.lastSeqNo = overriddenBeginSeqNo - 1;
        } else {
            this.beginGapFillSeqNum = -1;
            this.lastSeqNo = beginSeqNo - 1;
        }
        this.throttleRejectBuilder = throttleRejectBuilder;
        this.possDupEnabler = new PossDupEnabler(utcTimestampEncoder, bufferClaim, this::claimBuffer, this::onPreCommit, x$0 -> this.onIllegalState((String)x$0, new Object[0]), this::onException, clock, publication.maxPayloadLength());
        FixMessageTracker fixMessageTracker = new FixMessageTracker(LogTag.REPLAY_MESSAGE, this, sessionId);
        this.replayOperation = replayQuery.newReplayOperation(recordingRanges, LogTag.REPLAY, fixMessageTracker);
        this.state = State.START_REPLAY;
    }

    private void onPreCommit(MutableDirectBuffer buffer, int offset) {
        int frameOffset = offset + 8;
        this.replayer.fixMessageEncoder.wrap(buffer, frameOffset).connection(this.connectionId).sequenceNumber(this.headerSeqNum);
    }

    private void onException(Throwable e) {
        String exMessage = String.format("[%s] Error replying to message", this.message);
        this.errorHandler.onError((Throwable)new IllegalArgumentException(exMessage, e));
    }

    private void onIllegalState(String message, Object ... arguments) {
        this.errorHandler.onError((Throwable)new IllegalStateException(String.format(message, arguments)));
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header) {
        MessageHeaderDecoder messageHeader = this.replayer.messageHeaderDecoder.wrap(srcBuffer, srcOffset);
        int actingBlockLength = messageHeader.blockLength();
        int templateId = messageHeader.templateId();
        int offset = srcOffset + 8;
        int version = messageHeader.version();
        switch (templateId) {
            case 1: {
                return this.onFixMessage(srcBuffer, srcOffset, srcLength, actingBlockLength, offset, version);
            }
            case 71: {
                return this.onThrottleReject(srcBuffer, actingBlockLength, offset, version);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onFixMessage(DirectBuffer srcBuffer, int srcOffset, int srcLength, int actingBlockLength, int offset, int version) {
        FixMessageDecoder fixMessageDecoder = this.replayer.fixMessageDecoder;
        fixMessageDecoder.wrap(srcBuffer, offset, actingBlockLength, version);
        if (fixMessageDecoder.status() == MessageStatus.OK) {
            int metaDataAdjustment = version >= FixMessageDecoder.metaDataSinceVersion() ? FixMessageDecoder.metaDataHeaderLength() + fixMessageDecoder.metaDataLength() : 0;
            int messageFrameBlockLength = Replayer.MESSAGE_FRAME_BLOCK_LENGTH + metaDataAdjustment;
            int messageOffset = srcOffset + messageFrameBlockLength;
            int messageLength = srcLength - messageFrameBlockLength;
            int msgSeqNum = this.sequenceNumberExtractor.extract(srcBuffer, messageOffset, messageLength);
            long messageType = MessageTypeExtractor.getMessageType(fixMessageDecoder);
            AsciiBuffer asciiBuffer = this.replayer.sessionAsciiBuffer;
            asciiBuffer.wrap(srcBuffer);
            this.replayHandler.onReplayedMessage((DirectBuffer)asciiBuffer, messageOffset, messageLength, fixMessageDecoder.libraryId(), fixMessageDecoder.session(), fixMessageDecoder.sequenceIndex(), messageType);
            if (this.gapFillMessageTypes.contains(messageType)) {
                if (this.beginGapFillSeqNum == -1) {
                    this.beginGapFillSeqNum(this.lastSeqNo + 1);
                }
                this.lastSeqNo = msgSeqNum;
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            if (this.beginGapFillSeqNum != -1) {
                this.sendGapFill(this.beginGapFillSeqNum, msgSeqNum, false);
            } else if (msgSeqNum > this.lastSeqNo + 1) {
                if (this.lastSeqNo == 0) {
                    this.lastSeqNo = 1;
                }
                this.sendGapFill(this.lastSeqNo, msgSeqNum, false);
            }
            this.headerSeqNum = msgSeqNum == this.endSeqNo ? msgSeqNum : 0;
            ControlledFragmentHandler.Action action = this.possDupEnabler.enablePossDupFlag(srcBuffer, messageOffset, messageLength, srcOffset, srcLength, metaDataAdjustment, messageType);
            if (action != ControlledFragmentHandler.Action.ABORT) {
                this.lastSeqNo = msgSeqNum;
            }
            return action;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onThrottleReject(DirectBuffer srcBuffer, int actingBlockLength, int offset, int version) {
        ThrottleRejectDecoder throttleRejectDecoder = this.replayer.throttleRejectDecoder;
        throttleRejectDecoder.wrap(srcBuffer, offset, actingBlockLength, version);
        int msgSeqNum = throttleRejectDecoder.sequenceNumber();
        if (this.gapFillMessageTypes.contains(106L)) {
            if (this.beginGapFillSeqNum == -1) {
                this.beginGapFillSeqNum(this.lastSeqNo + 1);
            }
            this.lastSeqNo = msgSeqNum;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.beginGapFillSeqNum != -1) {
            this.sendGapFill(this.beginGapFillSeqNum, msgSeqNum, false);
        } else if (msgSeqNum > this.lastSeqNo + 1) {
            this.sendGapFill(this.lastSeqNo, msgSeqNum, false);
        }
        int businessRejectRefIDOffset = throttleRejectDecoder.limit() + ThrottleNotificationDecoder.businessRejectRefIDHeaderLength();
        this.throttleRejectBuilder.build(throttleRejectDecoder.refMsgType(), throttleRejectDecoder.refSeqNum(), throttleRejectDecoder.sequenceNumber(), srcBuffer, businessRejectRefIDOffset, throttleRejectDecoder.businessRejectRefIDLength(), true);
        ControlledFragmentHandler.Action action = this.sendFixMessage(this.throttleRejectBuilder.buffer(), this.throttleRejectBuilder.offset(), this.throttleRejectBuilder.length(), 106L, 0);
        if (action == ControlledFragmentHandler.Action.CONTINUE) {
            this.lastSeqNo = msgSeqNum;
        }
        return action;
    }

    private ControlledFragmentHandler.Action sendGapFill(int msgSeqNo, int newSeqNo, boolean lastMessage) {
        int sequenceNumber;
        long result = this.gapFillEncoder.encode(msgSeqNo, newSeqNo);
        int gapFillLength = Encoder.length((long)result);
        int gapFillOffset = Encoder.offset((long)result);
        MutableAsciiBuffer buffer = this.gapFillEncoder.buffer();
        ControlledFragmentHandler.Action action = this.sendFixMessage(buffer, gapFillOffset, gapFillLength, 52L, sequenceNumber = lastMessage ? msgSeqNo : 0);
        if (action == ControlledFragmentHandler.Action.CONTINUE) {
            this.beginGapFillSeqNum(-1);
        }
        return action;
    }

    private ControlledFragmentHandler.Action sendFixMessage(MutableAsciiBuffer fixBuffer, int fixOffset, int fixLength, long messageType, int sequenceNumber) {
        if (this.claimBuffer(Replayer.MESSAGE_FRAME_BLOCK_LENGTH + fixLength + FixMessageDecoder.metaDataHeaderLength(), fixLength)) {
            int destOffset = this.bufferClaim.offset();
            MutableDirectBuffer destBuffer = this.bufferClaim.buffer();
            this.replayer.fixMessageEncoder.wrapAndApplyHeader(destBuffer, destOffset, this.replayer.messageHeaderEncoder).session(this.sessionId).connection(this.connectionId).timestamp(this.clock.nanoTime()).status(MessageStatus.OK).libraryId(0).sequenceIndex(this.sequenceIndex).sequenceNumber(sequenceNumber).messageType(messageType).putMetaData(NO_BYTES, 0, 0).putBody((DirectBuffer)fixBuffer, fixOffset, fixLength);
            this.bufferClaim.commit();
            DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Replayed: ", (DirectBuffer)fixBuffer, fixOffset, fixLength);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        DebugLogger.log(LogTag.REPLAY, "Back pressured trying to sendFixMessage");
        return ControlledFragmentHandler.Action.ABORT;
    }

    @Override
    boolean attemptReplay() {
        switch (this.state) {
            case START_REPLAY: {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: START_REPLAY step");
                if (this.tryStartReplayMessage()) {
                    this.state = State.REPLAYING;
                }
                return false;
            }
            case REPLAYING: {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: REPLAYING step");
                if (this.replayOperation.pollReplay()) {
                    this.state = State.CHECK_REPLAY;
                    return this.attemptReplay();
                }
                return false;
            }
            case CHECK_REPLAY: {
                DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: CHECK_REPLAY step");
                if (this.completeReplay()) {
                    this.state = State.SEND_COMPLETE_MESSAGE;
                }
                return false;
            }
            case SEND_COMPLETE_MESSAGE: {
                return this.sendCompleteMessage();
            }
            case CLOSING: {
                return this.replayOperation.pollReplay();
            }
        }
        return false;
    }

    private boolean completeReplay() {
        int replayedMessages = this.replayOperation.replayedMessages();
        int newSequenceNumber = this.endSeqNo + 1;
        if (this.beginGapFillSeqNum != -1) {
            if (newSequenceNumber > this.beginGapFillSeqNum) {
                ControlledFragmentHandler.Action action = this.sendGapFill(this.beginGapFillSeqNum, newSequenceNumber, true);
                if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
                    DebugLogger.log(LogTag.REPLAY, this.replayer.completeReplayGapfillFormatter.clear().with(action.name()).with(replayedMessages).with(this.beginGapFillSeqNum).with(newSequenceNumber).with(this.connectionId));
                }
                return action != ControlledFragmentHandler.Action.ABORT;
            }
        } else {
            int adjustedBeginSeqNo = Replayer.adjustBeginningSequenceNo(this.beginSeqNo, this.overriddenBeginSeqNo);
            int expectedCount = this.endSeqNo - adjustedBeginSeqNo + 1;
            if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
                DebugLogger.log(LogTag.REPLAY, this.replayer.completeNotRecentFormatter.clear().with(replayedMessages).with(this.endSeqNo).with(this.beginSeqNo).with(this.overriddenBeginSeqNo).with(expectedCount).with(this.connectionId));
            }
            if (replayedMessages != expectedCount) {
                ControlledFragmentHandler.Action action;
                if (this.lastSeqNo < this.endSeqNo && (action = this.sendGapFill(this.lastSeqNo + 1, newSequenceNumber, true)) == ControlledFragmentHandler.Action.ABORT) {
                    return false;
                }
                this.onIllegalState("[%s] Error in resend request, count(%d) < expectedCount (%d), newSequenceNumber(%d), endSeqNo(%d)", this.message, replayedMessages, expectedCount, newSequenceNumber, this.endSeqNo);
            }
        }
        return true;
    }

    @Override
    void startClose() {
        this.state = State.CLOSING;
        super.startClose();
    }

    public String toString() {
        return "FixReplayerSession{message='" + this.message + "', gapFillMessageTypes=" + String.valueOf(this.gapFillMessageTypes) + ", bytesInBuffer=" + String.valueOf(this.bytesInBuffer) + ", maxBytesInBuffer=" + this.maxBytesInBuffer + ", lastSeqNo=" + this.lastSeqNo + ", beginGapFillSeqNum=" + this.beginGapFillSeqNum + ", state=" + String.valueOf((Object)this.state) + ", connectionId=" + this.connectionId + ", beginSeqNo=" + this.beginSeqNo + ", endSeqNo=" + this.endSeqNo + ", overriddenBeginSeqNo=" + this.overriddenBeginSeqNo + ", sessionId=" + this.sessionId + ", sequenceIndex=" + this.sequenceIndex + "}";
    }

    public void beginGapFillSeqNum(int beginGapFillSeqNum) {
        this.beginGapFillSeqNum = beginGapFillSeqNum;
    }

    private static enum State {
        START_REPLAY,
        REPLAYING,
        CHECK_REPLAY,
        SEND_COMPLETE_MESSAGE,
        CLOSING;

    }
}

