/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.CompletionPosition;
import uk.co.real_logic.artio.engine.logger.AbstractReplayer;
import uk.co.real_logic.artio.engine.logger.Indexer;

public class ArchivingAgents
implements Agent,
FragmentHandler {
    static final int LIMIT = 20;
    private final Indexer indexer;
    private final AbstractReplayer abstractReplayer;
    private final Subscription subscription;
    private final CompletionPosition completionPosition;

    public ArchivingAgents(Indexer indexer, AbstractReplayer abstractReplayer, Subscription subscription, CompletionPosition completionPosition) {
        this.indexer = Objects.requireNonNull(indexer);
        this.abstractReplayer = abstractReplayer;
        this.subscription = subscription;
        this.completionPosition = completionPosition;
    }

    public void onStart() {
        this.indexer.onStart();
        if (null != this.abstractReplayer) {
            this.abstractReplayer.onStart();
        }
    }

    public int doWork() throws Exception {
        int workCount = 0;
        workCount += this.subscription.poll((FragmentHandler)this, 20);
        workCount += this.indexer.doWork();
        if (null != this.abstractReplayer) {
            workCount += this.abstractReplayer.doWork();
        }
        return workCount;
    }

    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.indexer.onFragment(buffer, offset, length, header);
        if (null != this.abstractReplayer) {
            this.abstractReplayer.onFragment(buffer, offset, length, header);
        }
    }

    public void catchIndexUp(AeronArchive aeronArchive, ErrorHandler errorHandler) {
        this.indexer.catchIndexUp(aeronArchive, errorHandler);
    }

    public void onClose() {
        this.quiesce();
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{() -> Exceptions.closeAll((Agent[])new Agent[]{this.indexer, this.abstractReplayer}), this.subscription});
    }

    private void quiesce() {
        while (!this.completionPosition.hasCompleted()) {
            Thread.yield();
        }
        if (this.completionPosition.wasStartupComplete()) {
            return;
        }
        this.subscription.controlledPoll(this::quiesceFragment, Integer.MAX_VALUE);
    }

    private ControlledFragmentHandler.Action quiesceFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (header.position() <= this.completedPosition(header.sessionId())) {
            this.onFragment(buffer, offset, length, header);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        return ControlledFragmentHandler.Action.ABORT;
    }

    private long completedPosition(int aeronSessionId) {
        return this.completionPosition.positions().get((long)aeronSessionId);
    }

    public String roleName() {
        if (null != this.abstractReplayer) {
            return this.indexer.roleName() + "," + this.abstractReplayer.roleName();
        }
        return this.indexer.roleName();
    }
}

