/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.driver.DutyCycleTracker;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.FragmentHandler;
import java.util.function.Consumer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecsFactory;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.ReplayCompleteEncoder;
import uk.co.real_logic.artio.messages.StartReplayEncoder;
import uk.co.real_logic.artio.messages.ValidResendRequestDecoder;
import uk.co.real_logic.artio.util.CharFormatter;

public abstract class AbstractReplayer
implements Agent,
FragmentHandler {
    static final int REPLAY_COMPLETE_LEN = 28;
    static final int START_REPLAY_LENGTH = 32;
    final MessageHeaderDecoder messageHeader = new MessageHeaderDecoder();
    final ValidResendRequestDecoder validResendRequest = new ValidResendRequestDecoder();
    final StartReplayEncoder startReplayEncoder = new StartReplayEncoder();
    final Consumer<StringBuilder> validResendRequestAppendTo = arg_0 -> ((ValidResendRequestDecoder)this.validResendRequest).appendTo(arg_0);
    final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    final ReplayCompleteEncoder replayCompleteEncoder = new ReplayCompleteEncoder();
    final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final CharFormatter alreadyDisconnectedFormatter = new CharFormatter("Not processing Resend Request for connId=%s because it has already disconnected");
    final CharFormatter completeReplayGapfillFormatter = new CharFormatter("ReplayerSession: completeReplay-sendGapFill action=%s, replayedMessages=%s, beginGapFillSeqNum=%s, newSequenceNumber=%s connId=%s");
    final ExclusivePublication publication;
    final FixSessionCodecsFactory fixSessionCodecsFactory;
    final BufferClaim bufferClaim;
    final SenderSequenceNumbers senderSequenceNumbers;
    protected final EpochNanoClock clock;
    private final DutyCycleTracker dutyCycleTracker;

    AbstractReplayer(ExclusivePublication publication, FixSessionCodecsFactory fixSessionCodecsFactory, BufferClaim bufferClaim, SenderSequenceNumbers senderSequenceNumbers, EpochNanoClock clock, DutyCycleTracker dutyCycleTracker) {
        this.publication = publication;
        this.fixSessionCodecsFactory = fixSessionCodecsFactory;
        this.bufferClaim = bufferClaim;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.clock = clock;
        this.dutyCycleTracker = dutyCycleTracker;
    }

    boolean trySendStartReplay(long sessionId, long connectionId, long correlationId) {
        if (this.publication.tryClaim(32, this.bufferClaim) > 0L) {
            MutableDirectBuffer buffer = this.bufferClaim.buffer();
            int offset = this.bufferClaim.offset();
            this.startReplayEncoder.wrapAndApplyHeader(buffer, offset, this.messageHeaderEncoder).session(sessionId).connection(connectionId).correlationId(correlationId);
            DebugLogger.logSbeMessage(LogTag.REPLAY, this.startReplayEncoder);
            this.bufferClaim.commit();
            return true;
        }
        return false;
    }

    public void onStart() {
        this.dutyCycleTracker.update(this.clock.nanoTime());
    }

    protected void trackDutyCycleTime(long timeInNs) {
        this.dutyCycleTracker.measureAndUpdate(timeInNs);
    }

    public void onClose() {
        this.publication.close();
    }

    boolean checkDisconnected(long connectionId) {
        if (this.senderSequenceNumbers.hasDisconnected(connectionId)) {
            DebugLogger.log(LogTag.REPLAY, this.alreadyDisconnectedFormatter, connectionId);
            return true;
        }
        return false;
    }

    boolean sendCompleteMessage(long connectionId, long correlationId) {
        if (this.publication.tryClaim(28, this.bufferClaim) > 0L) {
            ReplayCompleteEncoder replayComplete = this.replayCompleteEncoder;
            replayComplete.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).libraryId(0).connection(connectionId).correlationId(correlationId);
            DebugLogger.logSbeMessage(LogTag.REPLAY, replayComplete);
            this.bufferClaim.commit();
            return true;
        }
        return false;
    }
}

