/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.Framer;

class UnbindCommand
implements AdminCommand,
Reply<Void> {
    private volatile Reply.State state = Reply.State.EXECUTING;
    private UnbindCommand concurrentUnbind;
    private Exception error;
    private final boolean disconnect;

    UnbindCommand(boolean disconnect) {
        this.disconnect = disconnect;
    }

    @Override
    public void execute(Framer framer) {
        framer.onUnbind(this);
    }

    void success() {
        this.state = Reply.State.COMPLETED;
        if (this.concurrentUnbind != null) {
            this.concurrentUnbind.success();
        }
    }

    void onError(Exception error) {
        this.error = error;
        this.state = Reply.State.ERRORED;
        if (this.concurrentUnbind != null) {
            this.concurrentUnbind.onError(error);
        }
    }

    @Override
    public Exception error() {
        return this.error;
    }

    @Override
    public Void resultIfPresent() {
        return null;
    }

    @Override
    public Reply.State state() {
        return this.state;
    }

    boolean disconnect() {
        return this.disconnect;
    }

    public String toString() {
        return "UnbindCommand{disconnect=" + this.disconnect + ", state=" + String.valueOf((Object)this.state) + ", error=" + String.valueOf(this.error) + "}";
    }

    public void addConcurrentUnbind(UnbindCommand unbindCommand) {
        if (this.concurrentUnbind == null) {
            this.concurrentUnbind = unbindCommand;
        } else {
            this.concurrentUnbind.addConcurrentUnbind(unbindCommand);
        }
    }
}

