/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.function.LongToIntFunction;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.AdminReplyPublication;
import uk.co.real_logic.artio.engine.framer.FixGatewaySession;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.Session;

class ResetSequenceNumberCommand
implements Reply<Void>,
AdminCommand {
    private volatile Reply.State state = Reply.State.EXECUTING;
    private Exception error;
    private final long sessionId;
    private final GatewaySessions gatewaySessions;
    private final SessionContexts sessionContexts;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final GatewayPublication inboundPublication;
    private final GatewayPublication outboundPublication;
    private final long resetTimeInNs;
    private Session session;
    private LongToIntFunction libraryLookup;
    private long awaitSequenceNumber = 1L;
    private boolean isAdminReset = false;
    private long adminCorrelationId;
    private AdminReplyPublication adminReplyPublication;
    private Step step = Step.START;

    void libraryLookup(LongToIntFunction libraryLookup) {
        this.libraryLookup = libraryLookup;
    }

    void setupAdminReset(long correlationId, AdminReplyPublication adminReplyPublication) {
        this.isAdminReset = true;
        this.adminCorrelationId = correlationId;
        this.adminReplyPublication = adminReplyPublication;
    }

    ResetSequenceNumberCommand(long sessionId, GatewaySessions gatewaySessions, SessionContexts sessionContexts, SequenceNumberIndexReader receivedSequenceNumberIndex, SequenceNumberIndexReader sentSequenceNumberIndex, GatewayPublication inboundPublication, GatewayPublication outboundPublication, long resetTimeInNs) {
        this.sessionId = sessionId;
        this.gatewaySessions = gatewaySessions;
        this.sessionContexts = sessionContexts;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.inboundPublication = inboundPublication;
        this.outboundPublication = outboundPublication;
        this.resetTimeInNs = resetTimeInNs;
    }

    @Override
    public Exception error() {
        return this.error;
    }

    private void onError(Exception error) {
        this.error = error;
        this.state = Reply.State.ERRORED;
    }

    @Override
    public Void resultIfPresent() {
        return null;
    }

    @Override
    public Reply.State state() {
        return this.state;
    }

    @Override
    public void execute(Framer framer) {
        framer.onResetSequenceNumber(this);
    }

    boolean poll() {
        switch (this.step) {
            case START: {
                if (this.sessionIsUnknown()) {
                    this.onError(new IllegalArgumentException(String.format("Unknown sessionId: %d", this.sessionId)));
                    return true;
                }
                GatewaySession gatewaySession = this.gatewaySessions.sessionById(this.sessionId);
                if (gatewaySession instanceof FixGatewaySession) {
                    this.session = ((FixGatewaySession)gatewaySession).session();
                }
                if (this.session != null) {
                    this.step = Step.RESET_ENGINE_SESSION;
                } else if (this.isAuthenticated()) {
                    this.step = Step.RESET_LIBRARY_SESSION;
                } else {
                    this.sessionContexts.sequenceReset(this.sessionId, this.resetTimeInNs);
                    this.step = Step.RESET_RECV;
                }
                return false;
            }
            case RESET_ENGINE_SESSION: {
                long position = this.session.tryResetSequenceNumbers();
                if (!Pressure.isBackPressured(position)) {
                    this.awaitSequenceNumber = 1L;
                    this.step = Step.AWAIT_RECV;
                }
                return false;
            }
            case RESET_LIBRARY_SESSION: {
                if (this.isAuthenticated()) {
                    int libraryId = this.libraryLookup.applyAsInt(this.sessionId);
                    if (!Pressure.isBackPressured(this.inboundPublication.saveResetLibrarySequenceNumber(libraryId, this.sessionId))) {
                        this.awaitSequenceNumber = 1L;
                        this.step = Step.AWAIT_RECV;
                    }
                } else {
                    this.step = Step.START;
                }
                return false;
            }
            case RESET_RECV: {
                this.awaitSequenceNumber = 0L;
                return this.reset(this.inboundPublication, Step.RESET_SENT);
            }
            case RESET_SENT: {
                this.awaitSequenceNumber = 0L;
                return this.reset(this.outboundPublication, Step.AWAIT_RECV);
            }
            case AWAIT_RECV: {
                return this.await(this.receivedSequenceNumberIndex, Step.AWAIT_SENT);
            }
            case AWAIT_SENT: {
                return this.await(this.sentSequenceNumberIndex, this.isAdminReset ? Step.NOTIFY_ADMIN_API : Step.DONE);
            }
            case NOTIFY_ADMIN_API: {
                return this.notifyAdminApi();
            }
            case DONE: {
                this.state = Reply.State.COMPLETED;
                return true;
            }
        }
        return false;
    }

    private boolean notifyAdminApi() {
        if (this.adminReplyPublication.saveGenericAdminReply(this.adminCorrelationId, GatewayError.NULL_VAL, "") > 0L) {
            this.step = Step.DONE;
        }
        return false;
    }

    private boolean isAuthenticated() {
        return this.sessionContexts.isAuthenticated(this.sessionId);
    }

    private boolean reset(GatewayPublication publication, Step nextStep) {
        if (!Pressure.isBackPressured(publication.saveResetSequenceNumber(this.sessionId))) {
            this.step = nextStep;
        }
        return false;
    }

    private boolean await(SequenceNumberIndexReader sequenceNumberIndex, Step nextStep) {
        boolean done;
        int lastKnownSequenceNumber = sequenceNumberIndex.lastKnownSequenceNumber(this.sessionId);
        boolean bl = done = (long)lastKnownSequenceNumber <= this.awaitSequenceNumber;
        if (done) {
            this.step = nextStep;
        }
        return false;
    }

    private boolean sessionIsUnknown() {
        return !this.sessionContexts.isKnownSessionId(this.sessionId);
    }

    public String toString() {
        return "ResetSequenceNumberReply{state=" + String.valueOf((Object)this.state) + ", error=" + String.valueOf(this.error) + ", sessionId=" + this.sessionId + ", step=" + String.valueOf((Object)this.step) + "}";
    }

    private static enum Step {
        START,
        RESET_ENGINE_SESSION,
        RESET_LIBRARY_SESSION,
        RESET_SENT,
        RESET_RECV,
        AWAIT_RECV,
        AWAIT_SENT,
        NOTIFY_ADMIN_API,
        DONE;

    }
}

