/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.builder.AbstractBusinessMessageRejectEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class FixThrottleRejectBuilder {
    private static final int BUFFER_CAPACITY = 512;
    private final MutableAsciiBuffer businessRejectBuffer;
    private int offset;
    private int length;
    private final UtcTimestampEncoder timestampEncoder;
    private final EpochNanoClock clock;
    private final AbstractBusinessMessageRejectEncoder businessMessageReject;
    private final byte[] refMsgTypeBuffer = new byte[2];

    public FixThrottleRejectBuilder(FixDictionary fixDictionary, ErrorHandler errorHandler, long sessionId, long connectionId, UtcTimestampEncoder timestampEncoder, EpochNanoClock clock, int throttleWindowInMs, int throttleLimitOfMessages) {
        this.timestampEncoder = timestampEncoder;
        this.clock = clock;
        this.businessRejectBuffer = new MutableAsciiBuffer(ByteBuffer.allocateDirect(512));
        this.businessMessageReject = fixDictionary.makeBusinessMessageRejectEncoder();
        if (this.businessMessageReject == null) {
            errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to create business reject when attempting to provide a throttle based rejection for sessId=%d,connId=%d - this is a fatal error for this session / connection", sessionId, connectionId)));
        } else {
            this.configureThrottle(throttleWindowInMs, throttleLimitOfMessages);
        }
    }

    boolean configureThrottle(int throttleWindowInMs, int throttleLimitOfMessages) {
        if (this.businessMessageReject != null) {
            this.businessMessageReject.text((CharSequence)String.format("Throttle limit exceeded (%s in %sms)", throttleLimitOfMessages, throttleWindowInMs));
            return true;
        }
        return false;
    }

    public boolean build(long refMsgType, int refSeqNum, int sequenceNumber, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength, boolean possDup) {
        AbstractBusinessMessageRejectEncoder businessMessageReject = this.businessMessageReject;
        if (businessMessageReject == null) {
            return false;
        }
        UtcTimestampEncoder timestampEncoder = this.timestampEncoder;
        byte[] refMsgTypeBuffer = this.refMsgTypeBuffer;
        MutableAsciiBuffer businessRejectBuffer = this.businessRejectBuffer;
        long timeInNs = this.clock.nanoTime();
        SessionHeaderEncoder header = businessMessageReject.header();
        header.sendingTime(timestampEncoder.buffer(), timestampEncoder.encodeFrom(timeInNs, TimeUnit.NANOSECONDS)).msgSeqNum(sequenceNumber);
        if (possDup) {
            header.possDupFlag(true);
        }
        int refMsgTypeLength = MessageTypeEncoding.unpackMessageType((long)refMsgType, (byte[])refMsgTypeBuffer);
        businessMessageReject.refMsgType(refMsgTypeBuffer, 0, refMsgTypeLength).refSeqNum(refSeqNum).businessRejectReason(99).businessRejectRefID(businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength);
        long result = businessMessageReject.encode(businessRejectBuffer, 0);
        this.offset = Encoder.offset((long)result);
        this.length = Encoder.length((long)result);
        return true;
    }

    public SessionHeaderEncoder header() {
        return this.businessMessageReject.header();
    }

    public MutableAsciiBuffer buffer() {
        return this.businessRejectBuffer;
    }

    public int offset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public long messageType() {
        return this.businessMessageReject.messageType();
    }
}

