/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.BusinessRejectRefIdExtractor;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.SessionConstants;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.framer.AcceptorFixDictionaryLookup;
import uk.co.real_logic.artio.engine.framer.FixContexts;
import uk.co.real_logic.artio.engine.framer.FixGatewaySession;
import uk.co.real_logic.artio.engine.framer.FixGatewaySessions;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.PasswordCleaner;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class FixReceiverEndPoint
extends ReceiverEndPoint {
    private static final byte[] PROXY_V1_SIG = "PROXY ".getBytes(StandardCharsets.US_ASCII);
    private static final int PROXY_V1_SIG_LEN = PROXY_V1_SIG.length;
    private static final byte[] PROXY_V2_SIG = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final int PROXY_V2_SIG_LEN;
    private static final int PROXY_V2_VER_CMD_OFFSET;
    private static final int PROXY_V2_VER_CMD_SIZE = 1;
    private static final byte PROXY_V2_VER = 32;
    private static final byte PROXY_V2_CMD_LOCAL = 0;
    private static final byte PROXY_V2_CMD_PROXY = 1;
    private static final int PROXY_V2_FAMILY_OFFSET;
    private static final int PROXY_V2_FAMILY_SIZE = 1;
    private static final byte PROXY_V2_FAMILY_UNSPEC = 0;
    private static final byte PROXY_V2_FAMILY_TCP_4 = 17;
    private static final byte PROXY_V2_FAMILY_TCP_6 = 33;
    private static final int PROXY_V2_BODY_LENGTH_OFFSET;
    private static final int PROXY_V2_BODY_LENGTH_SIZE = 2;
    private static final int PROXY_V2_ADDRESS_OFFSET;
    private static final int PROXY_V2_TCP4_ADDR_SIZE = 4;
    private static final int PROXY_V2_TCP4_PORT_SIZE = 2;
    private static final int PROXY_V2_TCP4_SRC_ADDR_OFFSET;
    private static final int PROXY_V2_TCP4_DST_ADDR_OFFSET;
    private static final int PROXY_V2_TCP4_SRC_PORT_OFFSET;
    private static final int PROXY_V2_TCP4_DST_PORT_OFFSET;
    private static final int PROXY_V2_TCP6_ADDR_SIZE = 16;
    private static final int PROXY_V2_TCP6_PORT_SIZE = 2;
    private static final int IPV6_DIGITS = 8;
    private static final int[] IPV6_LOCALHOST_DIGITS;
    private static final String IPV6_LOCALHOST = "::1:";
    private static final int PROXY_V2_TCP6_SRC_ADDR_OFFSET;
    private static final int PROXY_V2_TCP6_DST_ADDR_OFFSET;
    private static final int PROXY_V2_TCP6_SRC_PORT_OFFSET;
    private static final int PROXY_V2_TCP6_DST_PORT_OFFSET;
    private static final int PROXY_V2_MIN_LENGTH;
    private static final char INVALID_MESSAGE_TYPE = '-';
    private static final byte BODY_LENGTH_FIELD = 9;
    private static final byte BEGIN_STRING_FIELD = 8;
    private static final byte CHECKSUM0 = 1;
    private static final byte CHECKSUM1 = 49;
    private static final byte CHECKSUM2 = 48;
    private static final byte CHECKSUM3 = 61;
    private static final int MIN_CHECKSUM_SIZE;
    private static final int CHECKSUM_TAG_SIZE;
    private static final int UNKNOWN_MESSAGE_TYPE = -1;
    private static final int BREAK = -1;
    private static final int UNKNOWN_INDEX_BACKPRESSURED = -2;
    private static final int PASSWORD_CLEANED = 0;
    private final FixContexts fixContexts;
    private final AtomicCounter messagesRead;
    private final PasswordCleaner passwordCleaner = new PasswordCleaner();
    private final BusinessRejectRefIdExtractor businessRejectRefIdExtractor = new BusinessRejectRefIdExtractor();
    private final FixGatewaySessions gatewaySessions;
    private final EpochNanoClock clock;
    private final AcceptorFixDictionaryLookup acceptorFixDictionaryLookup;
    private final FixReceiverEndPointFormatters formatters;
    private final boolean reproductionEnabled;
    private FixGatewaySession gatewaySession;
    private long sessionId;
    private int sequenceIndex;
    private int pendingSequenceIndex;
    private boolean isPaused = false;
    private int pendingAcceptorLogonMsgOffset;
    private int pendingAcceptorLogonMsgLength;
    private long lastReadTimestampInNs;
    private String address;
    private boolean requiresProxyCheck = true;

    FixReceiverEndPoint(TcpChannel channel, int bufferSize, GatewayPublication publication, long connectionId, long sessionId, int sequenceIndex, FixContexts fixContexts, AtomicCounter messagesRead, Framer framer, ErrorHandler errorHandler, int libraryId, FixGatewaySessions gatewaySessions, EpochNanoClock clock, AcceptorFixDictionaryLookup acceptorFixDictionaryLookup, FixReceiverEndPointFormatters formatters, int throttleWindowInMs, int throttleLimitOfMessages, boolean reproductionEnabled) {
        super(publication, channel, connectionId, bufferSize, errorHandler, framer, libraryId, throttleWindowInMs, throttleLimitOfMessages);
        Objects.requireNonNull(fixContexts, "sessionContexts");
        Objects.requireNonNull(gatewaySessions, "gatewaySessions");
        Objects.requireNonNull(clock, "clock");
        this.formatters = formatters;
        this.sessionId = sessionId;
        this.sequenceIndex = sequenceIndex - 1;
        this.fixContexts = fixContexts;
        this.messagesRead = messagesRead;
        this.gatewaySessions = gatewaySessions;
        this.clock = clock;
        this.acceptorFixDictionaryLookup = acceptorFixDictionaryLookup;
        this.reproductionEnabled = reproductionEnabled;
        this.address = channel.remoteAddr();
    }

    private int readData() throws IOException {
        int dataRead = this.channel.read(this.byteBuffer);
        if (dataRead != -1) {
            if (dataRead > 0) {
                DebugLogger.log(LogTag.FIX_MESSAGE_TCP, "Read     ", (DirectBuffer)this.buffer, this.usedBufferData, dataRead);
            }
            this.usedBufferData += dataRead;
        } else {
            this.onDisconnectDetected();
        }
        return dataRead;
    }

    @Override
    int poll() {
        if (this.isPaused || this.hasDisconnected()) {
            return 0;
        }
        if (this.pendingAcceptorLogon != null) {
            return this.pollPendingLogon();
        }
        try {
            long latestReadTimestampInNs = this.clock.nanoTime();
            int bytesRead = this.readData();
            if (bytesRead == -1) {
                return 0;
            }
            if (this.frameMessages(bytesRead == 0 ? this.lastReadTimestampInNs : latestReadTimestampInNs)) {
                this.lastReadTimestampInNs = latestReadTimestampInNs;
                return bytesRead;
            }
            this.lastReadTimestampInNs = latestReadTimestampInNs;
            return -bytesRead;
        }
        catch (ClosedChannelException ex) {
            this.onDisconnectDetected();
            return 1;
        }
        catch (Exception ex) {
            if (!Exceptions.isJustDisconnect((Exception)ex)) {
                this.errorHandler.onError((Throwable)ex);
            }
            this.onDisconnectDetected();
            return 1;
        }
    }

    private int pollPendingLogon() {
        if (this.pendingAcceptorLogon.poll()) {
            if (this.pendingAcceptorLogon.isAccepted()) {
                return this.sendInitialLoginMessage();
            }
            this.completeDisconnect(this.pendingAcceptorLogon.reason());
        }
        return 1;
    }

    @Override
    boolean sendRejectedPendingLogon() {
        int length;
        DirectBuffer buffer;
        long position;
        int pendingAcceptorLogonMsgLength = this.pendingAcceptorLogonMsgLength;
        PasswordCleaner passwordCleaner = this.passwordCleaner;
        if (pendingAcceptorLogonMsgLength != 0) {
            passwordCleaner.clean((DirectBuffer)this.buffer, this.pendingAcceptorLogonMsgOffset, pendingAcceptorLogonMsgLength);
            ++this.sequenceIndex;
            this.pendingAcceptorLogonMsgLength = 0;
        }
        if (Pressure.isBackPressured(position = this.publication.saveMessage(buffer = passwordCleaner.cleanedBuffer(), 0, length = passwordCleaner.cleanedLength(), this.libraryId, 65L, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.AUTH_REJECT, 0, this.lastReadTimestampInNs))) {
            return false;
        }
        DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, 65L, "Auth Reject ", buffer, 0, length);
        return true;
    }

    private int sendInitialLoginMessage() {
        int sequenceIndex;
        int offset = this.pendingAcceptorLogonMsgOffset;
        int length = this.pendingAcceptorLogonMsgLength;
        if (this.isPaused) {
            this.moveRemainingDataToBufferStart(offset);
            return offset;
        }
        long sessionId = this.gatewaySession.sessionId();
        if (this.saveMessage(offset, 65L, length, sessionId, sequenceIndex = this.gatewaySession.sequenceIndex(), this.lastReadTimestampInNs)) {
            this.sessionId = sessionId;
            this.sequenceIndex = sequenceIndex;
            this.pendingAcceptorLogon = null;
            if (!this.reproductionEnabled) {
                this.framer.receiverEndPointPollingOptional(this.connectionId);
            }
            this.moveRemainingDataToBufferStart(offset += length);
            return offset;
        }
        return offset;
    }

    @Override
    boolean retryFrameMessages() {
        return this.frameMessages(this.lastReadTimestampInNs);
    }

    private boolean frameMessages(long readTimestampInNs) {
        MutableAsciiBuffer buffer = this.buffer;
        int offset = this.checkProxyLine(buffer);
        while (this.usedBufferData >= offset + SessionConstants.MIN_MESSAGE_SIZE) {
            try {
                int startOfBodyLength = this.scanForBodyLength(offset, readTimestampInNs);
                if (startOfBodyLength < 0) {
                    return startOfBodyLength == -1;
                }
                int endOfBodyLength = this.scanEndOfBodyLength(startOfBodyLength);
                if (endOfBodyLength == -1) break;
                int startOfChecksumTag = endOfBodyLength + this.getBodyLength(startOfBodyLength, endOfBodyLength);
                int endOfChecksumTag = startOfChecksumTag + MIN_CHECKSUM_SIZE;
                if (endOfChecksumTag >= this.usedBufferData) {
                    if (!this.isMessageOversized(offset)) break;
                    return this.saveOversizedMessageAndDisconnect(offset, readTimestampInNs);
                }
                if (!this.validateBodyLength(startOfChecksumTag)) {
                    int endOfMessage = this.onInvalidBodyLength(offset, startOfChecksumTag, readTimestampInNs);
                    if (endOfMessage == -1) break;
                    return true;
                }
                int startOfChecksumValue = startOfChecksumTag + MIN_CHECKSUM_SIZE;
                int endOfMessage = this.scanEndOfMessage(startOfChecksumValue);
                if (endOfMessage == -1) {
                    if (!this.isMessageOversized(offset)) break;
                    return this.saveOversizedMessageAndDisconnect(offset, readTimestampInNs);
                }
                int length = endOfMessage + 1 - offset;
                long messageType = this.getMessageType(endOfBodyLength, endOfMessage);
                if (messageType == 0L) {
                    if (this.saveInvalidMsgTypeMessage(offset, length, readTimestampInNs)) {
                        return false;
                    }
                } else if (!this.validateChecksum(endOfMessage, startOfChecksumValue, offset, startOfChecksumTag)) {
                    DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Invalidated (checksum): ", (DirectBuffer)buffer, offset, length);
                    if (this.saveInvalidChecksumMessage(offset, messageType, length, readTimestampInNs)) {
                        return false;
                    }
                } else {
                    boolean firstMessage;
                    boolean bl = firstMessage = this.messagesRead.incrementOrdered() == 0L;
                    if (this.requiresAuthentication()) {
                        this.startAuthenticationFlow(offset, length, messageType);
                        return true;
                    }
                    if (messageType == 65L) {
                        this.onLogon(readTimestampInNs, firstMessage);
                    }
                    if (!this.saveMessage(offset, messageType, length, readTimestampInNs, firstMessage)) {
                        return false;
                    }
                }
                offset += length;
            }
            catch (IllegalArgumentException ex) {
                return !this.invalidateMessage(offset, readTimestampInNs);
            }
            catch (Exception ex) {
                this.errorHandler.onError((Throwable)ex);
                break;
            }
        }
        this.moveRemainingDataToBufferStart(offset);
        return true;
    }

    private void onLogon(long readTimestampInNs, boolean firstMessage) {
        if (!firstMessage) {
            this.gatewaySession.onSequenceReset(readTimestampInNs);
        }
        ++this.sequenceIndex;
    }

    private int checkProxyLine(MutableAsciiBuffer buffer) {
        if (this.requiresProxyCheck) {
            int usedBufferData = this.usedBufferData;
            if (usedBufferData > PROXY_V2_MIN_LENGTH && this.checkSignature(buffer, PROXY_V2_SIG)) {
                return this.parseProxyV2(buffer);
            }
            if (usedBufferData > 8 && this.checkSignature(buffer, PROXY_V1_SIG)) {
                return this.parseProxyV1(buffer, usedBufferData);
            }
            if (usedBufferData > PROXY_V2_MIN_LENGTH) {
                this.requiresProxyCheck = false;
                DebugLogger.log(LogTag.PROXY, this.formatters.noProxyProtocol, this.connectionId);
            }
        }
        return 0;
    }

    private int parseProxyV2(MutableAsciiBuffer buffer) {
        byte verCmd = buffer.getByte(PROXY_V2_VER_CMD_OFFSET);
        if ((verCmd & 0xF0) != 32) {
            this.requiresProxyCheck = false;
            return 0;
        }
        block0 : switch (verCmd & 0xF) {
            case 1: {
                byte family = buffer.getByte(PROXY_V2_FAMILY_OFFSET);
                switch (family) {
                    case 17: {
                        int srcAddr = buffer.getInt(PROXY_V2_TCP4_SRC_ADDR_OFFSET, ByteOrder.BIG_ENDIAN);
                        char srcPort = buffer.getChar(PROXY_V2_TCP4_SRC_PORT_OFFSET, ByteOrder.BIG_ENDIAN);
                        this.address = String.valueOf(0xFF & srcAddr >> 24) + "." + (0xFF & srcAddr >> 16) + "." + (0xFF & srcAddr >> 8) + "." + (0xFF & srcAddr) + ":" + srcPort;
                        break block0;
                    }
                    case 33: {
                        int[] digits = new int[8];
                        for (int i = 0; i < 8; ++i) {
                            int index = PROXY_V2_TCP6_SRC_ADDR_OFFSET + i * 2;
                            digits[i] = buffer.getChar(index, ByteOrder.BIG_ENDIAN);
                        }
                        StringBuilder addressBuilder = new StringBuilder();
                        if (Arrays.equals(digits, IPV6_LOCALHOST_DIGITS)) {
                            addressBuilder.append(IPV6_LOCALHOST);
                        } else {
                            for (int i = 0; i < 8; ++i) {
                                addressBuilder.append(Integer.toHexString(digits[i]));
                                addressBuilder.append(':');
                            }
                        }
                        char srcPort = buffer.getChar(PROXY_V2_TCP6_SRC_PORT_OFFSET, ByteOrder.BIG_ENDIAN);
                        addressBuilder.append((int)srcPort);
                        this.address = addressBuilder.toString();
                        break block0;
                    }
                }
                break;
            }
        }
        int endIndex = PROXY_V2_ADDRESS_OFFSET + this.proxyV2BodyLength(buffer);
        this.logProxyV2(buffer, endIndex);
        this.requiresProxyCheck = false;
        return endIndex;
    }

    private int parseProxyV1(MutableAsciiBuffer buffer, int usedBufferData) {
        int index = PROXY_V1_SIG_LEN;
        index = buffer.scan(index, usedBufferData, ' ') + 1;
        int end = buffer.scan(index, usedBufferData, ' ');
        String sourceAddress = buffer.getAscii(index, end - index);
        index = buffer.scan(end + 1, usedBufferData, ' ') + 1;
        end = buffer.scan(index, usedBufferData, ' ');
        String sourcePort = buffer.getAscii(index, end - index);
        this.address = sourceAddress + ":" + sourcePort;
        index = buffer.scan(index, usedBufferData, '\r') + 2;
        DebugLogger.log(LogTag.PROXY, this.formatters.proxyV1Protocol, this.connectionId, this.address, (DirectBuffer)buffer, 0, index);
        this.requiresProxyCheck = false;
        return index;
    }

    private void logProxyV2(MutableAsciiBuffer buffer, int endIndex) {
        if (DebugLogger.isEnabled(LogTag.PROXY)) {
            byte[] bytes = new byte[endIndex];
            buffer.getBytes(0, bytes);
            DebugLogger.log(LogTag.PROXY, this.formatters.proxyV2Protocol.clear().with(this.connectionId).with(this.address).with(Arrays.toString(bytes)));
        }
    }

    private short proxyV2BodyLength(MutableAsciiBuffer buffer) {
        return buffer.getShort(PROXY_V2_BODY_LENGTH_OFFSET, ByteOrder.BIG_ENDIAN);
    }

    private boolean checkSignature(MutableAsciiBuffer buffer, byte[] proxyV1Sig) {
        for (int i = 0; i < proxyV1Sig.length; ++i) {
            if (buffer.getByte(i) == proxyV1Sig[i]) continue;
            return false;
        }
        return true;
    }

    private int onInvalidBodyLength(int offset, int startOfChecksumTag, long readTimestamp) {
        int endOfScanPoint;
        int checksumTagScanPoint = startOfChecksumTag + 1;
        while (!this.isStartOfChecksum(checksumTagScanPoint)) {
            endOfScanPoint = checksumTagScanPoint + CHECKSUM_TAG_SIZE;
            if (endOfScanPoint >= this.usedBufferData) {
                return -1;
            }
            ++checksumTagScanPoint;
        }
        endOfScanPoint = checksumTagScanPoint + CHECKSUM_TAG_SIZE;
        int endOfMessage = this.buffer.scan(endOfScanPoint, this.usedBufferData, (byte)1) + 1;
        if (endOfMessage > this.usedBufferData) {
            return -1;
        }
        if (this.saveInvalidMessage(offset, endOfMessage - offset, readTimestamp)) {
            DebugLogger.log(LogTag.FIX_MESSAGE, "Invalidated (Body Length): ", (DirectBuffer)this.buffer, offset, endOfMessage - offset);
            return offset;
        }
        this.moveRemainingDataToBufferStart(endOfMessage);
        return offset;
    }

    @Override
    boolean requiresAuthentication() {
        return this.sessionId == -1L;
    }

    private boolean validateChecksum(int endOfMessage, int startOfChecksumValue, int offset, int startOfChecksumTag) {
        int computedChecksum;
        int expectedChecksum = this.buffer.getInt(startOfChecksumValue - 1, endOfMessage);
        return expectedChecksum == (computedChecksum = this.buffer.computeChecksum(offset, startOfChecksumTag + 1));
    }

    private int scanEndOfMessage(int startOfChecksumValue) {
        return this.buffer.scan(startOfChecksumValue, this.usedBufferData, (byte)1);
    }

    private int scanForBodyLength(int offset, long readTimestamp) {
        if (this.invalidTag(offset, (byte)8)) {
            return this.invalidateMessageUnknownIndex(offset, readTimestamp);
        }
        int endOfCommonPrefix = this.scanNextField(offset + 2);
        if (endOfCommonPrefix == -1) {
            return this.invalidateMessageUnknownIndex(offset, readTimestamp);
        }
        int startOfBodyTag = endOfCommonPrefix + 1;
        if (this.invalidTag(startOfBodyTag, (byte)9)) {
            return this.invalidateMessageUnknownIndex(offset, readTimestamp);
        }
        return startOfBodyTag + 2;
    }

    private int invalidateMessageUnknownIndex(int offset, long readTimestamp) {
        return this.invalidateMessage(offset, readTimestamp) ? -2 : -1;
    }

    private int scanEndOfBodyLength(int startOfBodyLength) {
        return this.buffer.scan(startOfBodyLength + 1, this.usedBufferData, (byte)1);
    }

    private int scanNextField(int startScan) {
        return this.buffer.scan(startScan + 1, this.usedBufferData, (byte)1);
    }

    private void startAuthenticationFlow(int offset, int length, long messageType) {
        if (this.sessionId != -1L) {
            return;
        }
        if (messageType == 65L) {
            FixDictionary fixDictionary = this.acceptorFixDictionaryLookup.lookup((AsciiBuffer)this.buffer, offset, length);
            AbstractLogonDecoder logonDecoder = fixDictionary.makeLogonDecoder();
            logonDecoder.decode((AsciiBuffer)this.buffer, offset, length);
            this.pendingAcceptorLogonMsgOffset = offset;
            this.pendingAcceptorLogonMsgLength = length;
            this.pendingAcceptorLogon = this.gatewaySessions.authenticate(logonDecoder, this.connectionId(), this.gatewaySession, this.channel, fixDictionary, this.framer, this.address, this);
        } else {
            this.completeDisconnect(DisconnectReason.FIRST_MESSAGE_NOT_LOGON);
        }
    }

    private boolean stashIfBackPressured(int offset, long position) {
        boolean backPressured = Pressure.isBackPressured(position);
        if (backPressured) {
            this.moveRemainingDataToBufferStart(offset);
        }
        return backPressured;
    }

    private boolean saveMessage(int offset, long messageType, int length, long readTimestampInNs, boolean firstMessage) {
        if (firstMessage && messageType != 65L) {
            this.gatewaySession.onSequenceReset(readTimestampInNs);
            ++this.sequenceIndex;
        }
        return this.saveMessage(offset, messageType, length, this.sessionId, this.sequenceIndex, readTimestampInNs);
    }

    private boolean saveMessage(int messageOffset, long messageType, int messageLength, long sessionId, int sequenceIndex, long readTimestamp) {
        long position;
        boolean isUserRequest;
        MutableAsciiBuffer buffer = this.buffer;
        if (this.shouldThrottle(readTimestamp)) {
            return this.throttleMessage(messageOffset, messageType, messageLength, (DirectBuffer)buffer);
        }
        int offset = messageOffset;
        int length = messageLength;
        boolean bl = isUserRequest = messageType == 17730L;
        if (messageType == 65L || isUserRequest) {
            if (isUserRequest) {
                this.gatewaySessions.onUserRequest((DirectBuffer)buffer, offset, length, this.gatewaySession.fixDictionary(), this.connectionId, sessionId);
            }
            this.passwordCleaner.clean((DirectBuffer)buffer, offset, length);
            offset = 0;
            buffer = this.passwordCleaner.cleanedBuffer();
            length = this.passwordCleaner.cleanedLength();
        }
        if (Pressure.isBackPressured(position = this.publication.saveMessage((DirectBuffer)buffer, offset, length, this.libraryId, messageType, sessionId, sequenceIndex, this.connectionId, MessageStatus.OK, 0, readTimestamp))) {
            this.moveRemainingDataToBufferStart(messageOffset);
            return false;
        }
        this.gatewaySession.onMessage((DirectBuffer)buffer, offset, length, messageType, position);
        return true;
    }

    private boolean throttleMessage(int messageOffset, long messageType, int messageLength, DirectBuffer buffer) {
        BusinessRejectRefIdExtractor businessRejectRefIdExtractor = this.businessRejectRefIdExtractor;
        businessRejectRefIdExtractor.search(messageType, buffer, messageOffset, messageLength);
        int refSeqNum = businessRejectRefIdExtractor.sequenceNumber();
        AsciiBuffer refIdBuffer = businessRejectRefIdExtractor.buffer();
        int refIdOffset = businessRejectRefIdExtractor.offset();
        int refIdLength = businessRejectRefIdExtractor.length();
        long position = this.publication.saveThrottleNotification(this.libraryId, this.connectionId, messageType, refSeqNum, this.sessionId, this.sequenceIndex, (DirectBuffer)refIdBuffer, refIdOffset, refIdLength);
        if (position > 0L) {
            return this.gatewaySession.onThrottleNotification(messageType, refSeqNum, refIdBuffer, refIdOffset, refIdLength);
        }
        this.moveRemainingDataToBufferStart(messageOffset);
        return false;
    }

    private boolean validateBodyLength(int startOfChecksumTag) {
        return this.isStartOfChecksum(startOfChecksumTag);
    }

    private boolean isStartOfChecksum(int startOfChecksumTag) {
        return this.buffer.getByte(startOfChecksumTag) == 1 && this.buffer.getByte(startOfChecksumTag + 1) == 49 && this.buffer.getByte(startOfChecksumTag + 2) == 48 && this.buffer.getByte(startOfChecksumTag + 3) == 61;
    }

    private long getMessageType(int endOfBodyLength, int indexOfLastByteOfMessage) {
        if (1026896641 != this.buffer.getInt(endOfBodyLength)) {
            return 0L;
        }
        int start = endOfBodyLength + 4;
        int limit = Math.min(start + 8, indexOfLastByteOfMessage) + 1;
        int end = this.buffer.scan(start, limit, (byte)1);
        if (-1 == end) {
            return 0L;
        }
        int length = end - start;
        if (0 == length) {
            return 0L;
        }
        return this.buffer.getMessageType(start, length);
    }

    private int getBodyLength(int startOfBodyLength, int endOfBodyLength) {
        return this.buffer.getNatural(startOfBodyLength, endOfBodyLength);
    }

    private boolean invalidTag(int startOfBodyTag, byte tagId) {
        try {
            return this.buffer.getDigit(startOfBodyTag) != tagId || this.buffer.getChar(startOfBodyTag + 1) != '=';
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private boolean invalidateMessage(int offset, long readTimestamp) {
        DebugLogger.log(LogTag.FIX_MESSAGE, "Invalidated (IAE): ", (DirectBuffer)this.buffer, offset, SessionConstants.MIN_MESSAGE_SIZE);
        return this.saveInvalidMessage(offset, readTimestamp);
    }

    private boolean isMessageOversized(int offset) {
        return offset == 0 && this.byteBuffer.remaining() == 0;
    }

    private boolean saveOversizedMessageAndDisconnect(int offset, long readTimestamp) {
        DebugLogger.log(LogTag.FIX_MESSAGE, "Invalidated (oversized): ", (DirectBuffer)this.buffer, offset, this.usedBufferData - offset);
        if (this.saveInvalidMessage(offset, readTimestamp)) {
            return false;
        }
        this.errorHandler.onError((Throwable)new Exception("Unable to frame message, receiver buffer too small. connectionId=" + this.connectionId));
        this.completeDisconnect(DisconnectReason.EXCEPTION);
        return true;
    }

    private boolean saveInvalidMessage(int offset, int length, long readTimestamp) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, -1L, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID_BODYLENGTH, 0, readTimestamp);
        return this.stashIfBackPressured(offset, position);
    }

    private boolean saveInvalidMessage(int offset, long readTimestamp) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, this.usedBufferData - offset, this.libraryId, 45L, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID, 0, readTimestamp);
        boolean backPressured = this.stashIfBackPressured(offset, position);
        if (!backPressured) {
            this.clearBuffer();
        }
        return backPressured;
    }

    private void clearBuffer() {
        this.moveRemainingDataToBufferStart(this.usedBufferData);
    }

    private void moveRemainingDataToBufferStart(int offset) {
        this.usedBufferData -= offset;
        this.buffer.putBytes(0, (DirectBuffer)this.buffer, offset, this.usedBufferData);
        ByteBufferUtil.position(this.byteBuffer, this.usedBufferData);
    }

    private boolean saveInvalidChecksumMessage(int offset, long messageType, int length, long readTimestamp) {
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, messageType, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID_CHECKSUM, 0, readTimestamp);
        return this.stashIfBackPressured(offset, position);
    }

    private boolean saveInvalidMsgTypeMessage(int offset, int length, long readTimestamp) {
        DebugLogger.log(LogTag.FIX_MESSAGE, "Invalidated (MsgType): ", (DirectBuffer)this.buffer, offset, length);
        long position = this.publication.saveMessage((DirectBuffer)this.buffer, offset, length, this.libraryId, 45L, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.INVALID, 0, readTimestamp);
        return this.stashIfBackPressured(offset, position);
    }

    void onLogonSent(int sequenceIndex) {
        this.pendingSequenceIndex = sequenceIndex;
    }

    @Override
    void closeResources() {
        try {
            this.channel.close();
            this.messagesRead.close();
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }

    @Override
    void removeEndpointFromFramer() {
        this.framer.onDisconnect(this.libraryId, this.connectionId, null);
    }

    @Override
    void cleanupDisconnectState(DisconnectReason reason) {
        SessionContext sessionContext;
        int currentSequenceIndex;
        Map.Entry<CompositeKey, SessionContext> entry = this.fixContexts.lookupById(this.sessionId);
        if (entry != null && this.pendingSequenceIndex > (currentSequenceIndex = (sessionContext = entry.getValue()).sequenceIndex())) {
            sessionContext.onSequenceIndex(this.clock.nanoTime(), this.pendingSequenceIndex);
            this.framer.schedule(() -> this.publication.saveResetSequenceNumber(this.sessionId));
        }
        this.fixContexts.onDisconnect(this.sessionId);
        this.gatewaySessions.onDisconnect(this.sessionId, this.connectionId, reason);
    }

    void gatewaySession(FixGatewaySession gatewaySession) {
        this.gatewaySession = gatewaySession;
    }

    void pause() {
        this.isPaused = true;
    }

    void play() {
        this.isPaused = false;
    }

    String address() {
        return this.address;
    }

    public String toString() {
        return "ReceiverEndPoint: " + this.connectionId;
    }

    static {
        PROXY_V2_VER_CMD_OFFSET = PROXY_V2_SIG_LEN = PROXY_V2_SIG.length;
        PROXY_V2_FAMILY_OFFSET = PROXY_V2_VER_CMD_OFFSET + 1;
        PROXY_V2_BODY_LENGTH_OFFSET = PROXY_V2_FAMILY_OFFSET + 1;
        PROXY_V2_TCP4_SRC_ADDR_OFFSET = PROXY_V2_ADDRESS_OFFSET = PROXY_V2_BODY_LENGTH_OFFSET + 2;
        PROXY_V2_TCP4_DST_ADDR_OFFSET = PROXY_V2_TCP4_SRC_ADDR_OFFSET + 4;
        PROXY_V2_TCP4_SRC_PORT_OFFSET = PROXY_V2_TCP4_DST_ADDR_OFFSET + 4;
        PROXY_V2_TCP4_DST_PORT_OFFSET = PROXY_V2_TCP4_SRC_PORT_OFFSET + 2;
        IPV6_LOCALHOST_DIGITS = new int[]{0, 0, 0, 0, 0, 0, 0, 1};
        PROXY_V2_TCP6_SRC_ADDR_OFFSET = PROXY_V2_ADDRESS_OFFSET;
        PROXY_V2_TCP6_DST_ADDR_OFFSET = PROXY_V2_TCP6_SRC_ADDR_OFFSET + 16;
        PROXY_V2_TCP6_SRC_PORT_OFFSET = PROXY_V2_TCP6_DST_ADDR_OFFSET + 16;
        PROXY_V2_TCP6_DST_PORT_OFFSET = PROXY_V2_TCP6_SRC_PORT_OFFSET + 2;
        PROXY_V2_MIN_LENGTH = PROXY_V2_TCP6_SRC_ADDR_OFFSET;
        MIN_CHECKSUM_SIZE = " 10=".length() + 1;
        CHECKSUM_TAG_SIZE = "10=".length();
    }

    static class FixReceiverEndPointFormatters {
        private final CharFormatter noProxyProtocol = new CharFormatter("No proxy protocol usage for connId=%s");
        private final CharFormatter proxyV1Protocol = new CharFormatter("Proxy v1 detected for connId=%s,addr=%s,line=%s");
        private final CharFormatter proxyV2Protocol = new CharFormatter("Proxy v2 detected for connId=%s,addr=%s,line=%s");

        FixReceiverEndPointFormatters() {
        }
    }
}

