/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.io.IOException;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.SenderSequenceNumber;
import uk.co.real_logic.artio.engine.framer.FixPReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.ReproductionLogWriter;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.fixp.AbstractFixPOffsets;
import uk.co.real_logic.artio.fixp.SimpleOpenFramingHeader;

class ExplicitFixPSenderEndPoint
extends FixPSenderEndPoint {
    private final MessageTimingHandler messageTimingHandler;

    ExplicitFixPSenderEndPoint(long connectionId, TcpChannel channel, ErrorHandler errorHandler, ExclusivePublication inboundPublication, ReproductionLogWriter reproductionLogWriter, int libraryId, MessageTimingHandler messageTimingHandler, AtomicCounter bytesInBuffer, int maxBytesInBuffer, Framer framer, FixPReceiverEndPoint receiverEndPoint, SenderSequenceNumber senderSequenceNumber) {
        super(connectionId, channel, errorHandler, inboundPublication, reproductionLogWriter, libraryId, bytesInBuffer, maxBytesInBuffer, framer, receiverEndPoint, senderSequenceNumber);
        this.messageTimingHandler = messageTimingHandler;
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer directBuffer, int offset, boolean retransmit) {
        try {
            int sbeHeaderOffset;
            long sequenceNumber;
            int messageSize = SimpleOpenFramingHeader.readSofhMessageSize((DirectBuffer)directBuffer, (int)offset);
            int totalWritten = this.writeBuffer(directBuffer, offset, messageSize);
            if (totalWritten < messageSize) {
                this.reattemptBytesWritten = totalWritten;
                return ControlledFragmentHandler.Action.ABORT;
            }
            MessageTimingHandler messageTimingHandler = this.messageTimingHandler;
            if (messageTimingHandler != null && (sequenceNumber = AbstractFixPOffsets.clientSeqNum((DirectBuffer)directBuffer, (int)(sbeHeaderOffset = offset + 4))) != -1L) {
                messageTimingHandler.onMessage(sequenceNumber, this.connectionId, directBuffer, 0, 0);
            }
            this.reattemptBytesWritten = 0;
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    boolean reattempt() {
        return true;
    }

    @Override
    public void onValidResendRequest(long correlationId) {
    }
}

