/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.engine.framer.TcpChannel;

public class DefaultTcpChannel
extends TcpChannel {
    private final SocketChannel socketChannel;

    public DefaultTcpChannel(SocketChannel socketChannel) throws IOException {
        super(socketChannel.getRemoteAddress().toString());
        this.socketChannel = socketChannel;
    }

    @Override
    public SelectionKey register(Selector sel, int ops, Object att) throws ClosedChannelException {
        return this.socketChannel.register(sel, ops, att);
    }

    @Override
    public int write(ByteBuffer src, int seqNum, boolean replay) throws IOException {
        int written = this.socketChannel.write(src);
        if (written < 0) {
            throw new IOException("Disconnected " + this.remoteAddress + ", written=" + written);
        }
        return written;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.socketChannel.read(dst);
    }

    @Override
    public void close() {
        if (this.socketChannel.isOpen()) {
            try {
                this.socketChannel.close();
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
    }

    @Override
    public void onReplayComplete(long correlationId) {
    }
}

