/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.archive.status.RecordingPos;
import io.aeron.driver.Configuration;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.CountersReader;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.MonitoringAgent;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.LibraryAndRecordingIdConsumer;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.PreviousRecordingDecoder;
import uk.co.real_logic.artio.storage.messages.PreviousRecordingEncoder;
import uk.co.real_logic.artio.util.CharFormatter;

public class RecordingCoordinator
implements AutoCloseable,
RecordingDescriptorConsumer {
    private static volatile boolean saveOnShutdown = true;
    private static final String FILE_NAME = "recording_coordinator";
    private final CharFormatter loadRecordings = new CharFormatter("RecordingCoordinator.loadRecordingIds: inbound=%s,outbound=%s");
    private final CharFormatter recordingStarted = new CharFormatter("RecordingCoordinator.recordingStarted: recordingId=%s,direction=%s,sessionId=%s,libraryId=%s");
    private final IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
    private final SourceLocation outboundLocation;
    private final MutableLong registrationId = new MutableLong(-1L);
    private final Long2LongHashMap trackedRegistrationIdToRecordingId = new Long2LongHashMap(-1L);
    private final Aeron aeron;
    private final AeronArchive archive;
    private final String channel;
    private final CountersReader counters;
    private final EngineConfiguration configuration;
    private final RecordingIdLookup framerInboundLookup;
    private final RecordingIdLookup framerOutboundLookup;
    private final RecordingIdLookup indexerInboundLookup;
    private final RecordingIdLookup indexerOutboundLookup;
    private final File recordingIdsFile;
    private final ErrorHandler errorHandler;
    private MonitoringAgent monitoringAgent;
    private long reproductionRecordingId = -1L;
    private ExclusivePublication reproductionPublication = null;
    private final RecordingIds inboundRecordingIds = new RecordingIds();
    private final RecordingIds outboundRecordingIds = new RecordingIds();
    private final Int2ObjectHashMap<LibraryExtendPosition> libraryIdToExtendPosition = new Int2ObjectHashMap();
    private Long2LongHashMap inboundAeronSessionIdToCompletionPosition;
    private Long2LongHashMap outboundAeronSessionIdToCompletionPosition;
    private boolean closed = false;
    private LibraryExtendPosition libraryExtendPosition;

    public static void saveOnShutdownTesting(boolean saveOnShutdown) {
        RecordingCoordinator.saveOnShutdown = saveOnShutdown;
    }

    public static File recordingIdsFile(EngineConfiguration configuration) {
        return new File(configuration.logFileDir(), FILE_NAME);
    }

    RecordingCoordinator(Aeron aeron, AeronArchive archive, EngineConfiguration configuration, IdleStrategy archiverIdleStrategy, ErrorHandler errorHandler) {
        this.aeron = aeron;
        this.archive = archive;
        this.configuration = configuration;
        this.channel = configuration.libraryAeronChannel();
        this.errorHandler = errorHandler;
        this.recordingIdsFile = RecordingCoordinator.recordingIdsFile(configuration);
        this.outboundLocation = this.channel.equals("aeron:ipc") ? SourceLocation.LOCAL : SourceLocation.REMOTE;
        this.loadRecordingIdsFile();
        if (this.reproductionRecordingId != -1L && !configuration.isReproductionEnabled()) {
            archive.purgeRecording(this.reproductionRecordingId);
            this.reproductionRecordingId(-1L);
        }
        if (configuration.logAnyMessages()) {
            this.counters = this.aeron.countersReader();
            this.framerInboundLookup = new RecordingIdLookup(archive.archiveId(), archiverIdleStrategy, this.counters);
            this.framerOutboundLookup = new RecordingIdLookup(archive.archiveId(), archiverIdleStrategy, this.counters);
            this.indexerInboundLookup = new RecordingIdLookup(archive.archiveId(), archiverIdleStrategy, this.counters);
            this.indexerOutboundLookup = new RecordingIdLookup(archive.archiveId(), archiverIdleStrategy, this.counters);
        } else {
            this.counters = null;
            this.framerInboundLookup = null;
            this.framerOutboundLookup = null;
            this.indexerInboundLookup = null;
            this.indexerOutboundLookup = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRecordingIdsFile() {
        if (this.recordingIdsFile.exists()) {
            MappedByteBuffer mappedBuffer = IoUtil.mapExistingFile((File)this.recordingIdsFile, (String)FILE_NAME);
            UnsafeBuffer buffer = new UnsafeBuffer((ByteBuffer)mappedBuffer);
            try {
                MessageHeaderDecoder header = new MessageHeaderDecoder();
                PreviousRecordingDecoder previousRecording = new PreviousRecordingDecoder();
                header.wrap((DirectBuffer)buffer, 0);
                int version = header.version();
                previousRecording.wrap((DirectBuffer)buffer, 8, header.blockLength(), version);
                if (version >= PreviousRecordingDecoder.reproductionRecordingIdSinceVersion()) {
                    this.reproductionRecordingId(previousRecording.reproductionRecordingId());
                } else {
                    this.reproductionRecordingId(-1L);
                }
                for (PreviousRecordingDecoder.InboundRecordingsDecoder inboundRecording : previousRecording.inboundRecordings()) {
                    this.inboundRecordingIds.free.put((long)inboundRecording.libraryId(), inboundRecording.recordingId());
                }
                for (PreviousRecordingDecoder.OutboundRecordingsDecoder outboundRecording : previousRecording.outboundRecordings()) {
                    this.outboundRecordingIds.free.put((long)outboundRecording.libraryId(), outboundRecording.recordingId());
                }
                if (DebugLogger.isEnabled(LogTag.STATE_CLEANUP)) {
                    DebugLogger.log(LogTag.STATE_CLEANUP, this.loadRecordings.clear().with(this.inboundRecordingIds.toString()).with(this.outboundRecordingIds.toString()));
                }
            }
            finally {
                IoUtil.unmap((MappedByteBuffer)mappedBuffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRecordingIdsFile() {
        try {
            int inboundSize = this.inboundRecordingIds.size();
            int outboundSize = this.outboundRecordingIds.size() + this.libraryIdToExtendPosition.size();
            File saveFile = File.createTempFile(FILE_NAME, "tmp", new File(this.configuration.logFileDir()));
            int requiredLength = 22 + PreviousRecordingEncoder.InboundRecordingsEncoder.sbeBlockLength() * inboundSize + PreviousRecordingEncoder.OutboundRecordingsEncoder.sbeBlockLength() * outboundSize;
            MappedByteBuffer mappedBuffer = IoUtil.mapExistingFile((File)saveFile, (String)FILE_NAME, (long)0L, (long)requiredLength);
            UnsafeBuffer buffer = new UnsafeBuffer((ByteBuffer)mappedBuffer);
            try {
                MessageHeaderEncoder header = new MessageHeaderEncoder();
                PreviousRecordingEncoder previousRecording = new PreviousRecordingEncoder();
                previousRecording.wrapAndApplyHeader((MutableDirectBuffer)buffer, 0, header);
                previousRecording.reproductionRecordingId(this.reproductionRecordingId);
                PreviousRecordingEncoder.InboundRecordingsEncoder inbound = previousRecording.inboundRecordingsCount(inboundSize);
                this.inboundRecordingIds.forEach((libraryId, recordingId) -> inbound.next().recordingId(recordingId).libraryId(libraryId));
                PreviousRecordingEncoder.OutboundRecordingsEncoder outbound = previousRecording.outboundRecordingsCount(outboundSize);
                this.outboundRecordingIds.forEach((libraryId, recordingId) -> outbound.next().recordingId(recordingId).libraryId(libraryId));
                Int2ObjectHashMap.EntryIterator entry = this.libraryIdToExtendPosition.entrySet().iterator();
                while (entry.hasNext()) {
                    entry.next();
                    int libraryId2 = entry.getIntKey();
                    LibraryExtendPosition pos = (LibraryExtendPosition)entry.getValue();
                    outbound.next().recordingId(pos.recordingId).libraryId(libraryId2);
                }
                mappedBuffer.force();
            }
            finally {
                IoUtil.unmap((MappedByteBuffer)mappedBuffer);
            }
            Files.move(saveFile.toPath(), this.recordingIdsFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable e) {
            this.errorHandler.onError(e);
        }
    }

    public ExclusivePublication trackEngine(String aeronChannel, int streamId) {
        if (this.configuration.isRelevantStreamId(streamId)) {
            ExclusivePublication publication;
            boolean isInbound = streamId == this.configuration.inboundLibraryStream();
            RecordingIds recordingIds = isInbound ? this.inboundRecordingIds : this.outboundRecordingIds;
            RecordingIdLookup lookup = isInbound ? this.framerOutboundLookup : this.framerInboundLookup;
            LibraryExtendPosition libraryExtendPosition = this.acquireRecording(streamId, recordingIds, 0);
            if (libraryExtendPosition != null) {
                ChannelUri channelUri = ChannelUri.parse((CharSequence)aeronChannel);
                channelUri.initialPosition(libraryExtendPosition.stopPosition, libraryExtendPosition.initialTermId, libraryExtendPosition.termBufferLength);
                RecordingCoordinator.setMtuLength(libraryExtendPosition.mtuLength, channelUri);
                String channel = channelUri.toString();
                publication = this.aeron.addExclusivePublication(channel, streamId);
                this.extendRecording(streamId, libraryExtendPosition, publication.sessionId());
            } else {
                publication = this.aeron.addExclusivePublication(aeronChannel, streamId);
                this.startRecording(streamId, publication.sessionId(), SourceLocation.LOCAL);
            }
            this.checkRecordingStart(publication.sessionId(), lookup, recordingIds.used, isInbound, 0);
            return publication;
        }
        return this.aeron.addExclusivePublication(aeronChannel, streamId);
    }

    public ExclusivePublication reproductionPublication() {
        if (this.reproductionPublication == null) {
            int streamId = this.configuration.reproductionLogStream();
            try {
                long recId;
                this.reproductionPublication = this.aeron.addExclusivePublication("aeron:ipc", streamId);
                String fullChannel = ChannelUri.addSessionId((String)"aeron:ipc", (int)this.reproductionPublication.sessionId());
                this.archive.startRecording(fullChannel, streamId, SourceLocation.LOCAL, true);
                while (true) {
                    if ((recId = this.archive.findLastMatchingRecording(0L, "aeron:ipc", streamId, this.reproductionPublication.sessionId())) != -1L) break;
                    Thread.yield();
                }
                this.reproductionRecordingId(recId);
                this.saveRecordingIdsFile();
            }
            catch (Throwable ex) {
                CloseHelper.quietClose((AutoCloseable)this.reproductionPublication);
                this.errorHandler.onError(ex);
                return null;
            }
        }
        return this.reproductionPublication;
    }

    public Subscription reproductionSubscription() {
        if (this.reproductionRecordingId == -1L) {
            return null;
        }
        int streamId = this.configuration.reproductionLogStream();
        return this.archive.replay(this.reproductionRecordingId, -1L, Long.MAX_VALUE, "aeron:ipc", streamId);
    }

    public static void setMtuLength(int mtuLength, ChannelUri channelUri) {
        channelUri.put("mtu", Integer.toString(mtuLength));
    }

    private void extendRecording(int streamId, LibraryExtendPosition libraryExtendPosition, int sessionId) {
        try {
            String recordingChannel = ChannelUri.addSessionId((String)this.channel, (int)sessionId);
            long recordingId = libraryExtendPosition.recordingId;
            long registrationId = this.archive.extendRecording(recordingId, recordingChannel, streamId, SourceLocation.LOCAL);
            this.trackedRegistrationIdToRecordingId.put(registrationId, recordingId);
        }
        catch (ArchiveException e) {
            this.errorHandler.onError((Throwable)e);
        }
    }

    private LibraryExtendPosition acquireRecording(int streamId, RecordingIds recordingIds, int libraryId) {
        this.libraryExtendPosition = null;
        long recordingId = recordingIds.acquire(libraryId);
        if (recordingId != -1L) {
            int count = this.archive.listRecording(recordingId, (RecordingDescriptorConsumer)this);
            if (count != 1 || null == this.libraryExtendPosition) {
                this.errorHandler.onError((Throwable)new IllegalStateException("Unable to reuse recordingId: " + recordingId + " (Perhaps you have deleted this recording id or some aeron archiver state?)"));
                if (this.libraryExtendPosition == null) {
                    return null;
                }
            } else if (this.libraryExtendPosition.streamId != streamId) {
                this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to reuse recordingId: %d. Stream id is mismatch: actual: %d, expected: %d", recordingId, this.libraryExtendPosition.streamId, streamId)));
                this.libraryExtendPosition = null;
                return null;
            }
            while (this.libraryExtendPosition.stopPosition == -1L) {
                this.archive.tryStopRecordingByIdentity(recordingId);
                this.libraryExtendPosition.stopPosition = this.archive.getStopPosition(recordingId);
            }
        }
        return this.libraryExtendPosition;
    }

    public LibraryExtendPosition trackLibrary(int sessionId, int libraryId) {
        if (this.configuration.logOutboundMessages()) {
            int streamId = this.configuration.outboundLibraryStream();
            LibraryExtendPosition extendPosition = (LibraryExtendPosition)this.libraryIdToExtendPosition.get(libraryId);
            if (extendPosition != null) {
                if (sessionId != extendPosition.newSessionId) {
                    return extendPosition;
                }
                this.libraryIdToExtendPosition.remove(libraryId);
                this.checkRecordingStart(sessionId, this.framerOutboundLookup, this.outboundRecordingIds.used, false, libraryId);
                return null;
            }
            extendPosition = this.acquireRecording(streamId, this.outboundRecordingIds, libraryId);
            if (extendPosition != null) {
                this.extendRecording(streamId, extendPosition, extendPosition.newSessionId);
                this.saveRecordingIdsFile();
                this.libraryIdToExtendPosition.put(libraryId, (Object)extendPosition);
                return extendPosition;
            }
            if (this.startRecording(streamId, sessionId, this.outboundLocation)) {
                this.checkRecordingStart(sessionId, this.framerOutboundLookup, this.outboundRecordingIds.used, false, libraryId);
            }
        }
        return null;
    }

    public void onRecordingDescriptor(long controlSessionId, long correlationId, long recordingId, long startTimestamp, long stopTimestamp, long startPosition, long stopPosition, int initialTermId, int segmentFileLength, int termBufferLength, int mtuLength, int sessionId, int streamId, String strippedChannel, String originalChannel, String sourceIdentity) {
        int newSessionId = ThreadLocalRandom.current().nextInt(Configuration.publicationReservedSessionIdLow(), Configuration.publicationReservedSessionIdHigh());
        this.libraryExtendPosition = new LibraryExtendPosition(newSessionId, recordingId, streamId, stopPosition, initialTermId, termBufferLength, mtuLength);
    }

    private boolean startRecording(int streamId, int sessionId, SourceLocation local) {
        if (this.recordingAlreadyStarted(sessionId)) {
            return true;
        }
        try {
            String channel = ChannelUri.addSessionId((String)this.channel, (int)sessionId);
            this.registrationId.set(this.archive.startRecording(channel, streamId, local));
            return true;
        }
        catch (ArchiveException e) {
            this.errorHandler.onError((Throwable)e);
            return false;
        }
    }

    private boolean recordingAlreadyStarted(int sessionId) {
        return RecordingPos.findCounterIdBySession((CountersReader)this.counters, (int)sessionId, (long)this.archive.archiveId()) != -1;
    }

    private void checkRecordingStart(int sessionId, RecordingIdLookup lookup, Long2LongHashMap libraryIdToRecordingId, boolean isInbound, int libraryId) {
        long recordingId = lookup.getRecordingId(sessionId);
        libraryIdToRecordingId.put((long)libraryId, recordingId);
        long registrationId = this.registrationId.get();
        if (registrationId != -1L) {
            this.trackedRegistrationIdToRecordingId.put(registrationId, recordingId);
            this.registrationId.set(-1L);
        }
        this.saveRecordingIdsFile();
        if (DebugLogger.isEnabled(LogTag.STATE_CLEANUP)) {
            DebugLogger.log(LogTag.STATE_CLEANUP, this.recordingStarted.clear().with(recordingId).with(isInbound ? "inbound" : "outbound").with(sessionId).with(libraryId));
        }
    }

    public void completionPositions(Long2LongHashMap inboundAeronSessionIdToCompletionPosition, Long2LongHashMap outboundAeronSessionIdToCompletionPosition) {
        this.inboundAeronSessionIdToCompletionPosition = inboundAeronSessionIdToCompletionPosition;
        this.outboundAeronSessionIdToCompletionPosition = outboundAeronSessionIdToCompletionPosition;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.awaitRecordingsCompletion();
            CloseHelper.quietClose((AutoCloseable)this.reproductionPublication);
            this.shutdownArchiver();
            this.closed = true;
        }
    }

    private void awaitRecordingsCompletion() {
        if (this.configuration.logInboundMessages()) {
            this.awaitRecordingsCompletion(this.inboundAeronSessionIdToCompletionPosition);
        }
        if (this.configuration.logOutboundMessages()) {
            this.awaitRecordingsCompletion(this.outboundAeronSessionIdToCompletionPosition);
        }
        if (saveOnShutdown) {
            this.saveRecordingIdsFile();
        }
    }

    private void awaitRecordingsCompletion(Long2LongHashMap aeronSessionIdToCompletionPosition) {
        if (aeronSessionIdToCompletionPosition == null) {
            throw new IllegalStateException("Unknown completionPositions when shutting down the RecordingCoordinator");
        }
        ArrayList<CompletingRecording> completingRecordings = new ArrayList<CompletingRecording>();
        aeronSessionIdToCompletionPosition.forEachLong((sessionId, completionPosition) -> {
            int counterId = RecordingPos.findCounterIdBySession((CountersReader)this.counters, (int)((int)sessionId), (long)this.archive.archiveId());
            if (counterId != -1) {
                CompletingRecording recording = new CompletingRecording(completionPosition, counterId);
                completingRecordings.add(recording);
            }
        });
        while (!completingRecordings.isEmpty()) {
            completingRecordings.removeIf(CompletingRecording::hasRecordingCompleted);
            this.idleStrategy.idle();
        }
        this.idleStrategy.reset();
    }

    private void shutdownArchiver() {
        Long2LongHashMap.EntryIterator it = this.trackedRegistrationIdToRecordingId.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            long registrationId = it.getLongKey();
            long recordingId = it.getLongValue();
            int counterId = RecordingPos.findCounterIdByRecording((CountersReader)this.counters, (long)recordingId, (long)this.archive.archiveId());
            this.archive.stopRecording(registrationId);
            if (counterId == -1) continue;
            while (RecordingPos.isActive((CountersReader)this.counters, (int)counterId, (long)recordingId)) {
                this.idleStrategy.idle();
            }
            this.idleStrategy.reset();
        }
        if (this.configuration.requiresAeronArchive()) {
            if (this.monitoringAgent != null) {
                this.monitoringAgent.archiverStopped();
            }
            this.archive.close();
        }
    }

    public void forEachRecording(LibraryAndRecordingIdConsumer recordingIdConsumer) {
        this.inboundRecordingIds.forEach(recordingIdConsumer);
        this.outboundRecordingIds.forEach(recordingIdConsumer);
    }

    private void reproductionRecordingId(long reproductionRecordingId) {
        this.reproductionRecordingId = reproductionRecordingId;
    }

    RecordingIdLookup indexerInboundRecordingIdLookup() {
        return this.indexerInboundLookup;
    }

    RecordingIdLookup indexerOutboundRecordingIdLookup() {
        return this.indexerOutboundLookup;
    }

    public RecordingIdLookup framerInboundLookup() {
        return this.framerInboundLookup;
    }

    public RecordingIdLookup framerOutboundLookup() {
        return this.framerOutboundLookup;
    }

    public AeronArchive archive() {
        return this.archive;
    }

    public Aeron aeron() {
        return this.aeron;
    }

    void monitoringAgent(MonitoringAgent monitoringAgent) {
        this.monitoringAgent = monitoringAgent;
    }

    static final class RecordingIds {
        private final Long2LongHashMap free = new Long2LongHashMap(-1L);
        private final Long2LongHashMap used = new Long2LongHashMap(-1L);

        RecordingIds() {
        }

        int size() {
            return this.free.size() + this.used.size();
        }

        void forEach(LibraryAndRecordingIdConsumer recordingIdConsumer) {
            this.forEach(this.free, recordingIdConsumer);
            this.forEach(this.used, recordingIdConsumer);
        }

        private void forEach(Long2LongHashMap map, LibraryAndRecordingIdConsumer recordingIdConsumer) {
            Long2LongHashMap.EntryIterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                it.next();
                recordingIdConsumer.accept((int)it.getLongKey(), it.getLongValue());
            }
        }

        long acquire(int libraryId) {
            Long2LongHashMap.ValueIterator it;
            long recordingId = this.free.remove((long)libraryId);
            if (recordingId == -1L && (it = this.free.values().iterator()).hasNext()) {
                recordingId = it.nextValue();
                it.remove();
            }
            return recordingId;
        }

        public String toString() {
            return "RecordingIds{free=" + String.valueOf(this.free) + ", used=" + String.valueOf(this.used) + "}";
        }
    }

    public static class LibraryExtendPosition {
        public final int newSessionId;
        public final long recordingId;
        public final int streamId;
        public final int initialTermId;
        public final int termBufferLength;
        public final int mtuLength;
        public long stopPosition;

        LibraryExtendPosition(int newSessionId, long recordingId, int streamId, long stopPosition, int initialTermId, int termBufferLength, int mtuLength) {
            this.newSessionId = newSessionId;
            this.recordingId = recordingId;
            this.streamId = streamId;
            this.stopPosition = stopPosition;
            this.initialTermId = initialTermId;
            this.termBufferLength = termBufferLength;
            this.mtuLength = mtuLength;
        }

        public String toString() {
            return "LibraryExtendPosition{newSessionId=" + this.newSessionId + ", recordingId=" + this.recordingId + ", streamId=" + this.streamId + ", stopPosition=" + this.stopPosition + ", initialTermId=" + this.initialTermId + ", termBufferLength=" + this.termBufferLength + ", mtuLength=" + this.mtuLength + "}";
        }
    }

    private class CompletingRecording {
        private final long completedPosition;
        private final long recordingId;
        private final int counterId;

        CompletingRecording(long completedPosition, int counterId) {
            this.completedPosition = completedPosition;
            this.counterId = counterId;
            this.recordingId = RecordingPos.getRecordingId((CountersReader)RecordingCoordinator.this.counters, (int)this.counterId);
        }

        boolean hasRecordingCompleted() {
            long recordedPosition = RecordingCoordinator.this.counters.getCounterValue(this.counterId);
            if (recordedPosition >= this.completedPosition) {
                return true;
            }
            if (!RecordingPos.isActive((CountersReader)RecordingCoordinator.this.counters, (int)this.counterId, (long)this.recordingId)) {
                throw new IllegalStateException("recording has stopped unexpectedly: " + this.recordingId);
            }
            return false;
        }

        public String toString() {
            return "CompletingRecording{completedPosition=" + this.completedPosition + ", recordingId=" + this.recordingId + ", counterId=" + this.counterId + "}";
        }
    }
}

