/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import java.util.concurrent.ThreadFactory;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.engine.RecordingCoordinator;

public class LockStepFramerEngineScheduler
implements EngineScheduler {
    private AgentRunner archivingRunner;
    private AgentRunner monitoringRunner;
    private AgentInvoker framerInvoker;
    private RecordingCoordinator recordingCoordinator;

    @Override
    public void launch(EngineConfiguration configuration, ErrorHandler errorHandler, Agent framer, Agent indexingAgent, Agent monitoringAgent, Agent conductorAgent, RecordingCoordinator recordingCoordinator) {
        this.recordingCoordinator = recordingCoordinator;
        this.framerInvoker = new AgentInvoker(errorHandler, null, framer);
        this.framerInvoker.start();
        if (this.archivingRunner != null) {
            EngineScheduler.fail();
        }
        this.archivingRunner = new AgentRunner(configuration.archiverIdleStrategy(), errorHandler, null, indexingAgent);
        AgentRunner.startOnThread((AgentRunner)this.archivingRunner, (ThreadFactory)configuration.threadFactory());
        if (monitoringAgent != null) {
            this.monitoringRunner = new AgentRunner(configuration.monitoringThreadIdleStrategy(), errorHandler, null, monitoringAgent);
            AgentRunner.startOnThread((AgentRunner)this.monitoringRunner, (ThreadFactory)configuration.threadFactory());
        }
    }

    public int invokeFramer() {
        try {
            return this.framerInvoker.invoke();
        }
        catch (Exception e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return 0;
        }
    }

    @Override
    public void close() {
        EngineScheduler.awaitRunnerStart(this.archivingRunner);
        EngineScheduler.awaitRunnerStart(this.monitoringRunner);
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.framerInvoker, this.recordingCoordinator, this.archivingRunner, this.monitoringRunner});
    }

    @Override
    public int pollFramer() {
        return 0;
    }

    @Override
    public void configure(Aeron.Context aeronContext) {
    }
}

