/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.ParsedAddress;

public class FixAdminSession
implements SessionInfo {
    private final long lastLogonTime;
    private final String connectedHost;
    private final CompositeKey sessionKey;
    private final long sessionId;
    private final long connectionId;
    private final int lastReceivedMsgSeqNum;
    private final int lastSentMsgSeqNum;
    private final int connectedPort;
    private final int sequenceIndex;
    private final boolean isSlow;

    public FixAdminSession(long sessionId, long connectionId, int lastReceivedMsgSeqNum, int lastSentMsgSeqNum, long lastLogonTime, int sequenceIndex, boolean isSlow, String address, CompositeKey sessionKey) {
        this.sessionId = sessionId;
        this.connectionId = connectionId;
        this.lastReceivedMsgSeqNum = lastReceivedMsgSeqNum;
        this.lastSentMsgSeqNum = lastSentMsgSeqNum;
        this.lastLogonTime = lastLogonTime;
        this.isSlow = isSlow;
        ParsedAddress parsed = ParsedAddress.parse(address);
        this.connectedHost = parsed.host();
        this.connectedPort = parsed.port();
        this.sessionKey = sessionKey;
        this.sequenceIndex = sequenceIndex;
    }

    @Override
    public long sessionId() {
        return this.sessionId;
    }

    @Override
    public CompositeKey sessionKey() {
        return this.sessionKey;
    }

    @Override
    public int sequenceIndex() {
        return this.sequenceIndex;
    }

    public long connectionId() {
        return this.connectionId;
    }

    public String connectedHost() {
        return this.connectedHost;
    }

    public int connectedPort() {
        return this.connectedPort;
    }

    public long lastLogonTime() {
        return this.lastLogonTime;
    }

    public int lastReceivedMsgSeqNum() {
        return this.lastReceivedMsgSeqNum;
    }

    public int lastSentMsgSeqNum() {
        return this.lastSentMsgSeqNum;
    }

    public boolean isConnected() {
        return this.connectionId != -1L;
    }

    public boolean isSlow() {
        return this.isSlow;
    }

    public String toString() {
        return "FixAdminSession{lastLogonTime=" + this.lastLogonTime + ", connectedHost='" + this.connectedHost + "', sessionKey=" + String.valueOf(this.sessionKey) + ", sessionId=" + this.sessionId + ", connectionId=" + this.connectionId + ", lastReceivedMsgSeqNum=" + this.lastReceivedMsgSeqNum + ", lastSentMsgSeqNum=" + this.lastSentMsgSeqNum + ", connectedPort=" + this.connectedPort + ", sequenceIndex=" + this.sequenceIndex + ", isSlow=" + this.isSlow + "}";
    }
}

