/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.framer.ReproductionProtocolHandler;
import uk.co.real_logic.artio.util.CharFormatter;

public class ReproductionClock
implements EpochNanoClock {
    private final CharFormatter formatter = new CharFormatter("Clock.advance:old=%s,new=%s,back=%s");
    private static final long NS_IN_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private long timeInNs;

    public ReproductionClock(long timeInNs) {
        this.timeInNs = timeInNs;
    }

    public long nanoTime() {
        return this.timeInNs;
    }

    public void advanceTimeTo(long timeInNs) {
        long oldTimeInNs = this.timeInNs;
        if (ReproductionProtocolHandler.REPRO_DEBUG_ENABLED) {
            DebugLogger.log(LogTag.REPRODUCTION, this.formatter, oldTimeInNs, timeInNs, oldTimeInNs > timeInNs ? "yes" : "no");
        }
        this.timeInNs = Math.max(oldTimeInNs, timeInNs);
    }

    public EpochClock toMillis() {
        return () -> this.timeInNs / NS_IN_MS;
    }
}

