/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.CloseChecker;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;

public final class MonitoringFile
implements AutoCloseable {
    private final MappedByteBuffer mappedByteBuffer;
    private final AtomicBuffer errorBuffer;
    private final String absolutePath;

    MonitoringFile(boolean newFile, CommonConfiguration configuration) {
        int length;
        File file = new File(configuration.monitoringFile()).getAbsoluteFile();
        this.absolutePath = file.getAbsolutePath();
        CloseChecker.validate(this.absolutePath);
        CloseChecker.onOpen(this.absolutePath, this);
        if (newFile) {
            IoUtil.deleteIfExists((File)file);
            length = configuration.monitoringBuffersLength();
            this.mappedByteBuffer = LoggerUtil.mapNewFile(file, length);
        } else {
            if (!(file.exists() && file.canRead() && file.isFile())) {
                throw new IllegalStateException("Unable to read from file: " + String.valueOf(file));
            }
            this.mappedByteBuffer = IoUtil.mapExistingFile((File)file, (String)"counters file");
            length = this.mappedByteBuffer.capacity();
        }
        UnsafeBuffer mappedFile = new UnsafeBuffer((ByteBuffer)this.mappedByteBuffer);
        this.errorBuffer = new UnsafeBuffer((DirectBuffer)mappedFile, 0, length);
    }

    public AtomicBuffer errorBuffer() {
        return this.errorBuffer;
    }

    @Override
    public void close() {
        IoUtil.unmap((MappedByteBuffer)this.mappedByteBuffer);
        CloseChecker.onClose(this.absolutePath, this);
    }
}

