/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.NotConnectedException;
import uk.co.real_logic.artio.util.CharFormatter;

public final class LivenessDetector {
    public static final int SEND_INTERVAL_FRACTION = 4;
    private static final Runnable NONE = () -> {};
    private static final int AWAITING_CONNECT = 0;
    private static final int CONNECTED = 1;
    private static final int DISCONNECTED = 2;
    private final GatewayPublication publication;
    private final Runnable onDisconnect;
    private final EpochNanoClock clock;
    private final int libraryId;
    private final long replyTimeoutInMs;
    private final long sendIntervalInMs;
    private final CharFormatter disconnectTriggered = new CharFormatter("%s: Disconnect triggered by a NotConnectedException (Stream CLOSED or MAX_POSITION_EXCEEDED)");
    private long latestNextReceiveTimeInMs;
    private long nextSendTimeInMs;
    private int state;

    public static LivenessDetector forEngine(GatewayPublication inboundPublication, int libraryId, long replyTimeoutInMs, long timeInMs, EpochNanoClock clock) {
        LivenessDetector detector = new LivenessDetector(inboundPublication, libraryId, replyTimeoutInMs, 1, NONE, clock);
        detector.latestNextReceiveTimeInMs = timeInMs + replyTimeoutInMs;
        detector.heartbeat(timeInMs);
        return detector;
    }

    public static LivenessDetector forLibrary(GatewayPublication publication, int libraryId, long replyTimeoutInMs, Runnable onDisconnect, EpochNanoClock clock) {
        return new LivenessDetector(publication, libraryId, replyTimeoutInMs, 0, onDisconnect, clock);
    }

    private LivenessDetector(GatewayPublication publication, int libraryId, long replyTimeoutInMs, int state, Runnable onDisconnect, EpochNanoClock clock) {
        this.publication = publication;
        this.libraryId = libraryId;
        this.replyTimeoutInMs = replyTimeoutInMs;
        this.state = state;
        this.sendIntervalInMs = replyTimeoutInMs / 4L;
        this.onDisconnect = onDisconnect;
        this.clock = clock;
    }

    public boolean isConnected() {
        return this.state == 1;
    }

    public boolean hasDisconnected() {
        return this.state == 2;
    }

    public int poll(long timeInMs) {
        switch (this.state) {
            case 1: {
                if (timeInMs > this.latestNextReceiveTimeInMs) {
                    this.disconnect();
                    return 1;
                }
                if (timeInMs <= this.nextSendTimeInMs) break;
                this.heartbeat(timeInMs);
                return 1;
            }
        }
        return 0;
    }

    private void disconnect() {
        this.state = 2;
        this.onDisconnect.run();
    }

    public void onHeartbeat(long timeInMs) {
        if (this.state != 1) {
            this.state = 1;
        }
        this.latestNextReceiveTimeInMs = timeInMs + this.replyTimeoutInMs;
    }

    public void onConnectStep(long timeInMs) {
        this.latestNextReceiveTimeInMs = timeInMs + this.replyTimeoutInMs;
    }

    private void heartbeat(long timeInMs) {
        try {
            if (this.publication.saveApplicationHeartbeat(this.libraryId, this.clock.nanoTime()) >= 0L) {
                this.nextSendTimeInMs = timeInMs + this.sendIntervalInMs;
            }
        }
        catch (NotConnectedException ex) {
            if (DebugLogger.isEnabled(LogTag.LIBRARY_CONNECT)) {
                DebugLogger.log(LogTag.LIBRARY_CONNECT, this.disconnectTriggered.clear().with(this.libraryId));
            }
            this.disconnect();
        }
    }
}

