/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import org.agrona.ErrorHandler;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.errors.DistinctErrorLog;

public interface ErrorHandlerFactory {
    public static ErrorHandlerFactory saveDistinctErrors() {
        return errorBuffer -> {
            SystemEpochClock clock = new SystemEpochClock();
            DistinctErrorLog distinctErrorLog = new DistinctErrorLog(errorBuffer, (EpochClock)clock);
            return throwable -> {
                if (!distinctErrorLog.record(throwable)) {
                    System.err.println("Error Log is full, consider increasing aeron.error.buffer.length");
                    throwable.printStackTrace();
                }
            };
        };
    }

    public ErrorHandler make(AtomicBuffer var1);
}

