/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.validation;

import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.validation.PersistenceLevel;

@FunctionalInterface
public interface SessionPersistenceStrategy {
    @Deprecated
    public static SessionPersistenceStrategy alwaysIndexed() {
        return SessionPersistenceStrategy.alwaysPersistent();
    }

    @Deprecated
    public static SessionPersistenceStrategy alwaysUnindexed() {
        return SessionPersistenceStrategy.alwaysTransient();
    }

    public static SessionPersistenceStrategy alwaysPersistent() {
        return logon -> PersistenceLevel.PERSISTENT_SEQUENCE_NUMBERS;
    }

    public static SessionPersistenceStrategy alwaysTransient() {
        return logon -> PersistenceLevel.TRANSIENT_SEQUENCE_NUMBERS;
    }

    public static boolean resetSequenceNumbersUponLogon(PersistenceLevel persistenceLevel) {
        switch (persistenceLevel) {
            case PERSISTENT_SEQUENCE_NUMBERS: 
            case INDEXED: {
                return false;
            }
            case TRANSIENT_SEQUENCE_NUMBERS: 
            case UNINDEXED: {
                return true;
            }
        }
        throw new IllegalArgumentException("persistenceLevel=" + persistenceLevel);
    }

    public PersistenceLevel getPersistenceLevel(AbstractLogonDecoder var1);
}

