/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.timing;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.HdrHistogram.Histogram;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.timing.HistogramHandler;

class HistogramLogWriter
implements HistogramHandler {
    private static final int BUFFER_SIZE = 0x100000;
    private final FileChannel logFile;
    private final ByteBuffer buffer;
    private final ErrorHandler errorHandler;

    HistogramLogWriter(int numberOfTimers, String logFile, ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        this.buffer = ByteBuffer.allocateDirect(0x100000);
        this.buffer.putInt(numberOfTimers);
        this.logFile = this.open(logFile);
    }

    @Override
    public void identifyTimer(int id, String name) {
        byte[] nameBytes = name.getBytes(StandardCharsets.UTF_8);
        this.buffer.putInt(id);
        this.buffer.putInt(nameBytes.length);
        this.buffer.put(nameBytes);
    }

    @Override
    public void onEndTimerIdentification() {
        this.writeBuffer();
    }

    @Override
    public void onTimerUpdate(int id, Histogram histogram) {
        this.buffer.putInt(id);
        histogram.encodeIntoByteBuffer(this.buffer);
    }

    @Override
    public void onBeginTimerUpdate(long currentTimeInMs) {
        this.buffer.clear();
        this.buffer.putLong(currentTimeInMs);
    }

    @Override
    public void onEndTimerUpdate() {
        this.writeBuffer();
    }

    private FileChannel open(String logFile) {
        try {
            Path path = Paths.get(logFile, new String[0]);
            Path parent = path.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            return FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
            return null;
        }
    }

    private void writeBuffer() {
        try {
            this.buffer.flip();
            this.logFile.write(this.buffer);
            this.logFile.force(true);
        }
        catch (IOException ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }

    @Override
    public void close() {
        try {
            this.logFile.force(true);
        }
        catch (IOException ex) {
            this.errorHandler.onError((Throwable)ex);
        }
        CloseHelper.close((AutoCloseable)this.logFile);
    }
}

