/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class SessionWriter {
    private final int libraryId;
    private final long sessionId;
    private final MutableAsciiBuffer asciiBuffer;
    private final GatewayPublication publication;
    private long connectionId;
    private int sequenceIndex;
    private InternalSession session;
    private boolean closed = false;

    public SessionWriter(int libraryId, long sessionId, long connectionId, MutableAsciiBuffer asciiBuffer, GatewayPublication publication, int sequenceIndex) {
        this.libraryId = libraryId;
        this.sessionId = sessionId;
        this.connectionId = connectionId;
        this.asciiBuffer = asciiBuffer;
        this.publication = publication;
        this.sequenceIndex = sequenceIndex;
    }

    public void sequenceIndex(int sequenceIndex) {
        this.checkState();
        this.sequenceIndex = sequenceIndex;
        InternalSession session = this.session;
        if (session != null) {
            session.sequenceIndex(sequenceIndex);
        }
    }

    public int sequenceIndex() {
        return this.sequenceIndex;
    }

    public SessionWriter connectionId(long connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    public long connectionId() {
        return this.connectionId;
    }

    public long send(Encoder encoder, int seqNum) {
        this.checkState();
        long result = encoder.encode(this.asciiBuffer, 0);
        int length = Encoder.length((long)result);
        int offset = Encoder.offset((long)result);
        return this.send((DirectBuffer)this.asciiBuffer, offset, length, seqNum, encoder.messageType());
    }

    public long send(DirectBuffer messageBuffer, int offset, int length, int seqNum, long messageType) {
        InternalSession session;
        this.checkState();
        long position = this.publication.saveMessage(messageBuffer, offset, length, this.libraryId, messageType, this.sessionId, this.sequenceIndex, this.connectionId, MessageStatus.OK, seqNum);
        if (position > 0L && (session = this.session) != null) {
            session.lastSentMsgSeqNum(seqNum);
            if (messageType == 53L) {
                session.onSessionWriterLogout();
            }
        }
        return position;
    }

    public long requestDisconnect(DisconnectReason reason) {
        this.checkState();
        return this.publication.saveRequestDisconnect(this.libraryId, this.connectionId, reason);
    }

    public long id() {
        return this.sessionId;
    }

    void linkTo(InternalSession session) {
        this.session = session;
        this.connectionId = session.connectionId();
    }

    void onDisconnect() {
        this.connectionId = -1L;
    }

    void checkState() {
        if (this.closed) {
            throw new IllegalStateException("Library has been closed");
        }
    }

    void close() {
        this.closed = true;
    }
}

