/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.LongPredicate;
import org.agrona.concurrent.EpochNanoClock;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;

public final class CancelOnDisconnect {
    private Consumer<BooleanSupplier> enqueueTask;
    private final EpochNanoClock clock;
    private final boolean isAcceptor;
    private final LongPredicate sendCancelOnDisconnectTrigger;
    private long cancelOnDisconnectTimeoutWindowInNs;
    private CancelOnDisconnectOption cancelOnDisconnectOption;

    public CancelOnDisconnect(EpochNanoClock clock, boolean isAcceptor, LongPredicate sendCancelOnDisconnectTrigger) {
        this.clock = clock;
        this.isAcceptor = isAcceptor;
        this.sendCancelOnDisconnectTrigger = sendCancelOnDisconnectTrigger;
    }

    public void enqueueTask(Consumer<BooleanSupplier> enqueueTask) {
        this.enqueueTask = enqueueTask;
    }

    public void checkCancelOnDisconnectLogout(long timeInNs) {
        if (!this.notifyCancelOnDisconnect(timeInNs, CancelOnDisconnectOption.CANCEL_ON_LOGOUT_ONLY)) {
            this.enqueueTask.accept(() -> this.notifyCancelOnDisconnect(timeInNs, CancelOnDisconnectOption.CANCEL_ON_LOGOUT_ONLY));
        }
    }

    public void checkCancelOnDisconnectDisconnect() {
        long timeInNs = this.clock.nanoTime();
        if (!this.notifyCancelOnDisconnect(timeInNs, CancelOnDisconnectOption.CANCEL_ON_DISCONNECT_ONLY)) {
            this.enqueueTask.accept(() -> this.notifyCancelOnDisconnect(timeInNs, CancelOnDisconnectOption.CANCEL_ON_DISCONNECT_ONLY));
        }
    }

    private boolean notifyCancelOnDisconnect(long timeInNs, CancelOnDisconnectOption option) {
        if (this.isAcceptor && (this.cancelOnDisconnectOption == option || this.cancelOnDisconnectOption == CancelOnDisconnectOption.CANCEL_ON_DISCONNECT_OR_LOGOUT)) {
            long deadlineInNs = timeInNs + this.cancelOnDisconnectTimeoutWindowInNs;
            return this.sendCancelOnDisconnectTrigger.test(deadlineInNs);
        }
        return true;
    }

    public void cancelOnDisconnectTimeoutWindowInNs(long cancelOnDisconnectTimeoutWindowInNs) {
        this.cancelOnDisconnectTimeoutWindowInNs = cancelOnDisconnectTimeoutWindowInNs;
    }

    public void cancelOnDisconnectOption(CancelOnDisconnectOption cancelOnDisconnectOption) {
        this.cancelOnDisconnectOption = cancelOnDisconnectOption;
    }
}

