/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.logger.IndexQuery;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.PositionRange;
import uk.co.real_logic.artio.storage.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.storage.messages.TimeIndexRecordDecoder;

class TimeIndexReader {
    private static final int SCAN_START = 0;
    private static final int SCAN_END = 1;
    private final String logFileDir;
    private final int streamid;

    TimeIndexReader(String logFileDir, int streamid) {
        this.logFileDir = logFileDir;
        this.streamid = streamid;
    }

    boolean findPositionRange(IndexQuery indexQuery, Long2ObjectHashMap<PositionRange> recordingIdToPositionRange) {
        File logDir = new File(this.logFileDir);
        String fileNamePrefix = "time-index-" + this.streamid;
        if (!logDir.exists() || !logDir.isDirectory()) {
            return false;
        }
        for (String file : logDir.list()) {
            if (!file.contains(fileNamePrefix)) continue;
            long recordingId = Long.parseLong(file.substring(file.lastIndexOf(45) + 1));
            recordingIdToPositionRange.put(recordingId, (Object)this.findPositionRange(indexQuery, new File(logDir, file)));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PositionRange findPositionRange(IndexQuery indexQuery, File file) {
        long beginTimestampInclusive = indexQuery.beginTimestampInclusive();
        long endTimestampExclusive = indexQuery.endTimestampExclusive();
        MappedByteBuffer mappedByteBuffer = LoggerUtil.mapExistingFile(file);
        try {
            int state;
            UnsafeBuffer buffer = new UnsafeBuffer((ByteBuffer)mappedByteBuffer);
            MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
            TimeIndexRecordDecoder timeIndexRecord = new TimeIndexRecordDecoder();
            headerDecoder.wrap((DirectBuffer)buffer, 0);
            int blockLength = headerDecoder.blockLength();
            int version = headerDecoder.version();
            int offset = 8;
            int capacity = buffer.capacity();
            long startPosition = 0L;
            long endPosition = Long.MAX_VALUE;
            int n = state = beginTimestampInclusive == Long.MIN_VALUE ? 1 : 0;
            block6: while (offset + 16 <= capacity) {
                timeIndexRecord.wrap((DirectBuffer)buffer, offset, blockLength, version);
                long timestampInNs = timeIndexRecord.timestamp();
                switch (state) {
                    case 0: {
                        if (timestampInNs >= beginTimestampInclusive) {
                            state = 1;
                        } else {
                            startPosition = timeIndexRecord.position();
                            break;
                        }
                    }
                    default: {
                        if (timestampInNs < endTimestampExclusive) break;
                        endPosition = timeIndexRecord.position();
                        break block6;
                    }
                }
                offset += 16;
            }
            PositionRange positionRange = new PositionRange(startPosition, endPosition);
            return positionRange;
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)mappedByteBuffer);
        }
    }
}

