/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.archive.client.AeronArchive;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.logger.FixArchiveScanningAgent;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.FixMessageLogger;
import uk.co.real_logic.artio.fixp.FixPMessageConsumer;

public class FixArchiveScanner
implements AutoCloseable {
    public static final int DEFAULT_FRAGMENT_LIMIT = 10000;
    static final boolean DEBUG_LOG_ARCHIVE_SCAN = DebugLogger.isEnabled(LogTag.ARCHIVE_SCAN);
    private final IdleStrategy idleStrategy;
    private final FixArchiveScanningAgent agent;

    public FixArchiveScanner(Configuration configuration) {
        configuration.conclude();
        Aeron.Context aeronContext = new Aeron.Context().aeronDirectoryName(configuration.aeronDirectoryName());
        Aeron aeron = Aeron.connect((Aeron.Context)aeronContext);
        AeronArchive.Context archiveContext = configuration.archiveContext;
        if (archiveContext == null) {
            archiveContext = new AeronArchive.Context();
            if (archiveContext.controlRequestChannel() == null) {
                archiveContext.controlRequestChannel(AeronArchive.Configuration.localControlChannel()).controlRequestStreamId(AeronArchive.Configuration.localControlStreamId());
            }
            if (archiveContext.controlResponseChannel() == null) {
                archiveContext.controlResponseChannel("aeron:ipc");
            }
        }
        AeronArchive aeronArchive = AeronArchive.connect((AeronArchive.Context)archiveContext.aeron(aeron).ownsAeronClient(true));
        String logFileDir = configuration.logFileDir();
        if (!configuration.enableIndexScan()) {
            logFileDir = null;
        }
        this.idleStrategy = configuration.idleStrategy();
        this.agent = new FixArchiveScanningAgent(this.idleStrategy, configuration.compactionSize, configuration.maximumBufferSize, configuration.fragmentLimit, logFileDir, aeron, aeronArchive);
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer handler, boolean follow, int archiveScannerStreamId) {
        this.scan(aeronChannel, queryStreamId, handler, null, follow, archiveScannerStreamId);
    }

    public void scan(String aeronChannel, int queryStreamId, FixMessageConsumer fixHandler, FixPMessageConsumer fixPHandler, boolean follow, int archiveScannerStreamId) {
        IntHashSet queryStreamIds = new IntHashSet();
        queryStreamIds.add(queryStreamId);
        this.scan(aeronChannel, queryStreamIds, fixHandler, fixPHandler, follow, archiveScannerStreamId);
    }

    public void scan(String aeronChannel, IntHashSet queryStreamIds, FixMessageConsumer fixHandler, FixPMessageConsumer fixPHandler, boolean follow, int archiveScannerStreamId) {
        this.agent.setup(aeronChannel, queryStreamIds, fixHandler, fixPHandler, follow, archiveScannerStreamId);
        while (true) {
            if (this.agent.poll(Integer.MAX_VALUE)) {
                this.idleStrategy.reset();
                return;
            }
            this.idleStrategy.idle();
        }
    }

    @Override
    public void close() {
        this.agent.close();
    }

    public static class Configuration {
        private int fragmentLimit = 10000;
        private String aeronDirectoryName;
        private IdleStrategy idleStrategy;
        private int compactionSize = 0x10000000;
        public int maximumBufferSize = 0x3FFFFFFB;
        private String logFileDir;
        private boolean enableIndexScan;
        private AeronArchive.Context archiveContext;

        public Configuration aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Configuration idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Configuration compactionSize(int compactionSize) {
            FixMessageLogger.Configuration.validateCompactionSize(compactionSize);
            this.compactionSize = compactionSize;
            return this;
        }

        public int compactionSize() {
            return this.compactionSize;
        }

        public Configuration maximumBufferSize(int maximumBufferSize) {
            FixMessageLogger.Configuration.validateMaximumBufferSize(maximumBufferSize);
            this.maximumBufferSize = maximumBufferSize;
            return this;
        }

        public int maximumBufferSize() {
            return this.maximumBufferSize;
        }

        public Configuration fragmentLimit(int fragmentLimit) {
            this.fragmentLimit = fragmentLimit;
            return this;
        }

        public int fragmentLimit() {
            return this.fragmentLimit;
        }

        public Configuration logFileDir(String logFileDir) {
            this.logFileDir = logFileDir;
            this.enableIndexScan = true;
            return this;
        }

        public String logFileDir() {
            return this.logFileDir;
        }

        public Configuration enableIndexScan(boolean enableIndexScan) {
            this.enableIndexScan = enableIndexScan;
            return this;
        }

        public boolean enableIndexScan() {
            return this.enableIndexScan;
        }

        public Configuration archiveContext(AeronArchive.Context archiveContext) {
            this.archiveContext = archiveContext;
            return this;
        }

        private void conclude() {
            if (this.enableIndexScan && this.logFileDir == null) {
                throw new IllegalArgumentException("Please configure a logFileDir if you want to enable index scan");
            }
            FixMessageLogger.Configuration.validateMaxAndCompactionSize(this.maximumBufferSize, this.compactionSize);
        }
    }
}

