/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.LongHashSet;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.ReplayerCommand;
import uk.co.real_logic.artio.engine.ReplayerCommandQueue;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.util.CharFormatter;

public class PruneOperation
implements ReplayerCommand,
Reply<Long2LongHashMap>,
RecordingDescriptorConsumer,
AdminCommand {
    public static final boolean STATE_CLEANUP_ENABLED = DebugLogger.isEnabled(LogTag.STATE_CLEANUP);
    private final Formatters formatters;
    private final ReplayQuery outboundReplayQuery;
    private final ReplayQuery inboundReplayQuery;
    private final Long2LongHashMap recordingIdToNewStartPosition = new Long2LongHashMap(-1L);
    private final Long2LongHashMap minimumPrunePositions;
    private final AeronArchive aeronArchive;
    private final ReplayerCommandQueue replayerCommandQueue;
    private final RecordingCoordinator recordingCoordinator;
    private final LongHashSet allRecordingIds = new LongHashSet();
    private volatile Reply.State replyState;
    private Long2LongHashMap result;
    private Exception error;
    private long requestedNewStartPosition;
    private long segmentStartPosition;
    private long lowerBoundPrunePosition;
    private int stashedSegmentFileLength;
    private long stashedStartPosition;

    public PruneOperation(Formatters formatters, Exception error) {
        this(formatters, null, null, null, null, null, null);
        this.error = error;
        this.replyState = Reply.State.ERRORED;
    }

    public PruneOperation(Formatters formatters, Long2LongHashMap minimumPrunePositions, ReplayQuery outboundReplayQuery, ReplayQuery inboundReplayQuery, AeronArchive aeronArchive, ReplayerCommandQueue replayerCommandQueue, RecordingCoordinator recordingCoordinator) {
        this.formatters = formatters;
        this.outboundReplayQuery = outboundReplayQuery;
        this.inboundReplayQuery = inboundReplayQuery;
        this.minimumPrunePositions = minimumPrunePositions;
        this.aeronArchive = aeronArchive;
        this.replayerCommandQueue = replayerCommandQueue;
        this.recordingCoordinator = recordingCoordinator;
        this.replyState = Reply.State.EXECUTING;
    }

    @Override
    public Exception error() {
        return this.error;
    }

    @Override
    public Long2LongHashMap resultIfPresent() {
        return this.result;
    }

    @Override
    public Reply.State state() {
        return this.replyState;
    }

    @Override
    public void execute(Framer framer) {
        DebugLogger.log(LogTag.STATE_CLEANUP, "PruneOperation: starting on Framer Thread");
        this.recordingCoordinator.forEachRecording((libraryId, recordingId) -> this.allRecordingIds.add(recordingId));
        if (!this.replayerCommandQueue.offer(this)) {
            framer.schedule(() -> this.replayerCommandQueue.offer(this) ? 1L : -2L);
        }
    }

    @Override
    public void execute() {
        DebugLogger.log(LogTag.STATE_CLEANUP, "PruneOperation: starting on Replayer Thread");
        this.inboundReplayQuery.queryStartPositions(this.recordingIdToNewStartPosition);
        this.outboundReplayQuery.queryStartPositions(this.recordingIdToNewStartPosition);
        this.findAllRecordingPositions();
        this.prune();
    }

    private void findAllRecordingPositions() {
        if (STATE_CLEANUP_ENABLED) {
            CharFormatter formatter = this.formatters.findingPositionsFormatter.clear().with(this.allRecordingIds.toString()).with(this.recordingIdToNewStartPosition.toString());
            DebugLogger.log(LogTag.STATE_CLEANUP, formatter);
        }
        Long2LongHashMap.KeyIterator knownRecordingIds = this.recordingIdToNewStartPosition.keySet().iterator();
        while (knownRecordingIds.hasNext()) {
            this.allRecordingIds.remove(knownRecordingIds.nextValue());
        }
        LongHashSet.LongIterator it = this.allRecordingIds.iterator();
        while (it.hasNext()) {
            long recordingId = it.nextValue();
            long recordingPosition = this.aeronArchive.getRecordingPosition(recordingId);
            if (recordingPosition != -1L) {
                this.recordingIdToNewStartPosition.put(recordingId, recordingPosition);
                continue;
            }
            long stopPosition = this.aeronArchive.getStopPosition(recordingId);
            this.recordingIdToNewStartPosition.put(recordingId, stopPosition);
        }
        if (STATE_CLEANUP_ENABLED) {
            CharFormatter formatter = this.formatters.foundPositionsFormatter.clear().with(this.recordingIdToNewStartPosition.toString());
            DebugLogger.log(LogTag.STATE_CLEANUP, formatter);
        }
    }

    private void prune() {
        Long2LongHashMap.EntryIterator it = this.recordingIdToNewStartPosition.entrySet().iterator();
        while (it.hasNext()) {
            long requestedMinimumPosition;
            it.next();
            long recordingId = it.getLongKey();
            long newStartPosition = it.getLongValue();
            if (this.minimumPrunePositions != null && (requestedMinimumPosition = this.minimumPrunePositions.get(recordingId)) != -1L) {
                newStartPosition = Math.min(newStartPosition, requestedMinimumPosition);
            }
            try {
                this.requestedNewStartPosition = newStartPosition;
                this.listRecording(recordingId);
                long segmentStartPosition = this.segmentStartPosition;
                if (segmentStartPosition < this.lowerBoundPrunePosition) {
                    if (STATE_CLEANUP_ENABLED) {
                        this.formatters.filteredRecordingFormatter.clear().with(recordingId).with(segmentStartPosition).with(this.lowerBoundPrunePosition).with(this.stashedSegmentFileLength).with(this.requestedNewStartPosition).with(this.stashedStartPosition);
                        DebugLogger.log(LogTag.STATE_CLEANUP, this.formatters.filteredRecordingFormatter);
                    }
                    it.remove();
                    continue;
                }
                this.aeronArchive.purgeSegments(recordingId, segmentStartPosition);
                this.recordingIdToNewStartPosition.put(recordingId, segmentStartPosition);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.onPruneError(e, it);
                return;
            }
        }
        this.result = this.recordingIdToNewStartPosition;
        this.replyState = Reply.State.COMPLETED;
    }

    private void listRecording(long recordingId) {
        int count = this.aeronArchive.listRecording(recordingId, (RecordingDescriptorConsumer)this);
        if (count != 1) {
            throw new IllegalStateException("Unable to list the recording: " + recordingId);
        }
    }

    public void onRecordingDescriptor(long controlSessionId, long correlationId, long recordingId, long startTimestamp, long stopTimestamp, long startPosition, long stopPosition, int initialTermId, int segmentFileLength, int termBufferLength, int mtuLength, int sessionId, int streamId, String strippedChannel, String originalChannel, String sourceIdentity) {
        this.segmentStartPosition = AeronArchive.segmentFileBasePosition((long)startPosition, (long)this.requestedNewStartPosition, (int)termBufferLength, (int)segmentFileLength);
        this.lowerBoundPrunePosition = AeronArchive.segmentFileBasePosition((long)startPosition, (long)startPosition, (int)termBufferLength, (int)segmentFileLength) + (long)segmentFileLength;
        this.stashedSegmentFileLength = segmentFileLength;
        this.stashedStartPosition = startPosition;
    }

    private void onPruneError(Exception e, Long2LongHashMap.EntryIterator it) {
        it.remove();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        this.error = e;
        this.result = this.recordingIdToNewStartPosition;
        this.replyState = Reply.State.ERRORED;
    }

    public String toString() {
        return "PruneOperation{newStartPositions=" + this.recordingIdToNewStartPosition + ", minimumPrunePositions=" + this.minimumPrunePositions + ", replyState=" + this.replyState + ", result=" + this.result + ", error=" + this.error + "}";
    }

    public static class Formatters {
        private final CharFormatter findingPositionsFormatter = new CharFormatter("PruneOperation: allRecordingIds=%s,queried recordingIdToNewStartPosition=%s");
        private final CharFormatter foundPositionsFormatter = new CharFormatter("PruneOperation: complete recordingIdToNewStartPosition=%s");
        private final CharFormatter filteredRecordingFormatter = new CharFormatter("PruneOperation: filtered recordingId=%s,segmentStartPosition=%s,lowerBoundPrunePosition=%s,segmentFileLength=%s,requestedNewStartPosition=%s,startPosition=%s");
    }
}

