/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.EpochClock;
import uk.co.real_logic.artio.FixGatewayException;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.AbstractAuthenticationProxy;

abstract class GatewaySessions {
    protected final Long2LongHashMap sessionIdToLastLibraryId = new Long2LongHashMap(-1L);
    protected final LongHashSet disconnectedSessionIds = new LongHashSet();
    protected final CharFormatter acquiredConnection = new CharFormatter("Gateway Acquired Connection %s");
    protected final List<GatewaySession> sessions = new ArrayList<GatewaySession>();
    protected final EpochClock epochClock;
    protected final GatewayPublication inboundPublication;
    protected final GatewayPublication outboundPublication;
    protected final SequenceNumberIndexReader sentSequenceNumberIndex;
    protected final SequenceNumberIndexReader receivedSequenceNumberIndex;
    protected ErrorHandler errorHandler;

    GatewaySessions(EpochClock epochClock, GatewayPublication inboundPublication, GatewayPublication outboundPublication, ErrorHandler errorHandler, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex) {
        this.epochClock = epochClock;
        this.inboundPublication = inboundPublication;
        this.outboundPublication = outboundPublication;
        this.errorHandler = errorHandler;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
    }

    static GatewaySession removeSessionByConnectionId(long connectionId, List<GatewaySession> sessions) {
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.connectionId() != connectionId) continue;
            sessions.remove(i);
            return session;
        }
        return null;
    }

    GatewaySession releaseBySessionId(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.remove(index);
    }

    GatewaySession sessionById(long sessionId) {
        int index = this.indexBySessionId(sessionId);
        if (index < 0) {
            return null;
        }
        return this.sessions.get(index);
    }

    private int indexBySessionId(long sessionId) {
        List<GatewaySession> sessions = this.sessions;
        return GatewaySessions.indexBySessionId(sessionId, sessions);
    }

    static int indexBySessionId(long sessionId, List<GatewaySession> sessions) {
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            GatewaySession session = sessions.get(i);
            if (session.sessionId() != sessionId) continue;
            return i;
        }
        return -1;
    }

    void releaseByConnectionId(long connectionId) {
        GatewaySession session = GatewaySessions.removeSessionByConnectionId(connectionId, this.sessions);
        if (session != null) {
            session.onDisconnectReleasedByOwner();
            session.close();
            long sessionId = session.sessionId();
            if (sessionId != -1L) {
                this.sessionIdToLastLibraryId.put(sessionId, (long)session.lastLibraryId);
            }
        }
    }

    int pollSessions(long timeInMs, long timeInNs) {
        List<GatewaySession> sessions = this.sessions;
        int eventsProcessed = 0;
        int i = 0;
        int size = sessions.size();
        while (i < size) {
            GatewaySession session = sessions.get(i);
            eventsProcessed += session.poll(timeInMs, timeInNs);
            if (session.hasDisconnected()) {
                --size;
                continue;
            }
            ++i;
        }
        return eventsProcessed;
    }

    List<GatewaySession> sessions() {
        return this.sessions;
    }

    private boolean lookupSequenceNumbers(GatewaySession gatewaySession, long requiredPosition) {
        long indexedPosition;
        int aeronSessionId = this.outboundPublication.sessionId();
        long initialPosition = this.outboundPublication.initialPosition();
        if (requiredPosition > initialPosition && (indexedPosition = this.sentSequenceNumberIndex.indexedPosition(aeronSessionId)) < requiredPosition) {
            return false;
        }
        long sessionId = gatewaySession.sessionId();
        int lastSentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        int lastReceivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
        gatewaySession.acceptorSequenceNumbers(lastSentSequenceNumber, lastReceivedSequenceNumber);
        if (lastReceivedSequenceNumber != -1) {
            this.setLastSequenceResetTime(gatewaySession);
        }
        return true;
    }

    protected abstract void setLastSequenceResetTime(GatewaySession var1);

    void track(GatewaySession gatewaySession) {
        this.sessions.add(gatewaySession);
    }

    public LongHashSet findDisconnectedSessions(int libraryId) {
        this.disconnectedSessionIds.clear();
        Long2LongHashMap.EntryIterator it = this.sessionIdToLastLibraryId.entrySet().iterator();
        while (it.hasNext()) {
            it.next();
            if (it.getLongValue() != (long)libraryId) continue;
            this.disconnectedSessionIds.add(it.getLongKey());
        }
        return this.disconnectedSessionIds;
    }

    public void removeDisconnectedSessions(LongHashSet disconnectedSessions) {
        LongHashSet.LongIterator it = disconnectedSessions.iterator();
        while (it.hasNext()) {
            this.sessionIdToLastLibraryId.remove(it.nextValue());
        }
    }

    protected abstract class PendingAcceptorLogon
    implements AbstractAuthenticationProxy,
    AcceptorLogonResult {
        private static final long NO_REQUIRED_POSITION = -1L;
        protected final long connectionId;
        protected final TcpChannel channel;
        protected final Framer framer;
        protected final ReceiverEndPoint receiverEndPoint;
        protected volatile AuthenticationState state = AuthenticationState.PENDING;
        protected GatewaySession session;
        protected DisconnectReason reason;
        protected long requiredPosition = -1L;
        protected long lingerTimeoutInMs;
        protected long lingerExpiryTimeInMs;
        protected ByteBuffer rejectEncodeBuffer;
        protected MutableAsciiBuffer rejectAsciiBuffer;

        PendingAcceptorLogon(GatewaySession gatewaySession, long connectionId, TcpChannel channel, Framer framer, ReceiverEndPoint receiverEndPoint) {
            this.session = gatewaySession;
            this.connectionId = connectionId;
            this.channel = channel;
            this.framer = framer;
            this.receiverEndPoint = receiverEndPoint;
        }

        protected void onStrategyError(String strategyName, Throwable throwable, long connectionId, String theDefault, String messageForError) {
            String message = String.format("Exception thrown by %s strategy for connectionId=%d, processing [%s], defaulted to %s", strategyName, connectionId, messageForError, theDefault);
            this.onError(new FixGatewayException(message, throwable));
        }

        protected void onError(Throwable throwable) {
            if (GatewaySessions.this.errorHandler == null) {
                LangUtil.rethrowUnchecked((Throwable)throwable);
            } else {
                GatewaySessions.this.errorHandler.onError(throwable);
            }
        }

        @Override
        public DisconnectReason reason() {
            return this.reason;
        }

        @Override
        public void accept() {
            this.validateState();
            this.setState(AuthenticationState.AUTHENTICATED);
        }

        protected void validateState() {
            AuthenticationState state = this.state;
            if (state != AuthenticationState.PENDING && state != AuthenticationState.AUTHENTICATED) {
                throw new IllegalStateException(String.format("Cannot reject and accept a pending operation at the same time (state=%s)", new Object[]{state}));
            }
        }

        @Override
        public boolean poll() {
            switch (this.state) {
                case AUTHENTICATED: {
                    this.session.onAuthenticationResult();
                    this.onAuthenticated();
                    return false;
                }
                case SAVING_REJECTED_LOGON_NO_REPLY: {
                    this.checkedOnAuthenticationResult();
                    boolean sentRejectedPendingLogon = this.receiverEndPoint.sendRejectedPendingLogon();
                    if (sentRejectedPendingLogon) {
                        this.setState(AuthenticationState.REJECTED);
                    }
                    return sentRejectedPendingLogon;
                }
                case SAVING_REJECTED_LOGON_WITH_REPLY: {
                    if (this.receiverEndPoint.sendRejectedPendingLogon()) {
                        this.setState(AuthenticationState.ENCODING_REJECT_MESSAGE);
                    }
                    return false;
                }
                case ENCODING_REJECT_MESSAGE: {
                    this.checkedOnAuthenticationResult();
                    this.onEncodingRejectMessage();
                    return false;
                }
                case SENDING_REJECT_MESSAGE: {
                    return this.onSendingRejectMessage();
                }
                case INDEXER_CATCHUP: {
                    this.onIndexerCatchup();
                    return false;
                }
                case ACCEPTED: 
                case REJECTED: {
                    return true;
                }
            }
            return false;
        }

        protected abstract void onAuthenticated();

        private void checkedOnAuthenticationResult() {
            if (this.session != null) {
                this.session.onAuthenticationResult();
                this.session = null;
            }
        }

        private void onEncodingRejectMessage() {
            try {
                this.encodeRejectMessage();
                this.setState(AuthenticationState.SENDING_REJECT_MESSAGE);
            }
            catch (Exception e) {
                GatewaySessions.this.errorHandler.onError((Throwable)e);
                this.setState(AuthenticationState.REJECTED);
            }
        }

        private boolean onSendingRejectMessage() {
            switch (this.sendReject()) {
                case INFLIGHT: {
                    long timeInMs = GatewaySessions.this.epochClock.time();
                    this.lingerExpiryTimeInMs = timeInMs + this.lingerTimeoutInMs;
                    this.framer.startLingering(this, this.lingerExpiryTimeInMs);
                    this.setState(AuthenticationState.LINGERING_REJECT_MESSAGE);
                    return false;
                }
                case BACK_PRESSURED: {
                    return false;
                }
            }
            this.setState(AuthenticationState.SAVING_REJECTED_LOGON_NO_REPLY);
            return true;
        }

        protected abstract void encodeRejectMessage();

        protected abstract SendRejectResult sendReject();

        private void onIndexerCatchup() {
            if (GatewaySessions.this.lookupSequenceNumbers(this.session, this.requiredPosition)) {
                this.setState(AuthenticationState.ACCEPTED);
            }
        }

        @Override
        public abstract void reject();

        protected void reject(DisconnectReason reason) {
            this.validateState();
            this.reason = reason;
            this.setState(AuthenticationState.SAVING_REJECTED_LOGON_NO_REPLY);
        }

        @Override
        public boolean isAccepted() {
            return AuthenticationState.ACCEPTED == this.state;
        }

        @Override
        public long connectionId() {
            return this.connectionId;
        }

        public void setState(AuthenticationState state) {
            this.state = state;
        }

        public boolean onLingerTimeout() {
            this.setState(AuthenticationState.REJECTED);
            ReceiverEndPoint receiverEndPoint = this.receiverEndPoint;
            receiverEndPoint.poll();
            return receiverEndPoint.hasDisconnected();
        }
    }

    static enum SendRejectResult {
        INFLIGHT,
        BACK_PRESSURED,
        DISCONNECTED;

    }

    static enum AuthenticationState {
        PENDING,
        AUTHENTICATED,
        INDEXER_CATCHUP,
        ACCEPTED,
        SAVING_REJECTED_LOGON_WITH_REPLY,
        ENCODING_REJECT_MESSAGE,
        SENDING_REJECT_MESSAGE,
        LINGERING_REJECT_MESSAGE,
        SAVING_REJECTED_LOGON_NO_REPLY,
        REJECTED;

    }
}

