/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.Subscription;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.status.ReadablePosition;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.StreamInformation;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineContext;
import uk.co.real_logic.artio.engine.EngineScheduler;
import uk.co.real_logic.artio.engine.FixPSessionInfo;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.AdminReplyPublication;
import uk.co.real_logic.artio.engine.framer.BindCommand;
import uk.co.real_logic.artio.engine.framer.DisconnectAllCommand;
import uk.co.real_logic.artio.engine.framer.EngineStreamInfo;
import uk.co.real_logic.artio.engine.framer.EngineStreamInfoRequestCommand;
import uk.co.real_logic.artio.engine.framer.FinalImagePositions;
import uk.co.real_logic.artio.engine.framer.FixContexts;
import uk.co.real_logic.artio.engine.framer.FixEndPointFactory;
import uk.co.real_logic.artio.engine.framer.FixGatewaySessions;
import uk.co.real_logic.artio.engine.framer.FixPContexts;
import uk.co.real_logic.artio.engine.framer.FixPGatewaySessions;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.engine.framer.LookupSessionIdCommand;
import uk.co.real_logic.artio.engine.framer.PositionRequestCommand;
import uk.co.real_logic.artio.engine.framer.QueryLibrariesCommand;
import uk.co.real_logic.artio.engine.framer.ReproductionLogWriter;
import uk.co.real_logic.artio.engine.framer.ResetReplayQueryCommand;
import uk.co.real_logic.artio.engine.framer.ResetSequenceNumberCommand;
import uk.co.real_logic.artio.engine.framer.ResetSessionIdsCommand;
import uk.co.real_logic.artio.engine.framer.StartReproduction;
import uk.co.real_logic.artio.engine.framer.UnbindCommand;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.Streams;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.timing.EngineTimers;

public class FramerContext {
    private static final int ADMIN_COMMAND_CAPACITY = 64;
    private final QueuedPipe<AdminCommand> adminCommands = new ManyToOneConcurrentArrayQueue(64);
    private final Framer framer;
    private final EngineConfiguration configuration;
    private final GatewaySessions gatewaySessions;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final GatewayPublication outboundPublication;
    private final GatewayPublication inboundPublication;
    private final FixContexts fixContexts;
    private final FixPContexts fixPContexts;
    private volatile boolean startingClose = false;

    public FramerContext(EngineConfiguration configuration, FixCounters fixCounters, EngineContext engineContext, ErrorHandler errorHandler, Image replayImage, EngineTimers timers, AgentInvoker conductorAgentInvoker, RecordingCoordinator recordingCoordinator, Aeron aeron) {
        FixEndPointFactory endPointFactory;
        this.configuration = configuration;
        SessionIdStrategy sessionIdStrategy = configuration.sessionIdStrategy();
        IdleStrategy idleStrategy = configuration.framerIdleStrategy();
        Streams outboundLibraryStreams = engineContext.outboundLibraryStreams();
        this.fixContexts = new FixContexts(configuration.sessionIdBuffer(), sessionIdStrategy, configuration.initialSequenceIndex(), errorHandler, configuration.isReproductionEnabled());
        this.fixPContexts = new FixPContexts(configuration.fixPIdBuffer(), errorHandler, configuration.epochNanoClock());
        this.inboundPublication = engineContext.inboundPublication();
        this.outboundPublication = outboundLibraryStreams.gatewayPublication(idleStrategy, outboundLibraryStreams.dataPublication("outboundPublication"));
        Subscription adminEngineSubscription = this.newAdminEngineSubscription(aeron);
        AdminReplyPublication adminReplyPublication = this.newAdminReplyPublication(aeron, fixCounters, idleStrategy);
        this.sentSequenceNumberIndex = new SequenceNumberIndexReader(configuration.sentSequenceNumberBuffer(), errorHandler, recordingCoordinator.framerOutboundLookup(), configuration.logFileDir());
        this.receivedSequenceNumberIndex = new SequenceNumberIndexReader(configuration.receivedSequenceNumberBuffer(), errorHandler, recordingCoordinator.framerInboundLookup(), null);
        ReproductionLogWriter reproductionLogWriter = this.reproductionLogWriter(outboundLibraryStreams);
        SystemEpochClock epochClock = new SystemEpochClock();
        if (configuration.acceptsFixP()) {
            this.gatewaySessions = new FixPGatewaySessions((EpochClock)epochClock, this.inboundPublication, this.outboundPublication, errorHandler, this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex, configuration, this.fixPContexts);
            endPointFactory = null;
        } else {
            this.gatewaySessions = new FixGatewaySessions((EpochClock)epochClock, this.inboundPublication, this.outboundPublication, sessionIdStrategy, configuration.sessionCustomisationStrategy(), fixCounters, configuration, errorHandler, this.fixContexts, configuration.sessionPersistenceStrategy(), this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex, configuration.sessionEpochFractionFormat());
            endPointFactory = new FixEndPointFactory(configuration, this.fixContexts, this.inboundPublication, reproductionLogWriter, fixCounters, errorHandler, (FixGatewaySessions)this.gatewaySessions, engineContext.senderSequenceNumbers(), configuration.messageTimingHandler());
        }
        FinalImagePositions finalImagePositions = new FinalImagePositions();
        this.framer = new Framer((EpochClock)epochClock, timers.outboundTimer(), timers.sendTimer(), configuration, adminEngineSubscription, adminReplyPublication, endPointFactory, engineContext.outboundLibrarySubscription("outboundLibrarySubscription", finalImagePositions), replayImage, engineContext.inboundReplayQuery(false), this.outboundPublication, this.inboundPublication, this.adminCommands, sessionIdStrategy, this.fixContexts, this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex, this.gatewaySessions, errorHandler, configuration.agentNamePrefix(), engineContext.inboundCompletionPosition(), engineContext.outboundLibraryCompletionPosition(), finalImagePositions, recordingCoordinator, this.fixPContexts, aeron.countersReader(), engineContext.inboundIndexRegistrationId(), engineContext.outboundIndexRegistrationId(), fixCounters, engineContext.senderSequenceNumbers(), conductorAgentInvoker, reproductionLogWriter);
    }

    private ReproductionLogWriter reproductionLogWriter(Streams outboundLibraryStreams) {
        if (this.configuration.writeReproductionLog()) {
            return new ReproductionLogWriter(outboundLibraryStreams.reproductionPublication());
        }
        return null;
    }

    private Subscription newAdminEngineSubscription(Aeron aeron) {
        Subscription adminEngineSubscription = aeron.addSubscription(this.configuration.libraryAeronChannel(), this.configuration.outboundAdminStream());
        StreamInformation.print("adminEngineSubscription", adminEngineSubscription, this.configuration.printAeronStreamIdentifiers());
        return adminEngineSubscription;
    }

    private AdminReplyPublication newAdminReplyPublication(Aeron aeron, FixCounters fixCounters, IdleStrategy idleStrategy) {
        ExclusivePublication adminDataPublication = aeron.addExclusivePublication(this.configuration.libraryAeronChannel(), this.configuration.inboundAdminStream());
        StreamInformation.print("adminEnginePublication", adminDataPublication, this.configuration.printAeronStreamIdentifiers());
        return new AdminReplyPublication(adminDataPublication, fixCounters.failedAdminReplyPublications(), idleStrategy, this.configuration.outboundMaxClaimAttempts());
    }

    public Agent framer() {
        return this.framer;
    }

    public Reply<List<LibraryInfo>> libraries() {
        QueryLibrariesCommand reply = new QueryLibrariesCommand();
        if (this.adminCommands.offer((Object)reply)) {
            return reply;
        }
        return null;
    }

    public Reply<?> resetSequenceNumber(long sessionId) {
        ResetSequenceNumberCommand reply = new ResetSequenceNumberCommand(sessionId, this.gatewaySessions, this.configuration.acceptsFixP() ? this.fixPContexts : this.fixContexts, this.receivedSequenceNumberIndex, this.sentSequenceNumberIndex, this.inboundPublication, this.outboundPublication, this.configuration.epochNanoClock().nanoTime());
        if (this.adminCommands.offer((Object)reply)) {
            return reply;
        }
        return null;
    }

    public Reply<?> resetSessionIds(File backupLocation) {
        ResetSessionIdsCommand command;
        if (backupLocation != null && !backupLocation.exists()) {
            try {
                if (!backupLocation.createNewFile()) {
                    throw new IllegalStateException("Could not create: " + backupLocation);
                }
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
        if (this.adminCommands.offer((Object)(command = new ResetSessionIdsCommand(backupLocation)))) {
            return command;
        }
        return null;
    }

    public void startClose() {
        IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
        DisconnectAllCommand command = new DisconnectAllCommand();
        while (!this.adminCommands.offer((Object)command)) {
            idleStrategy.idle();
        }
        idleStrategy.reset();
        this.startingClose = true;
        while (!command.hasCompleted()) {
            idleStrategy.idle();
        }
        idleStrategy.reset();
        if (command.hasErrored()) {
            LangUtil.rethrowUnchecked((Throwable)command.error());
        }
    }

    public Reply<Long> lookupSessionId(String localCompId, String remoteCompId, String localSubId, String remoteSubId, String localLocationId, String remoteLocationId) {
        LookupSessionIdCommand command = new LookupSessionIdCommand(localCompId, remoteCompId, localSubId, remoteSubId, localLocationId, remoteLocationId);
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }

    public Reply<?> bind() {
        BindCommand command = new BindCommand();
        if (!this.configuration.hasBindAddress()) {
            command.onError(new IllegalStateException("Missing address: EngineConfiguration.bindTo()"));
            return command;
        }
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }

    public Reply<?> unbind(boolean disconnect) {
        UnbindCommand command = new UnbindCommand(disconnect);
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }

    public boolean offer(AdminCommand command) {
        return this.adminCommands.offer((Object)command);
    }

    public List<SessionInfo> allSessions() {
        return this.fixContexts.allSessions();
    }

    public List<FixPSessionInfo> allFixPSessions() {
        return this.fixPContexts.allSessions();
    }

    public Reply<ReadablePosition> libraryIndexedPosition(int libraryId) {
        PositionRequestCommand command = new PositionRequestCommand(libraryId);
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }

    public void resetOutboundReplayQuery(long fixSessionId) {
        if (this.startingClose) {
            return;
        }
        ResetReplayQueryCommand command = new ResetReplayQueryCommand(fixSessionId);
        IdleStrategy idleStrategy = this.configuration.archiverIdleStrategy();
        EngineScheduler scheduler = this.configuration.scheduler();
        while (!this.adminCommands.offer((Object)command) && !this.startingClose) {
            idleStrategy.idle(scheduler.pollFramer());
        }
        idleStrategy.reset();
        while (!command.isDone() && !this.startingClose) {
            idleStrategy.idle(scheduler.pollFramer());
        }
        idleStrategy.reset();
    }

    public Reply<?> startReproduction() {
        StartReproduction command = new StartReproduction();
        while (!this.offer(command) && !this.startingClose) {
            Thread.yield();
        }
        return command;
    }

    public Reply<EngineStreamInfo> engineStreamInfo() {
        EngineStreamInfoRequestCommand command = new EngineStreamInfoRequestCommand();
        if (this.adminCommands.offer((Object)command)) {
            return command;
        }
        return null;
    }
}

