/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Image;
import io.aeron.ImageControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import org.agrona.DeadlineTimerWheel;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;
import org.agrona.concurrent.status.ReadablePosition;
import org.agrona.concurrent.status.UnsafeBufferPosition;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.LivenessDetector;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.CompletionPosition;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.EngineReproductionConfiguration;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.AcceptorFixDictionaryLookup;
import uk.co.real_logic.artio.engine.framer.AcceptorFixPReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.AdminCommand;
import uk.co.real_logic.artio.engine.framer.AdminEngineProtocolSubscription;
import uk.co.real_logic.artio.engine.framer.AdminReplyPublication;
import uk.co.real_logic.artio.engine.framer.BindCommand;
import uk.co.real_logic.artio.engine.framer.CancelOnDisconnectTimeoutOperation;
import uk.co.real_logic.artio.engine.framer.CatchupReplayer;
import uk.co.real_logic.artio.engine.framer.ConnectingSession;
import uk.co.real_logic.artio.engine.framer.Continuation;
import uk.co.real_logic.artio.engine.framer.DisconnectAllCommand;
import uk.co.real_logic.artio.engine.framer.DisconnectAllOperation;
import uk.co.real_logic.artio.engine.framer.EngineLibraryInfo;
import uk.co.real_logic.artio.engine.framer.EngineStreamInfo;
import uk.co.real_logic.artio.engine.framer.EngineStreamInfoRequestCommand;
import uk.co.real_logic.artio.engine.framer.FinalImagePositions;
import uk.co.real_logic.artio.engine.framer.FixContexts;
import uk.co.real_logic.artio.engine.framer.FixEndPointFactory;
import uk.co.real_logic.artio.engine.framer.FixGatewaySession;
import uk.co.real_logic.artio.engine.framer.FixGatewaySessions;
import uk.co.real_logic.artio.engine.framer.FixPContexts;
import uk.co.real_logic.artio.engine.framer.FixPGatewaySession;
import uk.co.real_logic.artio.engine.framer.FixPGatewaySessions;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.FixPSenderEndPoints;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixSenderEndPoint;
import uk.co.real_logic.artio.engine.framer.FixSenderEndPoints;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.ILink3Context;
import uk.co.real_logic.artio.engine.framer.ILink3Key;
import uk.co.real_logic.artio.engine.framer.InitiatorFixPReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.engine.framer.LiveLibraryInfo;
import uk.co.real_logic.artio.engine.framer.LookupSessionIdCommand;
import uk.co.real_logic.artio.engine.framer.PositionRequestCommand;
import uk.co.real_logic.artio.engine.framer.QueryLibrariesCommand;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoints;
import uk.co.real_logic.artio.engine.framer.ReproductionLog;
import uk.co.real_logic.artio.engine.framer.ReproductionLogReader;
import uk.co.real_logic.artio.engine.framer.ReproductionLogWriter;
import uk.co.real_logic.artio.engine.framer.ReproductionPoller;
import uk.co.real_logic.artio.engine.framer.ReproductionTcpChannelSupplier;
import uk.co.real_logic.artio.engine.framer.ResetSequenceNumberCommand;
import uk.co.real_logic.artio.engine.framer.ResetSessionIdsCommand;
import uk.co.real_logic.artio.engine.framer.RetryManager;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.StartReproduction;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.framer.TcpChannelSupplier;
import uk.co.real_logic.artio.engine.framer.TimerEventHandler;
import uk.co.real_logic.artio.engine.framer.UnbindCommand;
import uk.co.real_logic.artio.engine.framer.UnitOfWork;
import uk.co.real_logic.artio.engine.framer.WriteMetaDataResponse;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.fixp.FixPCancelOnDisconnectTimeoutHandler;
import uk.co.real_logic.artio.fixp.FixPContext;
import uk.co.real_logic.artio.fixp.FixPFirstMessageResponse;
import uk.co.real_logic.artio.fixp.FixPMessageDissector;
import uk.co.real_logic.artio.fixp.FixPProtocol;
import uk.co.real_logic.artio.fixp.FixPProtocolFactory;
import uk.co.real_logic.artio.fixp.FixPRejectRefIdExtractor;
import uk.co.real_logic.artio.fixp.InternalFixPContext;
import uk.co.real_logic.artio.messages.AllFixSessionsReplyEncoder;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.InitialAcceptedSessionOwner;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.MetaDataStatus;
import uk.co.real_logic.artio.messages.ReplayMessagesStatus;
import uk.co.real_logic.artio.messages.SequenceNumberType;
import uk.co.real_logic.artio.messages.SessionReplyStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.messages.SessionStatus;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.messages.ThrottleConfigurationStatus;
import uk.co.real_logic.artio.protocol.EngineEndPointHandler;
import uk.co.real_logic.artio.protocol.EngineProtocolSubscription;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.ProtocolHandler;
import uk.co.real_logic.artio.protocol.ProtocolSubscription;
import uk.co.real_logic.artio.protocol.ReplayProtocolHandler;
import uk.co.real_logic.artio.protocol.ReplayProtocolSubscription;
import uk.co.real_logic.artio.session.CancelOnDisconnectTimeoutHandler;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.timing.Timer;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.CharFormatter;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

class Framer
implements Agent,
EngineEndPointHandler,
ProtocolHandler {
    private static final DirectBuffer NULL_METADATA = new UnsafeBuffer(new byte[0]);
    private final CharFormatter timingOutFormatter = new CharFormatter("Timing out connection to library %s");
    private final CharFormatter libraryConnectedFormatter = new CharFormatter("Library %s - %s connected");
    private final CharFormatter handingToLibraryFormatter = new CharFormatter("Handing control for session %s to library %s");
    private final CharFormatter initiatingSessionFormatter = new CharFormatter("Initiating session %s from library %s");
    private final CharFormatter applicationHeartbeatFormatter = new CharFormatter("Received Heartbeat (msg=%s) from library %s at %sms, sent at %sns");
    private final CharFormatter acquiringSessionFormatter = new CharFormatter("Acquiring session %s from library %s");
    private final CharFormatter releasingSessionFormatter = new CharFormatter("Releasing session %s with connectionId %s from library %s");
    private final CharFormatter connectingFormatter = new CharFormatter("Connecting to %s:%s from library %s");
    private final RetryManager retryManager = new RetryManager();
    private final List<ResetSequenceNumberCommand> replies = new ArrayList<ResetSequenceNumberCommand>();
    private final Int2ObjectHashMap<LiveLibraryInfo> idToLibrary = new Int2ObjectHashMap();
    private final List<LiveLibraryInfo> librariesBeingAcquired = new ArrayList<LiveLibraryInfo>();
    private final Consumer<AdminCommand> onAdminCommand = command -> command.execute(this);
    private final TcpChannelSupplier.NewChannelHandler onNewConnectionFunc = this::onNewConnection;
    private final Predicate<LiveLibraryInfo> retryAcquireLibrarySessionsFunc = this::retryAcquireLibrarySessions;
    private final Consumer<FixGatewaySession> onSessionLogon = this::onSessionLogon;
    private final CatchupReplayer.Formatters catchupReplayFormatters = new CatchupReplayer.Formatters();
    private final Long2LongHashMap resendSlowStatus = new Long2LongHashMap(-1L);
    private final Long2LongHashMap resendNotSlowStatus = new Long2LongHashMap(-1L);
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final ReproductionPoller reproductionPoller;
    private final TcpChannelSupplier channelSupplier;
    private final EpochClock epochClock;
    private final EpochNanoClock clock;
    private final Timer outboundTimer;
    private final Timer sendTimer;
    private final ControlledFragmentHandler librarySubscriber;
    private final ControlledFragmentHandler replaySubscriber;
    private final AdminEngineProtocolSubscription adminEngineProtocolSubscription;
    private final Subscription adminEngineSubscription;
    private final ReceiverEndPoints receiverEndPoints;
    private final FixSenderEndPoints fixSenderEndPoints;
    private final CountersReader countersReader;
    private final long inboundIndexRegistrationId;
    private final long outboundIndexRegistrationId;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final ReproductionLogWriter reproductionLogWriter;
    private final FixCounters fixCounters;
    private final FixPSenderEndPoints fixPSenderEndPoints;
    private final LongConsumer removeILink3SenderEndPoints;
    private final EngineConfiguration configuration;
    private final AdminReplyPublication adminReplyPublication;
    private final FixEndPointFactory endPointFactory;
    private final Subscription librarySubscription;
    private final Image replayImage;
    private final GatewayPublication inboundPublication;
    private final String agentNamePrefix;
    private final CompletionPosition inboundCompletionPosition;
    private final CompletionPosition outboundLibraryCompletionPosition;
    private final FinalImagePositions finalImagePositions;
    private final SessionIdStrategy sessionIdStrategy;
    private final FixContexts fixContexts;
    private final QueuedPipe<AdminCommand> adminCommands;
    private final SequenceNumberIndexReader sentSequenceNumberIndex;
    private final SequenceNumberIndexReader receivedSequenceNumberIndex;
    private final int inboundBytesReceivedLimit;
    private final int outboundLibraryFragmentLimit;
    private final int replayFragmentLimit;
    private final GatewaySessions gatewaySessions;
    private final ReplayQuery inboundMessages;
    private final ErrorHandler errorHandler;
    private final GatewayPublication outboundPublication;
    private final RecordingCoordinator recordingCoordinator;
    private final boolean soleLibraryMode;
    private final InitialAcceptedSessionOwner initialAcceptedSessionOwner;
    private final AcceptorFixDictionaryLookup acceptorFixDictionaryLookup;
    private final LongHashSet requestAllSessionSeenSessions = new LongHashSet();
    private final CancelOnDisconnectFinder cancelOnDisconnectFinder = new CancelOnDisconnectFinder();
    private final Image outboundEngineImage;
    private final boolean acceptsFixP;
    private final FixPContexts fixPContexts;
    private final long replyTimeoutInNs;
    private final DeadlineTimerWheel timerWheel;
    private final TimerEventHandler timerEventHandler;
    private long nextConnectionId = (long)(Math.random() * 9.223372036854776E18);
    private FixPProtocol fixPProtocol;
    private AbstractFixPParser fixPParser;
    private AbstractFixPProxy fixPProxy;
    private FixPRejectRefIdExtractor fixPRejectRefIdExtractor;
    private boolean performingDisconnectOperation = false;
    private UnbindCommand pendingUnbind = null;
    private boolean shouldBind;
    private long nextApplicationHeartbeatTimeInNs = 0L;

    Framer(EpochClock epochClock, Timer outboundTimer, Timer sendTimer, EngineConfiguration configuration, Subscription adminEngineSubscription, AdminReplyPublication adminReplyPublication, FixEndPointFactory endPointFactory, Subscription librarySubscription, Image replayImage, ReplayQuery inboundMessages, GatewayPublication outboundPublication, GatewayPublication inboundPublication, QueuedPipe<AdminCommand> adminCommands, SessionIdStrategy sessionIdStrategy, FixContexts fixContexts, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex, GatewaySessions gatewaySessions, ErrorHandler errorHandler, String agentNamePrefix, CompletionPosition inboundCompletionPosition, CompletionPosition outboundLibraryCompletionPosition, FinalImagePositions finalImagePositions, RecordingCoordinator recordingCoordinator, FixPContexts fixPContexts, CountersReader countersReader, long inboundIndexRegistrationId, long outboundIndexRegistrationId, FixCounters fixCounters, SenderSequenceNumbers senderSequenceNumbers, AgentInvoker conductorAgentInvoker, ReproductionLogWriter reproductionLogWriter) {
        boolean isReproducing;
        this.epochClock = epochClock;
        this.clock = configuration.epochNanoClock();
        this.outboundTimer = outboundTimer;
        this.sendTimer = sendTimer;
        this.configuration = configuration;
        this.adminEngineSubscription = adminEngineSubscription;
        this.adminReplyPublication = adminReplyPublication;
        this.endPointFactory = endPointFactory;
        this.librarySubscription = librarySubscription;
        this.replayImage = replayImage;
        this.gatewaySessions = gatewaySessions;
        this.inboundMessages = inboundMessages;
        this.errorHandler = errorHandler;
        this.outboundPublication = outboundPublication;
        this.inboundPublication = inboundPublication;
        this.agentNamePrefix = agentNamePrefix;
        this.inboundCompletionPosition = inboundCompletionPosition;
        this.outboundLibraryCompletionPosition = outboundLibraryCompletionPosition;
        this.fixSenderEndPoints = new FixSenderEndPoints(errorHandler);
        this.countersReader = countersReader;
        this.inboundIndexRegistrationId = inboundIndexRegistrationId;
        this.outboundIndexRegistrationId = outboundIndexRegistrationId;
        this.senderSequenceNumbers = senderSequenceNumbers;
        this.reproductionLogWriter = reproductionLogWriter;
        this.fixPSenderEndPoints = new FixPSenderEndPoints();
        this.removeILink3SenderEndPoints = this.fixPSenderEndPoints::removeConnection;
        this.recordingCoordinator = recordingCoordinator;
        this.sessionIdStrategy = sessionIdStrategy;
        this.fixContexts = fixContexts;
        this.adminCommands = adminCommands;
        this.sentSequenceNumberIndex = sentSequenceNumberIndex;
        this.receivedSequenceNumberIndex = receivedSequenceNumberIndex;
        this.finalImagePositions = finalImagePositions;
        this.initialAcceptedSessionOwner = configuration.initialAcceptedSessionOwner();
        this.soleLibraryMode = this.initialAcceptedSessionOwner == InitialAcceptedSessionOwner.SOLE_LIBRARY;
        this.acceptsFixP = configuration.acceptsFixP();
        this.fixPContexts = fixPContexts;
        this.fixCounters = fixCounters;
        this.replyTimeoutInNs = TimeUnit.MILLISECONDS.toNanos(configuration.replyTimeoutInMs());
        this.timerEventHandler = new TimerEventHandler(errorHandler);
        this.acceptorFixDictionaryLookup = new AcceptorFixDictionaryLookup(configuration.acceptorfixDictionary(), configuration.acceptorFixDictionaryOverrides());
        this.receiverEndPoints = new ReceiverEndPoints(errorHandler);
        this.outboundLibraryFragmentLimit = configuration.outboundLibraryFragmentLimit();
        this.replayFragmentLimit = configuration.replayFragmentLimit();
        this.inboundBytesReceivedLimit = configuration.inboundBytesReceivedLimit();
        this.librarySubscriber = new ControlledFragmentAssembler(ProtocolSubscription.of(this, new EngineProtocolSubscription(this)), 0, true);
        this.replaySubscriber = new ImageControlledFragmentAssembler(ProtocolSubscription.of(new ProtocolHandler(){

            @Override
            public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, long messageType, long timestamp, MessageStatus status, int sequenceNumber, Header header, int metaDataLength) {
                return Framer.this.fixSenderEndPoints.onReplayMessage(connectionId, buffer, offset, length, sequenceNumber);
            }

            @Override
            public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }

            @Override
            public ControlledFragmentHandler.Action onFixPMessage(long connectionId, DirectBuffer buffer, int offset) {
                return Framer.this.fixPSenderEndPoints.onMessage(connectionId, buffer, offset, true);
            }
        }, new ReplayProtocolSubscription(new FramerReplayProtocolHandler(false))), 0, true);
        this.adminEngineProtocolSubscription = new AdminEngineProtocolSubscription(this);
        EngineReproductionConfiguration reproductionConfiguration = configuration.reproductionConfiguration();
        boolean bl = isReproducing = reproductionConfiguration != null;
        if (isReproducing) {
            ReproductionLog reproductionLog = ReproductionLogReader.read(recordingCoordinator.reproductionSubscription());
            this.channelSupplier = new ReproductionTcpChannelSupplier(configuration.reproductionMessageHandler(), reproductionLog);
            this.reproductionPoller = new ReproductionPoller(reproductionConfiguration, this.channelSupplier, configuration.framerIdleStrategy(), configuration.logFileDir(), recordingCoordinator, configuration.libraryAeronChannel(), configuration.inboundLibraryStream(), configuration.reproductionReplayStream());
            this.shouldBind = false;
        } else {
            this.channelSupplier = configuration.channelSupplier();
            this.reproductionPoller = null;
            this.shouldBind = configuration.bindAtStartup();
        }
        Image image = null;
        while (image == null) {
            image = librarySubscription.imageBySessionId(outboundPublication.sessionId());
            if (conductorAgentInvoker != null) {
                conductorAgentInvoker.invoke();
            }
            Thread.yield();
        }
        this.outboundEngineImage = image;
        this.timerWheel = new DeadlineTimerWheel(TimeUnit.MILLISECONDS, epochClock.time(), 128L, 512);
    }

    public int doWork() throws Exception {
        long timeInNs = this.clock.nanoTime();
        long timeInMs = this.epochClock.time();
        this.fixSenderEndPoints.timeInMs(timeInMs);
        this.checkOutboundTimestampSender(timeInNs);
        return this.retryManager.attemptSteps() + this.sendOutboundMessages() + this.sendReplayMessages() + this.pollEndPoints() + this.pollNewConnections(timeInMs) + this.pollLibraries(timeInMs) + this.gatewaySessions.pollSessions(timeInMs, timeInNs) + this.fixSenderEndPoints.poll(timeInMs) + this.adminCommands.drain(this.onAdminCommand) + this.checkDutyCycle(timeInMs);
    }

    private void checkOutboundTimestampSender(long timeInNs) {
        long nextApplicationHeartbeatTimeInNs = this.nextApplicationHeartbeatTimeInNs;
        if (nextApplicationHeartbeatTimeInNs < timeInNs && this.outboundPublication.saveApplicationHeartbeat(0, timeInNs) > 0L) {
            this.nextApplicationHeartbeatTimeInNs = timeInNs + this.replyTimeoutInNs;
        }
    }

    private int checkDutyCycle(long timeInMs) {
        return CollectionUtil.removeIf(this.replies, ResetSequenceNumberCommand::poll) + this.resendSaveNotifications(this.resendSlowStatus, SlowStatus.SLOW) + this.resendSaveNotifications(this.resendNotSlowStatus, SlowStatus.NOT_SLOW) + this.timerWheel.poll(timeInMs, (DeadlineTimerWheel.TimerHandler)this.timerEventHandler, 10);
    }

    private int resendSaveNotifications(Long2LongHashMap resend, SlowStatus status) {
        int actions = 0;
        if (!resend.isEmpty()) {
            Long2LongHashMap.KeyIterator keyIterator = resend.keySet().iterator();
            while (keyIterator.hasNext()) {
                long connectionId = keyIterator.nextValue();
                int libraryId = (int)resend.get(connectionId);
                long position = this.inboundPublication.saveSlowStatusNotification(libraryId, connectionId, status);
                if (position > 0L) {
                    keyIterator.remove();
                }
                ++actions;
            }
        }
        return actions;
    }

    private int sendReplayMessages() {
        return this.replayImage.controlledPoll(this.replaySubscriber, this.replayFragmentLimit);
    }

    private int sendOutboundMessages() {
        return this.fixPSenderEndPoints.reattempt() + this.librarySubscription.controlledPoll(this.librarySubscriber, this.outboundLibraryFragmentLimit) + this.adminEngineSubscription.poll((FragmentHandler)this.adminEngineProtocolSubscription, this.outboundLibraryFragmentLimit);
    }

    private int pollLibraries(long timeInMs) {
        int total = 0;
        Int2ObjectHashMap.ValueIterator iterator = this.idToLibrary.values().iterator();
        while (iterator.hasNext()) {
            LiveLibraryInfo library = (LiveLibraryInfo)iterator.next();
            total += library.poll(timeInMs);
            if (library.isConnected()) continue;
            iterator.remove();
            this.onLibraryDisconnect(library);
            this.soleLibraryModeUnbind();
        }
        return total += CollectionUtil.removeIf(this.librariesBeingAcquired, this.retryAcquireLibrarySessionsFunc);
    }

    private void onLibraryDisconnect(LiveLibraryInfo library) {
        if (DebugLogger.isEnabled(LogTag.LIBRARY_MANAGEMENT)) {
            DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, this.timingOutFormatter.clear().with(library.libraryId()));
        }
        this.tryAcquireLibrarySessions(library);
        this.saveLibraryTimeout(library);
        this.disconnectILinkConnections(library);
    }

    private void disconnectILinkConnections(LiveLibraryInfo library) {
        int libraryId = library.libraryId();
        this.receiverEndPoints.disconnectILinkConnections(libraryId, this.removeILink3SenderEndPoints);
    }

    private void soleLibraryModeUnbind() {
        if (this.soleLibraryMode && this.idToLibrary.isEmpty()) {
            try {
                this.channelSupplier.unbind();
            }
            catch (IOException e) {
                this.errorHandler.onError((Throwable)e);
            }
        }
    }

    private void tryAcquireLibrarySessions(LiveLibraryInfo library) {
        int librarySessionId = library.aeronSessionId();
        Image image = this.librarySubscription.imageBySessionId(librarySessionId);
        long libraryPosition = this.finalImagePositions.lookupPosition(librarySessionId);
        if (image != null) {
            libraryPosition = image.position();
        }
        if (!this.configuration.logOutboundMessages() || this.sentIndexedPosition(librarySessionId, libraryPosition)) {
            this.acquireLibrarySessions(library);
        } else {
            library.acquireAtPosition(libraryPosition);
            this.librariesBeingAcquired.add(library);
        }
    }

    private boolean retryAcquireLibrarySessions(LiveLibraryInfo library) {
        if (!this.configuration.logOutboundMessages() || this.sentIndexedPosition(library.aeronSessionId(), library.acquireAtPosition())) {
            this.acquireLibrarySessions(library);
            return true;
        }
        return false;
    }

    private boolean sentIndexedPosition(int aeronSessionId, long position) {
        long indexedPosition = this.sentSequenceNumberIndex.indexedPosition(aeronSessionId);
        return indexedPosition >= position;
    }

    private boolean receivedIndexedPosition(int aeronSessionId, long position) {
        long indexedPosition = this.receivedSequenceNumberIndex.indexedPosition(aeronSessionId);
        return indexedPosition >= position;
    }

    private void saveLibraryTimeout(LibraryInfo library) {
        this.schedule(() -> this.inboundPublication.saveLibraryTimeout(library, 0L));
        this.schedule(() -> this.outboundPublication.saveLibraryTimeout(library, 0L));
    }

    private void acquireLibrarySessions(LiveLibraryInfo library) {
        List<GatewaySession> sessions = library.gatewaySessions();
        int size = sessions.size();
        for (int i = 0; i < size; ++i) {
            FixGatewaySession session;
            if (this.acceptsFixP || (session = (FixGatewaySession)sessions.get(i)).isOffline()) continue;
            long sessionId = session.sessionId();
            int sentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
            int receivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
            boolean hasLoggedIn = receivedSequenceNumber != -1;
            SessionState state = hasLoggedIn ? SessionState.ACTIVE : SessionState.CONNECTED;
            DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, this.acquiringSessionFormatter, session.sessionId(), (long)library.libraryId());
            ((FixGatewaySessions)this.gatewaySessions).acquire(session, state, false, session.heartbeatIntervalInS(), sentSequenceNumber, receivedSequenceNumber, session.username(), session.password());
            this.schedule(this.saveManageSession(0, session));
            if (!this.performingDisconnectOperation) continue;
            session.session().logoutAndDisconnect();
        }
        this.finalImagePositions.removePosition(library.aeronSessionId());
    }

    private int pollEndPoints() {
        int bytesReceived;
        int inboundBytesReceivedLimit = this.inboundBytesReceivedLimit;
        int totalBytesReceived = 0;
        while ((bytesReceived = this.receiverEndPoints.pollEndPoints()) > 0 && (totalBytesReceived += bytesReceived) < inboundBytesReceivedLimit) {
        }
        return totalBytesReceived;
    }

    private int pollNewConnections(long timeInMs) throws IOException {
        return this.channelSupplier.pollSelector(timeInMs, this.onNewConnectionFunc);
    }

    private void onNewConnection(long timeInMs, TcpChannel channel) {
        if (this.performingDisconnectOperation) {
            channel.close();
            return;
        }
        if (this.acceptsFixP) {
            this.onNewFixPConnection(timeInMs, channel);
        } else {
            this.onNewFixConnection(timeInMs, channel);
        }
    }

    private void onNewFixPConnection(long timeInMs, TcpChannel channel) {
        FixPProtocolType protocolType = this.initFixPProtocol();
        long connectionId = this.newConnectionId();
        AtomicCounter bytesInBuffer = this.fixCounters.bytesInBuffer(connectionId, channel.remoteAddr());
        this.senderSequenceNumbers.onNewSender(connectionId, bytesInBuffer);
        AcceptorFixPReceiverEndPoint receiverEndPoint = new AcceptorFixPReceiverEndPoint(connectionId, channel, this.configuration.receiverBufferSize(), this.errorHandler, this, this.inboundPublication, 0, this.configuration.epochNanoClock(), connectionId, this.fixPProtocol, this.configuration.throttleWindowInMs(), this.configuration.throttleLimitOfMessages(), this.fixPRejectRefIdExtractor);
        this.receiverEndPoints.add(receiverEndPoint);
        FixPSenderEndPoint senderEndPoint = FixPSenderEndPoint.of(connectionId, channel, this.errorHandler, this.inboundPublication.dataPublication(), this.reproductionLogWriter, 0, this.configuration.messageTimingHandler(), this.fixPProtocol.explicitSequenceNumbers(), this.fixPParser.templateIdOffset(), this.fixPParser.retransmissionTemplateId(), this.fixPSenderEndPoints, bytesInBuffer, this.configuration.senderMaxBytesInBuffer(), this, receiverEndPoint);
        this.fixPSenderEndPoints.add(senderEndPoint);
        FixPGatewaySession gatewaySession = new FixPGatewaySession(connectionId, -1L, channel.remoteAddr(), ConnectionType.ACCEPTOR, this.configuration.authenticationTimeoutInMs(), protocolType, this.fixPParser, this.fixPProxy, receiverEndPoint, senderEndPoint, (FixPGatewaySessions)this.gatewaySessions);
        gatewaySession.disconnectAt(timeInMs + (long)this.configuration.noLogonDisconnectTimeoutInMs());
        this.gatewaySessions.track(gatewaySession);
        receiverEndPoint.gatewaySession(gatewaySession);
        this.saveConnect(channel, connectionId);
    }

    private FixPProtocolType initFixPProtocol() {
        FixPProtocolType protocolType = this.configuration.supportedFixPProtocolType();
        if (this.fixPProtocol == null) {
            this.fixPProtocol = FixPProtocolFactory.make(protocolType, this.errorHandler);
            FixPMessageDissector fixPDissector = new FixPMessageDissector(this.fixPProtocol.messageDecoders());
            this.fixPParser = this.fixPProtocol.makeParser(null);
            try {
                this.fixPProxy = this.fixPProtocol.makeProxy(fixPDissector, null, null);
                this.fixPRejectRefIdExtractor = this.fixPProtocol.makeRefIdExtractor();
            }
            catch (Throwable e) {
                this.errorHandler.onError(e);
            }
        }
        return protocolType;
    }

    private void onNewFixConnection(long timeInMs, TcpChannel channel) {
        long connectionId = this.newConnectionId();
        FixGatewaySession gatewaySession = this.setupFixConnection(channel, connectionId, FixContexts.UNKNOWN_SESSION, null, 0, ConnectionType.ACCEPTOR, this.configuration.acceptedSessionClosedResendInterval(), this.configuration.acceptedSessionResendRequestChunkSize(), this.configuration.acceptedSessionSendRedundantResendRequests(), this.configuration.acceptedEnableLastMsgSeqNumProcessed(), null);
        gatewaySession.disconnectAt(timeInMs + (long)this.configuration.noLogonDisconnectTimeoutInMs());
        this.gatewaySessions.track(gatewaySession);
        this.saveConnect(channel, connectionId);
    }

    private void saveConnect(TcpChannel channel, long connectionId) {
        String address = channel.remoteAddr();
        long timeInNs = this.clock.nanoTime();
        long position = this.inboundPublication.saveConnect(connectionId, timeInNs, address);
        if (Pressure.isBackPressured(position)) {
            this.schedule(() -> this.inboundPublication.saveConnect(connectionId, timeInNs, address));
        }
    }

    private long newConnectionId() {
        long connectionId;
        if (this.reproductionPoller != null) {
            return this.reproductionPoller.newConnectionId();
        }
        do {
            ++this.nextConnectionId;
        } while (connectionId == -1L);
        return connectionId;
    }

    @Override
    public ControlledFragmentHandler.Action onInitiateILinkConnection(int libraryId, int port, long correlationId, boolean reestablishConnection, boolean useBackupHost, String primaryHost, String accessKeyId, String backupHost) {
        ILink3Key key;
        ILink3Context context;
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library == null) {
            this.saveUnknownLibrary(libraryId, correlationId);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        String host = useBackupHost ? backupHost : primaryHost;
        InetSocketAddress address = new InetSocketAddress(host, port);
        FixPContexts fixPContexts = this.fixPContexts;
        FixPProtocolType protocolType = this.configuration.supportedFixPProtocolType();
        if (protocolType != FixPProtocolType.ILINK_3) {
            return this.invalidFixPProtocol(libraryId, correlationId, protocolType);
        }
        if (this.fixPProtocol == null) {
            this.initFixPProtocol();
        }
        if (this.checkDuplicateILinkConnection(libraryId, correlationId, useBackupHost, accessKeyId, address, context = (ILink3Context)fixPContexts.calculateInitiatorContext(key = new ILink3Key(port, primaryHost, accessKeyId), reestablishConnection))) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        int aeronSessionId = library.aeronSessionId();
        Image image = this.librarySubscription.imageBySessionId(aeronSessionId);
        long position = image.position();
        ILink3LookupConnectOperation lookupInformation = new ILink3LookupConnectOperation(libraryId, correlationId, context, aeronSessionId, position, address);
        this.schedule(lookupInformation);
        try {
            DebugLogger.log(LogTag.FIX_CONNECTION, this.connectingFormatter, host, (long)port, (long)libraryId);
            this.channelSupplier.open(address, (channel, ex) -> {
                if (ex != null) {
                    this.cancelILink3LookupConnectOperation(correlationId, false);
                    this.saveError(GatewayError.UNABLE_TO_CONNECT, libraryId, correlationId, ex);
                    return;
                }
                DebugLogger.log(LogTag.FIX_CONNECTION, this.initiatingSessionFormatter, context.connectUuid(), (long)libraryId);
                long connectionId = this.newConnectionId();
                lookupInformation.connected(connectionId);
                if (useBackupHost) {
                    context.backupConnected(true);
                } else {
                    context.primaryConnected(true);
                }
                AtomicCounter bytesInBuffer = this.fixCounters.bytesInBuffer(connectionId, channel.remoteAddr());
                this.senderSequenceNumbers.onNewSender(connectionId, bytesInBuffer);
                InitiatorFixPReceiverEndPoint receiverEndPoint = new InitiatorFixPReceiverEndPoint(connectionId, channel, this.configuration.receiverBufferSize(), this.errorHandler, this, this.inboundPublication, libraryId, context, this.configuration.epochNanoClock(), correlationId, fixPContexts, this.fixPProtocol, this.configuration.throttleWindowInMs(), this.configuration.throttleLimitOfMessages(), this.fixPRejectRefIdExtractor);
                this.receiverEndPoints.add(receiverEndPoint);
                this.fixPSenderEndPoints.add(FixPSenderEndPoint.of(connectionId, channel, this.errorHandler, this.inboundPublication.dataPublication(), this.reproductionLogWriter, libraryId, this.configuration.messageTimingHandler(), this.fixPProtocol.explicitSequenceNumbers(), this.fixPParser.templateIdOffset(), this.fixPParser.retransmissionTemplateId(), this.fixPSenderEndPoints, bytesInBuffer, this.configuration.senderMaxBytesInBuffer(), this, receiverEndPoint));
            });
        }
        catch (Exception ex2) {
            this.cancelILink3LookupConnectOperation(correlationId, false);
            this.saveError(GatewayError.UNABLE_TO_CONNECT, libraryId, correlationId, ex2);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action invalidFixPProtocol(int libraryId, long correlationId, FixPProtocolType protocolType) {
        this.saveError(GatewayError.INVALID_CONFIGURATION, libraryId, correlationId, new IllegalStateException("Invalid configured protocol type: " + protocolType));
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public void onCancelOnDisconnectTrigger(long sessionId, long timeInNs) {
        if (this.acceptsFixP) {
            this.onFixPCancelOnDisconnectTrigger(sessionId, timeInNs);
        } else {
            this.onFixCancelOnDisconnectTrigger(sessionId, timeInNs);
        }
    }

    private void onFixPCancelOnDisconnectTrigger(long sessionId, long timeInNs) {
        final FixPCancelOnDisconnectTimeoutHandler handler = this.configuration.fixPCancelOnDisconnectTimeoutHandler();
        if (handler != null) {
            InternalFixPContext context = this.fixPContexts.lookupContext(sessionId);
            if (context == null) {
                this.cancelOnDisconnectError(sessionId);
                return;
            }
            this.schedule(new CancelOnDisconnectTimeoutOperation(sessionId, timeInNs, this.clock, this.errorHandler, (FixPContext)context){
                final /* synthetic */ FixPContext val$context;
                {
                    this.val$context = fixPContext;
                    super(sessionId, timeInNs, clock, errorHandler);
                }

                @Override
                protected void onCancelOnDisconnectTimeout() {
                    handler.onCancelOnDisconnectTimeout(this.sessionId, this.val$context);
                }
            });
        }
    }

    private void onFixCancelOnDisconnectTrigger(long sessionId, long timeInNs) {
        final CancelOnDisconnectTimeoutHandler handler = this.configuration.cancelOnDisconnectTimeoutHandler();
        if (handler != null) {
            Map.Entry<CompositeKey, SessionContext> entry = this.fixContexts.lookupById(sessionId);
            if (entry == null) {
                this.cancelOnDisconnectError(sessionId);
                return;
            }
            final CompositeKey sessionKey = entry.getKey();
            this.schedule(new CancelOnDisconnectTimeoutOperation(sessionId, timeInNs, this.clock, this.errorHandler){

                @Override
                protected void onCancelOnDisconnectTimeout() {
                    handler.onCancelOnDisconnectTimeout(this.sessionId, sessionKey);
                }
            });
        }
    }

    private void cancelOnDisconnectError(long sessionId) {
        this.errorHandler.onError((Throwable)new IllegalStateException("Unknown session id when performing cancel on disconnect timeout: " + sessionId));
    }

    @Override
    public ControlledFragmentHandler.Action onThrottleReject(int libraryId, long connectionId, long refMsgType, int refSeqNum, int sequenceNumber, int sequenceIndex, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength, Header header) {
        return this.fixSenderEndPoints.onThrottleReject(libraryId, connectionId, refMsgType, refSeqNum, sequenceNumber, sequenceIndex, businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength);
    }

    @Override
    public ControlledFragmentHandler.Action onThrottleConfiguration(int libraryId, long correlationId, long sessionId, int throttleWindowInMs, int throttleLimitOfMessages) {
        LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (libraryInfo == null) {
            return this.saveThrottleConfReply(libraryId, correlationId, ThrottleConfigurationStatus.UNKNOWN_LIBRARY);
        }
        GatewaySession gatewaySession = libraryInfo.lookupSessionById(sessionId);
        if (gatewaySession == null) {
            return this.saveThrottleConfReply(libraryId, correlationId, ThrottleConfigurationStatus.SESSION_NOT_OWNED);
        }
        if (gatewaySession.isOffline()) {
            return this.saveThrottleConfReply(libraryId, correlationId, ThrottleConfigurationStatus.SESSION_NOT_LOGGED_IN);
        }
        ThrottleConfigurationStatus status = gatewaySession.configureThrottle(throttleWindowInMs, throttleLimitOfMessages) ? ThrottleConfigurationStatus.OK : ThrottleConfigurationStatus.INVALID_DICTIONARY;
        return this.saveThrottleConfReply(libraryId, correlationId, status);
    }

    private ControlledFragmentHandler.Action saveThrottleConfReply(int libraryId, long correlationId, ThrottleConfigurationStatus ok) {
        long position = this.inboundPublication.saveThrottleConfigurationReply(libraryId, correlationId, ok);
        if (Pressure.isBackPressured(position)) {
            this.schedule(() -> this.inboundPublication.saveThrottleConfigurationReply(libraryId, correlationId, ok));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean checkDuplicateILinkConnection(int libraryId, long correlationId, boolean useBackupHost, String accessKeyId, InetSocketAddress address, ILink3Context context) {
        if (useBackupHost && !context.backupConnected() || !useBackupHost && !context.primaryConnected()) {
            return false;
        }
        this.saveError(GatewayError.DUPLICATE_SESSION, libraryId, correlationId, String.format("Duplicate iLink3 Connection for (addr=%s,accessKeyId=%s,%s)", address, accessKeyId, useBackupHost ? "backup" : "primary"));
        return true;
    }

    public void onAllFixSessions(long correlationId) {
        this.schedule(() -> this.allFixSessionsRequest(correlationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long allFixSessionsRequest(long correlationId) {
        LongHashSet seenSessions = this.requestAllSessionSeenSessions;
        try {
            List<SessionInfo> allSessions = this.fixContexts.allSessions();
            int sessionsCount = allSessions.size();
            AllFixSessionsReplyEncoder.SessionsEncoder sessionsEncoder = this.adminReplyPublication.startRequestAllFixSessions(correlationId, sessionsCount);
            this.replyConnectedSessions(seenSessions, sessionsEncoder, this.gatewaySessions.sessions());
            for (LiveLibraryInfo libraryInfo : this.idToLibrary.values()) {
                this.replyConnectedSessions(seenSessions, sessionsEncoder, libraryInfo.gatewaySessions());
            }
            for (SessionInfo sessionInfo : allSessions) {
                if (seenSessions.contains(sessionInfo.sessionId())) continue;
                SessionContext context = (SessionContext)sessionInfo;
                long lastLogonTime = context.lastLogonTimeInNs();
                this.replySession(sessionsEncoder, -1L, "", sessionInfo, lastLogonTime, false);
            }
            long l = this.adminReplyPublication.saveRequestAllFixSessions();
            return l;
        }
        finally {
            seenSessions.clear();
        }
    }

    public void onDisconnectSession(long correlationId, long sessionId) {
        if (!this.fixContexts.isKnownSessionId(sessionId)) {
            this.schedule(() -> this.saveUnknownSessionAdminReply(correlationId, sessionId));
            return;
        }
        if (!this.fixContexts.isAuthenticated(sessionId)) {
            this.schedule(() -> this.saveNotAuthenticatedAdminReply(correlationId, sessionId));
            return;
        }
        GatewaySession gatewaySession = this.gatewaySessions.sessionById(sessionId);
        if (gatewaySession == null) {
            gatewaySession = this.findLibrarySession(sessionId);
        }
        if (gatewaySession == null) {
            this.schedule(() -> this.saveNotAuthenticatedAdminReply(correlationId, sessionId));
            return;
        }
        int libraryId = gatewaySession.libraryId();
        long connectionId = gatewaySession.connectionId();
        this.onDisconnect(libraryId, connectionId, DisconnectReason.ADMIN_API_DISCONNECT);
        this.schedule(() -> this.saveOkAdminReply(correlationId));
    }

    private long saveOkAdminReply(long correlationId) {
        return this.adminReplyPublication.saveGenericAdminReply(correlationId, GatewayError.NULL_VAL, "");
    }

    private long saveUnknownSessionAdminReply(long correlationId, long sessionId) {
        return this.adminReplyPublication.saveGenericAdminReply(correlationId, GatewayError.UNKNOWN_SESSION, sessionId + " is an unknown session");
    }

    private long saveNotAuthenticatedAdminReply(long correlationId, long sessionId) {
        return this.adminReplyPublication.saveGenericAdminReply(correlationId, GatewayError.EXCEPTION, sessionId + " is not currently authenticated");
    }

    private void replyConnectedSessions(LongHashSet seenSessions, AllFixSessionsReplyEncoder.SessionsEncoder sessionsEncoder, List<GatewaySession> gatewaySessions) {
        int gatewaySessionsSize = gatewaySessions.size();
        for (int i = 0; i < gatewaySessionsSize; ++i) {
            FixGatewaySession gatewaySession = (FixGatewaySession)gatewaySessions.get(i);
            long connectionId = gatewaySession.connectionId();
            String address = gatewaySession.address();
            boolean isSlowConsumer = this.fixSenderEndPoints.isSlowConsumer(connectionId);
            this.replySession(sessionsEncoder, connectionId, address, gatewaySession, gatewaySession.lastLogonTime(), isSlowConsumer);
            seenSessions.add(gatewaySession.sessionId());
        }
    }

    private void replySession(AllFixSessionsReplyEncoder.SessionsEncoder sessionsEncoder, long connectionId, String address, SessionInfo sessionInfo, long lastLogonTime, boolean isSlowConsumer) {
        long sessionId = sessionInfo.sessionId();
        CompositeKey sessionKey = sessionInfo.sessionKey();
        if (sessionKey != null) {
            int lastReceivedSequenceNumber = this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
            int lastSentSequenceNumber = this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId);
            sessionsEncoder.next().sessionId(sessionId).connectionId(connectionId).lastReceivedSequenceNumber(lastReceivedSequenceNumber).lastSentSequenceNumber(lastSentSequenceNumber).lastLogonTime(lastLogonTime).sequenceIndex(sessionInfo.sequenceIndex()).slowStatus(isSlowConsumer ? SlowStatus.SLOW : SlowStatus.NOT_SLOW).address(address).localCompId(sessionKey.localCompId()).localSubId(sessionKey.localSubId()).localLocationId(sessionKey.localLocationId()).remoteCompId(sessionKey.remoteCompId()).remoteSubId(sessionKey.remoteSubId()).remoteLocationId(sessionKey.remoteLocationId());
        }
    }

    public void onAdminResetSequenceNumbersRequest(long correlationId, long sessionId) {
        if (!this.fixContexts.isKnownSessionId(sessionId)) {
            this.schedule(() -> this.saveUnknownSessionAdminReply(correlationId, sessionId));
            return;
        }
        ResetSequenceNumberCommand resetSequenceNumberCommand = new ResetSequenceNumberCommand(sessionId, this.gatewaySessions, this.fixContexts, this.receivedSequenceNumberIndex, this.sentSequenceNumberIndex, this.inboundPublication, this.outboundPublication, this.clock.nanoTime());
        resetSequenceNumberCommand.setupAdminReset(correlationId, this.adminReplyPublication);
        this.onResetSequenceNumber(resetSequenceNumberCommand);
    }

    public void startLingering(GatewaySessions.PendingAcceptorLogon pendingAcceptorLogon, long lingerExpiryTimeInMs) {
        long timerId = this.timerWheel.scheduleTimer(lingerExpiryTimeInMs);
        this.timerEventHandler.startLingering(timerId, pendingAcceptorLogon);
        this.receiverEndPoints.receiverEndPointPollingOptional(pendingAcceptorLogon.connectionId(), false);
    }

    void onResetReplayQuery(long fixSessionId) {
        this.inboundMessages.onReset(fixSessionId);
    }

    void onStartReproduction(StartReproduction startReproduction) {
        this.reproductionPoller.start(startReproduction, this.idToLibrary);
        this.schedule(this.reproductionPoller);
    }

    @Override
    public ControlledFragmentHandler.Action onInitiateConnection(int libraryId, int port, String host, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, SequenceNumberType sequenceNumberType, int requestedInitialReceivedSequenceNumber, int requestedInitialSentSequenceNumber, boolean resetSequenceNumber, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, String username, String password, Class<? extends FixDictionary> fixDictionaryClass, int heartbeatIntervalInS, long correlationId, Header header) {
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library == null) {
            return this.saveUnknownLibrary(libraryId, correlationId);
        }
        if (this.acceptsFixP) {
            return this.saveError(GatewayError.INVALID_CONFIGURATION, libraryId, correlationId, new IllegalStateException("Artio configured as a FIXP acceptor, cannot initiate FIX connection in this configuration."));
        }
        boolean logInboundMessages = this.configuration.logInboundMessages();
        boolean logOutboundMessages = this.configuration.logOutboundMessages();
        if (sequenceNumberType == SequenceNumberType.PERSISTENT && !this.configuration.logAllMessages()) {
            return this.badSequenceNumberConfiguration(libraryId, correlationId, logInboundMessages, logOutboundMessages);
        }
        CompositeKey sessionKey = this.sessionIdStrategy.onInitiateLogon(senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId);
        SessionContext sessionContext = this.fixContexts.onLogon(sessionKey, FixDictionary.of(fixDictionaryClass));
        if (this.isUnsafeDuplicateSession(sessionContext, library)) {
            return this.sendDuplicateSessionError(libraryId, correlationId, sessionKey);
        }
        try {
            DebugLogger.log(LogTag.FIX_CONNECTION, this.connectingFormatter, host, (long)port, (long)libraryId);
            InetSocketAddress address = new InetSocketAddress(host, port);
            ConnectingSession connectingSession = new ConnectingSession(address, sessionContext.sessionId());
            library.connectionStartsConnecting(correlationId, connectingSession);
            this.channelSupplier.open(address, (channel, ex) -> {
                if (ex != null) {
                    this.fixContexts.onDisconnect(sessionContext.sessionId());
                    library.connectionFinishesConnecting(correlationId);
                    this.saveError(GatewayError.UNABLE_TO_CONNECT, libraryId, correlationId, ex);
                    return;
                }
                this.onFixConnectionOpen(libraryId, senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId, sequenceNumberType, resetSequenceNumber, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, username, password, fixDictionaryClass, heartbeatIntervalInS, correlationId, header, library, address, channel, sessionContext, sessionKey);
            });
        }
        catch (Exception ex2) {
            this.fixContexts.onDisconnect(sessionContext.sessionId());
            return this.saveError(GatewayError.UNABLE_TO_CONNECT, libraryId, correlationId, ex2);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action sendDuplicateSessionError(int libraryId, long correlationId, CompositeKey sessionKey) {
        long sessionId = this.fixContexts.lookupSessionId(sessionKey);
        int owningLibraryId = this.fixSenderEndPoints.libraryLookup().applyAsInt(sessionId);
        String msg = "Duplicate Session for: " + sessionKey + " Surrogate Key: " + sessionId + " Currently owned by " + owningLibraryId;
        return this.saveError(GatewayError.DUPLICATE_SESSION, libraryId, correlationId, msg);
    }

    private boolean isUnsafeDuplicateSession(SessionContext sessionContext, LiveLibraryInfo library) {
        if (sessionContext == FixContexts.DUPLICATE_SESSION) {
            return true;
        }
        long sessionId = sessionContext.sessionId();
        GatewaySession gatewaySession = library.lookupSessionById(sessionId);
        if (gatewaySession != null && !this.acceptsFixP) {
            return !gatewaySession.isOffline();
        }
        return this.isOwnedSession(sessionId);
    }

    private ControlledFragmentHandler.Action saveUnknownLibrary(int libraryId, long correlationId) {
        return this.saveError(GatewayError.UNKNOWN_LIBRARY, libraryId, correlationId, "Unknown Library");
    }

    @Override
    public ControlledFragmentHandler.Action onMidConnectionDisconnect(int libraryId, long correlationId) {
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library == null) {
            this.saveError(GatewayError.UNKNOWN_LIBRARY, libraryId, correlationId, "");
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        ConnectingSession connectingSession = library.connectionFinishesConnecting(correlationId);
        if (connectingSession == null) {
            if (this.cancelILink3LookupConnectOperation(correlationId, true)) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            this.saveError(GatewayError.UNKNOWN_SESSION, libraryId, correlationId, "Engine doesn't think library is connecting this session");
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        this.fixContexts.onDisconnect(connectingSession.sessionId());
        InetSocketAddress address = connectingSession.address();
        this.stopConnecting(address);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean cancelILink3LookupConnectOperation(long correlationId, boolean requiresStopping) {
        return this.retryManager.removeIf(continuation -> {
            if (continuation instanceof ILink3LookupConnectOperation) {
                ILink3LookupConnectOperation connectOperation = (ILink3LookupConnectOperation)continuation;
                if (connectOperation.correlationId == correlationId) {
                    if (requiresStopping) {
                        this.stopConnecting(connectOperation.address);
                    }
                    return true;
                }
            }
            return false;
        }) > 0;
    }

    private void stopConnecting(InetSocketAddress address) {
        try {
            this.channelSupplier.stopConnecting(address);
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
        }
    }

    private ControlledFragmentHandler.Action badSequenceNumberConfiguration(int libraryId, long correlationId, boolean logInboundMessages, boolean logOutboundMessages) {
        String msg = "You need to enable the logging of inbound and outbound messages on your EngineConfiguration in order to initiate a connection with persistent sequence numbers. logInboundMessages = " + logInboundMessages + " logOutboundMessages = " + logOutboundMessages;
        this.saveError(GatewayError.INVALID_CONFIGURATION, libraryId, correlationId, msg);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void onFixConnectionOpen(int libraryId, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, SequenceNumberType sequenceNumberType, boolean resetSequenceNumber, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, String username, String password, Class<? extends FixDictionary> fixDictionaryClass, int heartbeatIntervalInS, long correlationId, Header outBoundheader, LiveLibraryInfo library, InetSocketAddress address, TcpChannel channel, SessionContext sessionContext, CompositeKey sessionKey) {
        try {
            DebugLogger.log(LogTag.FIX_CONNECTION, this.initiatingSessionFormatter, sessionContext.sessionId(), (long)library.libraryId());
            long connectionId = this.newConnectionId();
            FixDictionary fixDictionary = FixDictionary.of(fixDictionaryClass);
            sessionContext.onLogon(resetSequenceNumber || sequenceNumberType == SequenceNumberType.TRANSIENT, this.clock.nanoTime(), fixDictionary);
            long sessionId = sessionContext.sessionId();
            FixGatewaySession gatewaySession = this.setupFixConnection(channel, connectionId, sessionContext, sessionKey, libraryId, ConnectionType.INITIATOR, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, fixDictionary);
            gatewaySession.libraryId(libraryId);
            gatewaySession.lastSequenceResetTime(sessionContext.lastSequenceResetTime());
            gatewaySession.lastLogonTime(sessionContext.lastLogonTimeInNs());
            library.addSession(gatewaySession);
            this.handoverNewConnectionToLibrary(libraryId, senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, username, password, CancelOnDisconnectOption.DO_NOT_CANCEL_ON_DISCONNECT_OR_LOGOUT, 0L, fixDictionaryClass, heartbeatIntervalInS, correlationId, library, sessionContext, sessionKey, connectionId, sessionId, gatewaySession, outBoundheader.sessionId(), outBoundheader.position(), address.toString(), ConnectionType.INITIATOR);
        }
        catch (Exception e) {
            this.saveError(GatewayError.EXCEPTION, libraryId, correlationId, e);
        }
    }

    private void handoverNewConnectionToLibrary(int libraryId, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, String username, String password, CancelOnDisconnectOption cancelOnDisconnectOption, long cancelOnDisconnectTimeoutWindowInNs, Class<? extends FixDictionary> fixDictionary, int heartbeatIntervalInS, long correlationId, LiveLibraryInfo library, SessionContext sessionContext, CompositeKey sessionKey, long connectionId, long sessionId, FixGatewaySession gatewaySession, int outBoundAeronSessionId, long outBoundRequiredPosition, String address, ConnectionType connectionType) {
        this.schedule(new HandoverNewFixConnectionToLibrary(gatewaySession, outBoundAeronSessionId, outBoundRequiredPosition, sessionId, connectionType, sessionContext, sessionKey, username, password, cancelOnDisconnectOption, cancelOnDisconnectTimeoutWindowInNs, heartbeatIntervalInS, libraryId, connectionId, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, correlationId, senderCompId, senderSubId, senderLocationId, targetCompId, targetSubId, targetLocationId, address, fixDictionary, library));
    }

    ControlledFragmentHandler.Action saveError(GatewayError error, int libraryId, long replyToId, String message) {
        this.schedule(() -> this.inboundPublication.saveError(error, libraryId, replyToId, message));
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action saveError(GatewayError error, int libraryId, long replyToId, Exception e) {
        String message = e.getMessage();
        this.errorHandler.onError((Throwable)e);
        return this.saveError(error, libraryId, replyToId, message == null ? e.getClass().getName() : message);
    }

    @Override
    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, long connectionId, long sessionId, int sequenceIndex, long messageType, long timestamp, MessageStatus status, int sequenceNumber, Header header, int metaDataLength) {
        long now = this.outboundTimer.recordSince(timestamp);
        boolean online = this.fixSenderEndPoints.onMessage(libraryId, connectionId, buffer, offset, length, sequenceNumber, sequenceIndex, messageType, metaDataLength);
        if (!online) {
            this.checkOfflineSequenceReset(sessionId, messageType, sequenceIndex);
        }
        this.sendTimer.recordSince(now);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onValidResendRequest(long session, long connection, long correlationId, Header header) {
        this.fixSenderEndPoints.onValidResendRequest(connection, correlationId);
        this.fixPSenderEndPoints.onValidResendRequest(connection, correlationId);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void checkOfflineSequenceReset(long sessionId, long messageType, int sequenceIndex) {
        SessionContext context;
        int currentSequenceIndex;
        Map.Entry<CompositeKey, SessionContext> entry;
        if ((messageType == 65L || messageType == 52L) && (entry = this.fixContexts.lookupById(sessionId)) != null && sequenceIndex > (currentSequenceIndex = (context = entry.getValue()).sequenceIndex())) {
            context.onSequenceIndex(this.clock.nanoTime(), sequenceIndex);
        }
    }

    @Override
    public ControlledFragmentHandler.Action onFixPMessage(long connectionId, DirectBuffer buffer, int offset) {
        return this.fixPSenderEndPoints.onMessage(connectionId, buffer, offset, false);
    }

    private FixGatewaySession setupFixConnection(TcpChannel channel, long connectionId, SessionContext context, CompositeKey sessionKey, int libraryId, ConnectionType connectionType, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, FixDictionary fixDictionary) {
        FixReceiverEndPoint receiverEndPoint = this.endPointFactory.receiverEndPoint(channel, connectionId, context.sessionId(), context.sequenceIndex(), libraryId, this);
        this.receiverEndPoints.add(receiverEndPoint);
        FixSenderEndPoint senderEndPoint = this.endPointFactory.senderEndPoint(channel, connectionId, libraryId, this, receiverEndPoint);
        this.fixSenderEndPoints.add(senderEndPoint);
        FixGatewaySession gatewaySession = new FixGatewaySession(connectionId, context, channel.remoteAddr(), connectionType, sessionKey, receiverEndPoint, senderEndPoint, this.onSessionLogon, closedResendInterval, resendRequestChunkSize, sendRedundantResendRequests, enableLastMsgSeqNumProcessed, fixDictionary, this.configuration);
        receiverEndPoint.gatewaySession(gatewaySession);
        return gatewaySession;
    }

    @Override
    public ControlledFragmentHandler.Action onRequestDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        return this.onDisconnect(libraryId, connectionId, reason);
    }

    @Override
    public ControlledFragmentHandler.Action onDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        this.receiverEndPoints.removeConnection(connectionId, reason);
        this.fixSenderEndPoints.removeConnection(connectionId);
        this.fixPSenderEndPoints.removeConnection(connectionId);
        this.gatewaySessions.releaseByConnectionId(connectionId);
        this.fixPContexts.onDisconnect(connectionId);
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library != null) {
            if (this.soleLibraryMode) {
                library.offlineSession(connectionId);
            } else {
                library.removeSessionByConnectionId(connectionId);
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onSeqIndexSync(int libraryId, long sessionId, int sequenceIndex) {
        long timeInNs = this.clock.nanoTime();
        this.fixContexts.onSequenceIndex(sessionId, timeInNs, sequenceIndex);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onLibraryConnect(int libraryId, String libraryName, long correlationId, int aeronSessionId) {
        ControlledFragmentHandler.Action action = this.retryManager.retry(correlationId);
        if (action != null) {
            return action;
        }
        if (this.performingDisconnectOperation) {
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        RecordingCoordinator.LibraryExtendPosition extend = this.recordingCoordinator.trackLibrary(aeronSessionId, libraryId);
        if (extend != null) {
            return Pressure.apply(this.inboundPublication.saveLibraryExtendPosition(libraryId, correlationId, extend));
        }
        LiveLibraryInfo existingLibrary = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (existingLibrary != null) {
            existingLibrary.onHeartbeat(this.epochClock.time());
            return this.saveControlNotification(libraryId, existingLibrary.sessions()) ? ControlledFragmentHandler.Action.CONTINUE : ControlledFragmentHandler.Action.ABORT;
        }
        if (this.soleLibraryMode) {
            if (this.idToLibrary.size() >= 1) {
                this.logSoleLibraryError();
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            this.soleLibraryModeBind();
        }
        if (!this.saveControlNotification(libraryId, Collections.emptyList())) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        ArrayList<Continuation> unitsOfWork = new ArrayList<Continuation>();
        unitsOfWork.add(() -> {
            LivenessDetector livenessDetector = LivenessDetector.forEngine(this.inboundPublication, libraryId, this.configuration.replyTimeoutInMs(), this.epochClock.time(), this.clock);
            LiveLibraryInfo library = new LiveLibraryInfo(this.errorHandler, libraryId, libraryName, livenessDetector, aeronSessionId, this.gatewaySessions instanceof FixPGatewaySessions);
            this.idToLibrary.put(libraryId, (Object)library);
            DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, this.libraryConnectedFormatter, (long)libraryId, libraryName);
            return 1L;
        });
        for (GatewaySession gatewaySession : this.gatewaySessions.sessions()) {
            FixGatewaySession fixGatewaySession;
            InternalSession session;
            if (this.acceptsFixP || (session = (fixGatewaySession = (FixGatewaySession)gatewaySession).session()) == null) continue;
            unitsOfWork.add(this.saveManageSession(libraryId, fixGatewaySession));
        }
        return this.retryManager.firstAttempt(correlationId, new UnitOfWork(unitsOfWork));
    }

    private boolean saveControlNotification(int libraryId, List<?> sessions) {
        LongHashSet disconnectedSessions = this.gatewaySessions.findDisconnectedSessions(libraryId);
        if (Pressure.isBackPressured(this.inboundPublication.saveControlNotification(libraryId, this.initialAcceptedSessionOwner, sessions, disconnectedSessions))) {
            return false;
        }
        this.gatewaySessions.removeDisconnectedSessions(disconnectedSessions);
        return true;
    }

    private void soleLibraryModeBind() {
        if (this.shouldBind) {
            try {
                this.channelSupplier.bind();
            }
            catch (IOException e) {
                this.errorHandler.onError((Throwable)e);
            }
        }
    }

    @Override
    public ControlledFragmentHandler.Action onApplicationHeartbeat(int libraryId, int aeronSessionId, int messageTemplateId, long timestampInNs) {
        LiveLibraryInfo library = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (library != null) {
            long timeInMs = this.epochClock.time();
            DebugLogger.log(LogTag.APPLICATION_HEARTBEAT, this.applicationHeartbeatFormatter, (long)messageTemplateId, (long)libraryId, timeInMs, timestampInNs);
            library.onHeartbeat(timeInMs);
            return null;
        }
        if (libraryId == 0) {
            return null;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onReleaseSession(int libraryId, long connectionId, long sessionId, long correlationId, SessionState state, boolean awaitingResend, long heartbeatIntervalInMs, int lastSentSequenceNumber, int lastReceivedSequenceNumber, String username, String password, Header header) {
        LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (libraryInfo == null) {
            return this.saveReleaseSessionReply(correlationId, SessionReplyStatus.UNKNOWN_LIBRARY);
        }
        DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, this.releasingSessionFormatter, sessionId, connectionId, (long)libraryId);
        FixGatewaySession session = (FixGatewaySession)libraryInfo.removeSessionBySessionId(sessionId);
        if (session == null) {
            return this.saveReleaseSessionReply(correlationId, SessionReplyStatus.UNKNOWN_SESSION);
        }
        ControlledFragmentHandler.Action action = Pressure.apply(this.inboundPublication.saveReleaseSessionReply(SessionReplyStatus.OK, correlationId));
        if (action == ControlledFragmentHandler.Action.ABORT) {
            libraryInfo.addSession(session);
        } else if (state != SessionState.DISCONNECTED) {
            ((FixGatewaySessions)this.gatewaySessions).acquire(session, state, awaitingResend, (int)TimeUnit.MILLISECONDS.toSeconds(heartbeatIntervalInMs), lastSentSequenceNumber, lastReceivedSequenceNumber, username, password);
            this.schedule(this.saveManageSession(0, session));
        }
        return action;
    }

    private ControlledFragmentHandler.Action saveReleaseSessionReply(long correlationId, SessionReplyStatus unknownLibrary) {
        long position = this.inboundPublication.saveReleaseSessionReply(unknownLibrary, correlationId);
        if (Pressure.isBackPressured(position)) {
            this.schedule(() -> this.inboundPublication.saveReleaseSessionReply(unknownLibrary, correlationId));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onRequestSession(int libraryId, long sessionId, long correlationId, int replayFromSequenceNumber, int replayFromSequenceIndex) {
        LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (libraryInfo == null) {
            return this.saveRequestSessionReply(libraryId, SessionReplyStatus.UNKNOWN_LIBRARY, correlationId);
        }
        if (sessionId == -1L) {
            return this.saveRequestSessionReply(libraryId, SessionReplyStatus.UNKNOWN_SESSION, correlationId);
        }
        if (this.acceptsFixP) {
            return this.onRequestFixPSession(libraryId, libraryInfo, sessionId, correlationId);
        }
        return this.onRequestFixSession(libraryId, libraryInfo, sessionId, correlationId, replayFromSequenceNumber, replayFromSequenceIndex);
    }

    private ControlledFragmentHandler.Action saveRequestSessionReply(int libraryId, SessionReplyStatus status, long correlationId) {
        GatewayPublication inboundPublication = this.inboundPublication;
        long position = inboundPublication.saveRequestSessionReply(libraryId, status, correlationId);
        if (Pressure.isBackPressured(position)) {
            this.schedule(() -> inboundPublication.saveRequestSessionReply(libraryId, status, correlationId));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action onRequestFixPSession(int libraryId, LiveLibraryInfo libraryInfo, long sessionId, long correlationId) {
        return Pressure.apply(this.onRequestFixPSessionInternal(libraryId, libraryInfo, sessionId, correlationId));
    }

    private long onRequestFixPSessionInternal(int libraryId, LiveLibraryInfo libraryInfo, long sessionId, long correlationId) {
        FixPGatewaySession gatewaySession = (FixPGatewaySession)this.gatewaySessions.releaseBySessionId(sessionId);
        if (gatewaySession == null) {
            if (this.requestOfflineFixPSession(libraryInfo, sessionId, correlationId)) {
                return 1L;
            }
            return this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.UNKNOWN_SESSION, correlationId);
        }
        int currentLibraryId = gatewaySession.libraryId();
        if (currentLibraryId != 0 && currentLibraryId != libraryId) {
            return this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.OTHER_SESSION_OWNER, correlationId);
        }
        gatewaySession.setManagementTo(libraryId);
        libraryInfo.addSession(gatewaySession);
        this.schedule(new OnRequestFixPSessionHandover(correlationId, gatewaySession, libraryInfo, false));
        return 1L;
    }

    private boolean requestOfflineFixPSession(LiveLibraryInfo libraryInfo, long sessionId, long correlationId) {
        InternalFixPContext context = this.fixPContexts.lookupContext(sessionId);
        if (context == null) {
            return false;
        }
        if (this.isOwnedSession(sessionId)) {
            this.saveOtherSessionOwner(libraryInfo, correlationId);
        } else {
            FixPProtocolType protocolType = this.initFixPProtocol();
            int libraryId = libraryInfo.libraryId();
            FixPGatewaySession gatewaySession = new FixPGatewaySession(-1L, sessionId, ":-1", ConnectionType.ACCEPTOR, this.configuration.authenticationTimeoutInMs(), protocolType, this.fixPParser, this.fixPProxy, null, null, (FixPGatewaySessions)this.gatewaySessions);
            byte[] firstMessage = this.fixPProxy.encodeFirstMessage((FixPContext)context);
            gatewaySession.setupOfflineSession(context, firstMessage, libraryId);
            libraryInfo.addSession(gatewaySession);
            this.schedule(new OnRequestFixPSessionHandover(correlationId, gatewaySession, libraryInfo, true));
        }
        return true;
    }

    private ControlledFragmentHandler.Action onRequestFixSession(int libraryId, LiveLibraryInfo libraryInfo, long sessionId, long correlationId, int replayFromSequenceNumber, int replayFromSequenceIndex) {
        FixGatewaySession gatewaySession = (FixGatewaySession)this.gatewaySessions.releaseBySessionId(sessionId);
        if (gatewaySession == null) {
            if (this.requestOfflineFixSession(libraryInfo, sessionId, correlationId, replayFromSequenceIndex, replayFromSequenceNumber)) {
                return ControlledFragmentHandler.Action.CONTINUE;
            }
            return this.saveRequestSessionReply(libraryId, SessionReplyStatus.UNKNOWN_SESSION, correlationId);
        }
        InternalSession session = gatewaySession.session();
        if (session == null || !session.isActive()) {
            return this.saveRequestSessionReply(libraryId, SessionReplyStatus.SESSION_NOT_LOGGED_IN, correlationId);
        }
        this.schedule(new OnRequestFixSessionHandover(correlationId, replayFromSequenceNumber, replayFromSequenceIndex, libraryInfo, gatewaySession));
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private boolean requestOfflineFixSession(LiveLibraryInfo libraryInfo, long sessionId, long correlationId, int replayFromSequenceIndex, int replayFromSequenceNumber) {
        Map.Entry<CompositeKey, SessionContext> entry = this.fixContexts.lookupById(sessionId);
        if (entry == null) {
            return false;
        }
        if (this.isOwnedSession(sessionId)) {
            this.saveOtherSessionOwner(libraryInfo, correlationId);
        } else {
            this.schedule(new HandoverOfflineFixSession(libraryInfo, sessionId, correlationId, replayFromSequenceIndex, replayFromSequenceNumber, entry.getKey(), entry.getValue()));
        }
        return true;
    }

    private void saveOtherSessionOwner(LiveLibraryInfo libraryInfo, long correlationId) {
        this.schedule(() -> this.inboundPublication.saveRequestSessionReply(libraryInfo.libraryId(), SessionReplyStatus.OTHER_SESSION_OWNER, correlationId));
    }

    private boolean isOwnedSession(long sessionId) {
        return this.findLibrarySession(sessionId) != null;
    }

    private GatewaySession findLibrarySession(long sessionId) {
        for (LiveLibraryInfo library : this.idToLibrary.values()) {
            GatewaySession gatewaySession = library.lookupSessionById(sessionId);
            if (gatewaySession == null) continue;
            return gatewaySession;
        }
        return null;
    }

    @Override
    public ControlledFragmentHandler.Action onReplayMessages(int libraryId, long sessionId, long correlationId, int replayFromSequenceNumber, int replayFromSequenceIndex, int replayToSequenceNumber, int replayToSequenceIndex, long latestReplyArrivalTimeInMs) {
        LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (libraryInfo == null) {
            return this.saveReplayMessagesReply(libraryId, correlationId, ReplayMessagesStatus.UNKNOWN_LIBRARY);
        }
        FixGatewaySession gatewaySession = (FixGatewaySession)libraryInfo.lookupSessionById(sessionId);
        if (gatewaySession == null) {
            return this.saveReplayMessagesReply(libraryId, correlationId, ReplayMessagesStatus.SESSION_NOT_OWNED);
        }
        if (!this.configuration.canReplayInbound()) {
            return this.saveReplayMessagesReply(libraryId, correlationId, ReplayMessagesStatus.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES);
        }
        this.schedule(new CatchupReplayer(this.receivedSequenceNumberIndex, this.inboundMessages, this.inboundPublication, this.errorHandler, correlationId, gatewaySession.connectionId(), libraryId, replayToSequenceNumber, replayToSequenceIndex, replayFromSequenceNumber, replayFromSequenceIndex, gatewaySession, latestReplyArrivalTimeInMs, CatchupReplayer.ReplayFor.REPLAY_MESSAGES, this.catchupReplayFormatters, this.configuration.sessionEpochFractionFormat(), this.clock));
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action saveReplayMessagesReply(int libraryId, long correlationId, ReplayMessagesStatus unknownLibrary) {
        long position = this.inboundPublication.saveReplayMessagesReply(libraryId, correlationId, unknownLibrary);
        if (Pressure.isBackPressured(position)) {
            this.schedule(() -> this.inboundPublication.saveReplayMessagesReply(libraryId, correlationId, unknownLibrary));
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onFollowerSessionRequest(int libraryId, long correlationId, FixPProtocolType fixPProtocolType, DirectBuffer srcBuffer, int srcOffset, int srcLength, Header header) {
        if (this.acceptsFixP) {
            if (fixPProtocolType == FixPProtocolType.NULL_VAL || fixPProtocolType != this.configuration.supportedFixPProtocolType()) {
                this.saveError(GatewayError.INVALID_CONFIGURATION, libraryId, correlationId, "Engine is not configured to accept FIXP protocol: " + fixPProtocolType);
            } else {
                this.initFixPProtocol();
                long sessionId = this.fixPParser.sessionId(srcBuffer, srcOffset);
                InternalFixPContext context = this.fixPParser.lookupContext(srcBuffer, srcOffset, srcLength);
                FixPFirstMessageResponse resp = this.fixPContexts.onAcceptorLogon(sessionId, context, -1L, true);
                if (resp == FixPFirstMessageResponse.OK || resp == FixPFirstMessageResponse.NEGOTIATE_DUPLICATE_ID) {
                    this.saveFollowerSessionReply(libraryId, correlationId, sessionId);
                } else if (resp == FixPFirstMessageResponse.NEGOTIATE_DUPLICATE_ID_BAD_VER) {
                    this.saveError(GatewayError.INVALID_CONFIGURATION, libraryId, correlationId, "The session already exists and is currently connected with a different session version, cannot modify session version whilst connected");
                } else {
                    this.saveError(GatewayError.UNABLE_TO_LOGON, libraryId, correlationId, "Failed with error: " + resp);
                }
            }
        } else if (fixPProtocolType != FixPProtocolType.NULL_VAL) {
            this.saveError(GatewayError.INVALID_CONFIGURATION, libraryId, correlationId, "Engine is not configured to accept FIXP, but FIXP (" + fixPProtocolType + ") request made");
        } else {
            this.onFixFollowerSessionRequest(libraryId, correlationId, srcBuffer, srcOffset, srcLength);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void onFixFollowerSessionRequest(int libraryId, long correlationId, DirectBuffer srcBuffer, int srcOffset, int srcLength) {
        CompositeKey compositeKey;
        this.asciiBuffer.wrap(srcBuffer);
        FixDictionary fixDictionary = this.acceptorFixDictionaryLookup.lookup(this.asciiBuffer, srcOffset, srcLength);
        SessionHeaderDecoder acceptorHeaderDecoder = this.acceptorFixDictionaryLookup.lookupHeaderDecoder(fixDictionary);
        acceptorHeaderDecoder.reset();
        acceptorHeaderDecoder.decode(this.asciiBuffer, srcOffset, srcLength);
        try {
            compositeKey = this.sessionIdStrategy.onAcceptLogon(acceptorHeaderDecoder);
        }
        catch (IllegalArgumentException e) {
            this.saveError(GatewayError.EXCEPTION, libraryId, correlationId, e.getMessage());
            return;
        }
        SessionContext sessionContext = this.fixContexts.newSessionContext(compositeKey, fixDictionary);
        long sessionId = sessionContext.sessionId();
        this.saveFollowerSessionReply(libraryId, correlationId, sessionId);
    }

    private void saveFollowerSessionReply(int libraryId, long correlationId, long sessionId) {
        this.schedule(new UnitOfWork(() -> this.inboundPublication.saveFollowerSessionReply(libraryId, correlationId, sessionId), () -> this.outboundPublication.saveFollowerSessionReply(libraryId, correlationId, sessionId)));
    }

    private Continuation saveManageSession(int libraryId, FixGatewaySession gatewaySession) {
        CompositeKey compositeKey = gatewaySession.sessionKey();
        if (compositeKey != null) {
            InternalSession session = gatewaySession.session();
            return this.saveManageSession(libraryId, gatewaySession, SessionStatus.LIBRARY_NOTIFICATION, compositeKey, session, 0L, MetaDataStatus.NULL_VAL, NULL_METADATA);
        }
        return () -> 1L;
    }

    private UnitOfWork saveManageSession(int libraryId, FixGatewaySession gatewaySession, SessionStatus sessionstatus, CompositeKey compositeKey, InternalSession session, long correlationId, MetaDataStatus metaDataStatus, DirectBuffer metaData) {
        return new UnitOfWork(() -> this.saveManageSessionTo(libraryId, gatewaySession, sessionstatus, compositeKey, session, correlationId, metaDataStatus, metaData, this.inboundPublication), () -> this.saveManageSessionTo(libraryId, gatewaySession, sessionstatus, compositeKey, session, correlationId, metaDataStatus, metaData, this.outboundPublication));
    }

    private long saveManageSessionTo(int libraryId, FixGatewaySession gatewaySession, SessionStatus sessionstatus, CompositeKey compositeKey, InternalSession session, long correlationId, MetaDataStatus metaDataStatus, DirectBuffer metaData, GatewayPublication publication) {
        long connectionId = gatewaySession.connectionId();
        int lastSentSeqNum = session.lastSentMsgSeqNum();
        int lastReceivedSeqNum = session.lastReceivedMsgSeqNum();
        return publication.saveManageSession(libraryId, connectionId, gatewaySession.sessionId(), lastSentSeqNum, lastReceivedSeqNum, sessionstatus, gatewaySession.slowStatus(), gatewaySession.connectionType(), session.state(), session.awaitingResend(), gatewaySession.heartbeatIntervalInS(), gatewaySession.closedResendInterval(), gatewaySession.resendRequestChunkSize(), gatewaySession.sendRedundantResendRequests(), gatewaySession.enableLastMsgSeqNumProcessed(), correlationId, gatewaySession.sequenceIndex(), session.lastResentMsgSeqNo(), session.lastResendChunkMsgSeqNum(), session.endOfResendRequestRange(), session.awaitingHeartbeat(), gatewaySession.logonReceivedSequenceNumber(), gatewaySession.logonSequenceIndex(), session.lastLogonTimeInNs(), session.lastSequenceResetTimeInNs(), compositeKey.localCompId(), compositeKey.localSubId(), compositeKey.localLocationId(), compositeKey.remoteCompId(), compositeKey.remoteSubId(), compositeKey.remoteLocationId(), gatewaySession.address(), gatewaySession.username(), gatewaySession.password(), gatewaySession.fixDictionary().getClass(), metaDataStatus, metaData, gatewaySession.cancelOnDisconnectOption(), gatewaySession.cancelOnDisconnectTimeoutWindowInNs());
    }

    private void scheduleCatchupSession(List<Continuation> continuations, int libraryId, long connectionId, long correlationId, int replayFromSequenceNumber, int requestedReplayFromSequenceIndex, FixGatewaySession session, IntSupplier lastReceivedSeqNumSupplier) {
        if (replayFromSequenceNumber != -1) {
            if (!this.configuration.canReplayInbound()) {
                continuations.add(() -> {
                    long position = this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES, correlationId);
                    if (position > 0L) {
                        session.play();
                    }
                    return position;
                });
                return;
            }
            continuations.add(() -> {
                int replayFromSequenceIndex;
                int sequenceIndex = session.sequenceIndex();
                int lastReceivedSeqNum = lastReceivedSeqNumSupplier.getAsInt();
                if (requestedReplayFromSequenceIndex == -2) {
                    replayFromSequenceIndex = sequenceIndex;
                } else {
                    if (requestedReplayFromSequenceIndex > sequenceIndex || requestedReplayFromSequenceIndex == sequenceIndex && replayFromSequenceNumber > lastReceivedSeqNum) {
                        return this.sequenceNumberTooHigh(libraryId, correlationId, session);
                    }
                    replayFromSequenceIndex = requestedReplayFromSequenceIndex;
                }
                this.schedule(new CatchupReplayer(this.receivedSequenceNumberIndex, this.inboundMessages, this.inboundPublication, this.errorHandler, correlationId, connectionId, libraryId, lastReceivedSeqNum, sequenceIndex, replayFromSequenceNumber, replayFromSequenceIndex, session, this.catchupEndTimeInMs(), CatchupReplayer.ReplayFor.REQUEST_SESSION, this.catchupReplayFormatters, this.configuration.sessionEpochFractionFormat(), this.clock));
                return 1L;
            });
        } else {
            continuations.add(() -> CatchupReplayer.sendOk(this.inboundPublication, correlationId, session, libraryId, this.catchupReplayFormatters));
        }
    }

    private long catchupEndTimeInMs() {
        return this.epochClock.time() + this.configuration.replyTimeoutInMs() / 2L;
    }

    private long sequenceNumberTooHigh(int libraryId, long correlationId, FixGatewaySession session) {
        long position = this.inboundPublication.saveRequestSessionReply(libraryId, SessionReplyStatus.SEQUENCE_NUMBER_TOO_HIGH, correlationId);
        if (!Pressure.isBackPressured(position)) {
            session.play();
        }
        return position;
    }

    private void onSessionLogon(final FixGatewaySession gatewaySession) {
        if (!this.soleLibraryMode) {
            this.schedule(new Continuation(){
                private final CompositeKey key;
                private InternalSession session;
                private final Continuation saveManageSession;
                {
                    this.key = gatewaySession.sessionKey();
                    this.session = gatewaySession.session();
                    this.saveManageSession = this.session == null ? null : Framer.this.saveManageSession(0, gatewaySession, SessionStatus.SESSION_HANDOVER, this.key, this.session, 0L, MetaDataStatus.NULL_VAL, NULL_METADATA);
                }

                @Override
                public long attempt() {
                    this.session = gatewaySession.session();
                    if (this.session == null) {
                        return 1L;
                    }
                    return this.saveManageSession.attempt();
                }
            });
        }
    }

    boolean onFixLogonMessageReceived(FixGatewaySession gatewaySession, long sessionId) {
        this.stopCancelOnDisconnect(sessionId);
        if (this.checkOfflineSession(gatewaySession, sessionId)) {
            return true;
        }
        if (!this.soleLibraryMode) {
            ((FixGatewaySessions)this.gatewaySessions).acquire(gatewaySession, SessionState.CONNECTED, false, this.configuration.defaultHeartbeatIntervalInS(), -1, -1, null, null);
        }
        return false;
    }

    private void stopCancelOnDisconnect(long sessionId) {
        this.cancelOnDisconnectFinder.sessionId = sessionId;
        this.retryManager.removeIf(this.cancelOnDisconnectFinder);
    }

    public boolean onFixPLogonMessageReceived(FixPGatewaySession session, long sessionId) {
        this.stopCancelOnDisconnect(sessionId);
        LiveLibraryInfo library = this.lookupOfflineLibrary(session, sessionId);
        if (library == null) {
            return false;
        }
        int libraryId = library.libraryId();
        ControlledFragmentHandler.Action action = this.onRequestFixPSession(libraryId, library, sessionId, 0L);
        if (action != ControlledFragmentHandler.Action.CONTINUE) {
            this.schedule(() -> this.onRequestFixPSessionInternal(libraryId, library, sessionId, 0L));
        }
        return true;
    }

    private boolean checkOfflineSession(GatewaySession gatewaySession, long sessionId) {
        return this.lookupOfflineLibrary(gatewaySession, sessionId) != null;
    }

    private LiveLibraryInfo lookupOfflineLibrary(GatewaySession gatewaySession, long sessionId) {
        for (LiveLibraryInfo library : this.idToLibrary.values()) {
            GatewaySession oldGatewaySession = library.lookupSessionById(sessionId);
            if (oldGatewaySession == null) continue;
            gatewaySession.consumeOfflineSession(oldGatewaySession);
            library.removeSession(gatewaySession);
            return library;
        }
        return null;
    }

    void onGatewaySessionSetup(FixGatewaySession gatewaySession, boolean isOfflineReconnect) {
        if (gatewaySession.connectionType() == ConnectionType.ACCEPTOR) {
            int libraryId;
            LiveLibraryInfo libraryInfo = null;
            if (this.soleLibraryMode) {
                if (this.idToLibrary.size() != 1) {
                    this.logSoleLibraryError();
                }
                libraryInfo = (LiveLibraryInfo)this.idToLibrary.values().iterator().next();
            }
            if (isOfflineReconnect && (libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId = gatewaySession.libraryId())) == null) {
                this.logOfflineSessionLibrary(libraryId);
            }
            if (libraryInfo != null) {
                CompositeKey sessionKey = gatewaySession.sessionKey();
                int libraryAeronSessionId = libraryInfo.aeronSessionId();
                long requiredPosition = this.librarySubscription.imageBySessionId(libraryAeronSessionId).position();
                int libraryId2 = libraryInfo.libraryId();
                gatewaySession.setManagementTo(libraryId2);
                libraryInfo.addSession(gatewaySession);
                this.handoverNewConnectionToLibrary(libraryId2, sessionKey.localCompId(), sessionKey.localSubId(), sessionKey.localLocationId(), sessionKey.remoteCompId(), sessionKey.remoteSubId(), sessionKey.remoteLocationId(), gatewaySession.closedResendInterval(), gatewaySession.resendRequestChunkSize(), gatewaySession.sendRedundantResendRequests(), gatewaySession.enableLastMsgSeqNumProcessed(), gatewaySession.username(), gatewaySession.password(), gatewaySession.cancelOnDisconnectOption(), gatewaySession.cancelOnDisconnectTimeoutWindowInNs(), gatewaySession.fixDictionary().getClass(), gatewaySession.heartbeatIntervalInS(), 0L, libraryInfo, gatewaySession.context(), sessionKey, gatewaySession.connectionId(), gatewaySession.sessionId(), gatewaySession, libraryAeronSessionId, requiredPosition, gatewaySession.address(), ConnectionType.ACCEPTOR);
            }
        }
    }

    private void logOfflineSessionLibrary(int libraryId) {
        this.errorHandler.onError((Throwable)new IllegalStateException("Error, offline session owned by non-existent library: " + libraryId));
    }

    private void logSoleLibraryError() {
        this.errorHandler.onError((Throwable)new IllegalStateException("Error, invalid numbers of libraries: " + this.idToLibrary.size() + " whilst in sole library mode"));
    }

    void onQueryLibraries(QueryLibrariesCommand command) {
        ArrayList<LibraryInfo> libraries = new ArrayList<LibraryInfo>((Collection<LibraryInfo>)this.idToLibrary.values());
        libraries.add(new EngineLibraryInfo(this.gatewaySessions));
        command.success(libraries);
    }

    void onResetSessionIds(File backupLocation, ResetSessionIdsCommand command) {
        Continuation[] continuationArray = new Continuation[4];
        continuationArray[0] = this.inboundPublication::saveResetSessionIds;
        continuationArray[1] = this.outboundPublication::saveResetSessionIds;
        continuationArray[2] = () -> {
            try {
                this.fixContexts.reset(backupLocation);
            }
            catch (Exception ex) {
                command.onError(ex);
            }
            return 1L;
        };
        continuationArray[3] = () -> {
            if (command.hasCompleted()) {
                return 1L;
            }
            if (this.sequenceNumbersNotReset()) {
                return -2L;
            }
            command.success();
            return 1L;
        };
        this.schedule(new UnitOfWork(continuationArray));
    }

    void onStartClose(DisconnectAllCommand disconnectAllCommand) {
        DebugLogger.log(LogTag.CLOSE, "Framer has started close operation");
        this.performingDisconnectOperation = true;
        this.schedule(this.disconnectAllOperation(disconnectAllCommand::success));
    }

    private DisconnectAllOperation disconnectAllOperation(Runnable onSuccess) {
        return new DisconnectAllOperation(this.inboundPublication, new ArrayList<LiveLibraryInfo>((Collection<LiveLibraryInfo>)this.idToLibrary.values()), new ArrayList<GatewaySession>(this.gatewaySessions.sessions()), this.receiverEndPoints, onSuccess);
    }

    void onResetSequenceNumber(ResetSequenceNumberCommand reply) {
        reply.libraryLookup(this.fixSenderEndPoints.libraryLookup());
        if (!reply.poll()) {
            this.replies.add(reply);
        }
    }

    void onLookupSessionId(LookupSessionIdCommand command) {
        CompositeKey compositeKey = this.sessionIdStrategy.onInitiateLogon(command.localCompId, command.localSubId, command.localLocationId, command.remoteCompId, command.remoteSubId, command.remoteLocationId);
        long sessionId = this.fixContexts.lookupSessionId(compositeKey);
        if (sessionId == -1L) {
            command.error(new IllegalArgumentException("Unknown Session: " + compositeKey));
        } else {
            command.complete(sessionId);
        }
    }

    private boolean sequenceNumbersNotReset() {
        return this.sentSequenceNumberIndex.lastKnownSequenceNumber(1L) != -1 || this.receivedSequenceNumberIndex.lastKnownSequenceNumber(1L) != -1;
    }

    @Override
    public ControlledFragmentHandler.Action onWriteMetaData(int libraryId, long sessionId, long correlationId, int metaDataOffset, DirectBuffer srcBuffer, int srcOffset, int srcLength) {
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    @Override
    public ControlledFragmentHandler.Action onReadMetaData(int libraryId, long sessionId, long correlationId) {
        UnsafeBuffer metaDataBuffer = new UnsafeBuffer();
        MetaDataStatus status = this.sentSequenceNumberIndex.readMetaData(sessionId, (DirectBuffer)metaDataBuffer);
        this.schedule(() -> this.lambda$onReadMetaData$31(libraryId, correlationId, status, (DirectBuffer)metaDataBuffer));
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public void onClose() {
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this::quiesce, this.retryManager, this.inboundMessages, this.receiverEndPoints, this.fixSenderEndPoints, this.fixPSenderEndPoints, this.channelSupplier, this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex});
    }

    private void quiesce() {
        Long2LongHashMap inboundPositions = new Long2LongHashMap(-1L);
        inboundPositions.put((long)this.inboundPublication.sessionId(), this.inboundPublication.position());
        this.inboundCompletionPosition.complete(inboundPositions);
        Long2LongHashMap outboundPositions = new Long2LongHashMap(-1L);
        this.idToLibrary.values().forEach(liveLibraryInfo -> {
            int aeronSessionId = liveLibraryInfo.aeronSessionId();
            Image image = this.librarySubscription.imageBySessionId(aeronSessionId);
            if (image != null) {
                long position = image.position();
                outboundPositions.put((long)aeronSessionId, position);
            }
        });
        this.outboundLibraryCompletionPosition.complete(outboundPositions);
        this.recordingCoordinator.completionPositions(inboundPositions, outboundPositions);
    }

    public String roleName() {
        return this.agentNamePrefix + "Framer";
    }

    void schedule(Continuation continuation) {
        this.retryManager.schedule(continuation);
    }

    void slowStatus(int libraryId, long connectionId, boolean hasBecomeSlow) {
        if (hasBecomeSlow) {
            this.resendNotSlowStatus.remove(connectionId);
            this.sendSlowStatus(libraryId, connectionId, this.resendSlowStatus, SlowStatus.SLOW);
        } else {
            this.resendSlowStatus.remove(connectionId);
            this.sendSlowStatus(libraryId, connectionId, this.resendNotSlowStatus, SlowStatus.NOT_SLOW);
        }
    }

    private void sendSlowStatus(int libraryId, long connectionId, Long2LongHashMap toResend, SlowStatus status) {
        long position = this.inboundPublication.saveSlowStatusNotification(libraryId, connectionId, status);
        if (Pressure.isBackPressured(position)) {
            toResend.put(connectionId, (long)libraryId);
        }
    }

    void receiverEndPointPollingOptional(long connectionId) {
        this.receiverEndPoints.receiverEndPointPollingOptional(connectionId, true);
    }

    void receiverEndPointPollingRequired(ReceiverEndPoint receiverEndPoint) {
        this.receiverEndPoints.receiverEndPointPollingRequired(receiverEndPoint.connectionId);
    }

    void onBind(BindCommand bindCommand) {
        if (this.soleLibraryMode && this.idToLibrary.isEmpty()) {
            this.shouldBind = true;
            bindCommand.success();
            return;
        }
        if (this.pendingUnbind != null) {
            bindCommand.onError(new IllegalStateException("Unbind operation is in progress"));
            return;
        }
        try {
            this.performingDisconnectOperation = false;
            this.channelSupplier.bind();
            this.shouldBind = true;
            bindCommand.success();
        }
        catch (Exception e) {
            bindCommand.onError(e);
        }
    }

    void onUnbind(UnbindCommand unbindCommand) {
        if (this.pendingUnbind != null) {
            this.pendingUnbind.addConcurrentUnbind(unbindCommand);
        }
        if (this.soleLibraryMode && this.idToLibrary.isEmpty()) {
            this.shouldBind = false;
            unbindCommand.success();
            return;
        }
        try {
            this.channelSupplier.unbind();
            this.shouldBind = false;
        }
        catch (Exception e) {
            unbindCommand.onError(e);
            return;
        }
        if (unbindCommand.disconnect()) {
            this.pendingUnbind = unbindCommand;
            this.performingDisconnectOperation = true;
            this.schedule(this.disconnectAllOperation(() -> {
                this.pendingUnbind = null;
                unbindCommand.success();
            }));
        } else {
            unbindCommand.success();
        }
    }

    public void onPositionRequest(PositionRequestCommand command) {
        int libraryId = command.libraryId();
        LiveLibraryInfo libraryInfo = (LiveLibraryInfo)this.idToLibrary.get(libraryId);
        if (libraryInfo == null) {
            command.error(new IllegalStateException("Unknown Library: " + libraryId));
            return;
        }
        CounterIdFinder finder = new CounterIdFinder(libraryInfo.aeronSessionId());
        this.countersReader.forEach((CountersReader.MetaData)finder);
        int counterId = finder.counterId;
        if (counterId == -1) {
            command.error(new IllegalStateException("Unable to find counter for: " + libraryId));
            return;
        }
        command.position((ReadablePosition)new UnsafeBufferPosition((UnsafeBuffer)this.countersReader.valuesBuffer(), counterId));
    }

    public void onEngineStreamInfoRequest(EngineStreamInfoRequestCommand command) {
        command.complete(new EngineStreamInfo(this.inboundIndexRegistrationId, this.outboundIndexRegistrationId, this.librarySubscription.registrationId(), this.inboundPublication.sessionId(), this.inboundPublication.position(), this.outboundPublication.sessionId(), this.outboundPublication.position()));
    }

    public void onWriteMetaDataResponse(WriteMetaDataResponse response) {
        this.schedule(() -> this.inboundPublication.saveWriteMetaDataReply(response.libraryId(), response.correlationId(), response.status()));
    }

    public AcceptorFixDictionaryLookup acceptorFixDictionaryLookup() {
        return this.acceptorFixDictionaryLookup;
    }

    private /* synthetic */ long lambda$onReadMetaData$31(int libraryId, long correlationId, MetaDataStatus status, DirectBuffer metaDataBuffer) {
        return this.inboundPublication.saveReadMetaDataReply(libraryId, correlationId, status, metaDataBuffer, 0, metaDataBuffer.capacity());
    }

    static class CancelOnDisconnectFinder
    implements Predicate<Continuation> {
        long sessionId;

        CancelOnDisconnectFinder() {
        }

        @Override
        public boolean test(Continuation continuation) {
            return continuation instanceof CancelOnDisconnectTimeoutOperation && ((CancelOnDisconnectTimeoutOperation)continuation).sessionId() == this.sessionId;
        }
    }

    class FramerReplayProtocolHandler
    implements ReplayProtocolHandler {
        private final boolean slow;

        FramerReplayProtocolHandler(boolean slow) {
            this.slow = slow;
        }

        @Override
        public ControlledFragmentHandler.Action onReplayComplete(long connectionId, long correlationId) {
            ControlledFragmentHandler.Action action = Framer.this.fixSenderEndPoints.onReplayComplete(connectionId, correlationId, this.slow);
            if (action != ControlledFragmentHandler.Action.ABORT && !this.slow) {
                return Framer.this.fixPSenderEndPoints.onReplayComplete(connectionId, correlationId, this.slow);
            }
            return action;
        }

        @Override
        public ControlledFragmentHandler.Action onStartReplay(long session, long connection, long correlationId, long position) {
            Framer.this.fixSenderEndPoints.onStartReplay(connection, correlationId, this.slow);
            return ControlledFragmentHandler.Action.CONTINUE;
        }
    }

    private final class ILink3LookupConnectOperation
    implements Continuation {
        private final int libraryId;
        private final long correlationId;
        private final ILink3Context context;
        private final int aeronSessionId;
        private final long position;
        private final InetSocketAddress address;
        private boolean hasConnected = false;
        private boolean hasScannedIndex = false;
        private long connectionId;
        private long lastReceivedSequenceNumber;
        private long lastSentSequenceNumber;

        private ILink3LookupConnectOperation(int libraryId, long correlationId, ILink3Context context, int aeronSessionId, long position, InetSocketAddress address) {
            this.libraryId = libraryId;
            this.correlationId = correlationId;
            this.context = context;
            this.aeronSessionId = aeronSessionId;
            this.position = position;
            this.address = address;
        }

        @Override
        public long attempt() {
            if (!this.hasScannedIndex) {
                this.scanIndex();
                return -2L;
            }
            if (!this.hasConnected) {
                return -2L;
            }
            return Framer.this.inboundPublication.saveILinkConnect(this.libraryId, this.correlationId, this.connectionId, this.context.connectUuid(), this.lastReceivedSequenceNumber, this.lastSentSequenceNumber, this.context.newlyAllocated(), this.context.connectLastUuid());
        }

        private void scanIndex() {
            if (Framer.this.sentSequenceNumberIndex.indexedPosition(this.aeronSessionId) > this.position) {
                long uuidToScan = this.context.connectLastUuid() == 0L ? this.context.connectUuid() : this.context.connectLastUuid();
                this.lastSentSequenceNumber = Framer.this.sentSequenceNumberIndex.lastKnownSequenceNumber(uuidToScan);
                this.lastReceivedSequenceNumber = Framer.this.receivedSequenceNumberIndex.lastKnownSequenceNumber(uuidToScan);
                this.hasScannedIndex = true;
            }
        }

        public void connected(long connectionId) {
            this.hasConnected = true;
            this.connectionId = connectionId;
        }
    }

    class HandoverNewFixConnectionToLibrary
    extends UnitOfWork {
        private final FixGatewaySession gatewaySession;
        private final int outBoundAeronSessionId;
        private final long outBoundRequiredPosition;
        private final int inboundAeronSessionId;
        private final long inBoundRequiredPosition;
        private final long sessionId;
        private final ConnectionType connectionType;
        private final SessionContext sessionContext;
        private final CompositeKey sessionKey;
        private final String username;
        private final String password;
        private final CancelOnDisconnectOption cancelOnDisconnectOption;
        private final long cancelOnDisconnectTimeoutWindowInNs;
        private final int heartbeatIntervalInS;
        private final int libraryId;
        private final long connectionId;
        private final boolean closedResendInterval;
        private final int resendRequestChunkSize;
        private final boolean sendRedundantResendRequests;
        private final boolean enableLastMsgSeqNumProcessed;
        private final long correlationId;
        private final String senderCompId;
        private final String senderSubId;
        private final String senderLocationId;
        private final String targetCompId;
        private final String targetSubId;
        private final String targetLocationId;
        private final String address;
        private final Class<? extends FixDictionary> fixDictionary;
        private final LiveLibraryInfo library;
        private MetaDataStatus metaDataStatus;
        private DirectBuffer metaDataBuffer;
        private int lastSentSequenceNumber;
        private int lastReceivedSequenceNumber;
        private boolean hasDisconnected;

        HandoverNewFixConnectionToLibrary(FixGatewaySession gatewaySession, int outBoundAeronSessionId, long outBoundRequiredPosition, long sessionId, ConnectionType connectionType, SessionContext sessionContext, CompositeKey sessionKey, String username, String password, CancelOnDisconnectOption cancelOnDisconnectOption, long cancelOnDisconnectTimeoutWindowInNs, int heartbeatIntervalInS, int libraryId, long connectionId, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, long correlationId, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, String address, Class<? extends FixDictionary> fixDictionary, LiveLibraryInfo library) {
            super(new Continuation[0]);
            this.hasDisconnected = false;
            this.gatewaySession = gatewaySession;
            this.outBoundAeronSessionId = outBoundAeronSessionId;
            this.outBoundRequiredPosition = outBoundRequiredPosition;
            this.sessionId = sessionId;
            this.connectionType = connectionType;
            this.sessionContext = sessionContext;
            this.sessionKey = sessionKey;
            this.username = username;
            this.password = password;
            this.cancelOnDisconnectOption = cancelOnDisconnectOption;
            this.cancelOnDisconnectTimeoutWindowInNs = cancelOnDisconnectTimeoutWindowInNs;
            this.heartbeatIntervalInS = heartbeatIntervalInS;
            this.libraryId = libraryId;
            this.connectionId = connectionId;
            this.closedResendInterval = closedResendInterval;
            this.resendRequestChunkSize = resendRequestChunkSize;
            this.sendRedundantResendRequests = sendRedundantResendRequests;
            this.enableLastMsgSeqNumProcessed = enableLastMsgSeqNumProcessed;
            this.correlationId = correlationId;
            this.senderCompId = senderCompId;
            this.senderSubId = senderSubId;
            this.senderLocationId = senderLocationId;
            this.targetCompId = targetCompId;
            this.targetSubId = targetSubId;
            this.targetLocationId = targetLocationId;
            this.address = address;
            this.fixDictionary = fixDictionary;
            this.library = library;
            this.inboundAeronSessionId = Framer.this.inboundPublication.sessionId();
            this.inBoundRequiredPosition = Framer.this.inboundPublication.position();
            if (Framer.this.configuration.logAllMessages()) {
                this.work(this::checkLoggerUpToDate, this::saveManageSessionOutbound, this::saveManageSessionInbound);
            } else {
                this.noMetaData();
                gatewaySession.lastLogonWasSequenceReset();
                this.work(this::onLogon, this::saveManageSessionOutbound, this::saveManageSessionInbound);
            }
        }

        private long checkLoggerUpToDate() {
            if (this.checkDisconnectDuringHandover()) {
                return 1L;
            }
            if (this.gatewaySession.initialResetSeqNum()) {
                this.lastSentSequenceNumber = 0;
                this.lastReceivedSequenceNumber = 0;
                this.noMetaData();
                this.gatewaySession.lastLogonWasSequenceReset();
                return 1L;
            }
            if (Framer.this.sentIndexedPosition(this.outBoundAeronSessionId, this.outBoundRequiredPosition) && Framer.this.receivedIndexedPosition(this.inboundAeronSessionId, this.inBoundRequiredPosition)) {
                this.lastSentSequenceNumber = Framer.this.sentSequenceNumberIndex.lastKnownSequenceNumber(this.sessionId);
                this.lastReceivedSequenceNumber = Framer.this.receivedSequenceNumberIndex.lastKnownSequenceNumber(this.sessionId);
                if (this.connectionType == ConnectionType.ACCEPTOR) {
                    this.lastSentSequenceNumber = FixGatewaySession.adjustLastSequenceNumber(this.lastSentSequenceNumber);
                    this.lastReceivedSequenceNumber = FixGatewaySession.adjustLastSequenceNumber(this.lastReceivedSequenceNumber);
                    if (this.lastReceivedSequenceNumber == 0) {
                        this.gatewaySession.lastLogonWasSequenceReset();
                    } else {
                        this.gatewaySession.lastSequenceResetTime(this.sessionContext.lastSequenceResetTime());
                    }
                }
                this.metaDataBuffer = new UnsafeBuffer();
                this.metaDataStatus = Framer.this.sentSequenceNumberIndex.readMetaData(this.sessionId, this.metaDataBuffer);
                return this.onLogon();
            }
            return -2L;
        }

        private boolean checkDisconnectDuringHandover() {
            if (!this.hasDisconnected) {
                boolean bl = this.hasDisconnected = this.gatewaySession.connectionId() == -1L;
                if (this.hasDisconnected) {
                    this.library.connectionFinishesConnecting(this.correlationId);
                    Framer.this.saveError(GatewayError.UNABLE_TO_CONNECT, this.libraryId, this.correlationId, "Disconnected before session active");
                }
            }
            return this.hasDisconnected;
        }

        private void noMetaData() {
            this.metaDataStatus = MetaDataStatus.NO_META_DATA;
            this.metaDataBuffer = NULL_METADATA;
        }

        private long onLogon() {
            if (this.checkDisconnectDuringHandover()) {
                return 1L;
            }
            this.gatewaySession.onLogon(this.sessionId, this.sessionContext, this.sessionKey, this.username, this.password, this.heartbeatIntervalInS, this.lastReceivedSequenceNumber, this.cancelOnDisconnectOption, this.cancelOnDisconnectTimeoutWindowInNs);
            return 1L;
        }

        private long saveManageSessionOutbound() {
            if (this.checkDisconnectDuringHandover()) {
                return 1L;
            }
            return this.saveManageSession(Framer.this.outboundPublication);
        }

        private long saveManageSessionInbound() {
            if (this.checkDisconnectDuringHandover()) {
                return 1L;
            }
            long position = this.saveManageSession(Framer.this.inboundPublication);
            if (position > 0L) {
                this.library.connectionFinishesConnecting(this.correlationId);
                this.gatewaySession.play();
            }
            return position;
        }

        private long saveManageSession(GatewayPublication publication) {
            return publication.saveManageSession(this.libraryId, this.connectionId, this.sessionId, this.lastSentSequenceNumber, this.lastReceivedSequenceNumber, SessionStatus.SESSION_HANDOVER, SlowStatus.NOT_SLOW, this.connectionType, SessionState.CONNECTED, false, this.heartbeatIntervalInS, this.closedResendInterval, this.resendRequestChunkSize, this.sendRedundantResendRequests, this.enableLastMsgSeqNumProcessed, this.correlationId, this.sessionContext.sequenceIndex(), 0, 0, 0, false, this.gatewaySession.logonReceivedSequenceNumber(), this.gatewaySession.logonSequenceIndex(), this.gatewaySession.lastLogonTime(), this.gatewaySession.lastSequenceResetTime(), this.senderCompId, this.senderSubId, this.senderLocationId, this.targetCompId, this.targetSubId, this.targetLocationId, this.address, this.username, this.password, this.fixDictionary, this.metaDataStatus, this.metaDataBuffer, this.cancelOnDisconnectOption, this.cancelOnDisconnectTimeoutWindowInNs);
        }
    }

    final class OnRequestFixPSessionHandover
    extends SessionHandover {
        private final long correlationId;
        private final FixPGatewaySession gatewaySession;
        private final LiveLibraryInfo libraryInfo;
        private final boolean offline;

        OnRequestFixPSessionHandover(long correlationId, FixPGatewaySession gatewaySession, LiveLibraryInfo libraryInfo, boolean offline) {
            this.correlationId = correlationId;
            this.gatewaySession = gatewaySession;
            this.libraryInfo = libraryInfo;
            this.offline = offline;
            this.workList.add(this::awaitIndexer);
            this.workList.add(this::sendManageConnection);
        }

        private long sendManageConnection() {
            long sessionId = this.gatewaySession.sessionId();
            long lastConnectPayload = this.gatewaySession.hasUnsentMessagesAtNegotiate() ? 1L : 0L;
            return Framer.this.inboundPublication.saveManageFixPConnection(this.libraryInfo.libraryId(), this.correlationId, this.gatewaySession.connectionId(), sessionId, this.gatewaySession.protocolType(), Framer.this.receivedSequenceNumberIndex.lastKnownSequenceNumber(sessionId), Framer.this.sentSequenceNumberIndex.lastKnownSequenceNumber(sessionId), lastConnectPayload, this.gatewaySession.firstMessage(), this.offline);
        }
    }

    final class OnRequestFixSessionHandover
    extends SessionHandover {
        private final int libraryId;
        private final LiveLibraryInfo libraryInfo;
        private final FixGatewaySession gatewaySession;
        private final InternalSession session;
        private final long sessionId;
        private final long connectionId;
        private int lastSentSeqNum;
        private int lastRecvSeqNum;

        OnRequestFixSessionHandover(long correlationId, int replayFromSequenceNumber, int replayFromSequenceIndex, LiveLibraryInfo libraryInfo, FixGatewaySession gatewaySession) {
            this.libraryInfo = libraryInfo;
            this.gatewaySession = gatewaySession;
            this.libraryId = libraryInfo.libraryId();
            this.session = gatewaySession.session();
            this.sessionId = this.session.id();
            this.connectionId = gatewaySession.connectionId();
            UnsafeBuffer buffer = new UnsafeBuffer();
            MetaDataStatus status = Framer.this.sentSequenceNumberIndex.readMetaData(this.session.id(), (DirectBuffer)buffer);
            libraryInfo.addSession(gatewaySession);
            this.add(this::awaitGatewaySessionMessagesSent);
            this.add(() -> this.lambda$new$0(correlationId, status, (DirectBuffer)buffer));
            this.add(this::awaitIndexer);
            this.add(() -> this.lambda$new$1(correlationId, status, (DirectBuffer)buffer));
            Framer.this.scheduleCatchupSession(this.workList, this.libraryId, this.connectionId, correlationId, replayFromSequenceNumber, replayFromSequenceIndex, gatewaySession, () -> this.lastRecvSeqNum);
        }

        private long awaitGatewaySessionMessagesSent() {
            if (Framer.this.outboundEngineImage.position() < this.gatewaySession.lastSentPosition()) {
                return -2L;
            }
            this.gatewaySession.handoverManagementTo(this.libraryId);
            this.lastRecvSeqNum = this.session.lastReceivedMsgSeqNum();
            this.lastSentSeqNum = this.session.lastSentMsgSeqNum();
            DebugLogger.log(LogTag.LIBRARY_MANAGEMENT, Framer.this.handingToLibraryFormatter, this.sessionId, (long)this.libraryId);
            return 1L;
        }

        private long saveManageSessionTo(long correlationId, MetaDataStatus metaDataStatus, DirectBuffer metaData, GatewayPublication publication) {
            CompositeKey compositeKey = this.session.compositeKey();
            long position = publication.saveManageSession(this.libraryId, this.connectionId, this.gatewaySession.sessionId(), this.lastSentSeqNum, this.lastRecvSeqNum, SessionStatus.SESSION_HANDOVER, this.gatewaySession.slowStatus(), this.gatewaySession.connectionType(), this.session.state(), this.session.awaitingResend(), this.gatewaySession.heartbeatIntervalInS(), this.gatewaySession.closedResendInterval(), this.gatewaySession.resendRequestChunkSize(), this.gatewaySession.sendRedundantResendRequests(), this.gatewaySession.enableLastMsgSeqNumProcessed(), correlationId, this.gatewaySession.sequenceIndex(), this.session.lastResentMsgSeqNo(), this.session.lastResendChunkMsgSeqNum(), this.session.endOfResendRequestRange(), this.session.awaitingHeartbeat(), this.gatewaySession.logonReceivedSequenceNumber(), this.gatewaySession.logonSequenceIndex(), this.session.lastLogonTimeInNs(), this.session.lastSequenceResetTimeInNs(), compositeKey.localCompId(), compositeKey.localSubId(), compositeKey.localLocationId(), compositeKey.remoteCompId(), compositeKey.remoteSubId(), compositeKey.remoteLocationId(), this.gatewaySession.address(), this.gatewaySession.username(), this.gatewaySession.password(), this.gatewaySession.fixDictionary().getClass(), metaDataStatus, metaData, this.gatewaySession.cancelOnDisconnectOption(), this.gatewaySession.cancelOnDisconnectTimeoutWindowInNs());
            if (position > 0L) {
                this.requiredPosition = position;
            }
            return position;
        }

        private /* synthetic */ long lambda$new$1(long correlationId, MetaDataStatus status, DirectBuffer buffer) {
            return this.saveManageSessionTo(correlationId, status, buffer, Framer.this.inboundPublication);
        }

        private /* synthetic */ long lambda$new$0(long correlationId, MetaDataStatus status, DirectBuffer buffer) {
            return this.saveManageSessionTo(correlationId, status, buffer, Framer.this.outboundPublication);
        }
    }

    private final class HandoverOfflineFixSession
    extends UnitOfWork {
        private final DirectBuffer metaData;
        private final LiveLibraryInfo libraryInfo;
        private final long sessionId;
        private final long correlationId;
        private final CompositeKey compositeKey;
        private final FixGatewaySession gatewaySession;
        private final int aeronSessionId;
        private final long requiredPosition;
        private MetaDataStatus metaDataStatus;
        private int lastSentSequenceNumber;
        private int lastReceivedSequenceNumber;

        private HandoverOfflineFixSession(LiveLibraryInfo libraryInfo, long sessionId, long correlationId, int replayFromSequenceIndex, int replayFromSequenceNumber, CompositeKey compositeKey, SessionContext sessionContext) {
            super(new ArrayList<Continuation>());
            this.metaData = new UnsafeBuffer();
            this.libraryInfo = libraryInfo;
            this.sessionId = sessionId;
            this.correlationId = correlationId;
            this.compositeKey = compositeKey;
            this.aeronSessionId = Framer.this.outboundPublication.sessionId();
            this.requiredPosition = Framer.this.outboundPublication.position();
            if (Framer.this.configuration.canReplayInbound()) {
                int libraryId = libraryInfo.libraryId();
                this.gatewaySession = new FixGatewaySession(-1L, sessionContext, ":-1", ConnectionType.ACCEPTOR, compositeKey, null, null, null, Framer.this.configuration.acceptedSessionClosedResendInterval(), Framer.this.configuration.acceptedSessionResendRequestChunkSize(), Framer.this.configuration.acceptedSessionSendRedundantResendRequests(), Framer.this.configuration.acceptedEnableLastMsgSeqNumProcessed(), sessionContext.lastFixDictionary(), Framer.this.configuration);
                this.gatewaySession.lastSequenceResetTime(sessionContext.lastSequenceResetTime());
                this.gatewaySession.lastLogonTime(sessionContext.lastLogonTimeInNs());
                this.gatewaySession.libraryId(libraryId);
                libraryInfo.addSession(this.gatewaySession);
                this.workList.add(this::checkLoggerUpToDate);
                this.workList.add(() -> this.saveManageSession(Framer.this.outboundPublication));
                this.workList.add(() -> this.saveManageSession(Framer.this.inboundPublication));
                Framer.this.scheduleCatchupSession(this.workList, libraryId, -1L, correlationId, replayFromSequenceNumber, replayFromSequenceIndex, this.gatewaySession, () -> this.lastReceivedSequenceNumber);
            } else {
                this.gatewaySession = null;
                Framer.this.errorHandler.onError((Throwable)new IllegalStateException("Cannot return an offline session when logging disabled"));
                this.workList.add(() -> Framer.this.inboundPublication.saveRequestSessionReply(libraryInfo.libraryId(), SessionReplyStatus.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES, correlationId));
            }
        }

        private long checkLoggerUpToDate() {
            if (this.requiredPosition != 0L && !Framer.this.sentIndexedPosition(this.aeronSessionId, this.requiredPosition)) {
                return -2L;
            }
            this.lastSentSequenceNumber = FixGatewaySession.adjustLastSequenceNumber(Framer.this.sentSequenceNumberIndex.lastKnownSequenceNumber(this.sessionId));
            this.lastReceivedSequenceNumber = FixGatewaySession.adjustLastSequenceNumber(Framer.this.receivedSequenceNumberIndex.lastKnownSequenceNumber(this.sessionId));
            this.metaDataStatus = Framer.this.sentSequenceNumberIndex.readMetaData(this.sessionId, this.metaData);
            return 1L;
        }

        private long saveManageSession(GatewayPublication inboundPublication) {
            return inboundPublication.saveManageSession(this.libraryInfo.libraryId(), -1L, this.gatewaySession.sessionId(), this.lastSentSequenceNumber, this.lastReceivedSequenceNumber, SessionStatus.SESSION_HANDOVER, SlowStatus.NOT_SLOW, this.gatewaySession.connectionType(), SessionState.DISCONNECTED, false, this.gatewaySession.heartbeatIntervalInS(), this.gatewaySession.closedResendInterval(), this.gatewaySession.resendRequestChunkSize(), this.gatewaySession.sendRedundantResendRequests(), this.gatewaySession.enableLastMsgSeqNumProcessed(), this.correlationId, this.gatewaySession.sequenceIndex(), 0, 0, 0, false, this.gatewaySession.logonReceivedSequenceNumber(), this.gatewaySession.logonSequenceIndex(), this.gatewaySession.lastLogonTime(), this.gatewaySession.lastSequenceResetTime(), this.compositeKey.localCompId(), this.compositeKey.localSubId(), this.compositeKey.localLocationId(), this.compositeKey.remoteCompId(), this.compositeKey.remoteSubId(), this.compositeKey.remoteLocationId(), this.gatewaySession.address(), this.gatewaySession.username(), this.gatewaySession.password(), this.gatewaySession.fixDictionary().getClass(), this.metaDataStatus, this.metaData, this.gatewaySession.cancelOnDisconnectOption(), this.gatewaySession.cancelOnDisconnectTimeoutWindowInNs());
        }
    }

    class CounterIdFinder
    implements CountersReader.MetaData {
        private final String aeronSessionId;
        int counterId = -1;

        CounterIdFinder(int aeronSessionId) {
            this.aeronSessionId = String.valueOf(aeronSessionId);
        }

        public void accept(int counterId, int typeId, DirectBuffer keyBuffer, String label) {
            if (typeId == 4 && Framer.this.countersReader.getCounterRegistrationId(counterId) == Framer.this.outboundIndexRegistrationId && label.contains(this.aeronSessionId)) {
                this.counterId = counterId;
            }
        }
    }

    class SessionHandover
    extends UnitOfWork {
        private final int aeronSessionId;
        long requiredPosition;

        SessionHandover() {
            super(new ArrayList<Continuation>());
            this.aeronSessionId = Framer.this.outboundPublication.sessionId();
            this.requiredPosition = Framer.this.outboundPublication.position();
        }

        long awaitIndexer() {
            if (this.requiredPosition > 0L && Framer.this.configuration.logOutboundMessages()) {
                return Framer.this.sentIndexedPosition(this.aeronSessionId, this.requiredPosition) ? 1L : -2L;
            }
            return 1L;
        }
    }
}

