/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.ControlledFragmentHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.MessageTimingHandler;
import uk.co.real_logic.artio.engine.SenderSequenceNumber;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.FixThrottleRejectBuilder;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.ReproductionLogWriter;
import uk.co.real_logic.artio.engine.framer.SenderEndPoint;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.ThrottleRejectDecoder;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.util.CharFormatter;

class FixSenderEndPoint
extends SenderEndPoint {
    private static final boolean IS_SLOW_CONSUMER_LOG_TAG_ENABLED = DebugLogger.isEnabled(LogTag.SLOW_CONSUMER);
    private static final int ENQ_MSG = 1;
    private static final int ENQ_REPLAY_COMPLETE = 2;
    private static final int ENQ_START_REPLAY = 3;
    static final int ENQ_REPLAY_COMPLETE_LEN = 12;
    static final int ENQ_START_REPLAY_LEN = 12;
    static final int ENQ_MESSAGE_BLOCK_LEN = 16;
    protected static final int NO_REATTEMPT = 0;
    private static final int HEADER_LENGTH = 8;
    static final int START_REPLAY_LENGTH = 32;
    static final int TOTAL_START_REPLAY_LENGTH = 64;
    public static final int THROTTLE_BUSINESS_REJECT_REASON = 99;
    private final long connectionId;
    private final AtomicCounter invalidLibraryAttempts;
    private final long slowConsumerTimeoutInMs;
    private final SenderSequenceNumber senderSequenceNumber;
    private final MessageTimingHandler messageTimingHandler;
    private final FixReceiverEndPoint receiverEndPoint;
    private final Formatters formatters;
    private long sessionId;
    private long sendingTimeoutTimeInMs;
    private FixThrottleRejectBuilder throttleRejectBuilder;
    private FixDictionary fixDictionary;
    private CompositeKey sessionKey;
    private EngineConfiguration configuration;
    private final ReattemptState normalBuffer = new ReattemptState();
    private final ReattemptState replayBuffer = new ReattemptState();
    private boolean replaying;
    private long replayCorrelationId;
    private boolean requiresRetry;
    private int reattemptBytesWritten = 0;

    FixSenderEndPoint(long connectionId, int libraryId, ExclusivePublication inboundPublication, ReproductionLogWriter reproductionPublication, TcpChannel channel, AtomicCounter bytesInBuffer, AtomicCounter invalidLibraryAttempts, ErrorHandler errorHandler, Framer framer, int maxBytesInBuffer, long slowConsumerTimeoutInMs, long timeInMs, SenderSequenceNumber senderSequenceNumber, MessageTimingHandler messageTimingHandler, FixReceiverEndPoint receiverEndPoint, Formatters formatters) {
        super(connectionId, inboundPublication, reproductionPublication, libraryId, channel, bytesInBuffer, maxBytesInBuffer, errorHandler, framer);
        this.connectionId = connectionId;
        this.invalidLibraryAttempts = invalidLibraryAttempts;
        this.slowConsumerTimeoutInMs = slowConsumerTimeoutInMs;
        this.senderSequenceNumber = senderSequenceNumber;
        this.messageTimingHandler = messageTimingHandler;
        this.receiverEndPoint = receiverEndPoint;
        this.formatters = formatters;
        this.sendingTimeoutTimeInMs = timeInMs + slowConsumerTimeoutInMs;
    }

    void onOutboundMessage(int libraryId, DirectBuffer directBuffer, int offset, int bodyLength, int sequenceNumber, int sequenceIndex, long messageType, long timeInMs, int metaDataLength) {
        if (this.isWrongLibraryId(libraryId)) {
            this.invalidLibraryAttempts.increment();
            return;
        }
        this.onMessage(directBuffer, offset, bodyLength, metaDataLength, sequenceNumber, timeInMs, false);
        this.senderSequenceNumber.onNewMessage(sequenceNumber);
        if (messageType == 65L) {
            this.receiverEndPoint.onLogonSent(sequenceIndex);
        }
    }

    public void onThrottleReject(int libraryId, long refMsgType, int refSeqNum, int sequenceNumber, int sequenceIndex, DirectBuffer businessRejectRefIDBuffer, int businessRejectRefIDOffset, int businessRejectRefIDLength, long timeInMs) {
        if (this.isWrongLibraryId(libraryId)) {
            this.invalidLibraryAttempts.increment();
            return;
        }
        FixThrottleRejectBuilder throttleRejectBuilder = this.throttleRejectBuilder();
        if (!throttleRejectBuilder.build(refMsgType, refSeqNum, sequenceNumber, businessRejectRefIDBuffer, businessRejectRefIDOffset, businessRejectRefIDLength, false)) {
            return;
        }
        this.onOutboundMessage(libraryId, (DirectBuffer)throttleRejectBuilder.buffer(), throttleRejectBuilder.offset(), throttleRejectBuilder.length(), sequenceNumber, sequenceIndex, throttleRejectBuilder.messageType(), timeInMs, 0);
    }

    private FixThrottleRejectBuilder throttleRejectBuilder() {
        if (this.throttleRejectBuilder == null) {
            this.throttleRejectBuilder = new FixThrottleRejectBuilder(this.fixDictionary, this.errorHandler, this.sessionId, this.connectionId, new UtcTimestampEncoder(this.configuration.sessionEpochFractionFormat()), this.configuration.epochNanoClock(), this.configuration.throttleWindowInMs(), this.configuration.throttleLimitOfMessages());
            this.configuration.sessionIdStrategy().setupSession(this.sessionKey, this.throttleRejectBuilder.header());
        }
        return this.throttleRejectBuilder;
    }

    boolean configureThrottle(int throttleWindowInMs, int throttleLimitOfMessages) {
        return this.throttleRejectBuilder().configureThrottle(throttleWindowInMs, throttleLimitOfMessages);
    }

    private int throttleRejectLength(int businessRejectRefIDLength) {
        return 40 + ThrottleRejectDecoder.businessRejectRefIDHeaderLength() + businessRejectRefIDLength;
    }

    public void onMessage(DirectBuffer directBuffer, int offset, int bodyLength, int metaDataLength, int seqNum, long timeInMs, boolean replay) {
        try {
            int metaDataOffset = offset - FixMessageDecoder.bodyHeaderLength() - metaDataLength;
            if (this.replaying && !replay || !this.replaying && replay || this.requiresRetry) {
                this.enqueueMessage(directBuffer, offset, bodyLength, metaDataOffset, metaDataLength, seqNum, replay);
                if (this.requiresRetry) {
                    this.reattempt();
                }
                return;
            }
            if (this.checkLastReplayedMessage(seqNum, replay)) {
                this.enqueueMessage(directBuffer, offset, bodyLength, metaDataOffset, metaDataLength, seqNum, replay);
                return;
            }
            int reattemptBytesWritten = this.reattemptBytesWritten;
            int written = this.writeBuffer(directBuffer, offset, bodyLength, seqNum, replay);
            int totalWritten = reattemptBytesWritten + written;
            if (totalWritten < bodyLength) {
                this.reattemptBytesWritten = totalWritten;
                int enqSeqNum = replay ? 0 : seqNum;
                this.enqueueMessage(directBuffer, offset, bodyLength, metaDataOffset, metaDataLength, enqSeqNum, replay);
                this.tryLogBackPressure(seqNum, replay, written);
            } else {
                this.reattemptBytesWritten = 0;
                MessageTimingHandler messageTimingHandler = this.messageTimingHandler;
                if (messageTimingHandler != null && !replay) {
                    messageTimingHandler.onMessage(seqNum, this.connectionId, directBuffer, metaDataOffset, metaDataLength);
                }
                if (reattemptBytesWritten != 0) {
                    this.tryLogBackPressure(seqNum, replay, written);
                }
            }
            this.updateSendingTimeoutTimeInMs(timeInMs, written);
        }
        catch (IOException e) {
            this.errorHandler.onError((Throwable)e);
        }
    }

    private void tryLogBackPressure(int seqNum, boolean replay, int written) {
        ReproductionLogWriter reproductionLogWriter = this.reproductionLogWriter;
        if (reproductionLogWriter != null) {
            reproductionLogWriter.logBackPressure(this.connectionId, seqNum, replay, written);
        }
    }

    private boolean checkLastReplayedMessage(int seqNum, boolean replay) {
        if (replay && seqNum != 0) {
            return super.onReplayComplete(this.replayCorrelationId) == ControlledFragmentHandler.Action.ABORT;
        }
        return false;
    }

    private int writeBuffer(DirectBuffer directBuffer, int offset, int messageSize, int seqNum, boolean replay) throws IOException {
        ByteBuffer buffer = directBuffer.byteBuffer();
        int bufferOffset = directBuffer.wrapAdjustment() + offset;
        int startLimit = buffer.limit();
        int startPosition = buffer.position();
        ByteBufferUtil.limit(buffer, bufferOffset + messageSize);
        int writePosition = this.reattemptBytesWritten + bufferOffset;
        ByteBufferUtil.position(buffer, writePosition);
        int written = this.channel.write(buffer, seqNum, replay);
        DebugLogger.log(LogTag.FIX_MESSAGE_TCP, "Written  ", directBuffer, offset + this.reattemptBytesWritten, written);
        buffer.limit(startLimit).position(startPosition);
        return written;
    }

    private void enqueueMessage(DirectBuffer srcBuffer, int srcOffset, int bodyLength, int metaDataOffset, int metaDataLength, int sequenceNumber, boolean replay) {
        int totalLength = 16 + bodyLength + metaDataLength;
        ReattemptState reattemptState = this.enqueue(totalLength, replay);
        int reattemptOffset = reattemptState.usage - totalLength;
        ExpandableDirectByteBuffer buffer = reattemptState.buffer();
        buffer.putInt(reattemptOffset, 1);
        buffer.putInt(reattemptOffset += 4, sequenceNumber);
        buffer.putInt(reattemptOffset += 4, bodyLength);
        buffer.putBytes(reattemptOffset += 4, srcBuffer, srcOffset, bodyLength);
        buffer.putInt(reattemptOffset += bodyLength, metaDataLength);
        buffer.putBytes(reattemptOffset += 4, srcBuffer, metaDataOffset, metaDataLength);
    }

    private void enqueueReplayComplete(long correlationId) {
        this.enqueueCorrelation(correlationId, 2);
    }

    private void enqueueStartReplay(long correlationId) {
        this.enqueueCorrelation(correlationId, 3);
    }

    private void enqueueCorrelation(long correlationId, int messageType) {
        ReattemptState reattemptState = this.enqueue(12, true);
        int reattemptOffset = reattemptState.usage - 12;
        ExpandableDirectByteBuffer buffer = reattemptState.buffer();
        buffer.putInt(reattemptOffset, messageType);
        buffer.putLong(reattemptOffset += 4, correlationId);
    }

    private ReattemptState enqueue(int length, boolean replay) {
        int bufferUsage;
        boolean currentStream;
        boolean bl = currentStream = replay == this.replaying;
        if (!this.requiresRetry && currentStream) {
            this.requiresRetry(true);
            this.sendSlowStatus(true);
        }
        ReattemptState reattemptState = this.reattemptState(replay);
        reattemptState.usage = bufferUsage = reattemptState.usage + length;
        if (currentStream) {
            if (bufferUsage > this.maxBytesInBuffer) {
                if (IS_SLOW_CONSUMER_LOG_TAG_ENABLED) {
                    DebugLogger.log(LogTag.SLOW_CONSUMER, this.formatters.bufferSlowDisconnect.clear().with(this.connectionId).with(this.sessionId).with(bufferUsage).with(this.maxBytesInBuffer).with(replay));
                }
                this.disconnectEndpoint(DisconnectReason.SLOW_CONSUMER);
            }
            this.bytesInBuffer.setOrdered((long)bufferUsage);
        }
        return reattemptState;
    }

    private ReattemptState reattemptState(boolean replay) {
        return replay ? this.replayBuffer : this.normalBuffer;
    }

    private boolean processReattemptBuffer(boolean replay) {
        ReattemptState reattemptState = this.reattemptState(replay);
        ExpandableDirectByteBuffer buffer = reattemptState.buffer;
        int reattemptBufferUsage = reattemptState.usage;
        if (reattemptBufferUsage == 0) {
            return true;
        }
        int offset = 0;
        while (offset < reattemptBufferUsage) {
            try {
                int enqueueType = buffer.getInt(offset);
                if (enqueueType == 1) {
                    int sequenceNumberOffset = offset + 4;
                    int sequenceNumber = buffer.getInt(sequenceNumberOffset);
                    if (this.checkLastReplayedMessage(sequenceNumber, replay)) {
                        this.reattemptBytesWritten = 0;
                        break;
                    }
                    if (replay) {
                        buffer.putInt(sequenceNumberOffset, 0);
                    }
                    int bodyLengthOffset = sequenceNumberOffset + 4;
                    int bodyLength = buffer.getInt(bodyLengthOffset);
                    int bodyOffset = bodyLengthOffset + 4;
                    int written = this.writeBuffer((DirectBuffer)buffer, bodyOffset, bodyLength, sequenceNumber, replay);
                    int totalWritten = written + this.reattemptBytesWritten;
                    this.tryLogBackPressure(sequenceNumber, replay, written);
                    if (totalWritten < bodyLength) {
                        this.reattemptBytesWritten = totalWritten;
                        break;
                    }
                    offset = this.onProcessMsgComplete(replay, buffer, offset, sequenceNumber, bodyLength, bodyOffset, totalWritten);
                    continue;
                }
                if (enqueueType == 2) {
                    int idOffset = offset + 4;
                    long correlationId = buffer.getLong(idOffset);
                    this.reattemptBytesWritten = 0;
                    int endOfReplayEntry = idOffset + 8;
                    if (buffer.getInt(endOfReplayEntry) == 3) continue;
                    this.replaying(false, correlationId);
                    reattemptState.shuffleWritten(endOfReplayEntry);
                    this.bytesInBuffer.setOrdered((long)this.normalBuffer.usage);
                    return true;
                }
                if (enqueueType == 3) {
                    offset += 12;
                    continue;
                }
                throw new IllegalStateException("enqueueType = " + enqueueType + ", usage = " + reattemptState.usage + ", offset = " + offset + ", replay = " + replay);
            }
            catch (Throwable e) {
                this.onError(e);
                return true;
            }
        }
        int usage = reattemptState.shuffleWritten(offset);
        this.bytesInBuffer.setOrdered((long)usage);
        return usage == 0;
    }

    private int onProcessMsgComplete(boolean replay, ExpandableDirectByteBuffer buffer, int offset, int sequenceNumber, int bodyLength, int bodyOffset, int totalWritten) {
        int metaDataLengthOffset = bodyOffset + bodyLength;
        int metaDataLength = buffer.getInt(metaDataLengthOffset);
        int metaDataOffset = metaDataLengthOffset + 4;
        MessageTimingHandler messageTimingHandler = this.messageTimingHandler;
        if (messageTimingHandler != null && !replay) {
            messageTimingHandler.onMessage(sequenceNumber, this.connectionId, (DirectBuffer)buffer, metaDataOffset, metaDataLength);
        }
        this.reattemptBytesWritten = 0;
        return offset + 16 + totalWritten + metaDataLength;
    }

    public boolean reattempt() {
        return this.reattempt(this.replaying);
    }

    private boolean reattempt(boolean replaying) {
        boolean caughtUp = this.processReattemptBuffer(replaying);
        if (caughtUp && this.requiresRetry) {
            boolean other = !replaying;
            ReattemptState reattemptState = this.reattemptState(other);
            int usage = reattemptState.usage;
            if (usage == 0) {
                this.requiresRetry(false);
                this.sendSlowStatus(false);
            } else {
                this.replaying(!replaying, this.replayCorrelationId);
                this.bytesInBuffer.setOrdered((long)usage);
            }
        }
        return caughtUp;
    }

    ControlledFragmentHandler.Action onReplayMessage(DirectBuffer directBuffer, int offset, int bodyLength, long timeInMs, int sequenceNumber) {
        this.onMessage(directBuffer, offset, bodyLength, 0, sequenceNumber, timeInMs, true);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void updateSendingTimeoutTimeInMs(long timeInMs, int written) {
        if (written > 0) {
            this.sendingTimeoutTimeInMs = timeInMs + this.slowConsumerTimeoutInMs;
        }
    }

    private void onError(Throwable ex) {
        this.errorHandler.onError((Throwable)new Exception(String.format("Exception reported for sessionId=%d,connectionId=%d", this.sessionId, this.connectionId), ex));
        this.disconnectEndpoint(DisconnectReason.EXCEPTION);
    }

    @Override
    public void close() {
        this.senderSequenceNumber.close();
        this.invalidLibraryAttempts.close();
        super.close();
    }

    private boolean isWrongLibraryId(int libraryId) {
        return libraryId != this.libraryId;
    }

    boolean isSlowConsumer() {
        return this.bytesInBufferWeak() > 0L;
    }

    long bytesInBuffer() {
        return this.bytesInBuffer.get();
    }

    private long bytesInBufferWeak() {
        return this.bytesInBuffer.getWeak();
    }

    void sessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    long sessionId() {
        return this.sessionId;
    }

    boolean poll(long timeInMs) {
        this.reattempt();
        if (this.isSlowConsumer() && timeInMs > this.sendingTimeoutTimeInMs) {
            if (IS_SLOW_CONSUMER_LOG_TAG_ENABLED) {
                DebugLogger.log(LogTag.SLOW_CONSUMER, this.formatters.timeoutSlowDisconnect.clear().with(this.connectionId).with(this.sessionId).with(timeInMs).with(this.maxBytesInBuffer).with(this.sendingTimeoutTimeInMs - this.slowConsumerTimeoutInMs));
            }
            this.disconnectEndpoint(DisconnectReason.SLOW_CONSUMER);
            return true;
        }
        return false;
    }

    private void disconnectEndpoint(DisconnectReason reason) {
        this.receiverEndPoint.completeDisconnect(reason);
    }

    @Override
    public ControlledFragmentHandler.Action onReplayComplete(long correlationId) {
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.replayComplete.clear().with(this.connectionId).with(correlationId));
        }
        if (!this.replaying && this.replayCorrelationId != correlationId || !this.reattempt(true)) {
            this.enqueueReplayComplete(correlationId);
        } else {
            this.replaying(false, correlationId);
            this.channel.onReplayComplete(correlationId);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    void fixDictionary(FixDictionary fixDictionary) {
        this.fixDictionary = fixDictionary;
    }

    void onLogon(CompositeKey sessionKey, EngineConfiguration configuration) {
        this.sessionKey = sessionKey;
        this.configuration = configuration;
    }

    public void onValidResendRequest(long correlationId) {
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.validResendRequest.clear().with(this.connectionId).with(correlationId));
        }
    }

    public void onStartReplay(long correlationId) {
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.checkStartReplay.clear().with(this.connectionId).with(correlationId));
        }
        if (this.replaying || this.requiresRetry) {
            this.enqueueStartReplay(correlationId);
        } else {
            this.replaying(true, correlationId);
        }
    }

    private void replaying(boolean replaying, long correlationId) {
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.replaying.clear().with(this.connectionId).with(replaying));
        }
        this.replaying = replaying;
        this.replayCorrelationId = correlationId;
    }

    private void requiresRetry(boolean requiresRetry) {
        if (DebugLogger.IS_REPLAY_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.REPLAY, this.formatters.requiresRetry.clear().with(this.connectionId).with(requiresRetry));
        }
        this.requiresRetry = requiresRetry;
    }

    public String toString() {
        return "FixSenderEndPoint{connectionId=" + this.connectionId + ", sessionId=" + this.sessionId + ", sessionKey=" + this.sessionKey + "} " + super.toString();
    }

    boolean isReplaying() {
        return this.replaying;
    }

    boolean requiresRetry() {
        return this.requiresRetry;
    }

    int reattemptBytesWritten() {
        return this.reattemptBytesWritten;
    }

    @Override
    protected void sendSlowStatus(boolean hasBecomeSlow) {
        if (IS_SLOW_CONSUMER_LOG_TAG_ENABLED) {
            DebugLogger.log(LogTag.SLOW_CONSUMER, this.formatters.becomesSlow.clear().with(this.connectionId).with(hasBecomeSlow));
        }
        super.sendSlowStatus(hasBecomeSlow);
    }

    static class ReattemptState {
        ExpandableDirectByteBuffer buffer;
        int usage;

        ReattemptState() {
        }

        ExpandableDirectByteBuffer buffer() {
            ExpandableDirectByteBuffer buffer = this.buffer;
            if (buffer == null) {
                buffer = this.buffer = new ExpandableDirectByteBuffer();
            }
            buffer.checkLimit(this.usage);
            return buffer;
        }

        int shuffleWritten(int written) {
            int usage = this.usage;
            if (written > 0) {
                this.buffer.putBytes(0, (DirectBuffer)this.buffer, written, usage -= written);
                this.usage = usage;
            }
            return usage;
        }
    }

    static class Formatters {
        final CharFormatter replayComplete = new CharFormatter("SEP.replayComplete, connId=%s, corrId=%s");
        final CharFormatter validResendRequest = new CharFormatter("SEP.validResendRequest, connId=%s, corrId=%s");
        final CharFormatter checkStartReplay = new CharFormatter("SEP.onStartReplay, connId=%s, corrId=%s");
        final CharFormatter replaying = new CharFormatter("SEP.replaying, connId=%s, replay=%s");
        final CharFormatter requiresRetry = new CharFormatter("SEP.requiresRetry, connId=%s, retry=%s");
        final CharFormatter becomesSlow = new CharFormatter("SEP.becomesSlow, connId=%s, becomeSlow=%s");
        final CharFormatter bufferSlowDisconnect = new CharFormatter("SEP.bufferSlowDisconnect, conn=%s,sess=%s,bufferUsage=%s,maxBytesInBuffer=%s,replay=%s");
        final CharFormatter timeoutSlowDisconnect = new CharFormatter("SEP.timeoutSlowDisconnect, conn=%s,sess=%s,time=%s,maxBytesInBuffer=%s,noWriteSince=%s");

        Formatters() {
        }
    }
}

