/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.zip.CRC32;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.ByteBufferUtil;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.SectorFramer;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.SessionContexts;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.storage.messages.SessionIdDecoder;
import uk.co.real_logic.artio.storage.messages.SessionIdEncoder;

public class FixContexts
implements SessionContexts {
    static final SessionContext DUPLICATE_SESSION = new SessionContext(null, -3L, -3, -1L, -1L, null, -1, 0, null, false);
    static final SessionContext UNKNOWN_SESSION = new SessionContext(null, -1L, 0, -1L, -1L, null, -1, 0, null, false);
    static final long LOWEST_VALID_SESSION_ID = 1L;
    static final int VERSION_WITHOUT_FIX_DICTIONARY = 2;
    private static final int HEADER_SIZE = 8;
    private static final int ENCODING_BUFFER_SIZE = 4092;
    private final UnsafeBuffer compositeKeyBuffer = new UnsafeBuffer(new byte[4092]);
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final SessionIdEncoder sessionIdEncoder = new SessionIdEncoder();
    private final SessionIdDecoder sessionIdDecoder = new SessionIdDecoder();
    private final int actingBlockLength = this.sessionIdEncoder.sbeBlockLength();
    private final int actingVersion = this.sessionIdEncoder.sbeSchemaVersion();
    private final LongHashSet currentlyAuthenticatedSessionIds = new LongHashSet();
    private final CopyOnWriteArrayList<SessionInfo> allSessions = new CopyOnWriteArrayList();
    private final Map<CompositeKey, SessionContext> compositeToContext = new HashMap<CompositeKey, SessionContext>();
    private final CRC32 crc32 = new CRC32();
    private final SectorFramer sectorFramer;
    private final ByteBuffer byteBuffer;
    private final AtomicBuffer buffer;
    private final boolean reproductionEnabled;
    private final SessionIdStrategy idStrategy;
    private final ErrorHandler errorHandler;
    private final MappedFile mappedFile;
    private final int initialSequenceIndex;
    private int filePosition;
    private long counter = 1L;

    public FixContexts(MappedFile mappedFile, SessionIdStrategy idStrategy, int initialSequenceIndex, ErrorHandler errorHandler, boolean reproductionEnabled) {
        this.mappedFile = mappedFile;
        this.buffer = mappedFile.buffer();
        this.reproductionEnabled = reproductionEnabled;
        this.byteBuffer = this.buffer.byteBuffer();
        this.sectorFramer = new SectorFramer(this.buffer.capacity());
        this.idStrategy = idStrategy;
        this.initialSequenceIndex = initialSequenceIndex;
        this.errorHandler = errorHandler;
        this.loadBuffer();
        this.allSessions.addAll(this.compositeToContext.values());
    }

    private void loadBuffer() {
        this.checkByteBuffer();
        this.initialiseBuffer();
        this.headerDecoder.wrap((DirectBuffer)this.buffer, 0);
        boolean needsUpgrading = this.headerDecoder.version() <= 2;
        FixDictionary dictionary = needsUpgrading ? FixDictionary.of((Class)FixDictionary.findDefault()) : null;
        boolean requiresCompaction = this.readFileSessionInfos(dictionary);
        if (needsUpgrading || requiresCompaction) {
            this.resetBuffer();
            this.compositeToContext.values().forEach(this::allocateNewSlot);
        }
    }

    private boolean readFileSessionInfos(FixDictionary dictionary) {
        boolean requiresCompaction = false;
        int sectorEnd = 0;
        this.filePosition = 8;
        int lastRecordStart = this.buffer.capacity() - 32;
        while (this.filePosition < lastRecordStart) {
            sectorEnd = this.validateSectorChecksum(this.filePosition, sectorEnd);
            long sessionId = this.wrap(this.sessionIdDecoder, this.filePosition);
            int startOfNextChecksum = sectorEnd - 4;
            int endOfSessionId = this.filePosition + SessionIdDecoder.sessionIdEncodingLength();
            if (sessionId == 0L || startOfNextChecksum < endOfSessionId && this.filePosition != sectorEnd) {
                int nextSectorPeekPosition = sectorEnd;
                if (nextSectorPeekPosition > lastRecordStart) {
                    return requiresCompaction;
                }
                sessionId = this.wrap(this.sessionIdDecoder, nextSectorPeekPosition);
                if (sessionId == 0L) {
                    return requiresCompaction;
                }
                this.filePosition = nextSectorPeekPosition;
                continue;
            }
            if (sessionId == -1L) {
                int compositeKeyLength = this.sessionIdDecoder.compositeKeyLength();
                this.sessionIdDecoder.skipLastFixDictionary();
                this.filePosition = this.sessionIdDecoder.limit() + compositeKeyLength;
                requiresCompaction = true;
                continue;
            }
            int sequenceIndex = this.sessionIdDecoder.sequenceIndex();
            long lastLogonTime = this.sessionIdDecoder.logonTime();
            long lastSequenceResetTime = this.sessionIdDecoder.lastSequenceResetTime();
            int compositeKeyLength = this.sessionIdDecoder.compositeKeyLength();
            String lastFixDictionary = this.sessionIdDecoder.lastFixDictionary();
            this.filePosition = this.sessionIdDecoder.limit();
            CompositeKey compositeKey = this.idStrategy.load((DirectBuffer)this.buffer, this.filePosition, compositeKeyLength);
            if (compositeKey == null) {
                return requiresCompaction;
            }
            try {
                FixDictionary thisDictionary = dictionary == null ? FixDictionary.of((Class)FixDictionary.find((String)lastFixDictionary)) : dictionary;
                SessionContext sessionContext = new SessionContext(compositeKey, sessionId, sequenceIndex, lastLogonTime, lastSequenceResetTime, this, this.sessionIdDecoder.offset(), this.initialSequenceIndex, thisDictionary, this.reproductionEnabled);
                this.compositeToContext.put(compositeKey, sessionContext);
            }
            catch (Exception e) {
                this.errorHandler.onError((Throwable)e);
            }
            this.counter = Math.max(this.counter, sessionId + 1L);
            this.filePosition += compositeKeyLength;
        }
        return requiresCompaction;
    }

    private long wrap(SessionIdDecoder sessionIdDecoder, int nextSectorPeekPosition) {
        sessionIdDecoder.wrap((DirectBuffer)this.buffer, nextSectorPeekPosition, this.headerDecoder.blockLength(), this.headerDecoder.version());
        return sessionIdDecoder.sessionId();
    }

    private void checkByteBuffer() {
        if (this.byteBuffer == null) {
            throw new IllegalStateException("Must use atomic buffer backed by a byte buffer");
        }
    }

    private void initialiseBuffer() {
        if (LoggerUtil.initialiseBuffer(this.buffer, this.headerEncoder, this.headerDecoder, this.sessionIdEncoder.sbeSchemaId(), this.sessionIdEncoder.sbeTemplateId(), this.actingVersion, this.actingBlockLength, this.errorHandler)) {
            this.updateChecksum(0, 4092);
            this.mappedFile.force();
        }
    }

    private int validateSectorChecksum(int position, int sectorEnd) {
        if (position > sectorEnd) {
            int nextSectorEnd = sectorEnd + 4096;
            int nextChecksum = nextSectorEnd - 4;
            this.crc32.reset();
            this.byteBuffer.clear();
            ByteBufferUtil.position(this.byteBuffer, sectorEnd);
            ByteBufferUtil.limit(this.byteBuffer, nextChecksum);
            this.crc32.update(this.byteBuffer);
            int calculatedChecksum = (int)this.crc32.getValue();
            int savedChecksum = this.buffer.getInt(nextChecksum);
            SectorFramer.validateCheckSum("session ids", sectorEnd, nextSectorEnd, savedChecksum, calculatedChecksum, this.errorHandler);
            return nextSectorEnd;
        }
        return sectorEnd;
    }

    public SessionContext onLogon(CompositeKey compositeKey, FixDictionary fixDictionary) {
        SessionContext sessionContext = this.newSessionContext(compositeKey, fixDictionary);
        if (!this.currentlyAuthenticatedSessionIds.add(sessionContext.sessionId())) {
            return DUPLICATE_SESSION;
        }
        return sessionContext;
    }

    SessionContext newSessionContext(CompositeKey compositeKey, FixDictionary fixDictionary) {
        SessionContext context = this.compositeToContext.computeIfAbsent(compositeKey, key -> this.onNewLogon((CompositeKey)key, fixDictionary));
        if (context.lastFixDictionary() != fixDictionary) {
            context.ensureFixDictionary(fixDictionary);
        }
        return context;
    }

    private SessionContext onNewLogon(CompositeKey compositeKey, FixDictionary fixDictionary) {
        long sessionId = this.counter++;
        SessionContext sessionContext = this.assignSessionId(compositeKey, sessionId, -1, fixDictionary);
        this.allSessions.add(sessionContext);
        return sessionContext;
    }

    private SessionContext assignSessionId(CompositeKey compositeKey, long sessionId, int sequenceIndex, FixDictionary fixDictionary) {
        SessionContext context = new SessionContext(compositeKey, sessionId, sequenceIndex, -1L, -1L, this, 0, this.initialSequenceIndex, fixDictionary, this.reproductionEnabled);
        this.allocateNewSlot(context);
        return context;
    }

    private void allocateNewSlot(SessionContext context) {
        CompositeKey compositeKey = context.sessionKey();
        long sessionId = context.sessionId();
        int sequenceIndex = context.sequenceIndex();
        FixDictionary fixDictionary = context.lastFixDictionary();
        String fixDictionaryName = this.nameOf(fixDictionary);
        int keyPosition = -1;
        int compositeKeyLength = this.idStrategy.save(compositeKey, (MutableDirectBuffer)this.compositeKeyBuffer, 0);
        if (compositeKeyLength == -1) {
            this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to save record session id %d for %s, because the buffer is too small", sessionId, compositeKey)));
            context.filePosition(-1);
        } else if (this.filePosition != -1) {
            int length = 32 + SessionIdEncoder.lastFixDictionaryHeaderLength() + fixDictionaryName.length() + compositeKeyLength;
            keyPosition = this.filePosition = this.sectorFramer.claim(this.filePosition, length);
            if (this.filePosition == -1) {
                this.errorHandler.onError((Throwable)new IllegalStateException("Run out of space when storing: " + compositeKey));
            } else {
                this.sessionIdEncoder.wrap((MutableDirectBuffer)this.buffer, this.filePosition).sessionId(sessionId).sequenceIndex(sequenceIndex).logonTime(context.lastLogonTimeInNs()).lastSequenceResetTime(context.lastSequenceResetTime()).compositeKeyLength(compositeKeyLength).lastFixDictionary(fixDictionaryName);
                this.filePosition = this.sessionIdEncoder.limit();
                this.buffer.putBytes(this.filePosition, (DirectBuffer)this.compositeKeyBuffer, 0, compositeKeyLength);
                this.filePosition += compositeKeyLength;
                this.updateChecksum(this.sectorFramer.sectorStart(), this.sectorFramer.checksumOffset());
                this.mappedFile.force();
            }
        }
        context.filePosition(keyPosition);
    }

    private String nameOf(FixDictionary fixDictionary) {
        return fixDictionary.getClass().getName();
    }

    @Override
    public void sequenceReset(long sessionId, long resetTimeInNs) {
        Map.Entry<CompositeKey, SessionContext> entry = this.lookupById(sessionId);
        if (entry != null) {
            SessionContext context = entry.getValue();
            context.onSequenceReset(resetTimeInNs);
        }
    }

    public void onSequenceIndex(long sessionId, long resetTimeInNs, int sequenceIndex) {
        Map.Entry<CompositeKey, SessionContext> entry = this.lookupById(sessionId);
        if (entry != null) {
            SessionContext context = entry.getValue();
            context.onSequenceIndex(resetTimeInNs, sequenceIndex);
        }
    }

    Map.Entry<CompositeKey, SessionContext> lookupById(long sessionId) {
        for (Map.Entry<CompositeKey, SessionContext> entry : this.compositeToContext.entrySet()) {
            if (entry.getValue().sessionId() != sessionId) continue;
            return entry;
        }
        return null;
    }

    private void updateChecksum(int start, int checksumOffset) {
        int endOfData = checksumOffset;
        this.byteBuffer.clear();
        ByteBufferUtil.position(this.byteBuffer, start);
        ByteBufferUtil.limit(this.byteBuffer, endOfData);
        this.crc32.reset();
        this.crc32.update(this.byteBuffer);
        int checksumValue = (int)this.crc32.getValue();
        this.buffer.putInt(checksumOffset, checksumValue);
    }

    public void onDisconnect(long sessionId) {
        this.currentlyAuthenticatedSessionIds.remove(sessionId);
    }

    public void reset(File backupLocation) {
        if (!this.currentlyAuthenticatedSessionIds.isEmpty()) {
            throw new IllegalStateException("There are currently authenticated sessions: " + this.currentlyAuthenticatedSessionIds);
        }
        this.counter = 1L;
        this.compositeToContext.clear();
        this.allSessions.clear();
        if (backupLocation != null) {
            this.mappedFile.transferTo(backupLocation);
        }
        this.resetBuffer();
    }

    private void resetBuffer() {
        this.buffer.setMemory(0, this.buffer.capacity(), (byte)0);
        this.initialiseBuffer();
        this.filePosition = 8;
    }

    void updateSavedData(SessionContext context, int filePosition) {
        String fixDictionaryName = this.nameOf(context.lastFixDictionary());
        this.sessionIdDecoder.wrap((DirectBuffer)this.buffer, filePosition, this.actingBlockLength, this.actingVersion);
        this.sessionIdEncoder.wrap((MutableDirectBuffer)this.buffer, filePosition);
        if (this.sessionIdDecoder.lastFixDictionaryLength() != fixDictionaryName.length()) {
            this.sessionIdEncoder.sessionId(-1L);
            this.allocateNewSlot(context);
            if (SectorFramer.nextSectorStart(filePosition) != SectorFramer.nextSectorStart(this.filePosition)) {
                this.updateSectorChecksum(filePosition);
            }
        } else {
            this.sessionIdEncoder.sequenceIndex(context.sequenceIndex()).logonTime(context.lastLogonTimeInNs()).lastSequenceResetTime(context.lastSequenceResetTime());
            this.updateSectorChecksum(filePosition);
        }
    }

    private void updateSectorChecksum(int filePosition) {
        int start = SectorFramer.nextSectorStart(filePosition) - 4096;
        int checksumOffset = start + 4092;
        this.updateChecksum(start, checksumOffset);
        this.mappedFile.force();
    }

    long lookupSessionId(CompositeKey compositeKey) {
        SessionContext sessionContext = this.compositeToContext.get(compositeKey);
        if (sessionContext == null) {
            return -1L;
        }
        return sessionContext.sessionId();
    }

    @Override
    public boolean isAuthenticated(long sessionId) {
        return this.currentlyAuthenticatedSessionIds.contains(sessionId);
    }

    @Override
    public boolean isKnownSessionId(long sessionId) {
        return this.lookupById(sessionId) != null;
    }

    public List<SessionInfo> allSessions() {
        return this.allSessions;
    }

    int filePosition() {
        return this.filePosition;
    }
}

