/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.HashMap;
import java.util.Map;
import uk.co.real_logic.artio.decoder.AbstractSequenceResetDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.util.AsciiBuffer;

class AcceptorFixDictionaryLookup {
    private static final int BEGIN_STRING_OFFSET = "8=".length();
    private final FixDictionary defaultfixDictionary;
    private final Map<String, FixDictionary> fixVersionToDictionaryOverride;
    private final Map<FixDictionary, CachedDecoders> dictionaryToDecoders;

    AcceptorFixDictionaryLookup(FixDictionary defaultfixDictionary, Map<String, FixDictionary> fixVersionToDictionaryOverride) {
        this.defaultfixDictionary = defaultfixDictionary;
        this.fixVersionToDictionaryOverride = fixVersionToDictionaryOverride;
        this.dictionaryToDecoders = new HashMap<FixDictionary, CachedDecoders>();
    }

    FixDictionary lookup(AsciiBuffer buffer, int offset, int length) {
        int beginStringOffset = offset + BEGIN_STRING_OFFSET;
        int messageEnd = offset + length;
        int beginStringEnd = buffer.scan(beginStringOffset, messageEnd, (byte)1);
        if (beginStringEnd == -1) {
            return this.defaultfixDictionary;
        }
        String beginString = buffer.getAscii(beginStringOffset, beginStringEnd - beginStringOffset);
        return this.fixVersionToDictionaryOverride.getOrDefault(beginString, this.defaultfixDictionary);
    }

    SessionHeaderDecoder lookupHeaderDecoder(FixDictionary dictionary) {
        return this.lookupCachedDecoders((FixDictionary)dictionary).sessionHeaderDecoder;
    }

    AbstractSequenceResetDecoder lookupSequenceResetDecoder(FixDictionary dictionary) {
        return this.lookupCachedDecoders((FixDictionary)dictionary).sequenceResetDecoder;
    }

    private CachedDecoders lookupCachedDecoders(FixDictionary dictionary) {
        return this.dictionaryToDecoders.computeIfAbsent(dictionary, CachedDecoders::new);
    }

    private static final class CachedDecoders {
        private final SessionHeaderDecoder sessionHeaderDecoder;
        private final AbstractSequenceResetDecoder sequenceResetDecoder;

        private CachedDecoders(FixDictionary dictionary) {
            this.sessionHeaderDecoder = dictionary.makeHeaderDecoder();
            this.sequenceResetDecoder = dictionary.makeSequenceResetDecoder();
        }
    }
}

