/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import io.aeron.archive.client.AeronArchive;
import java.io.File;
import org.agrona.CloseHelper;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.RecordingCoordinator;

class ResetArchiveState {
    private final File backupLocation;
    private final RecordingCoordinator recordingCoordinator;
    private final EngineConfiguration configuration;
    private AeronArchive archive;
    private Aeron aeron;

    ResetArchiveState(EngineConfiguration configuration, File backupLocation, RecordingCoordinator recordingCoordinator) {
        this.configuration = configuration;
        this.backupLocation = backupLocation;
        this.recordingCoordinator = recordingCoordinator;
    }

    void resetState() {
        if (this.configuration.logAnyMessages()) {
            this.createArchiver();
            try {
                this.truncateArchive();
                this.backupState();
            }
            finally {
                CloseHelper.close((AutoCloseable)this.archive);
                CloseHelper.close((AutoCloseable)this.aeron);
            }
        }
    }

    private void truncateArchive() {
        this.recordingCoordinator.forEachRecording((libraryId, recordingId) -> {
            long startPosition = this.archive.getStartPosition(recordingId);
            if (this.archive.getStopPosition(recordingId) != -1L) {
                boolean tryStop = this.archive.tryStopRecordingByIdentity(recordingId);
                if (DebugLogger.isEnabled(LogTag.ARCHIVE_SCAN)) {
                    DebugLogger.log(LogTag.ARCHIVE_SCAN, "Recording " + recordingId + " not stopped, stopping " + (tryStop ? "succeeded" : "failed"));
                }
            }
            this.archive.truncateRecording(recordingId, startPosition);
        });
    }

    private void createArchiver() {
        this.aeron = Aeron.connect((Aeron.Context)this.configuration.aeronContextClone());
        AeronArchive.Context archiveContext = this.configuration.archiveContextClone();
        this.archive = AeronArchive.connect((AeronArchive.Context)archiveContext.aeron(this.aeron));
    }

    private void backupState() {
        if (this.backupLocation != null) {
            File backupDir = this.backupLocation.getAbsoluteFile();
            if (this.backupLocation.exists()) {
                if (!this.backupLocation.isDirectory()) {
                    throw new IllegalStateException(backupDir + " is not a directory, so backup cannot proceed");
                }
            } else if (!this.backupLocation.mkdirs()) {
                throw new IllegalStateException(backupDir + " could not be created, so backup cannot proceed");
            }
            File logFileDir = new File(this.configuration.logFileDir());
            for (File file : logFileDir.listFiles()) {
                if (file.renameTo(new File(backupDir, file.getName()))) continue;
                throw new IllegalStateException("Unable to move " + file.getAbsolutePath() + " to " + backupDir);
            }
        }
    }
}

