/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import io.aeron.Aeron;
import io.aeron.Counter;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.exceptions.TimeoutException;
import io.aeron.logbuffer.FragmentHandler;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.agrona.CloseHelper;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.admin.AdminApiProtocolSubscription;
import uk.co.real_logic.artio.admin.AdminEndPointHandler;
import uk.co.real_logic.artio.admin.AdminPublication;
import uk.co.real_logic.artio.admin.ArtioAdminConfiguration;
import uk.co.real_logic.artio.admin.FixAdminSession;

public final class ArtioAdmin
implements AutoCloseable {
    private static final int MAX_CLAIM_ATTEMPTS = 10000;
    private static final int FRAGMENT_LIMIT = 10;
    private final Lock lock = new ReentrantLock();
    private final AdminEndPointHandler handler = new AdminEndPointHandler();
    private final AdminApiProtocolSubscription protocolSubscription = new AdminApiProtocolSubscription(this.handler);
    private final AdminPublication outboundPublication;
    private final Subscription inboundSubscription;
    private final Aeron aeron;
    private final IdleStrategy idleStrategy;
    private final EpochNanoClock epochNanoClock;
    private final Counter failCounter;
    private final long replyTimeoutInNs;
    private final BooleanSupplier checkReplyFunc = this::checkReply;
    private final BooleanSupplier saveRequestAllFixSessionsFunc = this::saveRequestAllFixSessionsFunc;
    private final Supplier<List<FixAdminSession>> allFixSessionsResultFunc = this.handler::allFixSessions;
    private volatile boolean closed = false;
    private long correlationId;

    public static ArtioAdmin launch(ArtioAdminConfiguration config) {
        return new ArtioAdmin(config);
    }

    public List<FixAdminSession> allFixSessions() {
        return this.exchangeMessage(this.saveRequestAllFixSessionsFunc, this.allFixSessionsResultFunc);
    }

    public void disconnectSession(long sessionId) {
        this.exchangeMessage(() -> this.outboundPublication.saveDisconnectSession(this.correlationId, sessionId) > 0L, this.handler::checkError);
    }

    public void resetSequenceNumbers(long sessionId) {
        this.exchangeMessage(() -> this.outboundPublication.saveResetSequenceNumbers(this.correlationId, sessionId) > 0L, this.handler::checkError);
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            if (!this.closed) {
                CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{this.failCounter, this.aeron});
                this.closed = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private ArtioAdmin(ArtioAdminConfiguration config) {
        try {
            config.conclude();
            this.aeron = Aeron.connect((Aeron.Context)config.aeronContext());
            this.idleStrategy = config.idleStrategy();
            this.epochNanoClock = config.epochNanoClock();
            this.failCounter = this.aeron.addCounter(FixCounters.FixCountersId.FAILED_ADMIN_TYPE_ID.id(), "Failed offer for admin publication");
            this.replyTimeoutInNs = config.replyTimeoutInNs();
            String channel = config.aeronChannel();
            ExclusivePublication publication = this.aeron.addExclusivePublication(channel, config.outboundAdminStream());
            this.outboundPublication = new AdminPublication(publication, (AtomicCounter)this.failCounter, this.idleStrategy, 10000);
            this.inboundSubscription = this.aeron.addSubscription(channel, config.inboundAdminStream());
            long connectDeadlineNs = this.nanoTime() + config.connectTimeoutNs();
            this.idleStrategy.reset();
            while (!this.inboundSubscription.isConnected() || !publication.isConnected()) {
                if (this.nanoTime() > connectDeadlineNs) {
                    throw new TimeoutException("Failed to connect to FixEngine using channel=" + channel + " outboundAdminStreamId=" + config.outboundAdminStream() + " inboundAdminStreamId=" + config.inboundAdminStream() + " subscription.isConnected=" + this.inboundSubscription.isConnected() + " publication.isConnected=" + publication.isConnected() + " after " + config.connectTimeoutNs() + " ns");
                }
                this.idleStrategy.idle();
            }
        }
        catch (RuntimeException ex) {
            this.close();
            throw ex;
        }
    }

    private boolean saveRequestAllFixSessionsFunc() {
        return this.outboundPublication.saveRequestAllFixSessions(this.correlationId) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T exchangeMessage(BooleanSupplier sendMessage, Supplier<T> getResult) {
        this.lock.lock();
        try {
            this.checkOpen();
            long deadlineInNs = this.nanoTime() + this.replyTimeoutInNs;
            this.correlationId = this.newCorrelationId();
            this.handler.expectedCorrelationId(this.correlationId);
            this.until(deadlineInNs, sendMessage);
            this.until(deadlineInNs, this.checkReplyFunc);
            T t = getResult.get();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean checkReply() {
        this.inboundSubscription.poll((FragmentHandler)this.protocolSubscription, 10);
        return this.handler.hasReceivedReply();
    }

    private long newCorrelationId() {
        return ThreadLocalRandom.current().nextLong(1L, Long.MAX_VALUE);
    }

    private void until(long deadlineInNs, BooleanSupplier attempt) {
        while (true) {
            if (this.nanoTime() > deadlineInNs) {
                throw new TimeoutException("Operation timed out after " + this.replyTimeoutInNs + " ns");
            }
            if (attempt.getAsBoolean()) break;
            this.idleStrategy.idle();
        }
    }

    private long nanoTime() {
        return this.epochNanoClock.nanoTime();
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException("client is closed");
        }
    }
}

