/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.timing;

import java.util.List;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.EpochClock;
import uk.co.real_logic.artio.timing.HistogramHandler;
import uk.co.real_logic.artio.timing.HistogramLogWriter;
import uk.co.real_logic.artio.timing.Timer;

public class HistogramLogAgent
implements Agent {
    private final List<Timer> timers;
    private final HistogramHandler histogramHandler;
    private final long intervalInMs;
    private final EpochClock milliClock;
    private final String agentNamePrefix;
    private long nextWriteTimeInMs = 0L;

    public HistogramLogAgent(List<Timer> timers, String logFile, long intervalInMs, ErrorHandler errorHandler, EpochClock milliClock, HistogramHandler histogramHandler, String agentNamePrefix) {
        this.timers = timers;
        this.intervalInMs = intervalInMs;
        this.milliClock = milliClock;
        this.agentNamePrefix = agentNamePrefix;
        if (histogramHandler == null) {
            histogramHandler = new HistogramLogWriter(timers.size(), logFile, errorHandler);
        }
        this.histogramHandler = histogramHandler;
        timers.forEach(timer -> this.histogramHandler.identifyTimer(timer.id(), timer.name()));
        histogramHandler.onEndTimerIdentification();
    }

    public int doWork() {
        long currentTimeInMs = this.milliClock.time();
        if (currentTimeInMs > this.nextWriteTimeInMs) {
            this.logHistograms(currentTimeInMs);
            this.nextWriteTimeInMs = currentTimeInMs + this.intervalInMs;
            return 1;
        }
        return 0;
    }

    private void logHistograms(long currentTimeInMs) {
        List<Timer> timers = this.timers;
        HistogramHandler histogramHandler = this.histogramHandler;
        histogramHandler.onBeginTimerUpdate(currentTimeInMs);
        int size = timers.size();
        for (int i = 0; i < size; ++i) {
            Timer timer = timers.get(i);
            histogramHandler.onTimerUpdate(timer.id(), timer.getTimings());
        }
        histogramHandler.onEndTimerUpdate();
    }

    public String roleName() {
        return this.agentNamePrefix + "HistogramLogger";
    }

    public void onClose() {
        CloseHelper.close((AutoCloseable)this.histogramHandler);
    }
}

