/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.ReproductionClock;
import uk.co.real_logic.artio.library.DefaultLibraryScheduler;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.FixPConnectionAcquiredHandler;
import uk.co.real_logic.artio.library.FixPConnectionExistsHandler;
import uk.co.real_logic.artio.library.GatewayErrorHandler;
import uk.co.real_logic.artio.library.LibraryConnectHandler;
import uk.co.real_logic.artio.library.LibraryReproductionConfiguration;
import uk.co.real_logic.artio.library.LibraryScheduler;
import uk.co.real_logic.artio.library.SessionAcquireHandler;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.session.DirectSessionProxy;
import uk.co.real_logic.artio.session.ResendRequestController;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProxyFactory;

public final class LibraryConfiguration
extends CommonConfiguration {
    public static final GatewayErrorHandler DEFAULT_GATEWAY_ERROR_HANDLER = (errorType, libraryId, message) -> ControlledFragmentHandler.Action.CONTINUE;
    public static final SessionExistsHandler DEFAULT_SESSION_EXISTS_HANDLER = (library, sessionId, senderCompId, senderSubId, senderLocationId, targetCompId, remoteSubId, remoteLocationId, logonReceivedSequence, logonSequenceIndex) -> {};
    public static final LibraryConnectHandler DEFAULT_LIBRARY_CONNECT_HANDLER = new LibraryConnectHandler(){

        @Override
        public void onConnect(FixLibrary library) {
        }

        @Override
        public void onDisconnect(FixLibrary library) {
        }
    };
    public static final SessionProxyFactory DEFAULT_SESSION_PROXY_FACTORY = DirectSessionProxy::new;
    private int libraryId = 0;
    private SessionAcquireHandler sessionAcquireHandler;
    private IdleStrategy libraryIdleStrategy = LibraryConfiguration.backoffIdleStrategy();
    private SessionExistsHandler sessionExistsHandler = DEFAULT_SESSION_EXISTS_HANDLER;
    private GatewayErrorHandler gatewayErrorHandler = DEFAULT_GATEWAY_ERROR_HANDLER;
    private List<String> libraryAeronChannels = new ArrayList<String>();
    private LibraryConnectHandler libraryConnectHandler = DEFAULT_LIBRARY_CONNECT_HANDLER;
    private LibraryScheduler scheduler = new DefaultLibraryScheduler();
    private String libraryName = "";
    private SessionProxyFactory sessionProxyFactory = DEFAULT_SESSION_PROXY_FACTORY;
    private FixPConnectionExistsHandler fixPConnectionExistsHandler;
    private FixPConnectionAcquiredHandler fixPConnectionAcquiredHandler;
    private LibraryReproductionConfiguration reproductionConfiguration;

    public LibraryConfiguration sessionAcquireHandler(SessionAcquireHandler sessionAcquireHandler) {
        this.sessionAcquireHandler = sessionAcquireHandler;
        return this;
    }

    public LibraryConfiguration fixPConnectionAcquiredHandler(FixPConnectionAcquiredHandler fixPConnectionAcquiredHandler) {
        this.fixPConnectionAcquiredHandler = fixPConnectionAcquiredHandler;
        return this;
    }

    public LibraryConfiguration libraryIdleStrategy(IdleStrategy libraryIdleStrategy) {
        this.libraryIdleStrategy = libraryIdleStrategy;
        return this;
    }

    public LibraryConfiguration sessionExistsHandler(SessionExistsHandler sessionExistsHandler) {
        this.sessionExistsHandler = sessionExistsHandler;
        return this;
    }

    public LibraryConfiguration fixPConnectionExistsHandler(FixPConnectionExistsHandler fixPConnectionExistsHandler) {
        this.fixPConnectionExistsHandler = fixPConnectionExistsHandler;
        return this;
    }

    public LibraryConfiguration gatewayErrorHandler(GatewayErrorHandler gatewayErrorHandler) {
        this.gatewayErrorHandler = gatewayErrorHandler;
        return this;
    }

    public LibraryConfiguration libraryConnectHandler(LibraryConnectHandler libraryConnectHandler) {
        this.libraryConnectHandler = libraryConnectHandler;
        return this;
    }

    public LibraryConfiguration scheduler(LibraryScheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public LibraryConfiguration libraryId(int libraryId) {
        if (libraryId == 0 || libraryId < 0) {
            throw new IllegalArgumentException("Invalid library id: " + libraryId);
        }
        this.libraryId = libraryId;
        return this;
    }

    public SessionAcquireHandler sessionAcquireHandler() {
        return this.sessionAcquireHandler;
    }

    public int libraryId() {
        return this.libraryId;
    }

    public IdleStrategy libraryIdleStrategy() {
        return this.libraryIdleStrategy;
    }

    public GatewayErrorHandler gatewayErrorHandler() {
        return this.gatewayErrorHandler;
    }

    public LibraryConnectHandler libraryConnectHandler() {
        return this.libraryConnectHandler;
    }

    public LibraryScheduler scheduler() {
        return this.scheduler;
    }

    public SessionProxyFactory sessionProxyFactory() {
        return this.sessionProxyFactory;
    }

    @Override
    public LibraryConfiguration sessionIdStrategy(SessionIdStrategy sessionIdStrategy) {
        super.sessionIdStrategy(sessionIdStrategy);
        return this;
    }

    @Override
    public LibraryConfiguration monitoringBuffersLength(Integer monitoringBuffersLength) {
        super.monitoringBuffersLength(monitoringBuffersLength);
        return this;
    }

    @Override
    public LibraryConfiguration monitoringFile(String monitoringFile) {
        super.monitoringFile(monitoringFile);
        return this;
    }

    public LibraryConfiguration libraryAeronChannels(List<String> libraryAeronChannels) {
        this.libraryAeronChannels = libraryAeronChannels;
        return this;
    }

    public LibraryConfiguration sessionProxyFactory(SessionProxyFactory sessionProxyFactory) {
        this.sessionProxyFactory = sessionProxyFactory;
        return this;
    }

    public LibraryConfiguration reproduceInbound(long startInNs, long endInNs) {
        ReproductionClock clock = new ReproductionClock(startInNs);
        this.epochNanoClock(clock);
        this.reproductionConfiguration = new LibraryReproductionConfiguration(startInNs, endInNs, clock);
        return this;
    }

    @Override
    public LibraryConfiguration replyTimeoutInMs(long replyTimeoutInMs) {
        super.replyTimeoutInMs(replyTimeoutInMs);
        return this;
    }

    @Override
    public LibraryConfiguration noEstablishFixPTimeoutInMs(long noEstablishFixPTimeoutInMs) {
        super.noEstablishFixPTimeoutInMs(noEstablishFixPTimeoutInMs);
        return this;
    }

    @Override
    public LibraryConfiguration fixPAcceptedSessionMaxRetransmissionRange(int fixPAcceptedSessionMaxRetransmissionRange) {
        super.fixPAcceptedSessionMaxRetransmissionRange(fixPAcceptedSessionMaxRetransmissionRange);
        return this;
    }

    @Override
    public LibraryConfiguration epochNanoClock(EpochNanoClock epochNanoClock) {
        super.epochNanoClock(epochNanoClock);
        return this;
    }

    @Override
    public LibraryConfiguration resendRequestController(ResendRequestController resendRequestController) {
        super.resendRequestController(resendRequestController);
        return this;
    }

    @Override
    public LibraryConfiguration defaultHeartbeatIntervalInS(int value) {
        super.defaultHeartbeatIntervalInS(value);
        return this;
    }

    @Override
    public LibraryConfiguration forcedHeartbeatIntervalInS(int value) {
        super.forcedHeartbeatIntervalInS(value);
        return this;
    }

    @Override
    public CommonConfiguration disableHeartbeatRepliesToTestRequests(boolean disableHeartbeatRepliesToTestRequests) {
        return super.disableHeartbeatRepliesToTestRequests(disableHeartbeatRepliesToTestRequests);
    }

    LibraryConfiguration conclude() {
        this.concludeLibraryId();
        super.conclude("library-" + this.libraryId());
        if (this.isReproductionEnabled() && this.reproductionConfiguration.clock() != this.epochNanoClock()) {
            throw new IllegalArgumentException("Do no set the nano clock when using reproduction mode");
        }
        if (this.libraryAeronChannels.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least one channel to connect to");
        }
        return this;
    }

    private void concludeLibraryId() {
        while (this.libraryId == 0 || this.libraryId < 0) {
            this.libraryId = ThreadLocalRandom.current().nextInt();
        }
    }

    SessionExistsHandler sessionExistsHandler() {
        return this.sessionExistsHandler;
    }

    FixPConnectionExistsHandler fixPConnectionExistsHandler() {
        return this.fixPConnectionExistsHandler;
    }

    FixPConnectionAcquiredHandler fixPConnectionAcquiredHandler() {
        return this.fixPConnectionAcquiredHandler;
    }

    public List<String> libraryAeronChannels() {
        return this.libraryAeronChannels;
    }

    String libraryName() {
        return this.libraryName;
    }

    LibraryReproductionConfiguration reproductionConfiguration() {
        return this.reproductionConfiguration;
    }

    boolean isReproductionEnabled() {
        return this.reproductionConfiguration != null;
    }

    public LibraryConfiguration libraryName(String libraryName) {
        this.libraryName = libraryName;
        return this;
    }
}

