/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import org.agrona.collections.Long2ObjectHashMap;
import uk.co.real_logic.artio.engine.logger.PrunePosition;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;

class StartPositionQuery {
    private final Long2ObjectHashMap<PrunePosition> recordingIdToStartPosition = new Long2ObjectHashMap();
    private int highestSequenceIndex = 0;

    StartPositionQuery() {
    }

    public void updateStartPosition(int sequenceNumber, int sequenceIndex, long recordingId, long beginPosition) {
        long trueBeginPosition = ReplayQuery.trueBeginPosition(beginPosition);
        if (sequenceIndex > this.highestSequenceIndex) {
            this.recordingIdToStartPosition.clear();
            this.recordingIdToStartPosition.put(recordingId, (Object)new PrunePosition(trueBeginPosition, sequenceNumber, sequenceIndex));
            this.highestSequenceIndex = sequenceIndex;
        } else if (sequenceIndex == this.highestSequenceIndex) {
            PrunePosition oldPosition = (PrunePosition)this.recordingIdToStartPosition.get(recordingId);
            if (oldPosition == null) {
                this.recordingIdToStartPosition.put(recordingId, (Object)new PrunePosition(trueBeginPosition, sequenceNumber, sequenceIndex));
            } else {
                int oldSequenceNumber = oldPosition.sequenceNumber();
                if (oldSequenceNumber == sequenceNumber) {
                    oldPosition.position(Math.max(oldPosition.position(), trueBeginPosition));
                } else if (sequenceNumber < oldSequenceNumber) {
                    oldPosition.sequenceNumber(sequenceNumber);
                    oldPosition.position(trueBeginPosition);
                }
            }
        }
    }

    public int highestSequenceIndex() {
        return this.highestSequenceIndex;
    }

    public Long2ObjectHashMap<PrunePosition> recordingIdToStartPosition() {
        return this.recordingIdToStartPosition;
    }
}

