/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.SectorFramer;

final class SequenceNumberIndexDescriptor {
    static final int HEADER_SIZE = 8;
    static final int RECORD_SIZE = 24;
    static final int NO_META_DATA = -1;
    static final long META_DATA_MAGIC_NUMBER = 48879L;
    static final int META_DATA_FILE_VERSION = 1;
    static final int READABLE_META_DATA_FILE_VERSION = 1;
    static final int META_DATA_FILE_HEADER_LENGTH = 12;
    static final int SIZE_OF_META_DATA_LENGTH = 4;
    static final double SEQUENCE_NUMBER_RATIO = 0.9;

    SequenceNumberIndexDescriptor() {
    }

    public static File metaDataFile(String logFileDir) {
        return new File(logFileDir + "/metadata");
    }

    static AtomicBuffer positionsBuffer(AtomicBuffer buffer, int positionsOffset) {
        return new UnsafeBuffer((DirectBuffer)buffer, positionsOffset, buffer.capacity() - positionsOffset);
    }

    static int positionTableOffset(int fileCapacity) {
        int proposedCapacity = SectorFramer.nextSectorStart((int)((double)fileCapacity * 0.9));
        if (proposedCapacity == fileCapacity) {
            return fileCapacity - 4096;
        }
        return proposedCapacity;
    }

    public static File passingFile(String indexFilePath) {
        return new File(indexFilePath + "-passing");
    }

    public static File writableFile(String indexFilePath) {
        return new File(indexFilePath + "-writable");
    }
}

