/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.IntHashSet;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.engine.FixPRetransmitHandler;
import uk.co.real_logic.artio.engine.logger.FixPMessageTracker;
import uk.co.real_logic.artio.engine.logger.MessageTracker;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.engine.logger.ReplayerSession;
import uk.co.real_logic.artio.fixp.AbstractFixPOffsets;
import uk.co.real_logic.artio.fixp.AbstractFixPParser;
import uk.co.real_logic.artio.fixp.AbstractFixPProxy;
import uk.co.real_logic.artio.messages.FixPMessageEncoder;

public class FixPReplayerSession
extends ReplayerSession {
    private final IntHashSet gapfillOnRetransmitILinkTemplateIds;
    private final FixPMessageEncoder fixPMessageEncoder;
    private final AbstractFixPParser binaryParser;
    private final AbstractFixPProxy binaryProxy;
    private final AbstractFixPOffsets fixPOffsets;
    private final FixPRetransmitHandler fixPRetransmitHandler;
    private boolean mustSendSequenceMessage = false;
    private State state;

    public FixPReplayerSession(long connectionId, long correlationId, BufferClaim bufferClaim, IdleStrategy idleStrategy, int maxClaimAttempts, ExclusivePublication publication, ReplayQuery replayQuery, int beginSeqNo, int endSeqNo, long sessionId, Replayer replayer, IntHashSet gapfillOnRetransmitILinkTemplateIds, FixPMessageEncoder fixPMessageEncoder, AbstractFixPParser binaryParser, AbstractFixPProxy binaryProxy, AbstractFixPOffsets fixPOffsets, FixPRetransmitHandler fixPRetransmitHandler, AtomicCounter bytesInBuffer, int maxBytesInBuffer) {
        super(connectionId, correlationId, bufferClaim, idleStrategy, maxClaimAttempts, publication, replayQuery, beginSeqNo, endSeqNo, sessionId, 0, replayer, bytesInBuffer, maxBytesInBuffer);
        this.gapfillOnRetransmitILinkTemplateIds = gapfillOnRetransmitILinkTemplateIds;
        this.fixPMessageEncoder = fixPMessageEncoder;
        this.binaryParser = binaryParser;
        this.binaryProxy = binaryProxy;
        this.fixPOffsets = fixPOffsets;
        this.fixPRetransmitHandler = fixPRetransmitHandler;
        this.state = State.REPLAYING;
    }

    @Override
    MessageTracker messageTracker() {
        return new FixPMessageTracker(this, this.binaryParser, this.endSeqNo - this.beginSeqNo + 1);
    }

    @Override
    public boolean attemptReplay() {
        switch (this.state) {
            case SEND_COMPLETE_MESSAGE: {
                if (this.mustSendSequenceMessage) {
                    if (this.sendSequence(this.endSeqNo + 1)) {
                        this.mustSendSequenceMessage = false;
                    } else {
                        return false;
                    }
                }
                return this.sendCompleteMessage();
            }
            case REPLAYING: {
                if (this.replayOperation.pollReplay()) {
                    DebugLogger.log(LogTag.REPLAY_ATTEMPT, "ReplayerSession: REPLAYING step");
                    this.state = State.SEND_COMPLETE_MESSAGE;
                }
                return false;
            }
            case CLOSING: {
                return this.replayOperation.pollReplay();
            }
        }
        return false;
    }

    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        int seqNum;
        int messageLength = length - 32;
        if (this.isBackpressured(messageLength)) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        int encoderOffset = offset + 8;
        int headerOffset = encoderOffset + 4 + 24;
        int templateId = this.binaryParser.templateId(buffer, headerOffset);
        int blockLength = this.binaryParser.blockLength(buffer, headerOffset);
        int version = this.binaryParser.version(buffer, headerOffset);
        int messageOffset = headerOffset + 8;
        this.fixPRetransmitHandler.onReplayedBusinessMessage(templateId, buffer, messageOffset, blockLength, version);
        if (this.gapfillOnRetransmitILinkTemplateIds.contains(templateId)) {
            this.mustSendSequenceMessage = true;
            return ControlledFragmentHandler.Action.CONTINUE;
        }
        if (this.mustSendSequenceMessage && (seqNum = this.fixPOffsets.seqNum(templateId, buffer, messageOffset)) != -1) {
            if (this.sendSequence(seqNum)) {
                this.mustSendSequenceMessage = false;
            } else {
                return ControlledFragmentHandler.Action.ABORT;
            }
        }
        this.fixPMessageEncoder.wrap((MutableDirectBuffer)buffer, encoderOffset).connection(this.connectionId);
        return Pressure.apply(this.publication.offer(buffer, offset, length));
    }

    private boolean sendSequence(int nextSentSequenceNumber) {
        this.binaryProxy.ids(this.connectionId, this.sessionId);
        return !Pressure.isBackPressured(this.binaryProxy.sendSequence(this.sessionId, nextSentSequenceNumber));
    }

    @Override
    void startClose() {
        this.state = State.CLOSING;
        super.startClose();
    }

    private static enum State {
        REPLAYING,
        SEND_COMPLETE_MESSAGE,
        CLOSING;

    }
}

