/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.LongHashSet;
import uk.co.real_logic.artio.ArtioLogHeader;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.engine.framer.MessageTypeExtractor;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.FixMessagePredicate;
import uk.co.real_logic.artio.engine.logger.HeaderField;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.BufferAsciiSequence;
import uk.co.real_logic.artio.util.MessageTypeEncoding;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public final class FixMessagePredicates {
    private FixMessagePredicates() {
    }

    public static FixMessageConsumer filterBy(FixMessageConsumer consumer, FixMessagePredicate predicate) {
        return new FilterBy(consumer, predicate);
    }

    public static FixMessagePredicate between(long beginTimestampInclusive, long endTimestampExclusive) {
        return FixMessagePredicates.from(beginTimestampInclusive).and(FixMessagePredicates.to(endTimestampExclusive));
    }

    public static FixMessagePredicate from(long beginTimestampInclusive) {
        return new From(beginTimestampInclusive);
    }

    public static FixMessagePredicate to(long endTimestampExclusive) {
        return new To(endTimestampExclusive);
    }

    public static FixMessagePredicate messageTypeOf(String ... messageTypes) {
        LongHashSet hashSet = new LongHashSet();
        Stream.of(messageTypes).mapToLong(MessageTypeEncoding::packMessageType).forEach(arg_0 -> ((LongHashSet)hashSet).add(arg_0));
        return FixMessagePredicates.messageTypeOf(hashSet);
    }

    public static FixMessagePredicate messageTypeOf(long ... messageTypes) {
        LongHashSet hashSet = new LongHashSet();
        LongStream.of(messageTypes).forEach(arg_0 -> ((LongHashSet)hashSet).add(arg_0));
        return FixMessagePredicates.messageTypeOf(hashSet);
    }

    private static FixMessagePredicate messageTypeOf(LongHashSet hashSet) {
        return message -> {
            long messageType = MessageTypeExtractor.getMessageType(message);
            return hashSet.contains(messageType);
        };
    }

    public static FixMessagePredicate sessionOf(FixDictionary fixDictionary, String senderCompId, String targetCompId) {
        return FixMessagePredicates.whereHeader(fixDictionary, FixMessagePredicates.senderCompIdOf(senderCompId).and(FixMessagePredicates.targetCompIdOf(targetCompId)));
    }

    public static Predicate<SessionHeaderDecoder> senderCompIdOf(String senderCompId) {
        return FixMessagePredicates.headerMatches(senderCompId, HeaderField.SENDER_COMP_ID, SessionHeaderDecoder::senderCompID, SessionHeaderDecoder::senderCompIDLength, true);
    }

    public static Predicate<SessionHeaderDecoder> targetCompIdOf(String targetCompId) {
        return FixMessagePredicates.headerMatches(targetCompId, HeaderField.TARGET_COMP_ID, SessionHeaderDecoder::targetCompID, SessionHeaderDecoder::targetCompIDLength, true);
    }

    public static Predicate<SessionHeaderDecoder> senderSubIdOf(String senderSubId) {
        return FixMessagePredicates.headerMatchesConsistent(senderSubId, SessionHeaderDecoder::senderSubID, SessionHeaderDecoder::senderSubIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetSubIdOf(String targetSubId) {
        return FixMessagePredicates.headerMatchesConsistent(targetSubId, SessionHeaderDecoder::targetSubID, SessionHeaderDecoder::targetSubIDLength);
    }

    public static Predicate<SessionHeaderDecoder> senderLocationIdOf(String senderLocationId) {
        return FixMessagePredicates.headerMatchesConsistent(senderLocationId, SessionHeaderDecoder::senderLocationID, SessionHeaderDecoder::senderLocationIDLength);
    }

    public static Predicate<SessionHeaderDecoder> targetLocationIdOf(String targetLocationId) {
        return FixMessagePredicates.headerMatchesConsistent(targetLocationId, SessionHeaderDecoder::targetLocationID, SessionHeaderDecoder::targetLocationIDLength);
    }

    public static Predicate<SessionHeaderDecoder> headerMatches(String value, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor) {
        return FixMessagePredicates.headerMatches(value, HeaderField.NOT_OPTIMISED, charExtractor, lengthExtractor, false);
    }

    private static Predicate<SessionHeaderDecoder> headerMatchesConsistent(String value, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor) {
        return FixMessagePredicates.headerMatches(value, HeaderField.NOT_OPTIMISED, charExtractor, lengthExtractor, true);
    }

    private static Predicate<SessionHeaderDecoder> headerMatches(String value, HeaderField headerField, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor, boolean sessionConsistent) {
        return new HeaderMatches(value, headerField, sessionConsistent, charExtractor, lengthExtractor);
    }

    public static FixMessagePredicate whereHeader(FixDictionary fixDictionary, Predicate<SessionHeaderDecoder> matches) {
        if (matches instanceof HeaderPredicate && ((HeaderPredicate)matches).isSessionConsistent()) {
            return new SessionConsistentWhereHeader(fixDictionary, matches);
        }
        return new WhereHeader(fixDictionary, matches);
    }

    public static FixMessagePredicate sessionOf(long sessionId) {
        return message -> message.session() == sessionId;
    }

    public static FixMessagePredicate bodyMatches(Pattern pattern) {
        ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
        BufferAsciiSequence sequence = new BufferAsciiSequence();
        return message -> {
            int length = message.bodyLength();
            buffer.checkLimit(length);
            message.getBody((MutableDirectBuffer)buffer, 0, length);
            sequence.wrap((DirectBuffer)buffer, 0, length);
            return pattern.matcher((CharSequence)sequence).matches();
        };
    }

    public static FixMessagePredicate alwaysTrue() {
        return message -> true;
    }

    static class SessionConsistentWhereHeader
    extends WhereHeader {
        private final LongHashSet matchingIds = new LongHashSet();
        private final LongHashSet rejectedIds = new LongHashSet();

        SessionConsistentWhereHeader(FixDictionary fixDictionary, Predicate<SessionHeaderDecoder> matches) {
            super(fixDictionary, matches);
        }

        @Override
        public void reset() {
            this.matchingIds.clear();
            this.rejectedIds.clear();
        }

        @Override
        public boolean test(FixMessageDecoder message) {
            LongHashSet matchingIds = this.matchingIds;
            LongHashSet rejectedIds = this.rejectedIds;
            long sessionId = message.session();
            if (matchingIds.contains(sessionId)) {
                return true;
            }
            if (rejectedIds.contains(sessionId)) {
                return false;
            }
            boolean result = super.test(message);
            if (result) {
                matchingIds.add(sessionId);
            } else {
                rejectedIds.add(sessionId);
            }
            return result;
        }
    }

    static class WhereHeader
    implements FixMessagePredicate {
        private final Predicate<SessionHeaderDecoder> matches;
        private final SessionHeaderDecoder header;
        private final AsciiBuffer asciiBuffer;

        WhereHeader(FixDictionary fixDictionary, Predicate<SessionHeaderDecoder> matches) {
            this.header = fixDictionary.makeHeaderDecoder();
            this.matches = matches;
            this.asciiBuffer = new MutableAsciiBuffer();
        }

        @Override
        public boolean test(FixMessageDecoder message) {
            DirectBuffer buffer = message.buffer();
            int length = message.bodyLength();
            int bodyOffset = message.limit() + FixMessageDecoder.bodyHeaderLength();
            this.asciiBuffer.wrap(buffer);
            this.header.decode(this.asciiBuffer, bodyOffset, length);
            return this.matches.test(this.header);
        }

        public Predicate<SessionHeaderDecoder> matches() {
            return this.matches;
        }
    }

    static class HeaderMatches
    extends HeaderPredicate {
        final char[] expectedChars;
        final HeaderField headerField;
        final String value;
        private final Function<SessionHeaderDecoder, char[]> charExtractor;
        private final ToIntFunction<SessionHeaderDecoder> lengthExtractor;

        HeaderMatches(String value, HeaderField headerField, boolean sessionConsistent, Function<SessionHeaderDecoder, char[]> charExtractor, ToIntFunction<SessionHeaderDecoder> lengthExtractor) {
            super(sessionConsistent);
            this.expectedChars = value.toCharArray();
            this.value = value;
            this.headerField = headerField;
            this.charExtractor = charExtractor;
            this.lengthExtractor = lengthExtractor;
        }

        @Override
        public boolean test(SessionHeaderDecoder header) {
            char[] actualChars = this.charExtractor.apply(header);
            int length = this.lengthExtractor.applyAsInt(header);
            return CodecUtil.equals((char[])actualChars, (char[])this.expectedChars, (int)length);
        }
    }

    static abstract class CompositeHeaderPredicate
    extends HeaderPredicate {
        final HeaderPredicate left;
        final HeaderPredicate right;

        CompositeHeaderPredicate(HeaderPredicate left, HeaderPredicate right) {
            super(left.isSessionConsistent() && right.isSessionConsistent());
            this.left = left;
            this.right = right;
        }
    }

    static abstract class HeaderPredicate
    implements Predicate<SessionHeaderDecoder> {
        private final boolean sessionConsistent;

        protected HeaderPredicate(boolean sessionConsistent) {
            this.sessionConsistent = sessionConsistent;
        }

        @Override
        public Predicate<SessionHeaderDecoder> and(Predicate<? super SessionHeaderDecoder> other) {
            if (other instanceof HeaderPredicate) {
                return new CompositeHeaderPredicate(this, (HeaderPredicate)other){

                    @Override
                    public boolean test(SessionHeaderDecoder sessionHeaderDecoder) {
                        return this.left.test(sessionHeaderDecoder) && this.right.test(sessionHeaderDecoder);
                    }
                };
            }
            return Predicate.super.and(other);
        }

        @Override
        public Predicate<SessionHeaderDecoder> or(Predicate<? super SessionHeaderDecoder> other) {
            if (other instanceof HeaderPredicate) {
                return new CompositeHeaderPredicate(this, (HeaderPredicate)other){

                    @Override
                    public boolean test(SessionHeaderDecoder sessionHeaderDecoder) {
                        return this.left.test(sessionHeaderDecoder) || this.right.test(sessionHeaderDecoder);
                    }
                };
            }
            return Predicate.super.or(other);
        }

        @Override
        public Predicate<SessionHeaderDecoder> negate() {
            final HeaderPredicate delegate = this;
            return new HeaderPredicate(delegate.sessionConsistent){

                @Override
                public boolean test(SessionHeaderDecoder sessionHeaderDecoder) {
                    return !delegate.test(sessionHeaderDecoder);
                }
            };
        }

        public boolean isSessionConsistent() {
            return this.sessionConsistent;
        }
    }

    static class To
    implements FixMessagePredicate {
        private final long endTimestampExclusive;

        To(long endTimestampExclusive) {
            this.endTimestampExclusive = endTimestampExclusive;
        }

        @Override
        public boolean test(FixMessageDecoder message) {
            return message.timestamp() < this.endTimestampExclusive;
        }

        public long endTimestampExclusive() {
            return this.endTimestampExclusive;
        }
    }

    static class From
    implements FixMessagePredicate {
        private final long beginTimestampInclusive;

        From(long beginTimestampInclusive) {
            this.beginTimestampInclusive = beginTimestampInclusive;
        }

        @Override
        public boolean test(FixMessageDecoder message) {
            return message.timestamp() >= this.beginTimestampInclusive;
        }

        long beginTimestampInclusive() {
            return this.beginTimestampInclusive;
        }

        public String toString() {
            return "From{beginTimestampInclusive=" + this.beginTimestampInclusive + '}';
        }
    }

    static class FilterBy
    implements FixMessageConsumer {
        final FixMessageConsumer consumer;
        final FixMessagePredicate predicate;

        FilterBy(FixMessageConsumer consumer, FixMessagePredicate predicate) {
            this.consumer = consumer;
            this.predicate = predicate;
        }

        @Override
        public void reset() {
            this.consumer.reset();
            this.predicate.reset();
        }

        @Override
        public void onMessage(FixMessageDecoder message, DirectBuffer buffer, int offset, int length, ArtioLogHeader header) {
            int actingVersion = message.sbeSchemaVersion();
            int actingBlockLength = message.sbeBlockLength();
            int initialOffset = message.initialOffset();
            if (this.predicate.test(message)) {
                message.wrap(buffer, initialOffset, actingBlockLength, actingVersion);
                if (actingVersion >= FixMessageDecoder.metaDataSinceVersion()) {
                    message.skipMetaData();
                }
                this.consumer.onMessage(message, buffer, offset, length, header);
            }
        }

        public String toString() {
            return "FilterBy{consumer=" + this.consumer + ", predicate=" + this.predicate + '}';
        }
    }
}

