/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.FragmentHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.agrona.collections.IntHashSet;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.logger.ArchiveScanPlanner;
import uk.co.real_logic.artio.engine.logger.FixArchiveScanner;
import uk.co.real_logic.artio.engine.logger.FixMessageConsumer;
import uk.co.real_logic.artio.engine.logger.IndexQuery;
import uk.co.real_logic.artio.engine.logger.PositionRange;
import uk.co.real_logic.artio.engine.logger.StreamTimestampZipper;
import uk.co.real_logic.artio.engine.logger.TimeIndexReader;
import uk.co.real_logic.artio.fixp.FixPMessageConsumer;

public class FixArchiveScanningAgent
implements AutoCloseable {
    private final Aeron aeron;
    private final AeronArchive aeronArchive;
    private final IdleStrategy idleStrategy;
    private final int compactionSize;
    private final int maximumBufferSize;
    private final int fragmentLimit;
    private final String logFileDir;
    private final Long2ObjectHashMap<TimeIndexReader> streamIdToInboundTimeIndex = new Long2ObjectHashMap();
    private StreamTimestampZipper timestampZipper;
    private Subscription replaySubscription;
    private RecordingPoller[] pollers;
    private boolean follow;

    public FixArchiveScanningAgent(IdleStrategy idleStrategy, int compactionSize, int maximumBufferSize, int fragmentLimit, String logFileDir, Aeron aeron, AeronArchive aeronArchive) {
        this.idleStrategy = idleStrategy;
        this.compactionSize = compactionSize;
        this.maximumBufferSize = maximumBufferSize;
        this.fragmentLimit = fragmentLimit;
        this.aeron = aeron;
        this.aeronArchive = aeronArchive;
        this.logFileDir = logFileDir;
    }

    public void setup(String aeronChannel, IntHashSet queryStreamIds, FixMessageConsumer fixHandler, FixPMessageConsumer fixPHandler, boolean follow, int archiveScannerStreamId) {
        if (fixHandler != null) {
            fixHandler.reset();
        }
        Long2ObjectHashMap<PositionRange> recordingIdToPositionRange = this.scanIndexIfPossible(fixHandler, follow, queryStreamIds);
        this.follow = follow;
        this.replaySubscription = this.aeron.addSubscription("aeron:ipc", archiveScannerStreamId);
        this.pollers = this.makeRecordingPollers(aeronChannel, queryStreamIds, follow, recordingIdToPositionRange, this.replaySubscription);
        if (FixArchiveScanner.DEBUG_LOG_ARCHIVE_SCAN) {
            DebugLogger.log(LogTag.ARCHIVE_SCAN, "Pollers: %s", this.pollers);
        }
        this.timestampZipper = new StreamTimestampZipper(fixHandler, fixPHandler, this.compactionSize, this.maximumBufferSize, !follow, this.pollers);
    }

    public boolean poll(int fragmentLimit) {
        int received = this.timestampZipper.poll(fragmentLimit);
        if (0 == received && !this.follow && this.checkCompletion(this.pollers)) {
            Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.timestampZipper, this.replaySubscription});
            return true;
        }
        return false;
    }

    private RecordingPoller[] makeRecordingPollers(String aeronChannel, IntHashSet queryStreamIds, boolean follow, Long2ObjectHashMap<PositionRange> recordingIdToPositionRange, Subscription replaySubscription) {
        return (RecordingPoller[])queryStreamIds.stream().flatMap(id -> this.lookupArchiveLocations((int)id, follow, aeronChannel, recordingIdToPositionRange).stream().filter(archiveLocation -> archiveLocation.length() != 0L).map(archiveLocation -> new RecordingPoller(replaySubscription, (int)id, (ArchiveLocation)archiveLocation))).toArray(RecordingPoller[]::new);
    }

    private Long2ObjectHashMap<PositionRange> scanIndexIfPossible(FixMessageConsumer fixHandler, boolean follow, IntHashSet queryStreamIds) {
        if (FixArchiveScanner.DEBUG_LOG_ARCHIVE_SCAN) {
            DebugLogger.log(LogTag.ARCHIVE_SCAN, "checking index,follow=" + follow + ",logFileDir=" + this.logFileDir + ",queryStreamIds=" + queryStreamIds);
        }
        if (follow) {
            return null;
        }
        if (this.logFileDir == null) {
            return null;
        }
        try {
            IndexQuery indexQuery = ArchiveScanPlanner.extractIndexQuery(fixHandler);
            if (FixArchiveScanner.DEBUG_LOG_ARCHIVE_SCAN) {
                DebugLogger.log(LogTag.ARCHIVE_SCAN, "indexQuery = " + indexQuery);
            }
            if (indexQuery == null) {
                return null;
            }
            Long2ObjectHashMap recordingIdToPositionRange = new Long2ObjectHashMap();
            IntHashSet.IntIterator intIterator = queryStreamIds.iterator();
            while (intIterator.hasNext()) {
                int streamId = (Integer)intIterator.next();
                TimeIndexReader reader = (TimeIndexReader)this.streamIdToInboundTimeIndex.get((long)streamId);
                if (reader == null) {
                    reader = new TimeIndexReader(this.logFileDir, streamId);
                    this.streamIdToInboundTimeIndex.put((long)streamId, (Object)reader);
                }
                if (reader.findPositionRange(indexQuery, (Long2ObjectHashMap<PositionRange>)recordingIdToPositionRange)) continue;
                return null;
            }
            if (FixArchiveScanner.DEBUG_LOG_ARCHIVE_SCAN) {
                DebugLogger.log(LogTag.ARCHIVE_SCAN, "recordingIdToPositionRange = " + recordingIdToPositionRange);
            }
            return recordingIdToPositionRange;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean checkCompletion(RecordingPoller[] pollers) {
        for (RecordingPoller poller : pollers) {
            if (poller.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        this.aeronArchive.close();
    }

    private List<ArchiveLocation> lookupArchiveLocations(int queryStreamId, boolean follow, String aeronChannel, Long2ObjectHashMap<PositionRange> recordingIdToPositionRange) {
        ArrayList<ArchiveLocation> archiveLocations = new ArrayList<ArchiveLocation>();
        this.aeronArchive.listRecordings(0L, Integer.MAX_VALUE, (controlSessionId, correlationId, recordingId, startTimestamp, stopTimestamp, startPosition, stopPosition, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity) -> {
            ChannelUri uri = ChannelUri.parse((CharSequence)strippedChannel);
            uri.remove("session-id");
            String comparableChannel = uri.toString();
            if (streamId == queryStreamId && comparableChannel.contains(aeronChannel)) {
                archiveLocations.add(new ArchiveLocation(recordingId, startPosition, stopPosition));
            }
        });
        if (!follow) {
            for (ArchiveLocation location : archiveLocations) {
                if (location.stopPosition != -1L) continue;
                location.stopPosition = this.aeronArchive.getRecordingPosition(location.recordingId);
            }
        }
        if (recordingIdToPositionRange != null) {
            Iterator iterator = archiveLocations.iterator();
            while (iterator.hasNext()) {
                ArchiveLocation location;
                location = (ArchiveLocation)iterator.next();
                PositionRange positionRange = (PositionRange)recordingIdToPositionRange.get(location.recordingId);
                if (positionRange == null) {
                    iterator.remove();
                    continue;
                }
                long startPosition2 = positionRange.startPosition();
                long endPosition = positionRange.endPosition();
                if (location.stopPosition > endPosition) {
                    location.stopPosition = endPosition;
                }
                if (location.startPosition >= startPosition2) continue;
                location.startPosition = startPosition2;
            }
        }
        return archiveLocations;
    }

    class RecordingPoller
    implements StreamTimestampZipper.Poller {
        private final Subscription replaySubscription;
        private final int originalStreamId;
        private ArchiveLocation archiveLocation;
        long stopPosition;
        Image image;

        RecordingPoller(Subscription replaySubscription, int originalStreamId, ArchiveLocation archiveLocation) {
            this.replaySubscription = replaySubscription;
            this.originalStreamId = originalStreamId;
            this.archiveLocation = archiveLocation;
        }

        @Override
        public boolean isComplete() {
            return this.stopPosition != -1L && this.image == null && this.archiveLocation == null;
        }

        @Override
        public int poll(FragmentAssembler fragmentAssembler, int fragmentLimit) {
            if (this.image == null) {
                if (this.archiveLocation == null) {
                    return 0;
                }
                if (this.archiveLocation.length() != 0L) {
                    int sessionId = (int)FixArchiveScanningAgent.this.aeronArchive.startReplay(this.archiveLocation.recordingId, this.archiveLocation.startPosition, this.archiveLocation.length(), "aeron:ipc", this.replaySubscription.streamId());
                    this.image = this.lookupImage(sessionId);
                    this.stopPosition = this.archiveLocation.stopPosition;
                    this.archiveLocation = null;
                }
                return 1;
            }
            if (this.stopPosition != -1L && this.image.position() >= this.stopPosition) {
                this.image = null;
                return 1;
            }
            return this.image.poll((FragmentHandler)fragmentAssembler, FixArchiveScanningAgent.this.fragmentLimit);
        }

        @Override
        public int streamId() {
            return this.originalStreamId;
        }

        private Image lookupImage(int sessionId) {
            Image image = null;
            while (image == null) {
                FixArchiveScanningAgent.this.idleStrategy.idle();
                image = this.replaySubscription.imageBySessionId(sessionId);
            }
            FixArchiveScanningAgent.this.idleStrategy.reset();
            return image;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "RecordingPoller{archiveLocations=" + this.archiveLocation + ", replaySubscription=" + this.replaySubscription + ", originalStreamId=" + this.originalStreamId + ", stopPosition=" + this.stopPosition + ", image=" + this.image + '}';
        }
    }

    static class ArchiveLocation {
        final long recordingId;
        long startPosition;
        long stopPosition;

        ArchiveLocation(long recordingId, long startPosition, long stopPosition) {
            this.recordingId = recordingId;
            this.startPosition = startPosition;
            this.stopPosition = stopPosition;
        }

        public long stopPosition() {
            return this.stopPosition;
        }

        public long length() {
            return this.startPosition == -1L ? -1L : this.stopPosition - this.startPosition;
        }

        public String toString() {
            return "ArchiveLocation{recordingId=" + this.recordingId + ", startPosition=" + this.startPosition + ", stopPosition=" + this.stopPosition + '}';
        }
    }
}

