/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.function.IntConsumer;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.collections.Int2ObjectHashMap;
import uk.co.real_logic.artio.ArtioLogHeader;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.ReproductionClock;
import uk.co.real_logic.artio.engine.framer.LiveLibraryInfo;
import uk.co.real_logic.artio.engine.framer.ReproductionTcpChannelSupplier;
import uk.co.real_logic.artio.engine.logger.ReproductionFixProtocolConsumer;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatDecoder;
import uk.co.real_logic.artio.messages.ConnectDecoder;
import uk.co.real_logic.artio.messages.FixMessageDecoder;

public class ReproductionProtocolHandler
implements ReproductionFixProtocolConsumer {
    public static volatile IntConsumer countHandler;
    public static final boolean REPRO_DEBUG_ENABLED;
    private final ReproductionTcpChannelSupplier tcpChannelSupplier;
    private final ReproductionClock clock;
    private final ErrorHandler errorHandler;
    private long connectionId = -1L;
    private Int2ObjectHashMap<LiveLibraryInfo> idToLibrary;
    private boolean operationInProgress = false;
    private int count;

    public ReproductionProtocolHandler(ReproductionTcpChannelSupplier tcpChannelSupplier, ReproductionClock clock, ErrorHandler errorHandler) {
        this.tcpChannelSupplier = tcpChannelSupplier;
        this.clock = clock;
        this.errorHandler = errorHandler;
        tcpChannelSupplier.registerEndOperation(this::endOperation);
    }

    @Override
    public void onMessage(FixMessageDecoder message, DirectBuffer buffer, int offset, int length, ArtioLogHeader header) {
        ++this.count;
        if (REPRO_DEBUG_ENABLED) {
            DebugLogger.log(LogTag.REPRODUCTION, "ReproductionProtocolHandler.onMessage: ", buffer, offset, length);
        }
        this.startOperation();
        long messageType = message.messageType();
        this.clock.advanceTimeTo(message.timestamp());
        this.validateLibraryId(message.libraryId());
        int initialOffset = message.initialOffset() - 8;
        int fullLength = offset + length - initialOffset;
        int messageOffset = offset - initialOffset;
        long connectionId = message.connection();
        if (!this.tcpChannelSupplier.enqueueMessage(connectionId, buffer, initialOffset, messageOffset, length, messageType == 50L)) {
            System.err.println("FAILURE - What has happened?");
        }
    }

    private void validateLibraryId(int libraryId) {
        if (libraryId != 0 && !this.idToLibrary.containsKey(libraryId)) {
            this.errorHandler.onError((Throwable)new IllegalStateException("Unknown library Id: " + libraryId + " not in " + this.idToLibrary.keySet()));
        }
    }

    @Override
    public void onConnect(ConnectDecoder connectDecoder, DirectBuffer buffer, int start, int length) {
        ++this.count;
        if (REPRO_DEBUG_ENABLED) {
            DebugLogger.log(LogTag.REPRODUCTION, "ReproductionProtocolHandler.onConnect: ", connectDecoder.toString());
        }
        this.startOperation();
        this.clock.advanceTimeTo(connectDecoder.timestamp());
        this.connectionId = connectDecoder.connection();
        this.tcpChannelSupplier.enqueueConnect(connectDecoder);
    }

    @Override
    public void onApplicationHeartbeat(ApplicationHeartbeatDecoder decoder, DirectBuffer buffer, int start, int length) {
        ++this.count;
        if (REPRO_DEBUG_ENABLED) {
            DebugLogger.log(LogTag.REPRODUCTION, "ReproductionProtocolHandler.onApplicationHeartbeat: ", decoder.toString());
        }
        this.clock.advanceTimeTo(decoder.timestampInNs());
        this.validateLibraryId(decoder.libraryId());
    }

    public long newConnectionId() {
        if (this.connectionId == -1L) {
            IllegalStateException ex = new IllegalStateException("Unknown connection id");
            this.errorHandler.onError((Throwable)ex);
            throw ex;
        }
        long connectionId = this.connectionId;
        this.connectionId = -1L;
        this.endOperation();
        return connectionId;
    }

    public void idToLibrary(Int2ObjectHashMap<LiveLibraryInfo> idToLibrary) {
        this.idToLibrary = idToLibrary;
    }

    private void startOperation() {
        if (REPRO_DEBUG_ENABLED) {
            DebugLogger.log(LogTag.REPRODUCTION, "ReproductionProtocolHandler.startOperation: ", String.valueOf(this.operationInProgress));
        }
        if (this.operationInProgress) {
            this.errorHandler.onError((Throwable)new IllegalStateException("Multiple operations in flight attempted"));
        }
        this.operationInProgress = true;
    }

    private void endOperation() {
        if (REPRO_DEBUG_ENABLED) {
            DebugLogger.log(LogTag.REPRODUCTION, "ReproductionProtocolHandler.endOperation: ", String.valueOf(this.operationInProgress));
        }
        if (!this.operationInProgress) {
            this.errorHandler.onError((Throwable)new IllegalStateException("No operation in flight"));
        }
        this.operationInProgress = false;
    }

    public boolean operationInProgress() {
        return this.operationInProgress;
    }

    public void resetCount() {
        this.count = 0;
    }

    public void checkCount(int fragmentLimit) {
        if (this.count > fragmentLimit && countHandler != null) {
            countHandler.accept(this.count);
        }
    }

    static {
        REPRO_DEBUG_ENABLED = DebugLogger.isEnabled(LogTag.REPRODUCTION);
    }
}

