/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.HeaderSetup;
import uk.co.real_logic.artio.engine.framer.AcceptorLogonResult;
import uk.co.real_logic.artio.engine.framer.FixContexts;
import uk.co.real_logic.artio.engine.framer.FixGatewaySession;
import uk.co.real_logic.artio.engine.framer.FixReceiverEndPoint;
import uk.co.real_logic.artio.engine.framer.Framer;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.TcpChannel;
import uk.co.real_logic.artio.engine.framer.UserRequestExtractor;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.messages.CancelOnDisconnectOption;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.DirectSessionProxy;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.ResendRequestController;
import uk.co.real_logic.artio.session.SessionCustomisationStrategy;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionParser;
import uk.co.real_logic.artio.util.EpochFractionClock;
import uk.co.real_logic.artio.util.EpochFractionClocks;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;
import uk.co.real_logic.artio.validation.AuthenticationProxy;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;
import uk.co.real_logic.artio.validation.PersistenceLevel;
import uk.co.real_logic.artio.validation.SessionPersistenceStrategy;

public class FixGatewaySessions
extends GatewaySessions {
    private final Map<FixDictionary, UserRequestExtractor> dictionaryToUserRequestExtractor = new HashMap<FixDictionary, UserRequestExtractor>();
    private final Function<FixDictionary, UserRequestExtractor> newUserRequestExtractor = dictionary -> new UserRequestExtractor((FixDictionary)dictionary, this.errorHandler);
    private final InternalSession.Formatters formatters = new InternalSession.Formatters();
    private final EpochFractionClock epochFractionClock;
    private final SessionIdStrategy sessionIdStrategy;
    private final SessionCustomisationStrategy customisationStrategy;
    private final FixCounters fixCounters;
    private final AuthenticationStrategy authenticationStrategy;
    private final MessageValidationStrategy validationStrategy;
    private final int sessionBufferSize;
    private final long sendingTimeWindowInMs;
    private final long reasonableTransmissionTimeInMs;
    private final boolean logAllMessages;
    private final boolean validateCompIdsOnEveryMessage;
    private final boolean validateTimeStrictly;
    private final FixContexts fixContexts;
    private final SessionPersistenceStrategy sessionPersistenceStrategy;
    private final EpochNanoClock clock;
    private final EpochFractionFormat epochFractionPrecision;
    private final UtcTimestampEncoder sendingTimeEncoder;
    private final ResendRequestController resendRequestController;
    private final int forcedHeartbeatIntervalInS;
    private final boolean disableHeartbeatRepliesToTestRequests;
    private final boolean isReproductionEnabled;
    private final CancelOnDisconnectOption cancelOnDisconnectOption;
    private final int cancelOnDisconnectTimeoutWindowInMs;
    private SessionContext sessionContext;

    FixGatewaySessions(EpochClock epochClock, GatewayPublication inboundPublication, GatewayPublication outboundPublication, SessionIdStrategy sessionIdStrategy, SessionCustomisationStrategy customisationStrategy, FixCounters fixCounters, EngineConfiguration configuration, ErrorHandler errorHandler, FixContexts fixContexts, SessionPersistenceStrategy sessionPersistenceStrategy, SequenceNumberIndexReader sentSequenceNumberIndex, SequenceNumberIndexReader receivedSequenceNumberIndex, EpochFractionFormat epochFractionPrecision) {
        super(epochClock, inboundPublication, outboundPublication, errorHandler, sentSequenceNumberIndex, receivedSequenceNumberIndex);
        this.sessionIdStrategy = sessionIdStrategy;
        this.customisationStrategy = customisationStrategy;
        this.fixCounters = fixCounters;
        this.authenticationStrategy = configuration.authenticationStrategy();
        this.validationStrategy = configuration.messageValidationStrategy();
        this.sessionBufferSize = configuration.sessionBufferSize();
        this.sendingTimeWindowInMs = configuration.sendingTimeWindowInMs();
        this.reasonableTransmissionTimeInMs = configuration.reasonableTransmissionTimeInMs();
        this.logAllMessages = configuration.logAllMessages();
        this.isReproductionEnabled = configuration.isReproductionEnabled();
        this.validateCompIdsOnEveryMessage = configuration.validateCompIdsOnEveryMessage();
        this.validateTimeStrictly = configuration.validateTimeStrictly();
        this.clock = configuration.epochNanoClock();
        this.fixContexts = fixContexts;
        this.sessionPersistenceStrategy = sessionPersistenceStrategy;
        this.epochFractionPrecision = epochFractionPrecision;
        this.epochFractionClock = EpochFractionClocks.create((EpochClock)epochClock, (EpochNanoClock)configuration.epochNanoClock(), (EpochFractionFormat)epochFractionPrecision);
        this.resendRequestController = configuration.resendRequestController();
        this.forcedHeartbeatIntervalInS = configuration.forcedHeartbeatIntervalInS();
        this.disableHeartbeatRepliesToTestRequests = configuration.disableHeartbeatRepliesToTestRequests();
        this.cancelOnDisconnectOption = configuration.cancelOnDisconnectOption();
        this.cancelOnDisconnectTimeoutWindowInMs = configuration.cancelOnDisconnectTimeoutWindowInMs();
        this.sendingTimeEncoder = new UtcTimestampEncoder(epochFractionPrecision);
    }

    void acquire(FixGatewaySession gatewaySession, SessionState state, boolean awaitingResend, int heartbeatIntervalInS, int lastSentSequenceNumber, int lastReceivedSequenceNumber, String username, String password) {
        CompositeKey sessionKey;
        long sessionId = gatewaySession.sessionId();
        long connectionId = gatewaySession.connectionId();
        AtomicCounter receivedMsgSeqNo = this.fixCounters.receivedMsgSeqNo(connectionId, sessionId);
        AtomicCounter sentMsgSeqNo = this.fixCounters.sentMsgSeqNo(connectionId, sessionId);
        MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer(new byte[this.sessionBufferSize]);
        OnMessageInfo messageInfo = new OnMessageInfo();
        DirectSessionProxy proxy = new DirectSessionProxy(this.sessionBufferSize, this.outboundPublication, this.sessionIdStrategy, this.customisationStrategy, this.clock, connectionId, 0, this.errorHandler, this.epochFractionPrecision);
        InternalSession session = new InternalSession(heartbeatIntervalInS, connectionId, this.clock, state, false, proxy, this.inboundPublication, this.outboundPublication, this.sessionIdStrategy, this.sendingTimeWindowInMs, receivedMsgSeqNo, sentMsgSeqNo, 0, lastSentSequenceNumber + 1, 0, this.reasonableTransmissionTimeInMs, asciiBuffer, gatewaySession.enableLastMsgSeqNumProcessed(), this.customisationStrategy, messageInfo, this.epochFractionClock, gatewaySession.connectionType(), this.resendRequestController, this.forcedHeartbeatIntervalInS, this.disableHeartbeatRepliesToTestRequests, true, this.formatters);
        session.awaitingResend(awaitingResend);
        session.closedResendInterval(gatewaySession.closedResendInterval());
        session.resendRequestChunkSize(gatewaySession.resendRequestChunkSize());
        session.sendRedundantResendRequests(gatewaySession.sendRedundantResendRequests());
        session.cancelOnDisconnectOption(gatewaySession.cancelOnDisconnectOption());
        session.cancelOnDisconnectTimeoutWindowInNs(gatewaySession.cancelOnDisconnectTimeoutWindowInNs());
        SessionParser sessionParser = new SessionParser(session, this.validationStrategy, this.errorHandler, this.validateCompIdsOnEveryMessage, this.validateTimeStrictly, messageInfo, this.sessionIdStrategy);
        if (!this.sessions.contains(gatewaySession)) {
            this.sessions.add(gatewaySession);
        }
        gatewaySession.manage(sessionParser, session, proxy);
        if (DebugLogger.isEnabled(LogTag.FIX_CONNECTION)) {
            DebugLogger.log(LogTag.FIX_CONNECTION, this.acquiredConnection.clear().with(connectionId));
        }
        if ((sessionKey = gatewaySession.sessionKey()) != null) {
            gatewaySession.updateSessionDictionary();
            gatewaySession.onLogon(username, password, heartbeatIntervalInS);
            session.initialLastReceivedMsgSeqNum(lastReceivedSequenceNumber);
        }
    }

    AcceptorLogonResult authenticate(AbstractLogonDecoder logon, long connectionId, FixGatewaySession gatewaySession, TcpChannel channel, FixDictionary fixDictionary, Framer framer, String remoteAddress, FixReceiverEndPoint fixReceiverEndPoint) {
        gatewaySession.startAuthentication(this.epochClock.time());
        return new FixPendingAcceptorLogon(this.sessionIdStrategy, gatewaySession, logon, connectionId, this.fixContexts, channel, fixDictionary, framer, remoteAddress, fixReceiverEndPoint, this.cancelOnDisconnectOption, this.cancelOnDisconnectTimeoutWindowInMs);
    }

    void onUserRequest(DirectBuffer buffer, int offset, int length, FixDictionary dictionary, long connectionId, long sessionId) {
        UserRequestExtractor extractor = this.dictionaryToUserRequestExtractor.computeIfAbsent(dictionary, this.newUserRequestExtractor);
        extractor.onUserRequest(buffer, offset, length, this.authenticationStrategy, connectionId, sessionId);
    }

    void onDisconnect(long sessionId, long connectionId, DisconnectReason reason) {
        this.authenticationStrategy.onDisconnect(sessionId, connectionId, reason);
    }

    @Override
    protected void setLastSequenceResetTime(GatewaySession session) {
        ((FixGatewaySession)session).lastSequenceResetTime(this.sessionContext.lastSequenceResetTime());
    }

    final class FixPendingAcceptorLogon
    extends GatewaySessions.PendingAcceptorLogon
    implements AuthenticationProxy {
        private static final int ENCODE_BUFFER_SIZE = 1024;
        private final SessionIdStrategy sessionIdStrategy;
        private final FixGatewaySession session;
        private final AbstractLogonDecoder logon;
        private final FixContexts fixContexts;
        private final String remoteAddress;
        private final boolean resetSeqNum;
        private final CancelOnDisconnectOption cancelOnDisconnectOption;
        private final int cancelOnDisconnectTimeoutWindowInMs;
        private FixDictionary fixDictionary;
        private Encoder encoder;
        private Class<? extends FixDictionary> fixDictionaryClass;
        private long rejectEncodeResult;

        FixPendingAcceptorLogon(SessionIdStrategy sessionIdStrategy, FixGatewaySession gatewaySession, AbstractLogonDecoder logon, long connectionId, FixContexts fixContexts, TcpChannel channel, FixDictionary fixDictionary, Framer framer, String remoteAddress, FixReceiverEndPoint fixReceiverEndPoint, CancelOnDisconnectOption cancelOnDisconnectOption, int cancelOnDisconnectTimeoutWindowInMs) {
            super(FixGatewaySessions.this, gatewaySession, connectionId, channel, framer, fixReceiverEndPoint);
            this.sessionIdStrategy = sessionIdStrategy;
            this.session = gatewaySession;
            this.logon = logon;
            this.fixContexts = fixContexts;
            this.fixDictionary = fixDictionary;
            this.remoteAddress = remoteAddress;
            this.cancelOnDisconnectOption = cancelOnDisconnectOption;
            this.cancelOnDisconnectTimeoutWindowInMs = cancelOnDisconnectTimeoutWindowInMs;
            PersistenceLevel persistenceLevel = this.getPersistenceLevel(logon, connectionId);
            boolean resetSeqNumFlag = logon.hasResetSeqNumFlag() && logon.resetSeqNumFlag();
            boolean resetSequenceNumbersUponLogon = SessionPersistenceStrategy.resetSequenceNumbersUponLogon(persistenceLevel);
            boolean bl = this.resetSeqNum = resetSequenceNumbersUponLogon || resetSeqNumFlag;
            if (!(resetSequenceNumbersUponLogon || FixGatewaySessions.this.logAllMessages || FixGatewaySessions.this.isReproductionEnabled)) {
                this.onError(new IllegalStateException("Persistence Strategy specified INDEXED but EngineConfiguration has disabled required logging of messages"));
                this.reject(DisconnectReason.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES);
                return;
            }
            this.authenticate(logon, connectionId);
        }

        private PersistenceLevel getPersistenceLevel(AbstractLogonDecoder logon, long connectionId) {
            try {
                return FixGatewaySessions.this.sessionPersistenceStrategy.getPersistenceLevel(logon);
            }
            catch (Throwable throwable) {
                this.onStrategyError("persistence", throwable, connectionId, "TRANSIENT_SEQUENCE_NUMBERS", logon.toString());
                return PersistenceLevel.TRANSIENT_SEQUENCE_NUMBERS;
            }
        }

        private void authenticate(AbstractLogonDecoder logon, long connectionId) {
            block2: {
                try {
                    FixGatewaySessions.this.authenticationStrategy.authenticateAsync(logon, this);
                }
                catch (Throwable throwable) {
                    this.onStrategyError("authentication", throwable, connectionId, "false", logon.toString());
                    if (this.state == GatewaySessions.AuthenticationState.REJECTED) break block2;
                    this.reject();
                }
            }
        }

        @Override
        public void accept(Class<? extends FixDictionary> fixDictionaryClass) {
            this.validateState();
            this.fixDictionaryClass = fixDictionaryClass;
            this.setState(GatewaySessions.AuthenticationState.AUTHENTICATED);
        }

        @Override
        protected void onAuthenticated() {
            CompositeKey compositeKey;
            if (this.fixDictionaryClass != null && this.fixDictionary.getClass() != this.fixDictionaryClass) {
                this.fixDictionary = FixDictionary.of(this.fixDictionaryClass);
                this.session.fixDictionary(this.fixDictionary);
            }
            String username = SessionParser.username(this.logon);
            String password = SessionParser.password(this.logon);
            CancelOnDisconnectOption cancelOnDisconnectOption = SessionParser.cancelOnDisconnectType(this.logon, this.cancelOnDisconnectOption);
            long cancelOnDisconnectTimeoutWindowInNs = TimeUnit.MILLISECONDS.toNanos(SessionParser.cancelOnDisconnectTimeoutWindow(this.logon, this.cancelOnDisconnectTimeoutWindowInMs));
            SessionHeaderDecoder header = this.logon.header();
            try {
                compositeKey = this.sessionIdStrategy.onAcceptLogon(header);
            }
            catch (IllegalArgumentException e) {
                this.reject(DisconnectReason.MISSING_LOGON_COMP_ID);
                return;
            }
            FixGatewaySessions.this.sessionContext = this.fixContexts.onLogon(compositeKey, this.fixDictionary);
            if (FixGatewaySessions.this.sessionContext == FixContexts.DUPLICATE_SESSION) {
                this.reject(DisconnectReason.DUPLICATE_SESSION);
                return;
            }
            boolean isOfflineReconnect = this.framer.onFixLogonMessageReceived(this.session, FixGatewaySessions.this.sessionContext.sessionId());
            long logonTimeInNs = FixGatewaySessions.this.clock.nanoTime();
            FixGatewaySessions.this.sessionContext.onLogon(this.resetSeqNum, logonTimeInNs, this.fixDictionary);
            this.session.initialResetSeqNum(this.resetSeqNum);
            this.session.fixDictionary(this.fixDictionary);
            this.session.updateSessionDictionary();
            this.session.onLogon(FixGatewaySessions.this.sessionContext.sessionId(), FixGatewaySessions.this.sessionContext, compositeKey, username, password, this.logon.heartBtInt(), header.msgSeqNum(), cancelOnDisconnectOption, cancelOnDisconnectTimeoutWindowInNs);
            this.session.lastLogonTime(logonTimeInNs);
            if (this.resetSeqNum) {
                this.session.acceptorSequenceNumbers(-1, -1);
                this.session.lastLogonWasSequenceReset();
                this.setState(GatewaySessions.AuthenticationState.ACCEPTED);
            } else {
                this.requiredPosition = FixGatewaySessions.this.outboundPublication.position();
                this.setState(GatewaySessions.AuthenticationState.INDEXER_CATCHUP);
            }
            this.framer.onGatewaySessionSetup(this.session, isOfflineReconnect);
        }

        @Override
        public void reject(Encoder encoder, long lingerTimeoutInMs) {
            Objects.requireNonNull(encoder, "encoder should be provided");
            if (lingerTimeoutInMs < 0L) {
                throw new IllegalArgumentException(String.format("lingerTimeoutInMs should not be negative, (%d)", lingerTimeoutInMs));
            }
            this.encoder = encoder;
            this.reason = DisconnectReason.FAILED_AUTHENTICATION;
            this.lingerTimeoutInMs = lingerTimeoutInMs;
            this.setState(GatewaySessions.AuthenticationState.SAVING_REJECTED_LOGON_WITH_REPLY);
        }

        @Override
        protected void encodeRejectMessage() {
            if (this.rejectEncodeBuffer == null) {
                this.rejectEncodeBuffer = ByteBuffer.allocate(1024);
                this.rejectAsciiBuffer = new MutableAsciiBuffer(this.rejectEncodeBuffer);
            }
            SessionHeaderEncoder header = this.encoder.header();
            header.msgSeqNum(1);
            header.sendingTime(FixGatewaySessions.this.sendingTimeEncoder.buffer(), FixGatewaySessions.this.sendingTimeEncoder.encodeFrom(FixGatewaySessions.this.clock.nanoTime(), TimeUnit.NANOSECONDS));
            HeaderSetup.setup(this.logon.header(), header);
            FixGatewaySessions.this.customisationStrategy.configureHeader(header, FixContexts.UNKNOWN_SESSION.sessionId());
            this.rejectEncodeResult = this.encoder.encode(this.rejectAsciiBuffer, 0);
        }

        @Override
        protected GatewaySessions.SendRejectResult sendReject() {
            long messageType;
            int length;
            int offset = Encoder.offset((long)this.rejectEncodeResult);
            long position = FixGatewaySessions.this.outboundPublication.saveMessage((DirectBuffer)this.rejectAsciiBuffer, offset, length = Encoder.length((long)this.rejectEncodeResult), 0, messageType = this.encoder.messageType(), -1L, 0, this.connectionId, MessageStatus.OK, 1);
            boolean backPressured = Pressure.isBackPressured(position);
            if (!backPressured) {
                DebugLogger.logFixMessage(LogTag.FIX_MESSAGE, messageType, "Auth Reject Reply: ", (DirectBuffer)this.rejectAsciiBuffer, offset, length);
            }
            return backPressured ? GatewaySessions.SendRejectResult.BACK_PRESSURED : GatewaySessions.SendRejectResult.INFLIGHT;
        }

        @Override
        public void reject() {
            this.validateState();
            this.reject(DisconnectReason.FAILED_AUTHENTICATION);
        }

        @Override
        public String remoteAddress() {
            return this.remoteAddress;
        }
    }
}

