/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import io.aeron.Aeron;
import io.aeron.ExclusivePublication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.BufferClaim;
import java.util.ArrayList;
import org.agrona.ErrorHandler;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.CompositeAgent;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.EpochNanoClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.FixCounters;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.StreamInformation;
import uk.co.real_logic.artio.dictionary.generation.Exceptions;
import uk.co.real_logic.artio.engine.CompletionPosition;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.RecordingCoordinator;
import uk.co.real_logic.artio.engine.ReplayerCommandQueue;
import uk.co.real_logic.artio.engine.SenderSequenceNumbers;
import uk.co.real_logic.artio.engine.SequenceNumberExtractor;
import uk.co.real_logic.artio.engine.framer.FramerContext;
import uk.co.real_logic.artio.engine.framer.PruneOperation;
import uk.co.real_logic.artio.engine.logger.AbstractReplayer;
import uk.co.real_logic.artio.engine.logger.FixSessionCodecsFactory;
import uk.co.real_logic.artio.engine.logger.GapFiller;
import uk.co.real_logic.artio.engine.logger.Index;
import uk.co.real_logic.artio.engine.logger.Indexer;
import uk.co.real_logic.artio.engine.logger.LoggerUtil;
import uk.co.real_logic.artio.engine.logger.NoOpReplayQueryListener;
import uk.co.real_logic.artio.engine.logger.RecordingIdLookup;
import uk.co.real_logic.artio.engine.logger.ReplayEvictionHandler;
import uk.co.real_logic.artio.engine.logger.ReplayIndex;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;
import uk.co.real_logic.artio.engine.logger.Replayer;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexWriter;
import uk.co.real_logic.artio.fields.EpochFractionFormat;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.protocol.Streams;

public class EngineContext
implements AutoCloseable {
    private final PruneOperation.Formatters pruneOperationFormatters = new PruneOperation.Formatters();
    private final CompletionPosition inboundCompletionPosition = new CompletionPosition();
    private final CompletionPosition outboundLibraryCompletionPosition = new CompletionPosition();
    private final SequenceNumberExtractor sentSequenceNumberExtractor = new SequenceNumberExtractor();
    private final SequenceNumberExtractor recvSequenceNumberExtractor = new SequenceNumberExtractor();
    private final EpochNanoClock clock;
    private final EngineConfiguration configuration;
    private final ErrorHandler errorHandler;
    private final FixCounters fixCounters;
    private final Aeron aeron;
    private final ReplayerCommandQueue replayerCommandQueue;
    private final SenderSequenceNumbers senderSequenceNumbers;
    private final AeronArchive aeronArchive;
    private final RecordingCoordinator recordingCoordinator;
    private final ExclusivePublication replayPublication;
    private final SequenceNumberIndexWriter sentSequenceNumberIndex;
    private final SequenceNumberIndexWriter receivedSequenceNumberIndex;
    private final ReplayEvictionHandler inboundEvictionHandler;
    private final ReplayEvictionHandler outboundEvictionHandler;
    private Streams inboundLibraryStreams;
    private Streams outboundLibraryStreams;
    private Indexer inboundIndexer;
    private Indexer outboundIndexer;
    private Agent indexingAgent;
    private ReplayQuery pruneInboundReplayQuery;
    private ReplayQuery outboundReplayQuery;
    private FramerContext framerContext;
    private long inboundIndexRegistrationId;
    private long outboundIndexRegistrationId;

    EngineContext(EngineConfiguration configuration, ErrorHandler errorHandler, ExclusivePublication replayPublication, FixCounters fixCounters, Aeron aeron, AeronArchive aeronArchive, RecordingCoordinator recordingCoordinator) {
        this.configuration = configuration;
        this.errorHandler = errorHandler;
        this.fixCounters = fixCounters;
        this.aeron = aeron;
        this.clock = configuration.epochNanoClock();
        this.replayPublication = replayPublication;
        this.aeronArchive = aeronArchive;
        this.recordingCoordinator = recordingCoordinator;
        this.inboundEvictionHandler = new ReplayEvictionHandler(errorHandler);
        this.outboundEvictionHandler = new ReplayEvictionHandler(errorHandler);
        this.replayerCommandQueue = new ReplayerCommandQueue(configuration.framerIdleStrategy());
        this.senderSequenceNumbers = new SenderSequenceNumbers(this.replayerCommandQueue);
        try {
            SystemEpochClock epochClock = new SystemEpochClock();
            Long2LongHashMap connectionIdToFixPSessionId = new Long2LongHashMap(-1L);
            FixPProtocolType fixPProtocolType = configuration.supportedFixPProtocolType();
            boolean indexChecksumEnabled = configuration.indexChecksumEnabled();
            this.sentSequenceNumberIndex = new SequenceNumberIndexWriter(this.sentSequenceNumberExtractor, configuration.sentSequenceNumberBuffer(), configuration.sentSequenceNumberIndex(), errorHandler, configuration.outboundLibraryStream(), recordingCoordinator.indexerOutboundRecordingIdLookup(), configuration.indexFileStateFlushTimeoutInMs(), (EpochClock)epochClock, configuration.logFileDir(), connectionIdToFixPSessionId, fixPProtocolType, indexChecksumEnabled, configuration.logOutboundMessages());
            this.receivedSequenceNumberIndex = new SequenceNumberIndexWriter(this.recvSequenceNumberExtractor, configuration.receivedSequenceNumberBuffer(), configuration.receivedSequenceNumberIndex(), errorHandler, configuration.inboundLibraryStream(), recordingCoordinator.indexerInboundRecordingIdLookup(), configuration.indexFileStateFlushTimeoutInMs(), (EpochClock)epochClock, null, connectionIdToFixPSessionId, fixPProtocolType, indexChecksumEnabled, configuration.logInboundMessages());
            this.newStreams();
            this.newArchivingAgent();
        }
        catch (Exception e) {
            this.completeDuringStartup();
            Exceptions.suppressingClose((AutoCloseable)this, (Exception)e);
            throw e;
        }
    }

    private void newStreams() {
        String libraryAeronChannel = this.configuration.libraryAeronChannel();
        boolean printAeronStreamIdentifiers = this.configuration.printAeronStreamIdentifiers();
        this.inboundLibraryStreams = new Streams(this.aeron, libraryAeronChannel, printAeronStreamIdentifiers, this.fixCounters.failedInboundPublications(), this.configuration.inboundLibraryStream(), this.clock, this.configuration.inboundMaxClaimAttempts(), this.recordingCoordinator);
        this.outboundLibraryStreams = new Streams(this.aeron, libraryAeronChannel, printAeronStreamIdentifiers, this.fixCounters.failedOutboundPublications(), this.configuration.outboundLibraryStream(), this.clock, this.configuration.outboundMaxClaimAttempts(), this.recordingCoordinator);
    }

    private ReplayIndex newReplayIndex(String logFileDir, int streamId, RecordingIdLookup recordingIdLookup, Long2LongHashMap connectionIdToILinkUuid, SequenceNumberIndexReader reader, SequenceNumberExtractor sequenceNumberExtractor, boolean indexChecksumEnabled, ReplayEvictionHandler evictionHandler) {
        return new ReplayIndex(sequenceNumberExtractor, logFileDir, streamId, this.configuration.replayIndexFileRecordCapacity(), this.configuration.replayIndexSegmentRecordCapacity(), LoggerUtil::map, (AtomicBuffer)ReplayIndexDescriptor.replayPositionBuffer(logFileDir, streamId, this.configuration.replayPositionBufferSize()), this.errorHandler, recordingIdLookup, connectionIdToILinkUuid, this.configuration.supportedFixPProtocolType(), reader, this.configuration.timeIndexReplayFlushIntervalInNs(), indexChecksumEnabled, evictionHandler);
    }

    private ReplayQuery newReplayQuery(IdleStrategy idleStrategy, int streamId) {
        String logFileDir = this.configuration.logFileDir();
        int cacheSetSize = this.configuration.loggerCacheSetSize();
        int cacheNumSets = this.configuration.loggerCacheNumSets();
        int archiveReplayStream = this.configuration.archiveReplayStream();
        return new ReplayQuery(logFileDir, cacheNumSets, cacheSetSize, LoggerUtil::mapExistingFile, streamId, idleStrategy, this.aeronArchive, this.errorHandler, NoOpReplayQueryListener.INSTANCE, archiveReplayStream, this.configuration.replayIndexFileRecordCapacity(), this.configuration.replayIndexSegmentRecordCapacity());
    }

    private Replayer newReplayer(ExclusivePublication replayPublication, ReplayQuery replayQuery) {
        EpochFractionFormat epochFractionFormat = this.configuration.sessionEpochFractionFormat();
        return new Replayer(replayQuery, replayPublication, new BufferClaim(), this.configuration.archiverIdleStrategy(), this.errorHandler, this.configuration.outboundMaxClaimAttempts(), this.inboundLibraryStreams.subscription("replayer"), this.configuration.agentNamePrefix(), this.configuration.gapfillOnReplayMessageTypes(), this.configuration.gapfillOnRetransmitILinkTemplateIds(), this.configuration.replayHandler(), this.configuration.fixPRetransmitHandler(), this.senderSequenceNumbers, new FixSessionCodecsFactory(this.clock, epochFractionFormat), this.configuration.senderMaxBytesInBuffer(), this.replayerCommandQueue, epochFractionFormat, this.fixCounters.currentReplayCount(), this.configuration.maxConcurrentSessionReplays(), this.clock, this.configuration.supportedFixPProtocolType(), this.configuration);
    }

    private void newIndexers() {
        ReplayIndex inboundReplayIndex = null;
        ReplayIndex outboundReplayIndex = null;
        try {
            String logFileDir = this.configuration.logFileDir();
            boolean indexChecksumEnabled = this.configuration.indexChecksumEnabled();
            Long2LongHashMap connectionIdToILinkUuid = new Long2LongHashMap(-1L);
            ArrayList<Index> inboundIndices = new ArrayList<Index>();
            if (this.configuration.logInboundMessages()) {
                inboundReplayIndex = this.newReplayIndex(logFileDir, this.configuration.inboundLibraryStream(), this.recordingCoordinator.indexerInboundRecordingIdLookup(), connectionIdToILinkUuid, this.receivedSequenceNumberIndex.reader(), this.recvSequenceNumberExtractor, indexChecksumEnabled, this.inboundEvictionHandler);
                inboundIndices.add(inboundReplayIndex);
            }
            inboundIndices.add(this.receivedSequenceNumberIndex);
            Subscription inboundIndexSubscription = this.inboundLibraryStreams.subscription("inboundIndexer");
            this.inboundIndexRegistrationId = inboundIndexSubscription.registrationId();
            this.inboundIndexer = new Indexer(inboundIndices, inboundIndexSubscription, this.configuration.agentNamePrefix(), this.inboundCompletionPosition, this.configuration.archiveReplayStream());
            ArrayList<Index> outboundIndices = new ArrayList<Index>();
            if (this.configuration.logOutboundMessages()) {
                outboundReplayIndex = this.newReplayIndex(logFileDir, this.configuration.outboundLibraryStream(), this.recordingCoordinator.indexerOutboundRecordingIdLookup(), connectionIdToILinkUuid, this.sentSequenceNumberIndex.reader(), this.sentSequenceNumberExtractor, indexChecksumEnabled, this.outboundEvictionHandler);
                outboundIndices.add(outboundReplayIndex);
            }
            outboundIndices.add(this.sentSequenceNumberIndex);
            Subscription outboundIndexSubscription = this.outboundLibraryStreams.subscription("outboundIndexer");
            this.outboundIndexRegistrationId = outboundIndexSubscription.registrationId();
            this.outboundIndexer = new Indexer(outboundIndices, outboundIndexSubscription, this.configuration.agentNamePrefix(), this.outboundLibraryCompletionPosition, this.configuration.archiveReplayStream());
        }
        catch (Exception e) {
            Exceptions.suppressingClose(inboundReplayIndex, (Exception)e);
            Exceptions.suppressingClose(outboundReplayIndex, (Exception)e);
            throw e;
        }
    }

    public long inboundIndexRegistrationId() {
        return this.inboundIndexRegistrationId;
    }

    public long outboundIndexRegistrationId() {
        return this.outboundIndexRegistrationId;
    }

    private void newArchivingAgent() {
        AbstractReplayer replayer;
        this.newIndexers();
        if (this.configuration.logOutboundMessages()) {
            this.outboundReplayQuery = this.newReplayQuery(this.configuration.archiverIdleStrategy(), this.configuration.outboundLibraryStream());
            this.outboundEvictionHandler.replayQuery(this.outboundReplayQuery);
            try {
                replayer = this.newReplayer(this.replayPublication, this.outboundReplayQuery);
            }
            catch (Throwable e) {
                this.outboundReplayQuery.close();
                throw e;
            }
        } else {
            GatewayPublication replayGatewayPublication = new GatewayPublication(this.replayPublication, this.fixCounters.failedReplayPublications(), this.configuration.archiverIdleStrategy(), this.clock, this.configuration.outboundMaxClaimAttempts());
            replayer = new GapFiller(this.inboundLibraryStreams.subscription("replayer"), replayGatewayPublication, this.configuration.agentNamePrefix(), this.senderSequenceNumbers, this.replayerCommandQueue, new FixSessionCodecsFactory(this.clock, this.configuration.sessionEpochFractionFormat()), this.clock);
        }
        ArrayList<Object> agents = new ArrayList<Object>();
        agents.add(this.inboundIndexer);
        agents.add(this.outboundIndexer);
        agents.add(replayer);
        this.indexingAgent = new CompositeAgent(agents);
    }

    public void catchupIndices() {
        if (this.configuration.logInboundMessages()) {
            this.inboundIndexer.catchIndexUp(this.aeronArchive, this.errorHandler);
        }
        if (this.configuration.logOutboundMessages()) {
            this.outboundIndexer.catchIndexUp(this.aeronArchive, this.errorHandler);
        }
    }

    public Streams outboundLibraryStreams() {
        return this.outboundLibraryStreams;
    }

    public Subscription outboundLibrarySubscription(String name, UnavailableImageHandler unavailableImageHandler) {
        Subscription subscription = this.aeron.addSubscription(this.configuration.libraryAeronChannel(), this.configuration.outboundLibraryStream(), null, unavailableImageHandler);
        StreamInformation.print(name, subscription, (CommonConfiguration)this.configuration);
        return subscription;
    }

    public ReplayQuery inboundReplayQuery(boolean replayerThread) {
        if (!this.configuration.canReplayInbound()) {
            return null;
        }
        ReplayQuery replayQuery = this.newReplayQuery(this.configuration.framerIdleStrategy(), this.configuration.inboundLibraryStream());
        if (replayerThread) {
            this.inboundEvictionHandler.replayQuery(replayQuery);
        } else {
            this.inboundEvictionHandler.framerReplayQuery(replayQuery);
        }
        return replayQuery;
    }

    public GatewayPublication inboundPublication() {
        return this.inboundLibraryStreams.gatewayPublication(this.configuration.framerIdleStrategy(), this.inboundLibraryStreams.dataPublication("inboundPublication"));
    }

    public CompletionPosition inboundCompletionPosition() {
        return this.inboundCompletionPosition;
    }

    public CompletionPosition outboundLibraryCompletionPosition() {
        return this.outboundLibraryCompletionPosition;
    }

    void completeDuringStartup() {
        this.inboundCompletionPosition.completeDuringStartup();
        this.outboundLibraryCompletionPosition.completeDuringStartup();
    }

    Agent indexingAgent() {
        return this.indexingAgent;
    }

    public SenderSequenceNumbers senderSequenceNumbers() {
        return this.senderSequenceNumbers;
    }

    public void framerContext(FramerContext framerContext) {
        this.framerContext = framerContext;
        this.sentSequenceNumberIndex.framerContext(framerContext);
        this.inboundEvictionHandler.framerContext(framerContext);
        this.outboundEvictionHandler.framerContext(framerContext);
    }

    public Reply<Long2LongHashMap> pruneArchive(Exception exception) {
        return new PruneOperation(this.pruneOperationFormatters, exception);
    }

    public Reply<Long2LongHashMap> pruneArchive(Long2LongHashMap minimumPrunePositions) {
        PruneOperation operation;
        if (this.pruneInboundReplayQuery == null) {
            this.pruneInboundReplayQuery = this.inboundReplayQuery(true);
        }
        if (!this.framerContext.offer(operation = new PruneOperation(this.pruneOperationFormatters, minimumPrunePositions, this.outboundReplayQuery, this.pruneInboundReplayQuery, this.aeronArchive, this.replayerCommandQueue, this.recordingCoordinator))) {
            return null;
        }
        return operation;
    }

    @Override
    public void close() {
        Exceptions.closeAll((AutoCloseable[])new AutoCloseable[]{this.sentSequenceNumberIndex, this.receivedSequenceNumberIndex, this.pruneInboundReplayQuery});
    }
}

