/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import io.aeron.ExclusivePublication;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.messages.AdminResetSequenceNumbersRequestEncoder;
import uk.co.real_logic.artio.messages.AllFixSessionsRequestEncoder;
import uk.co.real_logic.artio.messages.DisconnectSessionRequestEncoder;
import uk.co.real_logic.artio.protocol.ClaimablePublication;

class AdminPublication
extends ClaimablePublication {
    private static final int ALL_FIX_SESSIONS_REQUEST_LENGTH = 16;
    private static final int DISCONNECT_SESSION_REQUEST_LENGTH = 24;
    private static final int RESET_SEQUENCE_NUMBERS_REQUEST_LENGTH = 24;
    private final AllFixSessionsRequestEncoder allFixSessionsRequest = new AllFixSessionsRequestEncoder();
    private final DisconnectSessionRequestEncoder disconnectSessionRequest = new DisconnectSessionRequestEncoder();
    private final AdminResetSequenceNumbersRequestEncoder adminResetSequenceNumbersRequest = new AdminResetSequenceNumbersRequestEncoder();

    AdminPublication(ExclusivePublication dataPublication, AtomicCounter fails, IdleStrategy idleStrategy, int maxClaimAttempts) {
        super(maxClaimAttempts, idleStrategy, fails, dataPublication);
    }

    long saveRequestAllFixSessions(long correlationId) {
        long position = this.claim(16);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.allFixSessionsRequest.wrapAndApplyHeader(buffer, offset, this.header).correlationId(correlationId);
        this.bufferClaim.commit();
        return position;
    }

    long saveDisconnectSession(long correlationId, long sessionId) {
        long position = this.claim(24);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.disconnectSessionRequest.wrapAndApplyHeader(buffer, offset, this.header).correlationId(correlationId).sessionId(sessionId);
        this.bufferClaim.commit();
        return position;
    }

    long saveResetSequenceNumbers(long correlationId, long sessionId) {
        long position = this.claim(24);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.adminResetSequenceNumbersRequest.wrapAndApplyHeader(buffer, offset, this.header).correlationId(correlationId).sessionId(sessionId);
        this.bufferClaim.commit();
        return position;
    }
}

